/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.JdkUtils;
import com.intellij.ide.macro.EditorMacro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.JdkBundle;
import com.intellij.util.JdkBundleList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedPropertiesPanel {
    private static final String USER_DEFINED_DESCRIPTION = "User defined driver property.";
    private static final Set<String> PROHIBITED_PROPERTIES_NAMES = new THashSet(Arrays.asList("user", "password", "host", "port", "dbname", "pwd", "uid", "pghost", "pgport", "pgdbname"), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    @NlsSafe
    static final String DEFAULT = "Default";
    private final Project myProject;
    private final AbstractDatabaseConfigurable<?> myOwner;
    private final DatabaseConfigEditor myController;
    private JPanel myRoot;
    private JBLoadingPanel myLoadingPanel;
    private TableView<DriverPropertyInfo> myPropertiesTable;
    private JTextArea myPropertyInfo;
    private RawCommandLineEditor myVMParameters;
    private EnvironmentVariablesTextFieldWithBrowseButton myVMEnv;
    private ComboBox<String> myJreCombo;
    private JPanel myJrePanel;
    private JPanel myWorkingDirPanel;
    private TextFieldWithBrowseButton myWorkingDir;
    private final FallThroughValues myValuesMap;
    private final List<DriverPropertyInfo> myUserProperties;
    private String myPropertiesDriverName;
    private List<SimpleClasspathElement> myClassPath;

    public AdvancedPropertiesPanel(@NotNull Project project, @NotNull Map<String, String> properties, @NotNull AbstractDatabaseConfigurable<?> owner, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(3);
        }
        this.myValuesMap = new FallThroughValues();
        this.myUserProperties = new ArrayList<DriverPropertyInfo>();
        this.myClassPath = Collections.emptyList();
        this.myProject = project;
        this.myOwner = owner;
        this.myController = controller;
        if (owner instanceof DataSourceConfigurable) {
            DatabaseDriver driver = ((LocalDataSource)((DataSourceConfigurable)owner).getDataSource()).getDatabaseDriver();
            this.myValuesMap.setDefaults(driver == null ? Collections.emptyMap() : driver.getDriverProperties());
        }
        this.$$$setupUI$$$();
        this.myJrePanel.setVisible(owner instanceof DatabaseDriverConfigurable);
        this.myWorkingDirPanel.setVisible(owner instanceof DataSourceConfigurable);
        this.myWorkingDir.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor(), project){

            @NotNull
            @NonNls
            protected String expandPath(@NotNull @NonNls String path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = super.expandPath(JdbcConsoleRunContext.expand(this.getProject(), path));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expandPath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expandPath";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        MacrosDialog.addMacroSupport((ExtendableTextField)((ExtendableTextField)this.myWorkingDir.getTextField()), MacrosDialog.Filters.DIRECTORY_PATH.and(macro -> !(macro instanceof EditorMacro)), () -> false);
        this.myLoadingPanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)1, (int)0));
        this.myPropertyInfo.setEditable(false);
        this.myPropertyInfo.setRows(3);
        this.myPropertyInfo.setWrapStyleWord(true);
        this.myPropertyInfo.setLineWrap(true);
        this.myPropertyInfo.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.myPropertyInfo.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myPropertyInfo.setText(DatabaseBundle.message((String)"jdbc.properties.property.description", (Object[])new Object[0]));
        new UiNotifyConnector(this.myPropertiesTable, new Activatable(){

            public void showNotify() {
                AdvancedPropertiesPanel.this.refreshAdvancedProperties(false);
            }
        });
        this.myPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index2 = AdvancedPropertiesPanel.this.myPropertiesTable.getSelectionModel().getLeadSelectionIndex();
                if (index2 < 0) {
                    AdvancedPropertiesPanel.this.myPropertyInfo.setText("");
                } else {
                    int modelIndex = AdvancedPropertiesPanel.this.myPropertiesTable.convertRowIndexToModel(index2);
                    DriverPropertyInfo info = (DriverPropertyInfo)AdvancedPropertiesPanel.this.myPropertiesTable.getListTableModel().getItems().get(modelIndex);
                    AdvancedPropertiesPanel.this.myPropertyInfo.setText(info.description);
                }
                AdvancedPropertiesPanel.this.myPropertyInfo.setCaretPosition(0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/AdvancedPropertiesPanel$3", "valueChanged"));
            }
        });
        PopupHandler.installPopupHandler(this.myPropertiesTable, (ActionGroup)new DefaultActionGroup(new AnAction[]{new AnAction(DatabaseBundle.message((String)"jdbc.properties.refresh", (Object[])new Object[0]), null, AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                AdvancedPropertiesPanel.this.refreshAdvancedProperties(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/AdvancedPropertiesPanel$4", "actionPerformed"));
            }
        }, new AnAction(DatabaseBundle.message((String)"jdbc.properties.reset.to.driver", (Object[])new Object[0]), null, AllIcons.Diff.Revert){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                DriverPropertyInfo info = AdvancedPropertiesPanel.this.getSelected();
                e.getPresentation().setEnabledAndVisible(info != null && AdvancedPropertiesPanel.this.myValuesMap.isOverridden(info.name));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DriverPropertyInfo info;
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((info = AdvancedPropertiesPanel.this.getSelected()) != null) {
                    AdvancedPropertiesPanel.this.myValuesMap.reset(info.name);
                }
                AdvancedPropertiesPanel.this.refreshAdvancedProperties(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new AnAction(DatabaseBundle.message((String)"jdbc.properties.reset.to.default", (Object[])new Object[0]), null, AllIcons.Diff.Revert){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                DriverPropertyInfo info = AdvancedPropertiesPanel.this.getSelected();
                e.getPresentation().setEnabledAndVisible(info != null && AdvancedPropertiesPanel.this.myValuesMap.get(info.name) != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                DriverPropertyInfo info;
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                if ((info = AdvancedPropertiesPanel.this.getSelected()) != null) {
                    AdvancedPropertiesPanel.this.myValuesMap.put(info.name, null);
                }
                AdvancedPropertiesPanel.this.refreshAdvancedProperties(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }}), (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.myPropertyInfo.setBackground(this.myRoot.getBackground());
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            this.addUserDefinedProperty(prop.getKey(), prop.getValue(), true);
        }
        this.ensureNewPropertyPresent();
        this.setupTableView();
    }

    @Nullable
    private DriverPropertyInfo getSelected() {
        int index2 = this.myPropertiesTable.getSelectionModel().getLeadSelectionIndex();
        int modelIndex = index2 < 0 ? -1 : this.myPropertiesTable.convertRowIndexToModel(index2);
        return modelIndex < 0 ? null : (DriverPropertyInfo)this.myPropertiesTable.getListTableModel().getItems().get(modelIndex);
    }

    public void migrateDriver(@Nullable DatabaseDriver prevDriver, @Nullable DatabaseDriver newDriver) {
        this.myValuesMap.setDefaults(newDriver == null ? Collections.emptyMap() : newDriver.getDriverProperties());
    }

    private void createUIComponents() {
        this.myPropertiesTable = new TableView();
        this.myPropertiesTable.setEnableAntialiasing(true);
        this.myPropertiesTable.setRowHeight(new JTextField((String)"").getPreferredSize().height);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.myOwner);
        this.myVMParameters = new RawCommandLineEditor();
        this.myVMEnv = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myJreCombo = new MyJreComboBox();
    }

    private DriverPropertyInfo addUserDefinedProperty(String propertyName, String value2, boolean changed) {
        DriverPropertyInfo property = new DriverPropertyInfo(propertyName, value2);
        property.description = USER_DEFINED_DESCRIPTION;
        this.myUserProperties.add(property);
        if (changed) {
            this.myValuesMap.put(property.name, property.value);
        }
        return property;
    }

    public JPanel getComponent() {
        return this.myRoot;
    }

    public void refreshAdvancedProperties(boolean force) {
        boolean emptyDriver;
        DatabaseDriver databaseDriver;
        if (this.myOwner instanceof DataSourceConfigurable) {
            databaseDriver = ((DataSourceConfigurable)this.myOwner).getTempDataSource().getDatabaseDriver();
        } else if (this.myOwner instanceof DatabaseDriverConfigurable) {
            databaseDriver = ((DatabaseDriverConfigurable)this.myOwner).getTempDriver();
        } else {
            throw new AssertionError(this.myOwner);
        }
        if (databaseDriver == null || databaseDriver.getClasspathElements().isEmpty()) {
            return;
        }
        LocalDataSource tempDataSource = LocalDataSource.fromDriver(databaseDriver, AdvancedPropertiesPanel.getTempUrl(databaseDriver), true);
        boolean bl = emptyDriver = StringUtil.isEmptyOrSpaces((String)tempDataSource.getDriverClass()) || tempDataSource.getClasspathElements().isEmpty();
        if (emptyDriver) {
            this.myPropertiesTable.getEmptyText().setText(DatabaseBundle.message((String)"jdbc.properties.no.properties", (Object[])new Object[0]));
            this.myPropertiesTable.getListTableModel().setItems(new ArrayList<DriverPropertyInfo>(this.myUserProperties));
            return;
        }
        if (!force && this.isUpToDate(tempDataSource)) {
            return;
        }
        this.myPropertiesTable.getEmptyText().setText("");
        this.myLoadingPanel.startLoading();
        this.myPropertiesDriverName = tempDataSource.getDriverClass();
        this.myClassPath = new ArrayList<SimpleClasspathElement>(tempDataSource.getClasspathElements());
        ModalityState state = ModalityState.current();
        String url = this.myOwner instanceof DataSourceConfigurable ? ((DataSourceConfigurable)this.myOwner).getTempDataSource().getUrl() : tempDataSource.getUrl();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ArrayList rows = new ArrayList();
            Ref exRef = Ref.create(null);
            try {
                DatabaseConnectionManager.getInstance().useDriver(this.myProject, tempDataSource, this.myOwner.getController().getSecretService(), (ThrowableConsumer<? super RemoteDriver, ? extends Exception>)((ThrowableConsumer)driver -> {
                    DriverPropertyInfo[] propertyInfo;
                    for (DriverPropertyInfo info : propertyInfo = driver.getPropertyInfo(url, new Properties())) {
                        if (PROHIBITED_PROPERTIES_NAMES.contains(info.name)) continue;
                        if (info.choices != null && info.choices.length == 1 && "?".equals(info.choices[0])) {
                            info.choices = null;
                        }
                        rows.add(info);
                    }
                }));
            }
            catch (Exception e) {
                exRef.set((Object)e);
            }
            finally {
                Runnable runnable = () -> {
                    if (Disposer.isDisposed(this.myOwner)) {
                        return;
                    }
                    if (!this.isUpToDate(tempDataSource)) {
                        return;
                    }
                    this.myLoadingPanel.stopLoading();
                    this.myPropertiesTable.getEmptyText().setText(DatabaseBundle.message((String)(exRef.isNull() ? "jdbc.properties.no.properties.found" : "jdbc.properties.error"), (Object[])new Object[0]));
                    THashSet loadedNames = new THashSet();
                    for (DriverPropertyInfo row : rows) {
                        loadedNames.add((Object)row.name);
                    }
                    for (DriverPropertyInfo property : this.myUserProperties) {
                        if (loadedNames.contains((Object)property.name)) continue;
                        rows.add(property);
                    }
                    Set selection = ContainerUtil.map2Set((Collection)this.myPropertiesTable.getSelectedObjects(), pi -> pi.name);
                    this.myPropertiesTable.getListTableModel().setItems(rows);
                    List selected = ContainerUtil.filter((Collection)rows, pi -> selection.contains(pi.name));
                    this.myPropertiesTable.setSelection((Collection)selected);
                    TableUtil.scrollSelectionToVisible(this.myPropertiesTable);
                    this.myController.showErrorNotification(this.myOwner, "PROPERTIES_LOAD_FAILED", (Exception)exRef.get());
                };
                if (this.myProject.isOpen()) {
                    ApplicationManager.getApplication().invokeLater(runnable, state);
                }
            }
        });
    }

    public void setProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(4);
        }
        this.myValuesMap.setProperties(properties);
        ListTableModel model = this.myPropertiesTable.getListTableModel();
        Set props = ContainerUtil.map2Set((Collection)model.getItems(), pi -> pi.name);
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            if (props.contains(prop.getKey())) continue;
            model.addRow((Object)this.addUserDefinedProperty(prop.getKey(), prop.getValue(), true));
        }
    }

    @Nullable
    public String getWorkingDir() {
        return StringUtil.nullize((String)this.myWorkingDir.getText());
    }

    public void setWorkingDir(@Nullable String dir) {
        this.myWorkingDir.setText(StringUtil.notNullize((String)dir));
    }

    @NotNull
    public static String getTempUrl(DatabaseDriver driver) {
        String string = driver.getSampleUrl();
        if (string == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    private boolean isUpToDate(LocalDataSource tempDataSource) {
        return Objects.equals(this.myPropertiesDriverName, tempDataSource.getDriverClass()) && this.myClassPath.equals(tempDataSource.getClasspathElements());
    }

    private void setupTableView() {
        new TableSpeedSearch(this.myPropertiesTable).setComparator(new SpeedSearchComparator(false));
        final Comparator comparator2 = (o1, o2) -> {
            if (o1.description == USER_DEFINED_DESCRIPTION && o2.description != USER_DEFINED_DESCRIPTION) {
                return 1;
            }
            if (o2.description == USER_DEFINED_DESCRIPTION && o1.description != USER_DEFINED_DESCRIPTION) {
                return -1;
            }
            if (StringUtil.isEmpty((String)o1.name) && !StringUtil.isEmpty((String)o2.name)) {
                return 1;
            }
            if (StringUtil.isEmpty((String)o2.name) && !StringUtil.isEmpty((String)o1.name)) {
                return -1;
            }
            return StringUtil.naturalCompare((String)o1.name, (String)o2.name);
        };
        final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            @NotNull
            public Component getTableCellRendererComponent(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
                String hint;
                int style;
                boolean isUser;
                if (table == null) {
                    7.$$$reportNull$$$0(0);
                }
                Component result = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column2);
                DriverPropertyInfo o = (DriverPropertyInfo)AdvancedPropertiesPanel.this.myPropertiesTable.getListTableModel().getItems().get(AdvancedPropertiesPanel.this.myPropertiesTable.convertRowIndexToModel(row));
                String propertyValue = AdvancedPropertiesPanel.this.myValuesMap.get(o.name);
                boolean isJdbcDef = propertyValue == null;
                boolean resetsDrivers = isJdbcDef && AdvancedPropertiesPanel.this.myValuesMap.isOverridden(o.name);
                boolean bl = isUser = !isJdbcDef && AdvancedPropertiesPanel.this.myValuesMap.isUser(o.name);
                if (isUser) {
                    style = 1;
                    hint = DatabaseBundle.message((String)"jdbc.properties.value.user", (Object[])new Object[0]);
                } else if (resetsDrivers) {
                    style = column2 == 0 ? 0 : 1;
                    hint = DatabaseBundle.message((String)"jdbc.properties.value.resets.driver", (Object[])new Object[0]);
                } else if (isJdbcDef) {
                    style = 0;
                    hint = DatabaseBundle.message((String)"jdbc.properties.value.default", (Object[])new Object[0]);
                } else {
                    style = column2 == 0 ? 1 : 0;
                    hint = DatabaseBundle.message((String)"jdbc.properties.value.driver", (Object[])new Object[0]);
                }
                result.setFont(result.getFont().deriveFont(style));
                ((JComponent)result).setToolTipText(hint);
                if (StringUtil.isEmpty((String)o.name) && StringUtil.isEmpty((String)o.value)) {
                    this.setText(column2 == 0 ? DatabaseBundle.message((String)"user.defined", (Object[])new Object[0]) : DatabaseBundle.message((String)"value", (Object[])new Object[0]));
                }
                if (!isSelected) {
                    if (StringUtil.isEmpty((String)o.name)) {
                        result.setForeground(UIUtil.getInactiveTextColor());
                    } else if (o.description == AdvancedPropertiesPanel.USER_DEFINED_DESCRIPTION) {
                        result.setForeground(PlatformColors.BLUE);
                    } else {
                        result.setForeground(UIUtil.getLabelForeground());
                    }
                }
                Component component = result;
                if (component == null) {
                    7.$$$reportNull$$$0(1);
                }
                return component;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTableCellRendererComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getTableCellRendererComponent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        JBTextField editor1Field = new JBTextField();
        editor1Field.setBorder(renderer.getBorder());
        final ComboBox editor2Combo = new ComboBox();
        editor2Combo.setBorder(null);
        editor2Combo.setEditable(false);
        final DefaultCellEditor editor1 = new DefaultCellEditor((JTextField)editor1Field);
        final DefaultCellEditor editor2 = new DefaultCellEditor((JComboBox<?>)editor2Combo);
        editor2Combo.registerTableCellEditor((TableCellEditor)editor2);
        editor1.setClickCountToStart(1);
        editor2.setClickCountToStart(1);
        this.myPropertiesTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{new ColumnInfo<DriverPropertyInfo, String>(DatabaseBundle.message((String)"jdbc.properties.column.name", (Object[])new Object[0])){

            public String valueOf(DriverPropertyInfo o) {
                return o.required ? o.name + " *" : o.name;
            }

            public TableCellRenderer getRenderer(DriverPropertyInfo driverPropertyInfo) {
                return renderer;
            }

            public Comparator<DriverPropertyInfo> getComparator() {
                return comparator2;
            }

            public boolean isCellEditable(DriverPropertyInfo driverPropertyInfo) {
                return driverPropertyInfo.description == AdvancedPropertiesPanel.USER_DEFINED_DESCRIPTION;
            }

            public void setValue(DriverPropertyInfo driverPropertyInfo, String value2) {
                String prevName = driverPropertyInfo.name;
                driverPropertyInfo.name = value2;
                String propValue = AdvancedPropertiesPanel.this.myValuesMap.reset(prevName);
                if (StringUtil.isEmpty((String)value2) && propValue != null) {
                    driverPropertyInfo.value = propValue;
                }
                if (StringUtil.isEmpty((String)driverPropertyInfo.value) || StringUtil.isEmpty((String)value2)) {
                    DbUIUtil.invokeLater(() -> {
                        if (!AdvancedPropertiesPanel.this.myPropertiesTable.isShowing()) {
                            return;
                        }
                        int index2 = AdvancedPropertiesPanel.this.myPropertiesTable.getListTableModel().getItems().indexOf(driverPropertyInfo);
                        if (index2 < 0) {
                            return;
                        }
                        int row = AdvancedPropertiesPanel.this.myPropertiesTable.convertRowIndexToView(index2);
                        TableUtil.editCellAt(AdvancedPropertiesPanel.this.myPropertiesTable, (int)row, (int)1);
                    });
                }
                AdvancedPropertiesPanel.this.ensureNewPropertyPresent();
            }

            public TableCellEditor getEditor(DriverPropertyInfo info) {
                return editor1;
            }
        }, new ColumnInfo<DriverPropertyInfo, String>(DatabaseBundle.message((String)"jdbc.properties.column.value", (Object[])new Object[0])){

            public String valueOf(DriverPropertyInfo o) {
                String value2 = AdvancedPropertiesPanel.this.myValuesMap.get(o.name);
                return value2 == null ? o.value : value2;
            }

            public boolean isCellEditable(DriverPropertyInfo driverPropertyInfo) {
                return true;
            }

            public void setValue(DriverPropertyInfo driverPropertyInfo, String value2) {
                if (driverPropertyInfo.description == AdvancedPropertiesPanel.USER_DEFINED_DESCRIPTION && AdvancedPropertiesPanel.this.myValuesMap.get(driverPropertyInfo.name) == null) {
                    driverPropertyInfo.value = value2;
                } else if (AdvancedPropertiesPanel.this.myValuesMap.hasDefault(driverPropertyInfo.name) || !Objects.equals(StringUtil.nullize((String)driverPropertyInfo.value), StringUtil.nullize((String)value2))) {
                    AdvancedPropertiesPanel.this.myValuesMap.put(driverPropertyInfo.name, value2);
                } else {
                    AdvancedPropertiesPanel.this.myValuesMap.reset(driverPropertyInfo.name);
                }
                AdvancedPropertiesPanel.this.ensureNewPropertyPresent();
            }

            public TableCellRenderer getRenderer(DriverPropertyInfo driverPropertyInfo) {
                return renderer;
            }

            public TableCellEditor getEditor(DriverPropertyInfo o) {
                if (o.choices == null || o.choices.length == 0) {
                    return editor1;
                }
                editor2Combo.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(o.choices), (Object)o.value));
                return editor2;
            }
        }}, new ArrayList<DriverPropertyInfo>(this.myUserProperties), -1));
    }

    private void ensureNewPropertyPresent() {
        ArrayList<DriverPropertyInfo> emptyProperties = new ArrayList<DriverPropertyInfo>();
        for (DriverPropertyInfo property : this.myUserProperties) {
            if (!StringUtil.isEmpty((String)property.name) || !StringUtil.isEmpty((String)property.value)) continue;
            emptyProperties.add(property);
        }
        ArrayList<DriverPropertyInfo> toRemove = emptyProperties.isEmpty() ? emptyProperties : emptyProperties.subList(0, emptyProperties.size() - 1);
        this.myUserProperties.removeAll(toRemove);
        ListTableModel model = this.myPropertiesTable.getListTableModel();
        List items2 = model.getItems();
        if (!toRemove.isEmpty()) {
            int row = Math.min(this.myPropertiesTable.getSelectedRow(), model.getRowCount() - toRemove.size());
            for (DriverPropertyInfo property : toRemove) {
                model.removeRow(items2.indexOf(property));
            }
            this.myPropertiesTable.getSelectionModel().setSelectionInterval(row, row);
        }
        if (emptyProperties.isEmpty()) {
            DriverPropertyInfo property = this.addUserDefinedProperty("", "", false);
            model.addRow((Object)property);
            Rectangle rect = this.myPropertiesTable.getCellRect(model.getRowCount() - 1, 0, false);
            this.myPropertiesTable.scrollRectToVisible(rect);
        }
    }

    public void saveProperties(Map<String, String> driverProperties) {
        driverProperties.clear();
        driverProperties.putAll(this.myValuesMap.getValues());
        List allProperties = this.myPropertiesTable.getListTableModel().getItems();
        for (DriverPropertyInfo property : this.myUserProperties) {
            if (StringUtil.isEmpty((String)property.name) || this.myValuesMap.get(property.name) != null || !allProperties.contains(property)) continue;
            driverProperties.put(property.name, property.value);
        }
    }

    @Nullable
    public String getJrePath() {
        String item = (String)this.myJreCombo.getEditor().getItem();
        return item == null ? null : StringUtil.nullize((String)item.trim(), (String)DEFAULT);
    }

    public void setJrePath(@NlsSafe @Nullable String path) {
        this.myJreCombo.setSelectedItem((Object)StringUtil.notNullize((String)path, (String)DEFAULT));
    }

    public String getVmOptions() {
        return this.myVMParameters.getText().trim();
    }

    public void setVmOptions(String options) {
        this.myVMParameters.setText(options);
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map map2 = this.myVMEnv.getEnvs();
        if (map2 == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(6);
        }
        return map2;
    }

    public void setVmEnv(@NotNull Map<String, String> env) {
        if (env == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(7);
        }
        this.myVMEnv.setEnvs(env);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/AdvancedPropertiesPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        JTextArea jTextArea;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        jBLoadingPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jBLoadingPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBLoadingPanel.add((Component)jBScrollPane, "Center");
        TableView<DriverPropertyInfo> tableView = this.myPropertiesTable;
        jBScrollPane.setViewportView((Component)tableView);
        JBScrollPane jBScrollPane2 = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myPropertyInfo = jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jBScrollPane2.setViewportView(jTextArea);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12), null, 0, 0, null, null));
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton = this.myVMEnv;
        jPanel4.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("data.source.vm.env.label"));
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("data.source.vm.options.label"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myVMParameters;
        jPanel4.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myJrePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("data.source.vm.home.label"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        ComboBox<String> comboBox = this.myJreCombo;
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myWorkingDirPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/ExecutionBundle", AdvancedPropertiesPanel.class).getString("run.configuration.working.directory.label"));
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myWorkingDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class FallThroughValues {
        private final Map<String, String> myValues = new LinkedHashMap<String, String>();
        private final Map<String, String> myDefaults = new LinkedHashMap<String, String>();

        private FallThroughValues() {
        }

        @Nullable
        String get(@NotNull String key) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(0);
            }
            return this.myValues.containsKey(key) ? this.myValues.get(key) : this.getDefault(key);
        }

        private String getDefault(@NotNull String key) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(1);
            }
            return this.myDefaults.get(key);
        }

        void put(@NotNull String key, @Nullable String value2) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(2);
            }
            if (Objects.equals(value2, this.myDefaults.get(key))) {
                this.myValues.remove(key);
            } else {
                this.myValues.put(key, value2);
            }
        }

        String reset(@NotNull String key) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(3);
            }
            return this.myValues.remove(key);
        }

        boolean isOverridden(@NotNull String key) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(4);
            }
            return this.isUser(key) && this.hasDefault(key);
        }

        boolean hasDefault(@NotNull String key) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(5);
            }
            return this.myDefaults.containsKey(key);
        }

        boolean isUser(@NotNull String key) {
            if (key == null) {
                FallThroughValues.$$$reportNull$$$0(6);
            }
            return this.myValues.containsKey(key);
        }

        public void setDefaults(@NotNull Map<String, String> map2) {
            if (map2 == null) {
                FallThroughValues.$$$reportNull$$$0(7);
            }
            this.myDefaults.clear();
            this.myDefaults.putAll(map2);
            Iterator<Map.Entry<String, String>> it2 = this.myValues.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<String, String> e = it2.next();
                if (!Objects.equals(e.getValue(), this.myDefaults.get(e.getKey()))) continue;
                it2.remove();
            }
        }

        @NotNull
        private Map<String, String> getValues() {
            Map<String, String> map2 = this.myValues;
            if (map2 == null) {
                FallThroughValues.$$$reportNull$$$0(8);
            }
            return map2;
        }

        public void setProperties(Map<String, String> properties) {
            this.myValues.clear();
            for (Map.Entry<String, String> e : properties.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$FallThroughValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$FallThroughValues";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefault";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isOverridden";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasDefault";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isUser";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaults";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyJreComboBox
    extends ComboBox<String> {
        final Map<String, JdkBundle> bundleMap = new HashMap<String, JdkBundle>();
        boolean loaded;

        MyJreComboBox() {
            super(100);
            ((DefaultComboBoxModel)this.getModel()).addElement(AdvancedPropertiesPanel.DEFAULT);
            this.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.ensureModelLoaded();
                }
            });
            this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

                protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NlsSafe String value2, int index2, boolean selected, boolean hasFocus) {
                    JdkBundle bundle;
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    JavaVersion version = (bundle = bundleMap.get(value2)) != null ? bundle.getBundleVersion() : (value2 == AdvancedPropertiesPanel.DEFAULT ? JavaVersion.current() : null);
                    this.append(value2);
                    if (version != null) {
                        this.append(" " + DatabaseBundle.message((String)"jdbc.properties.java.version", (Object[])new Object[]{version}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/AdvancedPropertiesPanel$MyJreComboBox$2", "customizeCellRenderer"));
                }
            });
            this.setEditor(new BasicComboBoxEditor(){

                @Override
                protected JTextField createEditorComponent() {
                    ExtendableTextField field = new ExtendableTextField().addBrowseExtension(() -> this.showDialog(), null);
                    field.setTextToTriggerEmptyTextStatus(AdvancedPropertiesPanel.DEFAULT);
                    field.getEmptyText().appendText(AdvancedPropertiesPanel.DEFAULT, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    field.getEmptyText().appendText(" " + DatabaseBundle.message((String)"jdbc.properties.java.version", (Object[])new Object[]{JavaVersion.current()}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    field.setBorder(null);
                    field.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            this.update(e);
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            this.update(e);
                        }

                        private void update(FocusEvent e) {
                            Container c2 = e.getComponent().getParent();
                            if (c2 != null) {
                                c2.revalidate();
                                c2.repaint();
                            }
                        }
                    });
                    InsertPathAction.addTo((JTextComponent)field);
                    return field;
                }
            });
        }

        private void showDialog() {
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), null, null);
            if (file != null) {
                this.setSelectedItem(FileUtil.toSystemDependentName((String)file.getPath()));
            }
        }

        private void ensureModelLoaded() {
            if (this.loaded) {
                return;
            }
            new Task.Backgroundable(null, DatabaseBundle.message((String)"jdbc.properties.updating.jre.list", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    JdkBundleList bundles = JdkUtils.findJdkBundles((ProgressIndicator)indicator);
                    ComboBoxModel model = this.getModel();
                    String item = (String)((DefaultComboBoxModel)model).getSelectedItem();
                    Collection found = bundles.getBundles();
                    UIUtil.invokeLaterIfNeeded(() -> this.lambda$run$0((DefaultComboBoxModel)model, found, item));
                }

                private /* synthetic */ void lambda$run$0(DefaultComboBoxModel model, Collection found, String item) {
                    model.removeAllElements();
                    model.addElement(AdvancedPropertiesPanel.DEFAULT);
                    for (JdkBundle bundle : found) {
                        String path = bundle.getHome().getAbsolutePath();
                        bundleMap.put(path, bundle);
                        model.addElement(path);
                    }
                    model.setSelectedItem(item);
                    loaded = true;
                    this.hidePopup();
                    this.showPopup();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/AdvancedPropertiesPanel$MyJreComboBox$4", "run"));
                }
            }.queue();
        }

        public DefaultComboBoxModel<String> getModel() {
            return (DefaultComboBoxModel)super.getModel();
        }
    }
}

