/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.openapi.util.Key;
import com.intellij.util.Function;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorModelUtil {
    private static final Key<Boolean> STUB_FLAG = Key.create((String)"STUB_FLAG");

    @NotNull
    public static DeTable stubbize(@Nullable DeTable table, @Nullable DeObject parent2, @NotNull DeModel model) {
        if (model == null) {
            EditorModelUtil.$$$reportNull$$$0(0);
        }
        if (table != null) {
            DeTable deTable = table;
            if (deTable == null) {
                EditorModelUtil.$$$reportNull$$$0(1);
            }
            return deTable;
        }
        return EditorModelUtil.setStub(new DeTable("", parent2, model));
    }

    @NotNull
    public static DeColumn stubbize(@Nullable DeColumn column2, @NotNull DeTable parent2, @NotNull DeModel model) {
        if (parent2 == null) {
            EditorModelUtil.$$$reportNull$$$0(2);
        }
        if (model == null) {
            EditorModelUtil.$$$reportNull$$$0(3);
        }
        return EditorModelUtil.stubbize(column2, "", parent2, model);
    }

    @NotNull
    public static DeColumn stubbize(@Nullable DeColumn column2, @NotNull String name, @NotNull DeTable parent2, @NotNull DeModel model) {
        if (name == null) {
            EditorModelUtil.$$$reportNull$$$0(4);
        }
        if (parent2 == null) {
            EditorModelUtil.$$$reportNull$$$0(5);
        }
        if (model == null) {
            EditorModelUtil.$$$reportNull$$$0(6);
        }
        if (column2 != null) {
            DeColumn deColumn = column2;
            if (deColumn == null) {
                EditorModelUtil.$$$reportNull$$$0(7);
            }
            return deColumn;
        }
        return EditorModelUtil.setStub(new DeColumn(name, parent2, model));
    }

    @NotNull
    public static <De extends DeObject> De setStub(@NotNull De object) {
        if (object == null) {
            EditorModelUtil.$$$reportNull$$$0(8);
        }
        STUB_FLAG.set(object.flags, (Object)Boolean.TRUE);
        De De = object;
        if (De == null) {
            EditorModelUtil.$$$reportNull$$$0(9);
        }
        return De;
    }

    public static boolean isStub(@Nullable DeObject object) {
        return object == null || STUB_FLAG.get(object.flags) == Boolean.TRUE;
    }

    @NotNull
    public static String makeUnique(String name, DeObject object) {
        Set names;
        DeObject tmp;
        for (tmp = object; tmp != null && tmp.getKind() != ObjectKind.SCHEMA; tmp = tmp.getParent()) {
        }
        Set set = names = tmp == null ? Collections.emptySet() : ((JBTreeTraverser)((JBTreeTraverser)tmp.model.traverser().withRoot((Object)tmp)).expandAndSkip(o -> o.getKind() != object.getKind())).traverse().filter(o -> o != object).transform(DeObject::getName).toSet();
        if (!names.contains(name)) {
            String string = name;
            if (string == null) {
                EditorModelUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        int i2 = 2;
        while (true) {
            String n;
            if (!names.contains(n = name + "_" + i2)) {
                String string = n;
                if (string == null) {
                    EditorModelUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            ++i2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/EditorModelUtil";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/EditorModelUtil";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "stubbize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "makeUnique";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stubbize";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GeneratedNameHelper<De extends DeObject> {
        private final De myObject;
        @NotNull
        private final Function<? super De, String> myTemplate;
        private String myGenerated;

        public GeneratedNameHelper(@NotNull De object, @NotNull Function<? super De, String> template) {
            if (object == null) {
                GeneratedNameHelper.$$$reportNull$$$0(0);
            }
            if (template == null) {
                GeneratedNameHelper.$$$reportNull$$$0(1);
            }
            this.myObject = object;
            this.myTemplate = template;
            this.myGenerated = this.generateName();
        }

        @NotNull
        public String generateName() {
            String name = (String)this.myTemplate.fun(this.myObject);
            String string = EditorModelUtil.makeUnique(name, this.myObject);
            if (string == null) {
                GeneratedNameHelper.$$$reportNull$$$0(2);
            }
            return string;
        }

        private boolean isNotGeneratedYet() {
            return ((DeObject)this.myObject).name.isEmpty() && (!((DeObject)this.myObject).hasEdited() || !((DeObject)this.myObject).getPrevName().isEmpty());
        }

        public boolean updateGenerated() {
            boolean updateObject = this.isNotGeneratedYet() || ((DeObject)this.myObject).getName().equals(this.myGenerated);
            String generated = this.generateName();
            if (generated.equals(((DeObject)this.myObject).name)) {
                return false;
            }
            this.myGenerated = generated;
            if (updateObject) {
                ((DeObject)this.myObject).name = this.myGenerated;
            }
            return updateObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/models/EditorModelUtil$GeneratedNameHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/models/EditorModelUtil$GeneratedNameHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

