/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.editors.ShutSplitter;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEditorWithPreview {
    protected DatabaseEditorBaseEx myEditor;
    private final JComponent myPanel;
    private DdlPreview myDdlPreview;
    private boolean myInvalid;
    private final EventDispatcher<PreviewListener> myPreviewListener = EventDispatcher.create(PreviewListener.class);
    private DdlPreview.ModelTraverser myTraverser = null;
    private JComponent myTrailWidget;

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor == null ? null : this.myEditor.getPreferredFocusedComponent();
    }

    public ObjectEditorWithPreview() {
        this.myPanel = new JPanel(new BorderLayout());
    }

    public void subscribePreviewChanged(@NotNull PreviewListener listener2) {
        if (listener2 == null) {
            ObjectEditorWithPreview.$$$reportNull$$$0(0);
        }
        this.myPreviewListener.addListener((EventListener)listener2);
    }

    public void setTrailWidget(@Nullable JComponent widget) {
        this.myTrailWidget = widget;
    }

    public void setEditor(@NotNull DatabaseEditorBaseEx editor, @NotNull DdlPreview.ModelTraverser traverser) {
        if (editor == null) {
            ObjectEditorWithPreview.$$$reportNull$$$0(1);
        }
        if (traverser == null) {
            ObjectEditorWithPreview.$$$reportNull$$$0(2);
        }
        assert (this.myEditor == null);
        this.myEditor = editor;
        this.myTraverser = traverser;
        this.myDdlPreview = new DdlPreview(editor.getContext());
        this.myDdlPreview.getComponent().setMinimumSize((Dimension)JBUI.size((int)100));
        this.myEditor.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                ObjectEditorWithPreview.this.updatePreview();
            }
        }, editor);
        this.myPanel.removeAll();
        final ShutSplitter splitter = DatabaseEditorUtil.createHideableSplitter(DatabaseBundle.message((String)"ObjectEditorWithPreview.label.sql.script", (Object[])new Object[0]), this.myEditor.getComponent(), this.myDdlPreview.getComponent(), ObjectEditorWithPreview.class.getName());
        JComponent gear = DbUIUtil.createActionComponent(DatabaseScriptDialog.createSettingsPopupAction((Getter<ScriptingTask>)((Getter)this::getTask), (Consumer<ScriptingOptions>)((Consumer)this::setOptions)));
        splitter.setTrailWidget(this.myTrailWidget == null ? gear : JBUI.Panels.simplePanel().addToLeft((Component)gear).addToCenter((Component)this.myTrailWidget));
        splitter.setTitleLabelFor(this.myDdlPreview.getPreferredFocusedComponent());
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickImplementations").getShortcuts();
        new DumbAwareAction(DatabaseBundle.messagePointer((String)"action.ObjectEditorWithPreview.toggle.sql.script.preview.text", (Object[])new Object[0]), DatabaseBundle.messagePointer((String)"action.ObjectEditorWithPreview.toggle.sql.script.preview.description", (Object[])new Object[0]), null){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                splitter.setShut(!splitter.isShut());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/ObjectEditorWithPreview$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)((Object)splitter));
        splitter.setDividerToolTipText(DatabaseBundle.message((String)"ObjectEditorWithPreview.tooltip.toggle.sql.script.preview", (Object[])new Object[]{KeymapUtil.getShortcutsText((Shortcut[])shortcuts), shortcuts.length == 0 ? 0 : 1}));
        this.myPanel.add((Component)((Object)splitter), "Center");
        this.updatePreview();
    }

    public void updatePreview() {
        if (this.myEditor == null) {
            return;
        }
        if (this.myTraverser == null) {
            this.myTraverser = new DdlPreview.ModelTraverser(this.myEditor.getModel().getModel());
        }
        this.myInvalid = !this.myDdlPreview.updatePreview(this.myTraverser);
        ((PreviewListener)this.myPreviewListener.getMulticaster()).changed();
    }

    public void setOptions(@NotNull ScriptingOptions options) {
        if (options == null) {
            ObjectEditorWithPreview.$$$reportNull$$$0(3);
        }
        if (this.myTraverser != null) {
            this.myTraverser.setOptions(options);
        }
        this.updatePreview();
    }

    @Nullable
    public ScriptingTask getTask() {
        return this.myTraverser == null ? null : this.myTraverser.getTask();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            ObjectEditorWithPreview.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    public boolean isInvalid() {
        return this.myInvalid;
    }

    @NotNull
    public String getStatement() {
        String string = this.myDdlPreview == null ? "" : this.myDdlPreview.getPreviewText();
        if (string == null) {
            ObjectEditorWithPreview.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/ObjectEditorWithPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/ObjectEditorWithPreview";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subscribePreviewChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PreviewListener
    extends EventListener {
        public void changed();
    }
}

