/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DatabaseObjectEditor
extends DatabaseEditorBaseEx {
    private EditorTextField myNameField;
    private JPanel myPanel;
    private final ObjectEditorModel<?> myObjectModel;
    private final DatabaseEditorCapabilities.ObjectEditorCaps myCaps;
    private final EditorModelBase.Listener myChangeListener;

    public DatabaseObjectEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.ObjectEditorCaps caps, @NotNull ObjectEditorModel<?> model) {
        if (state == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(1);
        }
        if (model == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(2);
        }
        super(state);
        this.myChangeListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseObjectEditor.this.fromModelToUi();
            }
        };
        this.myObjectModel = model;
        this.myCaps = caps;
        this.$$$setupUI$$$();
        this.applyCaps();
        this.setupControls();
    }

    private void applyCaps() {
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    @Override
    @NotNull
    public ObjectEditorModel<?> getModel() {
        ObjectEditorModel<?> objectEditorModel = this.myObjectModel;
        if (objectEditorModel == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(3);
        }
        return objectEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseObjectEditor.setValue(this.myNameField, this.myObjectModel.getName());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField2 = this.myNameField;
        if (editorTextField2 == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(5);
        }
        return editorTextField2;
    }

    private void initSubscriptions() {
        this.myObjectModel.addListener(this.myChangeListener, this);
        this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!DatabaseObjectEditor.this.myUpdating) {
                    DatabaseObjectEditor.this.myObjectModel.setName(DatabaseObjectEditor.this.myNameField.getText());
                    DatabaseObjectEditor.this.myObjectModel.commit();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/editors/DatabaseObjectEditor$2", "documentChanged"));
            }
        });
    }

    @Nullable
    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.myObjectModel.getName())) {
            return new ValidationInfo(DatabaseBundle.message((String)"dialog.message.valid.name", (Object[])new Object[]{this.myObjectModel.getName(), ((DeObject)this.myObjectModel.getObject()).getKind().code()}), (JComponent)this.myNameField);
        }
        return null;
    }

    public EditorTextField getNameEditor() {
        return this.myNameField;
    }

    @Override
    @TestOnly
    @NotNull
    public DatabaseEditorCapabilities.ObjectEditorCaps getCaps() {
        DatabaseEditorCapabilities.ObjectEditorCaps objectEditorCaps = this.myCaps;
        if (objectEditorCaps == null) {
            DatabaseObjectEditor.$$$reportNull$$$0(6);
        }
        return objectEditorCaps;
    }

    private void createUIComponents() {
        this.myNameField = new EditorTextField(this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseObjectEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseObjectEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseObjectEditor.class).getString("DatabaseObjectEditor.label.name"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        EditorTextField editorTextField2 = this.myNameField;
        jPanel.add((Component)editorTextField2, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

