/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor {
    public static final SimpleTextAttributes INFO_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
    public static final SimpleTextAttributes INACTIVE_LINK_ATTRS = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.derive(SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES.getStyle() | 0x200, null, null, null);
    public static final SimpleTextAttributes ACTIVE_LINK_ATTRS = INACTIVE_LINK_ATTRS.derive(INACTIVE_LINK_ATTRS.getStyle() | 0x400, UIUtil.getLabelForeground(), null, null);
    static final String spaceDelimiter = "\u2002";

    public static void updatePresentation(PresentationData presentation, DasObject element2, Project project, DatabaseViewOptions viewOptions, TreePath pathUnderMouse) {
        presentation.clear();
        if (project.isDisposed()) {
            return;
        }
        presentation.setIcon(element2 instanceof DbDataSource ? DbNodeDescriptor.getDataSourceIcon((DbDataSource)element2) : DbPresentation.getIcon(element2));
        boolean commentsMode = UISettings.getInstance().getShowInplaceComments();
        String nodeText = DbPresentation.getPresentableName(element2, false);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes style = DbNodeDescriptor.handleErrors(project, presentation, element2, viewOptions);
        style = DbNodeDescriptor.handleModified(project, element2, style);
        presentation.addText(StringUtil.isEmpty((String)nodeText) ? DbPresentation.UNNAMED : nodeText, style);
        DbNodeDescriptor.addSpaceDelimiter(presentation);
        String comment = DbNodeDescriptor.adjustCommentString(element2.getComment());
        Dbms dbms = element2 instanceof BasicElement ? DbImplUtil.getDbms((BasicElement)element2) : Dbms.UNKNOWN;
        DescriptionService service = ModelFacade.forDbms(dbms).getDescriptionService();
        if (!commentsMode || StringUtil.isEmpty((String)comment)) {
            service.updatePresentation(project, element2, presentation);
        }
        if (element2 instanceof DbDataSource || element2 instanceof DasNamespace) {
            DbNodeDescriptor.appendCollapsedNamespaces(project, presentation, element2, viewOptions);
        }
        boolean activate = pathUnderMouse != null && element2 == pathUnderMouse.getLastPathComponent();
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, element2, project, viewOptions, activate);
        if (StringUtil.isNotEmpty((String)comment)) {
            DbNodeDescriptor.addTooltip(presentation, true, "<pre>" + StringUtil.escapeXmlEntities((String)comment) + "</pre>");
            if (commentsMode) {
                DbNodeDescriptor.addSpaceDelimiter(presentation);
                presentation.addText(comment, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
        }
    }

    public static void updatePresentation(@NotNull PresentationData presentation, @NotNull DatabaseStructure.FamilyGroup.EmptyScopeLeaf node, Project project, DatabaseViewOptions viewOptions, @Nullable TreePath pathUnderMouse) {
        if (presentation == null) {
            DbNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DbNodeDescriptor.$$$reportNull$$$0(1);
        }
        presentation.clear();
        presentation.addText(DatabaseBundle.message((String)"label.no.schemas.selected", (Object[])new Object[]{StringUtil.pluralize((String)node.getKind().getPresentableName())}), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        presentation.addText("  ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
        boolean activate = pathUnderMouse != null && node == pathUnderMouse.getLastPathComponent();
        DbNodeDescriptor.appendNamespaceChooserLink(presentation, node.getDasParent(), project, viewOptions, activate);
    }

    private static SimpleTextAttributes handleModified(Project project, DasObject element2, SimpleTextAttributes style) {
        BasicSourceAware sa = (BasicSourceAware)ObjectUtils.tryCast((Object)element2, BasicSourceAware.class);
        DbDataSource dataSource2 = sa == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)sa);
        VirtualFile file = dataSource2 == null ? null : DbSrcUtils.findDbSrcFile(dataSource2, sa, false);
        FileStatus status = file == null ? null : DbSrcChangesTracker.getFileStatuses().getStatus(file).getStatus();
        return status == null ? style : style.derive(-1, status.getColor(), null, null);
    }

    @Nullable
    private static Icon getDataSourceIcon(@NotNull DbDataSource element2) {
        if (element2 == null) {
            DbNodeDescriptor.$$$reportNull$$$0(2);
        }
        Project project = element2.getProject();
        Icon icon = element2.getIcon();
        if (project.isDisposed()) {
            return icon;
        }
        DatabaseSystem delegate = element2.getDelegate();
        if (delegate instanceof LocalDataSource) {
            LocalDataSource lds = (LocalDataSource)delegate;
            if (DataSourceSyncManager.getInstance().isActive(lds) || lds.isLoading()) {
                return AnimatedIcon.Default.INSTANCE;
            }
            int connectionCount = DbImplUtil.isConnected(project, lds) ? DbImplUtil.getActiveConnectionCount(lds) : 0;
            return connectionCount > 0 ? ExecutionUtil.getLiveIndicator((Icon)icon) : icon;
        }
        if (delegate instanceof SqlDataSource && !((SqlDataSource)delegate).isReady()) {
            return AnimatedIcon.Default.INSTANCE;
        }
        return icon;
    }

    @NotNull
    public static String adjustCommentString(@Nullable String comment) {
        String string = comment == null ? "" : StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true);
        if (string == null) {
            DbNodeDescriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void appendNamespaceChooserLink(PresentationData presentation, DasObject element2, Project project, DatabaseViewOptions viewOptions, boolean activate) {
        Couple<Integer> counters = DbNodeDescriptor.getNamespaceCounts(project, element2, viewOptions);
        if (counters == null) {
            return;
        }
        int enabled = (Integer)counters.first;
        int total = (Integer)counters.second;
        String text2 = enabled == 0 && total == 0 ? "  ...  " : (enabled != total ? " " + DatabaseBundle.message((String)"namespace.fraction", (Object[])new Object[]{enabled, total}) + " " : " " + enabled + " ");
        presentation.addText(text2, activate ? ACTIVE_LINK_ATTRS : INACTIVE_LINK_ATTRS);
    }

    @Nullable
    private static Couple<Integer> getNamespaceCounts(Project project, DasObject element2, DatabaseViewOptions viewOptions) {
        DbDataSource dataSource2;
        Object object = element2 instanceof DbDataSource ? (DbDataSource)element2 : (dataSource2 = element2 instanceof BasicNamespaceOwner ? DbPsiFacade.getInstance((Project)project).findDataSource(element2) : null);
        if (dataSource2 == null) {
            return null;
        }
        DasObject root2 = element2 instanceof BasicNamespaceOwner ? element2 : DatabaseStructure.getTopSingleRoot(dataSource2, viewOptions);
        DbElement dbElement = DbImplUtil.findElement(dataSource2, root2);
        if (dbElement == null) {
            return null;
        }
        return (Couple)CachedValuesManager.getCachedValue((PsiElement)dbElement, () -> new CachedValueProvider.Result(DbNodeDescriptor.calcNamespaceCounts(dbElement, viewOptions), new Object[]{DbPsiFacade.getInstance((Project)project), viewOptions}));
    }

    @Nullable
    private static Couple<Integer> calcNamespaceCounts(DbElement dbElement, DatabaseViewOptions viewOptions) {
        JBTreeTraverser traverser;
        DbDataSource dataSource2 = dbElement.getDataSource();
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource2);
        if (localDataSource == null) {
            return null;
        }
        DbDataSource element2 = dataSource2 == dbElement ? dataSource2 : (DasObject)dbElement.getDelegate();
        DasModel model = localDataSource.getModel();
        TreePattern scope = localDataSource.getIntrospectionScope();
        if (model instanceof BasicModel) {
            JBTreeTraverser tmp = ((BasicModel)model).basicTraverser();
            traverser = element2 instanceof BasicNamespaceOwner ? (JBTreeTraverser)tmp.withRoot((Object)((BasicElement)element2)) : tmp;
        } else {
            traverser = model.traverser();
        }
        Condition kindCondition = element2 == dataSource2 && model instanceof BasicModel && ((BasicModel)model).getRoot().familyOf(ObjectKind.DATABASE) != null ? DasUtil.byKind((ObjectKind)ObjectKind.DATABASE) : o -> DbImplUtil.isSchema(o);
        JBIterable allSchemas = ((JBTreeTraverser)((JBTreeTraverser)traverser.expandAndFilter(DasUtil.byClass(DasNamespace.class))).filter(kindCondition)).filter(DasNamespace.class);
        int enabled = 0;
        int total = 0;
        for (DasNamespace ns : allSchemas) {
            boolean shown = !viewOptions.HIDDEN_KINDS.contains(ns.getKind().code()) && DatabaseModelLoader.matches((DasObject)ns, scope);
            enabled += shown ? 1 : 0;
            ++total;
        }
        return Couple.of((Object)enabled, (Object)total);
    }

    private static void appendCollapsedNamespaces(Project project, PresentationData presentation, DasObject element2, DatabaseViewOptions options) {
        String textExt;
        DasObject root2;
        DasObject dasObject = options.SHOW_INTERMEDIATE ? element2 : (element2 instanceof DbDataSource ? DatabaseStructure.getTopSingleRoot((DbDataSource)element2, options) : (root2 = element2 instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(DbPsiFacade.getInstance((Project)project).findDataSource(element2), element2, options) : element2));
        if (root2 != element2 && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
            presentation.addText("(" + textExt + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            DbNodeDescriptor.addSpaceDelimiter(presentation);
        }
    }

    private static void addSpaceDelimiter(PresentationData presentation) {
        presentation.addText(spaceDelimiter, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static SimpleTextAttributes handleErrors(Project project, PresentationData presentation, Object element2, DatabaseViewOptions viewOptions) {
        SimpleTextAttributes style;
        boolean hasErrors = false;
        boolean hasWarnings = false;
        int connectionCount = -1;
        if (element2 instanceof DbDataSource) {
            LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DbDataSource)element2));
            hasErrors = dataSource2 != null && !DbImplUtil.canConnectTo(dataSource2);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(project, ((DbDataSource)element2).getDelegate(), null)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
            connectionCount = dataSource2 != null && DbImplUtil.isConnected(project, dataSource2) ? DbImplUtil.getActiveConnectionCount(dataSource2) : -1;
        } else if (element2 instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)element2).isInvalid();
        }
        SimpleTextAttributes simpleTextAttributes = style = element2 instanceof DasObject && DbPresentation.isUnnamed((DasObject)element2) ? INFO_ATTRS : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (viewOptions.SHOW_ALL_NAMESPACES && element2 instanceof DasObject && !DbNodeDescriptor.isIntrospected(project, (DasObject)element2)) {
            style = INFO_ATTRS;
        }
        if (hasErrors || hasWarnings) {
            SimpleTextAttributes waved = new SimpleTextAttributes(8, null, (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE));
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)waved);
        }
        if (hasErrors && element2 instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)element2)) {
            DbNodeDescriptor.addTooltip(presentation, false, DatabaseBundle.message((String)"tooltip.database.driver.files.not.found.open.properties.to.download", (Object[])new Object[0]));
        }
        if (connectionCount >= 0) {
            DbNodeDescriptor.addTooltip(presentation, false, DatabaseBundle.message((String)"tooltip.choice.connection.connections", (Object[])new Object[]{connectionCount, connectionCount == 1 ? 0 : 1}));
        }
        return style;
    }

    private static boolean isIntrospected(Project project, DasObject element2) {
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)element2, BasicNamespace.class);
        if (namespace == null) {
            return true;
        }
        TreePattern scope = DbImplUtil.getIntrospectionScope((DasDataSource)DbPsiFacade.getInstance((Project)project).findDataSource(element2));
        return DataSourceSchemaMapping.isIntrospected(scope, namespace);
    }

    private static void addTooltip(PresentationData presentation, boolean before2, @NlsContexts.Tooltip String tooltip) {
        Object result;
        String cur2 = presentation.getTooltip();
        if (StringUtil.isEmpty((String)cur2)) {
            result = tooltip;
        } else {
            String separator = "<p><p>";
            result = before2 ? tooltip + separator + cur2 : cur2 + separator + tooltip;
        }
        presentation.setTooltip((String)(((String)result).startsWith("<html>") ? result : "<html>" + (String)result));
    }

    @Nullable
    public static Object getData(@NonNls @NotNull String dataId, Project project, Object node) {
        if (dataId == null) {
            DbNodeDescriptor.$$$reportNull$$$0(4);
        }
        if (!(node instanceof DasObject)) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId) && node instanceof Navigatable) {
                return node;
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && node instanceof PsiElement) {
                return node;
            }
            return null;
        }
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return null;
        }
        DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource((DasObject)node);
        if (dataSource2 == null) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            if (node instanceof Navigatable && ((Navigatable)node).canNavigate()) {
                return node;
            }
            return DbImplUtil.findElement(dataSource2, (DasObject)node);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return DbImplUtil.findElement(dataSource2, (DasObject)node);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNodeDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustCommentString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceIcon";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

