/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.Searchable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DatabaseStructure
extends BaseTreeModel<Object>
implements InvokerSupplier,
Searchable {
    private static final Key<DbRootGroup> ROOT_GROUP = Key.create((String)"ROOT_GROUP");
    private static final Key<Map<DasObject, ConcurrentMap<ObjectKind, FamilyGroup>>> FAMILY_GROUPS = KeyWithDefaultValue.create((String)"FAMILY_GROUPS", () -> ConcurrentFactoryMap.create(o -> ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy()), () -> CollectionFactory.createConcurrentWeakIdentityMap()));
    private static final Key<Map<DbGroup, Map<String, DbGroup>>> DATABASE_GROUPS = KeyWithDefaultValue.create((String)"DATABASE_GROUPS", () -> ConcurrentFactoryMap.createWeakMap(group -> ConcurrentFactoryMap.create(name -> new DbGroup((String)name, (DbGroup)((Object)((Object)group))), CollectionFactory::createConcurrentWeakValueMap)));
    private static final boolean ourShowMiniCat = Registry.is((String)"database.view.show.mini.cat");
    private final Invoker myInvoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
    private final DbRootGroup myRootGroup;

    DatabaseStructure(DbPsiFacade facade, DatabaseViewOptions viewOptions) {
        this.myRootGroup = DatabaseStructure.getRootGroup(facade, viewOptions);
    }

    public void refreshAll() {
        this.treeStructureChanged(null, null, null);
    }

    public Object getRoot() {
        return this.myRootGroup;
    }

    public boolean isLeaf(Object node) {
        return DatabaseStructure.isAlwaysLeafImpl(node);
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            DatabaseStructure.$$$reportNull$$$0(0);
        }
        return invoker;
    }

    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        LinkedList<Object> result = new LinkedList<Object>();
        Object cur2 = object;
        while (cur2 != null) {
            result.addFirst(cur2);
            cur2 = DatabaseStructure.getParentImpl(cur2, this.myRootGroup.viewOptions, this.myRootGroup.facade);
        }
        Promise promise = Promises.resolvedPromise((Object)new TreePath(ArrayUtil.toObjectArray(result)));
        if (promise == null) {
            DatabaseStructure.$$$reportNull$$$0(1);
        }
        return promise;
    }

    private int compareNodes(@NotNull Object o1, @NotNull Object o2) {
        boolean isGroup2;
        boolean isGroup1;
        if (o1 == null) {
            DatabaseStructure.$$$reportNull$$$0(2);
        }
        if (o2 == null) {
            DatabaseStructure.$$$reportNull$$$0(3);
        }
        if ((isGroup1 = o1 instanceof Group) != (isGroup2 = o2 instanceof Group)) {
            return isGroup1 ? -1 : 1;
        }
        int weightDiff = DbPresentation.getWeight(o1, this.myRootGroup.viewOptions.SORT_POSITIONED) - DbPresentation.getWeight(o2, this.myRootGroup.viewOptions.SORT_POSITIONED);
        return weightDiff != 0 ? weightDiff : DbPresentation.NAMES_COMPARATOR.compare(DatabaseStructure.getName(o1), DatabaseStructure.getName(o2));
    }

    @NotNull
    public List<Object> getChildren(Object parent2) {
        ArrayList<Object> children2 = new ArrayList<Object>();
        for (Object o : this.getChildElements(parent2)) {
            if (children2.size() % 10 == 0) {
                ProgressManager.checkCanceled();
            }
            children2.add(o);
        }
        children2.sort(this::compareNodes);
        ArrayList<Object> arrayList = children2;
        if (arrayList == null) {
            DatabaseStructure.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static String getName(@NotNull Object o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(5);
        }
        return o instanceof DasObject ? DbPresentation.getPresentableName((DasObject)o, true) : (o instanceof PsiNamedElement ? ((PsiNamedElement)o).getName() : null);
    }

    @NotNull
    private JBIterable<?> getChildElements(Object element2) {
        if (element2 instanceof PsiElement && !((PsiElement)element2).isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }
        return DatabaseStructure.getChildrenImpl(element2, this.myRootGroup.viewOptions, this.myRootGroup.facade);
    }

    public static boolean isAlwaysLeafImpl(Object o) {
        if (o instanceof FamilyGroup.EmptyScopeLeaf) {
            return true;
        }
        BasicElement basic = o instanceof DasObject ? DbImplUtil.getMaybeBasicElement((DasObject)o) : null;
        List<ObjectKind> familyKinds = basic == null ? null : DatabaseStructure.getFamilyKinds(basic);
        return familyKinds != null && familyKinds.isEmpty() || o instanceof DasObject && (((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasTableChild && (familyKinds == null || familyKinds.isEmpty()) || o instanceof DasRoutine || o instanceof DasSynonym);
    }

    @NotNull
    private static JBIterable<? extends DasObject> getChildren(@NotNull DasObject object, @NotNull ObjectKind kidKind) {
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(7);
        }
        if (kidKind == null) {
            DatabaseStructure.$$$reportNull$$$0(8);
        }
        if (object instanceof BasicElement) {
            BasicElement element2 = (BasicElement)object;
            JBIterable<? extends BasicElement> jBIterable = Provider.forDbms(DbImplUtil.getDbms(element2)).getChildren(element2, kidKind);
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }
        JBIterable jBIterable = object.getDasChildren(kidKind);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private static List<ObjectKind> getFamilyKinds(@NotNull BasicElement element2) {
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(11);
        }
        List<ObjectKind> list = Provider.forDbms(DbImplUtil.getDbms(element2)).getFamilyKinds(element2);
        if (list == null) {
            DatabaseStructure.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static DasObject getParent(@NotNull DasObject o) {
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(13);
        }
        if (o instanceof BasicElement) {
            BasicElement element2 = (BasicElement)o;
            return Provider.forDbms(DbImplUtil.getDbms(element2)).getParent(element2);
        }
        return o.getDasParent();
    }

    public static boolean isDatabaseObject(Object element2) {
        return element2 instanceof DasObject || element2 instanceof Group;
    }

    @NotNull
    public static JBIterable<?> getChildrenImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        ObjectKind nspChild;
        DasObject root0;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(14);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(15);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(16);
        }
        if (o instanceof DbGroup) {
            return DatabaseStructure.getDbGroupChildrenImpl((DbGroup)((Object)o), viewOptions);
        }
        Object object = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).dasParent : (o instanceof DbDataSource && !viewOptions.SHOW_INTERMEDIATE ? DatabaseStructure.getTopSingleRoot((DbDataSource)o, viewOptions) : (o instanceof DasNamespace && !viewOptions.SHOW_INTERMEDIATE ? DatabaseStructure.getTopSingleRoot(facade.findDataSource((DasObject)((DasNamespace)o)), (DasObject)o, viewOptions) : (root0 = o instanceof DasObject ? (DasObject)o : null)));
        if (root0 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        DasObject root2 = root0;
        DbDataSource dataSource2 = facade.findDataSource(root2);
        if (dataSource2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        ObjectKind kidKind = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).kidKind : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtil.getMetaModel(dataSource2);
        boolean isNamespace = DatabaseStructure.isNamespace(metaModel, rootKind);
        boolean groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        Dbms dbms = dataSource2.getDbms();
        if (groupOption && kidKind == ObjectKind.NONE) {
            SmartList groups = new SmartList();
            int count2 = 0;
            Provider.PresentationToModelConverter converter = Provider.forDbms(dbms).getConverter();
            for (ObjectKind childKind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DatabaseStructure.getWeight(childKind, dbms, ++count2);
                JBIterable<? extends DasObject> kids = DatabaseStructure.getChildObjects(dataSource2, viewOptions, root2, childKind);
                if (viewOptions.HIDDEN_KINDS.contains(childKind.code()) || viewOptions.HIDDEN_KINDS.contains(converter.toModelObjectKind(childKind).code()) || !DatabaseStructure.shouldShowEmptyGroup(viewOptions, DatabaseStructure.isNamespace(metaModel, childKind)) && kids.isEmpty()) continue;
                FamilyGroup group = DatabaseStructure.getGroup(root2, childKind, weight, dbms, dataSource2);
                group.size = kids.size();
                groups.add(group);
            }
            if (groups.size() > 1) {
                JBIterable jBIterable = JBIterable.from((Iterable)groups);
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(19);
                }
                return jBIterable;
            }
        }
        JBIterable children2 = DatabaseStructure.getChildObjects(dataSource2, viewOptions, root2, kidKind);
        if (!viewOptions.HIDDEN_KINDS.isEmpty()) {
            children2 = children2.filter(oo -> !viewOptions.HIDDEN_KINDS.contains(oo.getKind().code()));
        }
        if (DatabaseStructure.isNamespace(metaModel, kidKind) && children2.isEmpty()) {
            JBIterable jBIterable = JBIterable.of((Object)((Object)((FamilyGroup)((Object)o)).getEmptyScopeLeaf()));
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(20);
            }
            return jBIterable;
        }
        if (isNamespace && kidKind == ObjectKind.NONE && children2.find(it2 -> DatabaseStructure.isNamespace(metaModel, it2.getKind())) == null && (nspChild = (ObjectKind)metaModel.getChildKinds(rootKind).find(it2 -> DatabaseStructure.isNamespace(metaModel, it2))) != null) {
            FamilyGroup extra = DatabaseStructure.getGroup(root2, nspChild, DatabaseStructure.getWeight(nspChild, dbms, 0), dbms, dataSource2);
            JBIterable jBIterable = JBIterable.of((Object)((Object)extra.getEmptyScopeLeaf())).append((Iterable)children2);
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(21);
            }
            return jBIterable;
        }
        JBIterable jBIterable = children2;
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(22);
        }
        return jBIterable;
    }

    private static boolean isNamespace(@NotNull MetaModel metaModel, @NotNull ObjectKind rootKind) {
        if (metaModel == null) {
            DatabaseStructure.$$$reportNull$$$0(23);
        }
        if (rootKind == null) {
            DatabaseStructure.$$$reportNull$$$0(24);
        }
        return rootKind == ObjectKind.ROOT || metaModel.getNamespaces().contains(rootKind);
    }

    private static int getWeight(@NotNull ObjectKind kind, @NotNull Dbms dbms, int groupCount) {
        int weight;
        if (kind == null) {
            DatabaseStructure.$$$reportNull$$$0(25);
        }
        if (dbms == null) {
            DatabaseStructure.$$$reportNull$$$0(26);
        }
        return (weight = Provider.forDbms(dbms).getWeight(kind, groupCount)) == -1 ? DbPresentation.getWeight(kind, groupCount) : weight;
    }

    @NotNull
    private static JBIterable<? extends PsiElement> getDbGroupChildrenImpl(@NotNull DbGroup group, @NotNull DatabaseViewOptions viewOptions) {
        if (group == null) {
            DatabaseStructure.$$$reportNull$$$0(27);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(28);
        }
        JBIterable parentGroups = JBIterable.generate((Object)((Object)group), o -> o.parent);
        DbRootGroup root2 = Objects.requireNonNull((DbRootGroup)((Object)parentGroups.filter(DbRootGroup.class).first()));
        JBIterable dataSources2 = JBIterable.from((Iterable)root2.facade.getDataSources());
        if (!viewOptions.GROUP_DATA_SOURCES) {
            JBIterable jBIterable = group instanceof DbRootGroup ? dataSources2 : JBIterable.empty();
            if (jBIterable == null) {
                DatabaseStructure.$$$reportNull$$$0(29);
            }
            return jBIterable;
        }
        String fullName = group.getQualifiedName();
        Map groups = (Map)((Map)DATABASE_GROUPS.getRequired((UserDataHolder)root2)).get((Object)group);
        HashSet<String> subNames = new HashSet<String>();
        ArrayList<Object> result = new ArrayList<Object>();
        for (DbDataSource dataSource2 : dataSources2) {
            String subName;
            String groupName = StringUtil.notNullize((String)((AbstractDataSource)dataSource2.getDelegate()).getGroupName());
            if (!groupName.startsWith(fullName)) continue;
            if (groupName.equals(fullName)) {
                result.add(dataSource2);
                continue;
            }
            if (fullName.length() != 0 && groupName.charAt(fullName.length()) != '/') continue;
            String substring = StringUtil.trimStart((String)groupName.substring(fullName.length()), (String)"/");
            int idx = substring.indexOf("/");
            String string = subName = idx < 0 ? substring : substring.substring(0, idx);
            if (subName.isEmpty()) continue;
            DbGroup subGroup = (DbGroup)((Object)groups.get(subName));
            if (!subNames.add(subName)) {
                ++subGroup.size;
                continue;
            }
            result.add((Object)subGroup);
            subGroup.size = 1;
        }
        JBIterable jBIterable = JBIterable.from(result);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<? extends DasObject> getChildObjects(DbDataSource ds, DatabaseViewOptions viewOptions, DasObject element2, ObjectKind kidKind) {
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)ds);
        TreePattern scope = lds == null || viewOptions.SHOW_ALL_NAMESPACES ? null : lds.getIntrospectionScope();
        DasModel model = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel() : null;
        Condition condition = null;
        if (element2 instanceof DasNamespace || element2 instanceof DbDataSource || element2 instanceof BasicRoot) {
            if (element2 instanceof BasicMateNamespace && ((BasicMateNamespace)element2).isSubstituted() && !ourShowMiniCat) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DatabaseStructure.$$$reportNull$$$0(31);
                }
                return jBIterable;
            }
            condition = DatabaseStructure.buildFilter((DasDataSource)ds);
            Condition displayed = o -> scope == null || !(o instanceof DasNamespace) || DataSourceSchemaMapping.matches(scope, o);
            Condition condition2 = condition = condition == null ? displayed : Conditions.and((Condition)condition, (Condition)displayed);
        }
        JBIterable res2 = model instanceof BasicModel ? ((BasicModel)model).getRoot().getDasChildren(kidKind) : (model != null ? model.getModelRoots().filter(DasUtil.byKind((ObjectKind)kidKind)) : DatabaseStructure.getChildren(element2, kidKind));
        JBIterable jBIterable = condition == null ? res2 : res2.filter(condition);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(32);
        }
        return jBIterable;
    }

    public static Condition<DasObject> buildFilter(DasDataSource ds) {
        LocalDataSource source = DbImplUtil.getMaybeLocalDataSource(ds);
        if (source != null) {
            try {
                Condition<DasObject> c2 = DataSourceUiUtil.buildObjectFilter(source);
                if (c2 == Conditions.alwaysTrue()) {
                    return null;
                }
                return o -> o instanceof DasNamespace || c2.value(o);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    private static Iterable<ObjectKind> getChildKinds(@NotNull Object element2, @NotNull MetaModel mm, @NotNull ObjectKind parentKind) {
        DasModel model;
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(33);
        }
        if (mm == null) {
            DatabaseStructure.$$$reportNull$$$0(34);
        }
        if (parentKind == null) {
            DatabaseStructure.$$$reportNull$$$0(35);
        }
        DasModel dasModel = model = element2 instanceof DbDataSource ? ((DbDataSource)element2).getModel() : null;
        Object delegate = model instanceof BasicModel ? ((BasicModel)model).getRoot() : (element2 instanceof DbElement ? ((DbElement)element2).getDelegate() : element2);
        JBIterable jBIterable = delegate instanceof BasicElement ? DatabaseStructure.getFamilyKinds((BasicElement)delegate) : mm.getChildKinds(parentKind);
        if (jBIterable == null) {
            DatabaseStructure.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    @Nullable
    public static <T extends DasModel> T getModel(DasDataSource ds, Class<T> clazz) {
        LocalDataSource local = DbImplUtil.getMaybeLocalDataSource(ds);
        return (T)(local == null ? null : (DasModel)ObjectUtils.tryCast((Object)local.getModel(), clazz));
    }

    @Nullable
    public static PsiElement getParentImpl(@NotNull PsiElement o, DatabaseViewOptions viewOptions) {
        PsiElement delegate;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(37);
        }
        if (!o.isValid()) {
            return null;
        }
        Project project = o.getProject();
        Object object = o instanceof DbDataSource ? o : (o instanceof DbElement ? ((DbElement)o).getDelegate() : (delegate = o instanceof Group ? o : null));
        if (delegate == null) {
            return null;
        }
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        Object parent2 = DatabaseStructure.getParentImpl(delegate, viewOptions, facade);
        if (parent2 instanceof DasObject && !(parent2 instanceof DbDataSource)) {
            DbDataSource dataSource2 = facade.findDataSource((DasObject)parent2);
            return dataSource2 == null ? null : DbImplUtil.findElement(dataSource2, (DasObject)parent2);
        }
        return parent2 instanceof PsiElement ? (PsiElement)parent2 : null;
    }

    private static boolean shouldShowEmptyGroup(@NotNull DatabaseViewOptions viewOptions, boolean isNamespace) {
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(38);
        }
        return viewOptions.SHOW_EMPTY_GROUPS || isNamespace;
    }

    @Nullable
    private static Object getParentImpl(@NotNull Object o, @NotNull DatabaseViewOptions viewOptions, @NotNull DbPsiFacade facade) {
        DasObject grandPa;
        boolean groupOption;
        if (o == null) {
            DatabaseStructure.$$$reportNull$$$0(39);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(40);
        }
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(41);
        }
        if (o instanceof DbGroup) {
            return ((DbGroup)((Object)o)).parent;
        }
        if (o instanceof DbDataSource) {
            return DatabaseStructure.getDbGroup(facade, ((AbstractDataSource)((DbDataSource)o).getDelegate()).getGroupName(), viewOptions);
        }
        Object root0 = o instanceof FamilyGroup ? ((FamilyGroup)((Object)o)).dasParent : (o instanceof DasObject ? DatabaseStructure.getParent((DasObject)o) : null);
        DasObject root1 = root0;
        if (root1 == null) {
            return null;
        }
        DbDataSource dataSource2 = facade.findDataSource(root1);
        if (dataSource2 == null) {
            return JBIterable.empty();
        }
        DbDataSource root2 = root1.getKind() == ObjectKind.ROOT ? dataSource2 : root1;
        ObjectKind kidKind = o instanceof DasObject ? ((DasObject)o).getKind() : ObjectKind.NONE;
        ObjectKind rootKind = root2.getKind();
        MetaModel metaModel = DbImplUtil.getMetaModel(dataSource2);
        boolean isNamespace = DatabaseStructure.isNamespace(metaModel, rootKind);
        boolean bl = groupOption = isNamespace && viewOptions.GROUP_SCHEMA || !isNamespace && viewOptions.GROUP_CONTENTS;
        if (groupOption && kidKind != ObjectKind.NONE) {
            FamilyGroup result = null;
            int visible = 0;
            int count2 = 0;
            Dbms dbms = dataSource2.getDbms();
            Provider.PresentationToModelConverter converter = Provider.forDbms(dbms).getConverter();
            BasicElement basic = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)ObjectUtils.tryCast((Object)o, DasObject.class)), BasicElement.class);
            ObjectKind groupKind = basic == null ? kidKind : converter.getGroupKind(basic);
            for (ObjectKind kind : DatabaseStructure.getChildKinds(root2, metaModel, rootKind)) {
                int weight = DatabaseStructure.getWeight(kind, dbms, ++count2);
                visible += viewOptions.HIDDEN_KINDS.contains(kind.code()) ? 0 : (DatabaseStructure.shouldShowEmptyGroup(viewOptions, DatabaseStructure.isNamespace(metaModel, kind)) ? 1 : DatabaseStructure.getChildObjects(dataSource2, viewOptions, (DasObject)root2, kind).take(1).size());
                if (kind != groupKind) continue;
                result = DatabaseStructure.getGroup((DasObject)root2, kind, weight, dbms, dataSource2);
            }
            if (visible > 1 && result != null) {
                return result;
            }
        }
        while (root1 instanceof DasNamespace && (grandPa = root1.getDasParent()) != null && !viewOptions.SHOW_INTERMEDIATE && DatabaseStructure.getTopSingleRoot(dataSource2, grandPa, viewOptions) != grandPa) {
            root1 = grandPa;
        }
        Object object = root2 = root1.getKind() == ObjectKind.ROOT ? dataSource2 : root1;
        if (root2 instanceof BasicRoot) {
            return dataSource2;
        }
        return root2;
    }

    @NotNull
    static DasObject getTopSingleRoot(@NotNull DbDataSource databaseSystem, DatabaseViewOptions options) {
        DasObject single;
        DatabaseSystem delegate;
        DasModel model;
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(42);
        }
        if ((model = (delegate = databaseSystem.getDelegate()).getModel()) instanceof BasicModel) {
            BasicRoot root2 = ((BasicModel)model).getRoot();
            single = DatabaseStructure.getSingleChild(databaseSystem, root2, options);
        } else {
            DasObject singleRoot = (DasObject)model.getModelRoots().single();
            single = singleRoot != null && !options.HIDDEN_KINDS.contains(singleRoot.getKind().code()) ? singleRoot : null;
        }
        Object object = single instanceof DasNamespace ? DatabaseStructure.getTopSingleRoot(databaseSystem, single, options) : databaseSystem;
        if (object == null) {
            DatabaseStructure.$$$reportNull$$$0(43);
        }
        return object;
    }

    @Nullable
    private static DasObject getSingleChild(@NotNull DbDataSource databaseSystem, DasObject element2, DatabaseViewOptions options) {
        if (databaseSystem == null) {
            DatabaseStructure.$$$reportNull$$$0(44);
        }
        if (options.SHOW_INTERMEDIATE) {
            return null;
        }
        JBIterable kinds = element2 instanceof BasicElement ? JBIterable.from(((BasicElement)element2).getFamilyKinds()) : element2.getDasChildren(null).map(DasNamed::getKind).unique();
        ObjectKind singleKind = (ObjectKind)kinds.filter(kind -> !options.HIDDEN_KINDS.contains(kind.code()) && DatabaseStructure.getChildObjects(databaseSystem, options, element2, kind).isNotEmpty()).single();
        return singleKind == null ? null : (DasObject)DatabaseStructure.getChildObjects(databaseSystem, options, element2, singleKind).single();
    }

    static DasObject getTopSingleRoot(@Nullable DbDataSource databaseSystem, @NotNull DasObject element2, @NotNull DatabaseViewOptions options) {
        if (element2 == null) {
            DatabaseStructure.$$$reportNull$$$0(45);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(46);
        }
        if (databaseSystem == null) {
            return null;
        }
        return (DasObject)JBIterable.generate((Object)element2, cur2 -> {
            DasObject single = DatabaseStructure.getSingleChild(databaseSystem, cur2, options);
            return single instanceof DasNamespace ? single : null;
        }).last();
    }

    @NotNull
    static DbRootGroup getRootGroup(@NotNull DbPsiFacade facade, @NotNull DatabaseViewOptions options) {
        UserDataHolderEx project;
        DbRootGroup root2;
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(47);
        }
        if (options == null) {
            DatabaseStructure.$$$reportNull$$$0(48);
        }
        if ((root2 = (DbRootGroup)((Object)(project = (UserDataHolderEx)facade.getProject()).getUserData(ROOT_GROUP))) == null) {
            root2 = (DbRootGroup)((Object)project.putUserDataIfAbsent(ROOT_GROUP, (Object)new DbRootGroup(facade, options)));
        }
        DbRootGroup dbRootGroup = root2;
        if (dbRootGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(49);
        }
        return dbRootGroup;
    }

    @NotNull
    static FamilyGroup getGroup(@NotNull DasObject parentElement, @NotNull ObjectKind childKind, int weight, @NotNull Dbms dbms, @NotNull DbDataSource dataSource2) {
        ConcurrentMap groupMap;
        FamilyGroup result;
        if (parentElement == null) {
            DatabaseStructure.$$$reportNull$$$0(50);
        }
        if (childKind == null) {
            DatabaseStructure.$$$reportNull$$$0(51);
        }
        if (dbms == null) {
            DatabaseStructure.$$$reportNull$$$0(52);
        }
        if (dataSource2 == null) {
            DatabaseStructure.$$$reportNull$$$0(53);
        }
        if ((result = (FamilyGroup)((Object)(groupMap = (ConcurrentMap)((Map)FAMILY_GROUPS.getRequired((UserDataHolder)dataSource2)).get(parentElement)).get(childKind))) == null || result.weight != weight) {
            String name = StringUtil.pluralize((String)DbPresentation.getPresentableName(childKind, dbms));
            result = (FamilyGroup)((Object)ConcurrencyUtil.cacheOrGet((ConcurrentMap)groupMap, (Object)childKind, (Object)((Object)new FamilyGroup(name, childKind, parentElement, dataSource2, weight))));
        }
        FamilyGroup familyGroup = result;
        if (familyGroup == null) {
            DatabaseStructure.$$$reportNull$$$0(54);
        }
        return familyGroup;
    }

    @NotNull
    public static PsiElement getDbGroup(@NotNull DbPsiFacade facade, @Nullable String groupName, @NotNull DatabaseViewOptions viewOptions) {
        if (facade == null) {
            DatabaseStructure.$$$reportNull$$$0(55);
        }
        if (viewOptions == null) {
            DatabaseStructure.$$$reportNull$$$0(56);
        }
        DbRootGroup root2 = DatabaseStructure.getRootGroup(facade, viewOptions);
        if (!viewOptions.GROUP_DATA_SOURCES) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(57);
            }
            return dbRootGroup;
        }
        Map map2 = (Map)DATABASE_GROUPS.getRequired((UserDataHolder)root2);
        if (StringUtil.isEmpty((String)groupName)) {
            DbRootGroup dbRootGroup = root2;
            if (dbRootGroup == null) {
                DatabaseStructure.$$$reportNull$$$0(58);
            }
            return dbRootGroup;
        }
        PsiElement psiElement = (PsiElement)JBIterable.from((Iterable)StringUtil.split((String)groupName, (String)"/")).reduce((Object)root2, (p2, s2) -> (DbGroup)((Object)((Object)((Map)map2.get(p2)).get(s2))));
        if (psiElement == null) {
            DatabaseStructure.$$$reportNull$$$0(59);
        }
        return psiElement;
    }

    public static void renameGroup(@NotNull Project project, DbGroup group, @NotNull String newName) {
        if (project == null) {
            DatabaseStructure.$$$reportNull$$$0(60);
        }
        if (newName == null) {
            DatabaseStructure.$$$reportNull$$$0(61);
        }
        String fullname = group.getQualifiedName();
        String pathname = StringUtil.trimEnd((String)fullname, (String)group.name);
        String newFullname = pathname + newName;
        DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        for (DbDataSource dataSource2 : facade.getDataSources()) {
            AbstractDataSource ds = (AbstractDataSource)((Object)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), AbstractDataSource.class));
            String cur2 = ds == null ? null : ds.getGroupName();
            if (cur2 == null || !cur2.startsWith(fullname)) continue;
            ds.setGroupName(newFullname + cur2.substring(fullname.length()));
        }
        PsiElement newGroup = DatabaseStructure.getDbGroup(facade, newFullname, DatabaseViewOptions.getInstance(project));
        DatabaseView.refreshViewAndSelect(project, Collections.singleton(newGroup));
    }

    @Contract(value="!null->!null")
    public static Object unwrap(@Nullable Object o) {
        return o instanceof DbElement && !(o instanceof DbDataSource) ? ((DbElement)o).getDelegate() : o;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 60: 
            case 61: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 60: 
            case 61: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kidKind";
                break;
            }
            case 11: 
            case 33: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 28: 
            case 38: 
            case 40: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewOptions";
                break;
            }
            case 16: 
            case 41: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootKind";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 26: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mm";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseSystem";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childKind";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseStructure";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroupChildrenImpl";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildObjects";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSingleRoot";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootGroup";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenImpl";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isNamespace";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroupChildrenImpl";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowEmptyGroup";
                break;
            }
            case 42: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getTopSingleRoot";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSingleChild";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getRootGroup";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDbGroup";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "renameGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 60: 
            case 61: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Provider {
        public static final DbmsExtension<Provider> EP = new DbmsExtension("com.intellij.database.databaseViewStructureProvider");
        public static final int UNDEFINED = -1;

        public static Provider forDbms(@NotNull Dbms dbms) {
            if (dbms == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return (Provider)EP.forDbms(dbms);
        }

        @NotNull
        public JBIterable<? extends BasicElement> getChildren(@NotNull BasicElement var1, @Nullable ObjectKind var2);

        @NotNull
        public List<ObjectKind> getFamilyKinds(@NotNull BasicElement var1);

        @Nullable
        public BasicElement getParent(@NotNull BasicElement var1);

        @NotNull
        default public PresentationToModelConverter getConverter() {
            PresentationToModelConverter presentationToModelConverter = PresentationToModelConverter.INACTIVE;
            if (presentationToModelConverter == null) {
                Provider.$$$reportNull$$$0(1);
            }
            return presentationToModelConverter;
        }

        default public int getWeight(@NotNull BasicElement element2) {
            if (element2 == null) {
                Provider.$$$reportNull$$$0(2);
            }
            return -1;
        }

        default public int getWeight(@NotNull ObjectKind element2, int groupCount) {
            if (element2 == null) {
                Provider.$$$reportNull$$$0(3);
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$Provider";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$Provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forDbms";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getWeight";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static interface PresentationToModelConverter {
            public static final PresentationToModelConverter INACTIVE = new PresentationToModelConverter(){

                @Override
                @NotNull
                public BasicElement toModelParent(@NotNull BasicElement parent2) {
                    if (parent2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BasicElement basicElement = parent2;
                    if (basicElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return basicElement;
                }

                @Override
                @NotNull
                public ObjectKind toModelObjectKind(@NotNull ObjectKind kind) {
                    if (kind == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ObjectKind objectKind = kind;
                    if (objectKind == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return objectKind;
                }

                @Override
                @NotNull
                public ObjectKind getGroupKind(@NotNull BasicElement e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    ObjectKind objectKind = e.getKind();
                    if (objectKind == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return objectKind;
                }

                @Override
                @NotNull
                public JBIterable<? extends DbElement> pickOnlyGroupChildren(@NotNull BasicElement presentationParent, @NotNull JBIterable<? extends DbElement> children2, @NotNull ObjectKind kidKind) {
                    if (presentationParent == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (children2 == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    if (kidKind == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    JBIterable<? extends DbElement> jBIterable = children2;
                    if (jBIterable == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    return jBIterable;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 9: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 9: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "parent";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/view/DatabaseStructure$Provider$PresentationToModelConverter$1";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "kind";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "presentationParent";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "children";
                            break;
                        }
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "kidKind";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/view/DatabaseStructure$Provider$PresentationToModelConverter$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "toModelParent";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "toModelObjectKind";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getGroupKind";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[1] = "pickOnlyGroupChildren";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "toModelParent";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 9: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "toModelObjectKind";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "getGroupKind";
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            objectArray = objectArray;
                            objectArray[2] = "pickOnlyGroupChildren";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 5: 
                        case 9: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };

            @NotNull
            public BasicElement toModelParent(@NotNull BasicElement var1);

            @NotNull
            public ObjectKind toModelObjectKind(@NotNull ObjectKind var1);

            @NotNull
            public ObjectKind getGroupKind(@NotNull BasicElement var1);

            @NotNull
            public JBIterable<? extends DbElement> pickOnlyGroupChildren(@NotNull BasicElement var1, @NotNull JBIterable<? extends DbElement> var2, @NotNull ObjectKind var3);
        }
    }

    public static class FamilyGroup
    extends Group
    implements WeighedItem {
        public final DbDataSource dataSource;
        public final DasObject dasParent;
        private WeakReference<EmptyScopeLeaf> myEmptyScopeLeaf;
        final ObjectKind kidKind;
        final int weight;

        FamilyGroup(@NotNull String name, @NotNull ObjectKind kidKind, @NotNull DasObject dasParent, @NotNull DbDataSource dataSource2, int weight) {
            if (name == null) {
                FamilyGroup.$$$reportNull$$$0(0);
            }
            if (kidKind == null) {
                FamilyGroup.$$$reportNull$$$0(1);
            }
            if (dasParent == null) {
                FamilyGroup.$$$reportNull$$$0(2);
            }
            if (dataSource2 == null) {
                FamilyGroup.$$$reportNull$$$0(3);
            }
            super(name);
            this.myEmptyScopeLeaf = new WeakReference<Object>(null);
            this.dataSource = dataSource2;
            this.kidKind = kidKind;
            this.dasParent = dasParent;
            this.weight = weight;
        }

        public DbElement getParent() {
            return DbImplUtil.findElement(this.dataSource, this.dasParent);
        }

        public int getWeight() {
            return this.weight;
        }

        @NotNull
        public JBIterable<? extends DbElement> iterateChildren() {
            Provider.PresentationToModelConverter provider = this.converter();
            DasObject modelParent = this.dasParent instanceof BasicElement ? provider.toModelParent((BasicElement)this.dasParent) : this.dasParent;
            DbElement parent2 = DbImplUtil.findElement(this.dataSource, modelParent);
            JBIterable<? extends DbElement> children2 = parent2 == null ? JBIterable.empty() : parent2.getDasChildren(this.getChildrenKind());
            JBIterable<? extends DbElement> jBIterable = this.dasParent instanceof BasicElement ? provider.pickOnlyGroupChildren((BasicElement)this.dasParent, children2, this.kidKind) : children2;
            if (jBIterable == null) {
                FamilyGroup.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @NotNull
        public ObjectKind getChildrenKind() {
            ObjectKind objectKind = this.converter().toModelObjectKind(this.kidKind);
            if (objectKind == null) {
                FamilyGroup.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @NotNull
        private Provider.PresentationToModelConverter converter() {
            Provider.PresentationToModelConverter presentationToModelConverter = Provider.forDbms(this.dataSource.getDbms()).getConverter();
            if (presentationToModelConverter == null) {
                FamilyGroup.$$$reportNull$$$0(6);
            }
            return presentationToModelConverter;
        }

        @NotNull
        public EmptyScopeLeaf getEmptyScopeLeaf() {
            EmptyScopeLeaf leaf = (EmptyScopeLeaf)((Object)this.myEmptyScopeLeaf.get());
            if (leaf == null) {
                leaf = new EmptyScopeLeaf();
                this.myEmptyScopeLeaf = new WeakReference<EmptyScopeLeaf>(leaf);
            }
            EmptyScopeLeaf emptyScopeLeaf = leaf;
            if (emptyScopeLeaf == null) {
                FamilyGroup.$$$reportNull$$$0(7);
            }
            return emptyScopeLeaf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kidKind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dasParent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$FamilyGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenKind";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "converter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyScopeLeaf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public class EmptyScopeLeaf
        extends FakePsiElement {
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = this.getParent().getChildrenKind();
                if (objectKind == null) {
                    EmptyScopeLeaf.$$$reportNull$$$0(0);
                }
                return objectKind;
            }

            public DasObject getDasParent() {
                return this.getParent().dasParent;
            }

            protected Icon getBaseIcon() {
                return AllIcons.Nodes.NodePlaceholder;
            }

            @Nullable
            public Icon getIcon(boolean open) {
                return this.getBaseIcon();
            }

            public FamilyGroup getParent() {
                return FamilyGroup.this;
            }

            @NotNull
            public TextRange getTextRangeInParent() {
                TextRange textRange = TextRange.EMPTY_RANGE;
                if (textRange == null) {
                    EmptyScopeLeaf.$$$reportNull$$$0(1);
                }
                return textRange;
            }

            @NotNull
            public @NotNull Iterable<? extends @NotNull PsiSymbolReference> getOwnReferences() {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    EmptyScopeLeaf.$$$reportNull$$$0(2);
                }
                return jBIterable;
            }

            public String toString() {
                return "No " + this.getKind().code();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/view/DatabaseStructure$FamilyGroup$EmptyScopeLeaf";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTextRangeInParent";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOwnReferences";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    public static class DbRootGroup
    extends DbGroup {
        public final DbPsiFacade facade;
        public final DatabaseViewOptions viewOptions;

        public DbRootGroup(@NotNull DbPsiFacade facade, @NotNull DatabaseViewOptions options) {
            if (facade == null) {
                DbRootGroup.$$$reportNull$$$0(0);
            }
            if (options == null) {
                DbRootGroup.$$$reportNull$$$0(1);
            }
            super("Database", null);
            this.facade = facade;
            this.viewOptions = options;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.facade.getProject();
            if (project == null) {
                DbRootGroup.$$$reportNull$$$0(2);
            }
            return project;
        }

        public PsiManager getManager() {
            return PsiManager.getInstance((Project)this.getProject());
        }

        @Override
        public String getQualifiedName() {
            return "";
        }

        public PsiFile getContainingFile() {
            return null;
        }

        @Override
        public PsiElement getParent() {
            return null;
        }

        public boolean isValid() {
            return !this.getProject().isDisposed();
        }

        @Override
        protected Icon getBaseIcon() {
            return DatabaseIcons.Dbms;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$DbRootGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DbGroup
    extends Group {
        final DbGroup parent;

        public DbGroup(String name, DbGroup parent2) {
            super(name);
            this.parent = parent2;
        }

        @Override
        protected Icon getBaseIcon() {
            return DatabaseIcons.ObjectGroup;
        }

        public PsiElement getParent() {
            return this.parent;
        }

        @NotNull
        public Project getProject() {
            Project project = this.getParent().getProject();
            if (project == null) {
                DbGroup.$$$reportNull$$$0(0);
            }
            return project;
        }

        @Override
        @NotNull
        public JBIterable<? extends PsiElement> iterateChildren() {
            DbRootGroup root2 = Objects.requireNonNull((DbRootGroup)((Object)SyntaxTraverser.psiApi().parents((Object)this).filter(DbRootGroup.class).first()));
            JBIterable<? extends PsiElement> jBIterable = DatabaseStructure.getDbGroupChildrenImpl(this, root2.viewOptions);
            if (jBIterable == null) {
                DbGroup.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public String getQualifiedName() {
            StringBuilder sb = new StringBuilder(this.name);
            DbGroup cur2 = this.parent;
            while (cur2 != null && !(cur2 instanceof DbRootGroup)) {
                sb.insert(0, cur2.name + "/");
                cur2 = cur2.parent;
            }
            return sb.toString();
        }

        @NotNull
        public ItemPresentation getQualifiedPresentation() {
            PresentationData presentation = (PresentationData)this.getPresentation();
            presentation.getColoredText().set(0, new PresentableNodeDescriptor.ColoredFragment(this.getQualifiedName(), SimpleTextAttributes.REGULAR_ATTRIBUTES));
            PresentationData presentationData = presentation;
            if (presentationData == null) {
                DbGroup.$$$reportNull$$$0(2);
            }
            return presentationData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/view/DatabaseStructure$DbGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedPresentation";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class Group
    extends FakePsiElement
    implements NavigationItem {
        public final String name;
        final PresentationData presentation;
        int size;

        public Group(@NotNull String name) {
            if (name == null) {
                Group.$$$reportNull$$$0(0);
            }
            this.presentation = new PresentationData();
            this.name = name;
        }

        @NotNull
        public abstract JBIterable<? extends PsiElement> iterateChildren();

        @NotNull
        public ItemPresentation getPresentation() {
            this.presentation.clear();
            this.presentation.setIcon(this.getIcon(false));
            this.presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (this.size > 0) {
                this.presentation.addText("  " + this.size, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
            }
            PresentationData presentationData = this.presentation;
            if (presentationData == null) {
                Group.$$$reportNull$$$0(1);
            }
            return presentationData;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                Group.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        protected Icon getBaseIcon() {
            return DatabaseIcons.ObjectGroup;
        }

        @Nullable
        public Icon getIcon(boolean open) {
            return this.getBaseIcon();
        }

        public String toString() {
            return this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/DatabaseStructure$Group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/DatabaseStructure$Group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

