/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.Hash;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectPaths {
    public static final Hash.Strategy<ObjectPath> INSENSITIVE_STRATEGY = new Hash.Strategy<ObjectPath>(){

        public int hashCode(ObjectPath object) {
            if (object == null) {
                return 0;
            }
            return (Integer)object.reduce((Object)object.kind.hashCode(), (t, v) -> t * 31 + StringUtil.stringHashCodeInsensitive((CharSequence)v.name));
        }

        public boolean equals(ObjectPath o1, ObjectPath o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null || !Comparing.equal((Object)o1.kind, (Object)o2.kind)) {
                return false;
            }
            while (o1 != null && o2 != null && o1 != o2) {
                if (!Comparing.strEqual((String)o1.name, (String)o2.name, (boolean)false)) {
                    return false;
                }
                o1 = o1.parent;
                o2 = o2.parent;
            }
            return o1 == o2;
        }
    };

    public static int getLength(@Nullable ObjectPath root2) {
        return root2 == null ? 0 : root2.getSize();
    }

    @Contract(value="!null->!null")
    public static ObjectPath of(@Nullable DasObject o) {
        return ObjectPaths.of(o, null);
    }

    @Contract(value="!null,_->!null")
    public static ObjectPath of(@Nullable DasObject o, @Nullable CasingProvider normalizer) {
        if (o == null) {
            return null;
        }
        BasicElement basic = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(o), BasicElement.class);
        if (basic != null) {
            return BasicPaths.of(basic, normalizer);
        }
        DasObject parent2 = o.getDasParent();
        if (parent2 != null && parent2.getKind() == ObjectKind.ROOT) {
            parent2 = null;
        }
        return BasicPaths.createNormalized(o, DbSqlUtil.isQuoted(o), ObjectPaths.getIdentity(o), ObjectPaths.of(parent2, normalizer), normalizer);
    }

    @Nullable
    public static SearchPath of(@Nullable Iterable<? extends DasObject> o) {
        return o == null ? null : SearchPath.of((List)JBIterable.from(o).filter(Conditions.notNull()).transform(ObjectPaths::of).toList());
    }

    @Nullable
    public static SearchPath searchPathOf(@Nullable DasObject o) {
        return SearchPath.of((ObjectPath)ObjectPaths.of(o));
    }

    @NotNull
    private static String getEscapedName(@NotNull ObjectPath path) {
        if (path == null) {
            ObjectPaths.$$$reportNull$$$0(0);
        }
        String string = ((StringBuilder)path.reduce((Object)new StringBuilder(), (sb, p2) -> (sb.length() > 0 ? sb.append(".") : sb).append(DatabaseElementVirtualFileImpl.escape(p2.name)))).toString();
        if (string == null) {
            ObjectPaths.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static String getIdentity(@NotNull DasObject obj) {
        if (obj == null) {
            ObjectPaths.$$$reportNull$$$0(2);
        }
        if ((obj = (DasObject)ObjectUtils.notNull((Object)((DasObject)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(obj), DasObject.class)), (Object)obj)) instanceof BasicElement) {
            return BasicPaths.getIdentity((BasicElement)obj);
        }
        if (!(obj instanceof PsiElement)) {
            return null;
        }
        String name = obj.getName();
        Dbms dbms = DbImplUtil.getDbms((PsiElement)obj);
        if (dbms.isSybase() && obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
            short pos = ObjectPaths.getSybaseNumber(obj);
            return ModelUtil.calculateSybProcedureIdentity(pos);
        }
        if (obj instanceof DasOperator) {
            return ModelUtil.calculateRoutineIdentityByType("", ((DasOperator)obj).getArgumentTypes());
        }
        if (!(obj instanceof DasRoutine)) {
            return null;
        }
        String id = ObjectPaths.hasOverloads(dbms) ? ModelUtil.calculateRoutineIdentity("", ((DasRoutine)obj).getArguments()) : null;
        return name.equals(id) ? null : id;
    }

    private static boolean hasOverloads(Dbms dbms) {
        return dbms.isDb2() || dbms.isDerby() || dbms == Dbms.UNKNOWN || dbms.isH2() || dbms.isHsqldb() || dbms.isMysql() || dbms.isPostgres();
    }

    public static short getSybaseNumber(DasObject obj) {
        if (obj instanceof SqlCreateProcedureStatement) {
            return ObjectPaths.getSybaseNumber(obj.getName());
        }
        if (obj instanceof DasPositioned) {
            return ((DasPositioned)obj).getPosition();
        }
        return ObjectPaths.getSybaseNumber(obj.getName());
    }

    private static short getSybaseNumber(String name) {
        Short num = ObjectPaths.isNumber(name) ? ObjectPaths.tryConvert(name) : null;
        return num == null ? (short)1 : num;
    }

    @Nullable
    private static Short tryConvert(@Nullable String sub) {
        if (sub == null) {
            return null;
        }
        try {
            return Short.valueOf(sub);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isNumber(@Nullable String s2) {
        if (s2 == null) {
            return false;
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (Character.isDigit(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Contract(value="!null->!null")
    public static String serialize(@Nullable ObjectPath o) {
        if (o == null) {
            return null;
        }
        return o.kind.code() + "/" + ObjectPaths.getEscapedName(o);
    }

    @Nullable
    public static ObjectPath deserialize(@Nullable String o, @NotNull MetaModel metaModel) {
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(3);
        }
        if (o == null) {
            return null;
        }
        int idx = o.indexOf("/");
        if (idx < 0) {
            return ObjectPath.create((String)o, (ObjectKind)ObjectKind.NONE);
        }
        ObjectKind kind = (ObjectKind)ObjectUtils.notNull((Object)metaModel.findKind(o.substring(0, idx)), (Object)ObjectKind.NONE);
        return ObjectPaths.getObjectPath(metaModel, o.substring(idx + 1), kind);
    }

    @Nullable
    private static ObjectPath getObjectPath(@NotNull MetaModel metaModel, String qname, ObjectKind kind) {
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(4);
        }
        String[] names = DatabaseElementVirtualFileImpl.decodeQName(qname);
        List<ObjectKind> bestPath = ObjectPaths.findBestPath(metaModel, kind, names);
        return ObjectPaths.createPath(names, bestPath);
    }

    @Nullable
    private static ObjectPath createPath(String[] names, List<ObjectKind> kinds) {
        ObjectPath result = null;
        int e = names.length;
        for (int i2 = 0; i2 < e; ++i2) {
            int p2 = e - i2 - 1;
            result = ObjectPath.create((String)names[i2], (ObjectKind)(p2 >= kinds.size() ? ObjectKind.NONE : kinds.get(p2)), (boolean)true, null, result);
        }
        return result;
    }

    @NotNull
    public static JBIterable<ObjectPath> getObjectPaths(@NotNull MetaModel metaModel, String qname, ObjectKind kind) {
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(5);
        }
        String[] names = DatabaseElementVirtualFileImpl.decodeQName(qname);
        JBIterable jBIterable = metaModel.getPathsToRoot(kind).filterMap(kinds -> {
            if (kinds.size() < names.length + 1) {
                return null;
            }
            return ObjectPaths.createPath(names, kinds);
        });
        if (jBIterable == null) {
            ObjectPaths.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static List<ObjectKind> findBestPath(@NotNull MetaModel metaModel, ObjectKind kind, String[] names) {
        List paths;
        if (metaModel == null) {
            ObjectPaths.$$$reportNull$$$0(7);
        }
        if ((paths = metaModel.getPathsToRoot(kind).toList()).isEmpty()) {
            return Collections.emptyList();
        }
        if (paths.size() == 1) {
            return (List)paths.get(0);
        }
        for (int k = 0; k < 2; ++k) {
            boolean up = k == 0;
            int m = -1;
            for (int i2 = 0; i2 < paths.size(); ++i2) {
                int d2;
                int size = ((List)paths.get(i2)).size();
                if (size < names.length == up || m != -1 && ((d2 = ((List)paths.get(m)).size() - ((List)paths.get(i2)).size()) == 0 || d2 < 0 == up)) continue;
                m = i2;
            }
            if (m == -1) continue;
            return (List)paths.get(m);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedName";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIdentity";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBestPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

