/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.DynamicBundle;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DataViewsComponent
implements ConfigurableUi<DatabaseSettings> {
    private JPanel myPanel;
    private IntegerField myResultPageSizeTextField;
    private IntegerField myFilterHistorySizeField;
    private IntegerField myLobLengthLimitField;
    private IntegerField myPrefetchSizeTextField;
    private JBCheckBox mySubmitImmediatelyCheckBox;
    private JBCheckBox myLimitCheckBox;
    private JBCheckBox myAutoTranspose;
    private JBRadioButton myTextJBRadioButton;
    private JBRadioButton myCheckboxesJBRadioButton;

    public DataViewsComponent() {
        this.$$$setupUI$$$();
        this.myLimitCheckBox.addChangeListener(e -> this.configureLimitTextField());
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(0);
        }
        this.myLimitCheckBox.setSelected(settings.isLimitPageSize());
        this.myResultPageSizeTextField.setValue(Integer.valueOf(settings.getPageSize()));
        this.myFilterHistorySizeField.setValue(Integer.valueOf(settings.getFiltersHistorySize()));
        this.myLobLengthLimitField.setValue(Integer.valueOf(settings.getMaxLobLength()));
        this.myPrefetchSizeTextField.setValue(Integer.valueOf(settings.getPrefetchSize()));
        this.myAutoTranspose.setSelected(settings.isAutoTranspose());
        if (settings.getBooleanMode() == DatabaseSettings.BooleanMode.TEXT) {
            this.myTextJBRadioButton.setSelected(true);
        } else {
            this.myCheckboxesJBRadioButton.setSelected(true);
        }
        this.mySubmitImmediatelyCheckBox.setSelected(settings.isSubmitImmediately());
        this.configureLimitTextField();
    }

    @NotNull
    private DatabaseSettings.BooleanMode getBooleanMode() {
        DatabaseSettings.BooleanMode booleanMode = this.myTextJBRadioButton.isSelected() ? DatabaseSettings.BooleanMode.TEXT : DatabaseSettings.BooleanMode.CHECKBOX;
        if (booleanMode == null) {
            DataViewsComponent.$$$reportNull$$$0(1);
        }
        return booleanMode;
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(2);
        }
        if (settings.isLimitPageSize() != this.myLimitCheckBox.isSelected()) {
            return true;
        }
        if (settings.getPageSize() != this.myResultPageSizeTextField.getValue().intValue()) {
            return true;
        }
        if (settings.getFiltersHistorySize() != this.myFilterHistorySizeField.getValue().intValue()) {
            return true;
        }
        if (settings.getMaxLobLength() != this.myLobLengthLimitField.getValue().intValue()) {
            return true;
        }
        if (settings.getPrefetchSize() != this.myPrefetchSizeTextField.getValue().intValue()) {
            return true;
        }
        if (settings.isAutoTranspose() != this.myAutoTranspose.isSelected()) {
            return true;
        }
        if (settings.getBooleanMode() != this.getBooleanMode()) {
            return true;
        }
        return settings.isSubmitImmediately() != this.mySubmitImmediatelyCheckBox.isSelected();
    }

    public void apply(@NotNull DatabaseSettings settings) throws ConfigurationException {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(3);
        }
        this.myResultPageSizeTextField.validateContent();
        this.myFilterHistorySizeField.validateContent();
        this.myLobLengthLimitField.validateContent();
        this.myPrefetchSizeTextField.validateContent();
        settings.setLimitPageSize(this.myLimitCheckBox.isSelected());
        settings.setPageSize(this.myResultPageSizeTextField.getValue());
        settings.setFiltersHistorySize(this.myFilterHistorySizeField.getValue());
        settings.setMaxLobLength(this.myLobLengthLimitField.getValue());
        settings.setPrefetchSize(this.myPrefetchSizeTextField.getValue());
        settings.setAutoTranspose(this.myAutoTranspose.isSelected());
        settings.setBooleanMode(this.getBooleanMode());
        settings.setSubmitImmediately(this.mySubmitImmediatelyCheckBox.isSelected());
        DatabaseSettings.fireSettingsChanged();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataViewsComponent.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myResultPageSizeTextField = DataViewsComponent.createIntegerField();
        this.myFilterHistorySizeField = DataViewsComponent.createIntegerField();
        this.myLobLengthLimitField = DataViewsComponent.createIntegerField();
        this.myPrefetchSizeTextField = new IntegerField(null, 1, 1000);
    }

    private void configureLimitTextField() {
        this.myResultPageSizeTextField.setEnabled(this.myLimitCheckBox.isSelected());
    }

    @NotNull
    private static IntegerField createIntegerField() {
        return new IntegerField(null, 1, Integer.MAX_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DataViewsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DataViewsComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBooleanMode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        IntegerField integerField = this.myResultPageSizeTextField;
        integerField.setColumns(6);
        integerField.setHorizontalAlignment(4);
        jPanel.add((Component)integerField, new GridConstraints(0, 1, 1, 2, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.filter.history.size"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField2 = this.myFilterHistorySizeField;
        integerField2.setColumns(6);
        integerField2.setHorizontalAlignment(4);
        jPanel.add((Component)integerField2, new GridConstraints(2, 1, 1, 2, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.max.lob.length.bytes"));
        jBLabel2.setToolTipText(ResourceBundle.getBundle("messages/DatabaseBundle").getString("settings.max.lob.tooltip"));
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField3 = this.myLobLengthLimitField;
        integerField3.setColumns(6);
        integerField3.setHorizontalAlignment(4);
        jPanel.add((Component)integerField3, new GridConstraints(3, 1, 1, 2, 4, 0, 2, 0, null, null, null));
        IntegerField integerField4 = this.myPrefetchSizeTextField;
        integerField4.setColumns(6);
        integerField4.setHorizontalAlignment(4);
        jPanel.add((Component)integerField4, new GridConstraints(1, 1, 1, 2, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.result.set.pre.fetch.size"));
        jBLabel3.setToolTipText(ResourceBundle.getBundle("messages/DatabaseBundle").getString("DataViewsComponent.tooltip.default.number.of.rows"));
        jPanel.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySubmitImmediatelyCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.submit.changes.immediately"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(7, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.data.modification"));
        jPanel.add((Component)titledSeparator, new GridConstraints(6, 0, 1, 4, 0, 3, 6, 0, null, null, null));
        this.myLimitCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.limit.page.size.to"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoTranspose = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.automatically.transpose.tables"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("settings.show.boolean.values.as"));
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTextJBRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("boolean.values.mode.text"));
        jPanel.add((Component)jBRadioButton2, new GridConstraints(4, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCheckboxesJBRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataViewsComponent.class).getString("boolean.values.mode.checkbox"));
        jPanel.add((Component)jBRadioButton, new GridConstraints(4, 2, 1, 2, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)integerField2);
        jBLabel2.setLabelFor((Component)integerField3);
        jBLabel3.setLabelFor((Component)integerField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

