/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H&J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/J\u0017\u00100\u001a\u0004\u0018\u00010*2\b\u00101\u001a\u0004\u0018\u000102\u00a2\u0006\u0002\u00103R \u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR(\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u0082\u0001\u000245\u00a8\u00066"}, d2={"Lcom/intellij/database/script/generator/ScriptingTaskBuilder;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/database/model/basic/BasicModel;)V", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "setConsumer", "(Lcom/intellij/database/script/generator/ScriptConsumer;)V", "db", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/script/generator/ScriptingOptions;)V", "version", "Lcom/intellij/database/util/Version;", "getVersion", "()Lcom/intellij/database/util/Version;", "setVersion", "(Lcom/intellij/database/util/Version;)V", "build", "Lcom/intellij/database/script/generator/ScriptingTask;", "setCodeStyle", "", "codeStyleSettings", "Lcom/intellij/sql/formatter/settings/SqlCodeStyleSettings;", "setCodeStyleFrom", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "setCurrentNamespace", "nsp", "Lcom/intellij/database/model/basic/BasicNamespace;", "(Lcom/intellij/database/model/basic/BasicNamespace;)Lkotlin/Unit;", "Lcom/intellij/database/script/generator/ScriptingSingleModelTaskBuilderBase;", "Lcom/intellij/database/script/generator/ScriptingAlterTaskBuilder;", "intellij.database.impl"})
public abstract class ScriptingTaskBuilder {
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private Version version;
    @Nullable
    private ScriptConsumer<?> consumer;
    @Nullable
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;
    @NotNull
    private final BasicModel model;

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkNotNullParameter((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"<set-?>");
        this.version = version;
    }

    @Nullable
    public final ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    public final void setConsumer(@Nullable ScriptConsumer<?> scriptConsumer) {
        this.consumer = scriptConsumer;
    }

    @Nullable
    public final BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    public final void setCurrentDatabase(@Nullable BasicDatabase db) {
        if (db != null) {
            boolean bl = this.model.contains(db);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (Intrinsics.areEqual((Object)this.currentDatabase, (Object)db) ^ true) {
                this.setCurrentSchema(null);
                this.currentDatabase = db;
            }
        } else {
            this.setCurrentSchema(null);
            this.currentDatabase = null;
        }
    }

    @Nullable
    public final BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public final void setCurrentSchema(@Nullable BasicSchema s2) {
        if (s2 != null) {
            boolean bl = this.model.contains(s2);
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this.setCurrentDatabase(s2.getDatabase());
            this.currentSchema = s2;
        } else {
            this.currentSchema = null;
        }
    }

    @Nullable
    public final Unit setCurrentNamespace(@Nullable BasicNamespace nsp) {
        Unit unit;
        BasicNamespace basicNamespace = nsp;
        if (basicNamespace instanceof BasicSchema) {
            this.setCurrentSchema((BasicSchema)nsp);
            unit = Unit.INSTANCE;
        } else if (basicNamespace instanceof BasicDatabase) {
            this.setCurrentDatabase((BasicDatabase)nsp);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void setCodeStyleFrom(@NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.setCodeStyle(ScriptingTaskBuilderKt.getSqlCodeStyle(ds));
    }

    public final void setCodeStyle(@NotNull SqlCodeStyleSettings codeStyleSettings) {
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        DelegateScriptingOptions newOptions = new DelegateScriptingOptions(this.options);
        ((Map)newOptions.getOptions()).put(ScriptingOptionStatic.CODE_STYLE, codeStyleSettings);
        this.options = newOptions;
    }

    @NotNull
    public abstract ScriptingTask build();

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    private ScriptingTaskBuilder(BasicModel model) {
        this.model = model;
        this.options = ScriptingTaskKt.defaultScriptingOptions(this.model);
        BasicRoot basicRoot = this.model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"model.root");
        Version version = basicRoot.getServerVersion();
        if (version == null) {
            Version version2 = Version.ZERO;
            version = version2;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"Version.ZERO");
        }
        this.version = version;
        BasicRoot basicRoot2 = this.model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot2, (String)"model.root");
        BasicDatabase basicDatabase = this.currentDatabase = basicRoot2.getCurrentDatabase();
        this.currentSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
    }

    public /* synthetic */ ScriptingTaskBuilder(BasicModel model, DefaultConstructorMarker $constructor_marker) {
        this(model);
    }
}

