/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.ui.DatabasePreviewDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMigration {
    private static final Logger LOG = Logger.getInstance(DbSrcMigration.class);
    private static final Set<ObjectKind> DEPENDANT_OBJECTS = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.COLUMN, ObjectKind.OBJECT_ATTRIBUTE, ObjectKind.FOREIGN_KEY, ObjectKind.KEY, ObjectKind.CHECK, ObjectKind.INDEX});

    public static boolean isSupported(@NotNull VirtualFile file) {
        if (file == null) {
            DbSrcMigration.$$$reportNull$$$0(0);
        }
        if (!DbSrcUtils.isDbSrcFile(file)) {
            return false;
        }
        BasicElement element2 = DbSrcUtils.findObject(null, file.getPath(), BasicElement.class);
        return DbSrcMigration.isSupported(element2);
    }

    public static boolean isSupported(@Nullable BasicElement element2) {
        BasicModel model;
        BasicModel basicModel = model = element2 == null ? null : element2.getModel();
        if (model == null) {
            return true;
        }
        ScriptGenerator service = ScriptGenerators.INSTANCE.byModel(model);
        return DbSrcMigration.canRefactor(service, element2);
    }

    private static boolean canRefactor(ScriptGenerator service, BasicElement element2) {
        BasicModel model = element2.getModel();
        return service.capabilities(element2).getAlterAnything().get(model == null ? null : model.getRoot().getServerVersion());
    }

    @NotNull
    public static List<Pair<ObjectPath, VirtualFile>> getObjects(@NotNull Project project, @NotNull Iterable<VirtualFile> files) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(1);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(2);
        }
        ArrayList<Pair<ObjectPath, VirtualFile>> objects2 = new ArrayList<Pair<ObjectPath, VirtualFile>>();
        BasicModel model = null;
        ScriptGenerator ss2 = null;
        for (VirtualFile file : files) {
            ObjectPath path;
            if (!DbSrcUtils.isDbSrcFile(file)) continue;
            BasicElement element2 = DbSrcUtils.findObject(project, file.getPath(), BasicElement.class);
            if (element2 != null) {
                if (model == null) {
                    model = element2.getModel();
                }
                if (model != null) {
                    ss2 = ScriptGenerators.INSTANCE.byModel(model);
                }
                if (ss2 != null && !DbSrcMigration.canRefactor(ss2, element2)) continue;
            }
            if ((path = DbSrcUtils.getFullPath(file.getPath())) == null) continue;
            objects2.add((Pair<ObjectPath, VirtualFile>)Pair.create((Object)path, (Object)file));
        }
        ArrayList<Pair<ObjectPath, VirtualFile>> arrayList = objects2;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static ScriptingAlterTask buildMigrationTask(@NotNull Project project, @NotNull DbDataSource dataSource2, @NotNull Iterable<Pair<ObjectPath, VirtualFile>> files, @Nullable ObjectPath currentNamespace) {
        List<Pair<ObjectPath, SqlFile>> objects2;
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(4);
        }
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(5);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(6);
        }
        if ((objects2 = DbSrcMigration.findObjects(project, files)).isEmpty()) {
            return null;
        }
        BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
        if (model == null) {
            return null;
        }
        BasicModModel targetModel = new ModelFactory(new MemoryTextStorage()).createModel(model.getDbms());
        ScriptingAlterTaskBuilder task = new ScriptingAlterTaskBuilder(model, targetModel);
        HashMap<BasicModElement, ObjectPath> copied = new HashMap<BasicModElement, ObjectPath>();
        Function resolver = p2 -> p2 == null ? model.getRoot() : (BasicElement)DbSqlUtil.findObjects(dataSource2, p2).filter(BasicElement.class).first();
        DbSrcMigration.buildFromSql(project, (Function<ObjectPath, BasicElement>)resolver, objects2, targetModel, copied);
        DbSrcMigration.fillCorrespondence(task, copied, (Iterable<ObjectPath>)JBIterable.from(objects2).map(Functions.pairFirst()), (Function<ObjectPath, BasicElement>)resolver);
        task.setCurrentNamespace(currentNamespace == null ? null : (BasicNamespace)ObjectUtils.tryCast((Object)resolver.fun((Object)currentNamespace), BasicNamespace.class));
        return task.build();
    }

    private static void fillCorrespondence(ScriptingAlterTaskBuilder task, Map<BasicModElement, ObjectPath> copied, Iterable<ObjectPath> objects2, Function<ObjectPath, BasicElement> pathResolver) {
        HashMap<ObjectPath, BasicModElement> rev = new HashMap<ObjectPath, BasicModElement>();
        for (Map.Entry<BasicModElement, ObjectPath> entry : copied.entrySet()) {
            task.getCorrespondence().add(ElementDelta.create((BasicElement)pathResolver.fun((Object)entry.getValue()), (BasicElement)entry.getKey()));
            rev.put(entry.getValue(), entry.getKey());
        }
        for (ObjectPath objectPath : objects2) {
            DbSrcMigration.fillCorrespondence((BasicElement)pathResolver.fun((Object)objectPath), task, copied, rev);
            JBTreeTraverser<BasicElement> traverser = task.getModel().basicTraverser();
            for (BasicModElement element2 : ((JBTreeTraverser)traverser.withRoot((Object)((BasicElement)rev.get(objectPath)))).filter(BasicModElement.class)) {
                if (copied.containsKey(element2)) continue;
                task.getCorrespondence().add(ElementDelta.create(null, element2));
            }
        }
    }

    private static void fillCorrespondence(@Nullable BasicElement element2, ScriptingAlterTaskBuilder task, Map<BasicModElement, ObjectPath> copied, Map<ObjectPath, BasicModElement> rev) {
        if (element2 == null) {
            return;
        }
        if (!rev.containsKey(element2)) {
            BasicModElement object = (BasicModElement)DbSrcMigration.findObject(element2, rev);
            if (object != null) {
                rev.put(ObjectPaths.of(element2), object);
                copied.put(object, ObjectPaths.of(element2));
            } else {
                ObjectKind kind = element2.getKind();
                if (!DEPENDANT_OBJECTS.contains(kind)) {
                    return;
                }
            }
            task.getCorrespondence().add(ElementDelta.create(element2, object));
        }
        for (BasicElement child : element2.getChildren()) {
            DbSrcMigration.fillCorrespondence(child, task, copied, rev);
        }
    }

    private static void buildFromSql(@NotNull Project project, @NotNull Function<ObjectPath, BasicElement> pathResolver, List<Pair<ObjectPath, SqlFile>> objects2, BasicModModel targetModel, Map<BasicModElement, ObjectPath> copied) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(7);
        }
        if (pathResolver == null) {
            DbSrcMigration.$$$reportNull$$$0(8);
        }
        ArrayList<SqlFile> files = new ArrayList<SqlFile>(objects2.size());
        HashMap topObjects = new HashMap();
        HashSet<ObjectPath> rootBranch = new HashSet<ObjectPath>();
        for (Pair<ObjectPath, SqlFile> p2 : objects2) {
            files.add((SqlFile)p2.second);
            ObjectPath e = (ObjectPath)p2.first;
            DasObject def = DbSrcMigration.findObjectDefinition((SqlFile)p2.second, e);
            BasicElement ee = (BasicElement)pathResolver.fun((Object)e);
            rootBranch.add(e);
            while (def != null && e != null && def.getKind() == e.kind) {
                ContainerUtil.putIfNotNull((Object)def, (Object)e, topObjects);
                def = def.getDasParent();
                e = e.parent;
                ee = ee == null ? (e == null ? null : (BasicElement)pathResolver.fun((Object)e)) : ee.getParent();
            }
        }
        SqlPsiFacade.getInstance((Project)project).buildModel((DasModel)targetModel, files, (t, s2) -> {
            BasicElement srcResolved;
            BasicModElement mod = (BasicModElement)t;
            if (copied.containsKey(mod)) {
                return true;
            }
            ObjectPath src = (ObjectPath)topObjects.get(s2);
            if (src == null) {
                src = DbSrcMigration.findObject(mod, copied, pathResolver);
                if (src != null && !rootBranch.contains(src.parent)) {
                    src = null;
                }
                if (src != null) {
                    rootBranch.add(src);
                }
            }
            if (src == null) {
                return true;
            }
            BasicModElement root2 = (BasicModElement)((Object)mod.getModel().getRoot());
            if (!copied.containsKey(root2)) {
                BasicElement srcRoot = Objects.requireNonNull((BasicElement)pathResolver.fun(null));
                BasicMetaUtils.copyProperties(srcRoot, root2, true);
                copied.put(root2, null);
            }
            if ((srcResolved = (BasicElement)pathResolver.fun((Object)src)) != null) {
                BasicMetaUtils.copyProperties(srcResolved, mod, true);
            }
            copied.put(mod, src);
            return rootBranch.contains(src);
        });
    }

    @Nullable
    private static ObjectPath findObject(@Nullable BasicElement mod, Map<? extends BasicElement, ObjectPath> copied, @NotNull Function<ObjectPath, BasicElement> pathResolver) {
        if (pathResolver == null) {
            DbSrcMigration.$$$reportNull$$$0(9);
        }
        if (mod == null) {
            return null;
        }
        ObjectPath element2 = copied.get(mod);
        if (element2 != null) {
            return element2;
        }
        ObjectPath p2 = DbSrcMigration.findObject(mod.getParent(), copied, pathResolver);
        BasicElement parent2 = p2 == null ? null : (BasicElement)pathResolver.fun((Object)p2);
        Family<? extends BasicElement> family = parent2 == null ? null : parent2.familyOf(mod.getKind());
        BasicElement child = family == null ? null : ModelUtil.findObject(family, mod);
        return ObjectPaths.of(child);
    }

    @Nullable
    private static BasicElement findObject(@Nullable BasicElement mod, Map<ObjectPath, ? extends BasicElement> copied) {
        if (mod == null) {
            return null;
        }
        BasicElement element2 = copied.get(ObjectPaths.of(mod));
        if (element2 != null) {
            return element2;
        }
        BasicElement parent2 = DbSrcMigration.findObject(mod.getParent(), copied);
        Family<? extends BasicElement> family = parent2 == null ? null : parent2.familyOf(mod.getKind());
        return family == null ? null : ModelUtil.findObject(family, mod);
    }

    private static DasObject findObjectDefinition(SqlFile file, @NotNull ObjectPath target) {
        if (target == null) {
            DbSrcMigration.$$$reportNull$$$0(10);
        }
        return (DasObject)JBIterable.from((Iterable)file.getDdl()).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)target.kind)).first();
    }

    @NotNull
    private static List<Pair<ObjectPath, SqlFile>> findObjects(@NotNull Project project, @NotNull Iterable<Pair<ObjectPath, VirtualFile>> files) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(11);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(12);
        }
        FileDocumentManager dm = FileDocumentManager.getInstance();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
        ArrayList<Pair<ObjectPath, SqlFile>> objects2 = new ArrayList<Pair<ObjectPath, SqlFile>>();
        for (Pair<ObjectPath, VirtualFile> file : files) {
            SqlFile psiFile;
            Document doc = dm.getDocument((VirtualFile)file.second);
            SqlFile sqlFile = psiFile = doc == null ? null : (SqlFile)ObjectUtils.tryCast((Object)pdm.getPsiFile(doc), SqlFile.class);
            if (psiFile == null) continue;
            objects2.add((Pair<ObjectPath, SqlFile>)Pair.create((Object)((ObjectPath)file.first), (Object)psiFile));
        }
        ArrayList<Pair<ObjectPath, SqlFile>> arrayList = objects2;
        if (arrayList == null) {
            DbSrcMigration.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static void showMigrationDialog(@NotNull DbDataSource dataSource2, @NotNull Iterable<VirtualFile> files) {
        String statements2;
        if (dataSource2 == null) {
            DbSrcMigration.$$$reportNull$$$0(14);
        }
        if (files == null) {
            DbSrcMigration.$$$reportNull$$$0(15);
        }
        Project project = dataSource2.getProject();
        LocalDataSource localDataSource = DbImplUtil.getLocalDataSource((DasDataSource)dataSource2);
        List<Pair<ObjectPath, VirtualFile>> objects2 = DbSrcMigration.getObjects(project, files);
        ObjectPath any = (ObjectPath)JBIterable.from(objects2).filterMap(Functions.pairFirst()).first();
        ObjectPath spObject = DbImplUtil.getSearchPathObject(localDataSource.getDbms(), any);
        SearchPath searchPath = DbImplUtil.getAutoSwitchPath(localDataSource, SearchPath.of((ObjectPath)spObject));
        ScriptingAlterTask task = null;
        ArrayList<@NlsContexts.Label String> errors = new ArrayList<String>();
        if (any != null) {
            task = DbSrcMigration.buildMigrationTask(project, dataSource2, objects2, SearchPath.getCurrent((SearchPath)searchPath));
        }
        CompositeText text2 = null;
        if (task != null && !task.getCorrespondence().isEmpty()) {
            text2 = ScriptGenerators.INSTANCE.makeScript(dataSource2.getProject(), task).getScript();
        } else {
            errors.add(any == null ? DatabaseBundle.message((String)"label.no.objects.found", (Object[])new Object[0]) : DatabaseBundle.message((String)"label.no.create.statements.found", (Object[])new Object[0]));
        }
        if (text2 != null) {
            int ec = JBIterable.from(text2.getFragments()).filter(f -> f.getError() != null).size();
            if (ec != 0) {
                errors.add(DatabaseBundle.message((String)"label.script.contains.choice.error.errors", (Object[])new Object[]{ec, ec == 1 ? 0 : 1}));
            }
            try {
                text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource2), any.getDisplayName(), text2);
            }
            catch (Throwable th) {
                LOG.warn("Formatting failed", th);
            }
        }
        boolean apply2 = DatabaseSettings.getSettings().skipRefactoringPreview;
        String string = statements2 = text2 == null ? "" : text2.getText().toString();
        if (!apply2 || text2 == null || JBIterable.from(text2.getFragments()).filter(f -> f.getError() != null).isNotEmpty()) {
            DatabasePreviewDialog dialog2 = new DatabasePreviewDialog(project, dataSource2, searchPath, DatabaseBundle.message((String)"dialog.title.object.migration", (Object[])new Object[0]), DatabaseBundle.message((String)"label.scope.script", (Object[])new Object[0]), statements2, errors, true);
            apply2 = dialog2.showAndGet();
            statements2 = dialog2.getStatement();
        }
        if (apply2) {
            DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(project, localDataSource, searchPath).setStatement(statements2);
            LoaderContext context = handler.getContext();
            for (VirtualFile file : files) {
                DbElement item = DbSrcUtils.findDbElement(project, file.getPath(), DbElement.class);
                if (item != null) {
                    context.include(item);
                    continue;
                }
                context.include(DbSrcUtils.getFullPath(file.getPath()));
            }
            AsyncTask<Boolean> submit = handler.runStatements(false);
            if (Registry.is((String)"database.migration.source.revert.on.success")) {
                submit.apply(AsyncUtil.getEdtExecutor(), x -> {
                    try {
                        DbSrcUtils.revert(files);
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to revert user changes after refactoring", (Throwable)e);
                    }
                    return null;
                });
            }
        }
    }

    @NotNull
    public static PersistentMarkup formatCompositeText(@NotNull Project project, @NotNull SqlLanguageDialect dialect, @Nullable String target, @NotNull CompositeText text2) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(16);
        }
        if (dialect == null) {
            DbSrcMigration.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            DbSrcMigration.$$$reportNull$$$0(18);
        }
        DocumentImpl document = new DocumentImpl((CharSequence)"", true);
        ArrayList<Pair> ranges = new ArrayList<Pair>();
        boolean doNotFormat = true;
        for (CompositeText.Fragment fragment : text2.getFragments()) {
            int start2 = document.getTextLength();
            document.insertString(start2, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
            int end2 = document.getTextLength();
            CompositeText.Kind kind = fragment.getKind();
            if (kind != CompositeText.Kind.COMPACT_DEFINITION) {
                doNotFormat = kind == CompositeText.Kind.FIXED_TEXT || kind == CompositeText.Kind.ORIGINAL_TEXT || kind == CompositeText.Kind.SPECIFICATION_TEXT;
            }
            RangeMarker marker = doNotFormat ? document.createGuardedBlock(start2, end2) : document.createRangeMarker(start2, end2);
            ranges.add(Pair.create((Object)marker, (Object)fragment));
        }
        SqlPsiFacade.getInstance((Project)project).format(project, dialect, (Document)document);
        PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
        for (Pair range : ranges) {
            if (!((RangeMarker)range.first).isValid()) {
                LOG.warn("Range marker died during formatting" + (String)(target == null ? "" : " of " + target));
                continue;
            }
            builder.add(((CompositeText.Fragment)range.second).getKind(), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset(), ((CompositeText.Fragment)range.second).getError());
        }
        PersistentMarkup persistentMarkup = builder.build(document.getText());
        if (persistentMarkup == null) {
            DbSrcMigration.$$$reportNull$$$0(19);
        }
        return persistentMarkup;
    }

    @Nullable
    public static TextRange findCompactDefinitionRange(@NotNull Project project, Dbms dbms, ObjectPath path, CompositeText sql, Function<CompositeText, CompositeText> makeParsable) {
        if (project == null) {
            DbSrcMigration.$$$reportNull$$$0(20);
        }
        TextRange rg = null;
        if (!ContainerUtil.exists(sql.getFragments(), f -> f.getKind() == CompositeText.Kind.COMPACT_DEFINITION)) {
            TextRange content;
            SqlObjectBuilder builder = (SqlObjectBuilder)SqlObjectBuilder.EP.forDbms(dbms);
            rg = builder.getCompactDefinition(path, sql, null);
            if (rg == null) {
                TextRange r = sql.getContentRange();
                if (r == null) {
                    return null;
                }
                PsiObject object = null;
                int offset = 0;
                CompositeText parsable = sql;
                try {
                    parsable = (CompositeText)makeParsable.fun((Object)sql);
                    if (parsable != sql) {
                        TextRange pr = parsable.getContentRange();
                        if (pr == null) {
                            parsable = sql;
                        } else {
                            offset = r.getStartOffset() - pr.getStartOffset();
                        }
                    }
                    SqlFile file = SqlPsiFacade.getInstance((Project)project).createROFile(DbSqlUtil.getSqlDialect(dbms), parsable.getText());
                    object = (PsiObject)((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)file.getDdl())).expandAndSkip(o -> o instanceof SqlAlterStatement)).filter(PsiObject.class).first();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (object != null && (rg = builder.getCompactDefinition(path, parsable, object)) != null) {
                    rg = rg.shiftRight(offset);
                }
            }
            if (rg != null && (content = sql.getContentRange()) != null) {
                rg = rg.intersection(content);
            }
        }
        return rg == null || rg.isEmpty() ? null : rg;
    }

    public static boolean isToolbarPlace(String place) {
        return place != null && StringUtil.endsWithIgnoreCase((String)place, (String)"toolbar");
    }

    private static VirtualFile @NotNull [] getMigrationFiles(@NotNull AnActionEvent e) {
        Object[] els;
        Object[] files;
        if (e == null) {
            DbSrcMigration.$$$reportNull$$$0(21);
        }
        if (((files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || ContainerUtil.find((Object[])files, DbSrcUtils::isDbSrcFile) == null) && (els = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) != null) {
            files = (VirtualFile[])ContainerUtil.mapNotNull((Object[])els, o -> o instanceof DbElement ? DbSrcUtils.findDbSrcFile((DbElement)o, false) : null, (Object[])VirtualFile.EMPTY_ARRAY);
        }
        VirtualFile[] virtualFileArray = (VirtualFile[])ObjectUtils.chooseNotNull((Object)files, (Object)VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            DbSrcMigration.$$$reportNull$$$0(22);
        }
        return virtualFileArray;
    }

    @NotNull
    private static FileStatus getStatus(VirtualFile f, DbSrcFileStatus fileStatus) {
        FileStatus status = DbSrcUtils.isDbSrcFile(f) ? fileStatus.getStatus(f).getStatus() : null;
        FileStatus fileStatus2 = status == null ? FileStatus.NOT_CHANGED : status;
        if (fileStatus2 == null) {
            DbSrcMigration.$$$reportNull$$$0(23);
        }
        return fileStatus2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/DbSrcMigration";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/DbSrcMigration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjects";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCompositeText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getObjects";
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildMigrationTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildFromSql";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findObjectDefinition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findObjects";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showMigrationDialog";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatCompositeText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findCompactDefinitionRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 19: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DiffAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffAction.$$$reportNull$$$0(0);
            }
            Object[] files = DbSrcMigration.getMigrationFiles(e);
            DbSrcFileStatus fileStatus = DbSrcChangesTracker.getFileStatuses();
            boolean enabled = e.getProject() != null && ContainerUtil.find((Object[])files, f -> DbSrcMigration.getStatus(f, fileStatus) != FileStatus.NOT_CHANGED) != null;
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || DbSrcMigration.isToolbarPlace(e.getPlace()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffAction.$$$reportNull$$$0(1);
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            Object[] files = DbSrcMigration.getMigrationFiles(e);
            if (files.length == 0) {
                return;
            }
            DbSrcChangesTracker.flushAndUpdateFiles(Arrays.asList(files));
            List changes = JBIterable.of((Object[])files).filterMap(DbSrcChangesTracker::getChange).toList();
            if (changes.isEmpty()) {
                return;
            }
            ShowDiffAction.showDiffForChange((Project)e.getProject(), (Iterable)changes);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/script/DbSrcMigration$DiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class RevertAction
    extends DumbAwareAction {
        public static AnAction getInstance() {
            return ActionManager.getInstance().getAction("DatabaseView.Tools.RevertChanges");
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RevertAction.$$$reportNull$$$0(0);
            }
            VirtualFile[] files = DbSrcMigration.getMigrationFiles(e);
            DbSrcFileStatus fileStatus = DbSrcChangesTracker.getFileStatuses();
            boolean forget = true;
            boolean enabled = false;
            if (e.getProject() != null) {
                for (VirtualFile file : files) {
                    FileStatus status = DbSrcMigration.getStatus(file, fileStatus);
                    enabled |= status != FileStatus.NOT_CHANGED;
                    forget &= status == FileStatus.DELETED || status == FileStatus.UNKNOWN || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS;
                }
            }
            @Nls Supplier text2 = DatabaseBundle.messagePointer((String)((forget &= enabled) ? "action.DatabaseView.Tools.ForgetChanges.text" : "action.DatabaseView.Tools.RevertChanges.text"), (Object[])new Object[0]);
            e.getPresentation().setText(text2);
            @Nls Supplier desc = DatabaseBundle.messagePointer((String)(forget ? "action.DatabaseView.Tools.ForgetChanges.description" : "action.DatabaseView.Tools.RevertChanges.description"), (Object[])new Object[0]);
            e.getPresentation().setIcon(forget ? AllIcons.Actions.GC : AllIcons.Actions.Rollback);
            e.getPresentation().setDescription(desc);
            e.getPresentation().setEnabled(enabled);
            e.getPresentation().setVisible(enabled || DbSrcMigration.isToolbarPlace(e.getPlace()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile[] files;
            if (e == null) {
                RevertAction.$$$reportNull$$$0(1);
            }
            if ((files = DbSrcMigration.getMigrationFiles(e)).length == 0) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    DbSrcUtils.revert(Arrays.asList(files));
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/script/DbSrcMigration$RevertAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class SubmitAction
    extends DumbAwareAction {
        public static AnAction getInstance() {
            return ActionManager.getInstance().getAction("DatabaseView.Tools.SubmitChanges");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SubmitAction.$$$reportNull$$$0(0);
            }
            Object[] files = DbSrcMigration.getMigrationFiles(e);
            DbSrcFileStatus fileStatus = DbSrcChangesTracker.getFileStatuses();
            boolean enabled = e.getProject() != null && ContainerUtil.find((Object[])files, f -> DbSrcMigration.isSupported(f) && DbSrcMigration.getStatus(f, fileStatus) != FileStatus.NOT_CHANGED) != null;
            e.getPresentation().setVisible(enabled || DbSrcMigration.isToolbarPlace(e.getPlace()));
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable files;
            Project project;
            DbDataSource dataSource2;
            if (e == null) {
                SubmitAction.$$$reportNull$$$0(1);
            }
            if ((dataSource2 = DbImplUtil.findDataSource(project = Objects.requireNonNull(e.getProject()), (VirtualFile)(files = JBIterable.of((Object[])DbSrcMigration.getMigrationFiles(e))).first())) != null) {
                DbSrcMigration.showMigrationDialog(dataSource2, (Iterable<VirtualFile>)files);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/script/DbSrcMigration$SubmitAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

