/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.json.json5.Json5Language;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultTextRendererFactory
implements GridCellRendererFactory {
    @Nullable
    public static final Language XML_LANGUAGE = LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension("xml"));
    private final DataGrid myGrid;
    private final Map<Language, TextRenderer> myRenderers;

    DefaultTextRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myRenderers = FactoryMap.createMap(language -> {
            TextRenderer renderer = new TextRenderer(this.myGrid, (Language)language);
            Disposer.register((Disposable)this.myGrid, (Disposable)renderer);
            return renderer;
        }, () -> new Reference2ObjectOpenHashMap());
    }

    @Override
    public boolean supportsDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    public boolean supportsColumn(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(3);
        }
        GridCellRenderer gridCellRenderer = this.myRenderers.get(DefaultTextRendererFactory.getLanguage(columnIdx, this.myGrid));
        if (gridCellRenderer == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(4);
        }
        return gridCellRenderer;
    }

    @NotNull
    public static Language getLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull DataGrid grid) {
        Language language;
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(6);
        }
        if ((language = grid.getContentLanguage(columnIdx)) != Language.ANY) {
            Language language2 = language;
            if (language2 == null) {
                DefaultTextRendererFactory.$$$reportNull$$$0(7);
            }
            return language2;
        }
        DomainRegistry registry = DomainRegistry.get(DataGridUtil.getDbms(grid), null);
        if (registry != null) {
            LogicalType logicType;
            DataConsumer.Column column2 = DefaultTextRendererFactory.getColumn(columnIdx, grid);
            Domain domain = column2 == null ? null : registry.getDomain(column2);
            LogicalType logicalType = logicType = domain == null ? null : domain.getLogicType();
            if (logicType == LogicalType.JSON) {
                Json5Language json5Language = Json5Language.INSTANCE;
                if (json5Language == null) {
                    DefaultTextRendererFactory.$$$reportNull$$$0(8);
                }
                return json5Language;
            }
            if (logicType == LogicalType.XML) {
                language = XML_LANGUAGE;
            }
        }
        Object object = language != Language.ANY && language != null ? language : PlainTextLanguage.INSTANCE;
        if (object == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Nullable
    private static DataConsumer.Column getColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Grid<DataConsumer.Row, DataConsumer.Column> grid) {
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(10);
        }
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(11);
        }
        return grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsDialect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsColumn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextRenderer
    extends GridCellRenderer {
        private final Map<Object, String> myValueTextCache;
        private final Language myLanguage;
        private EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;
        private Inlay<HintRenderer> inlay;

        public TextRenderer(@NotNull DataGrid grid, @NotNull Language language) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(0);
            }
            if (language == null) {
                TextRenderer.$$$reportNull$$$0(1);
            }
            super(grid);
            this.myValueTextCache = CollectionFactory.createConcurrentWeakKeySoftValueIdentityMap((int)10, (float)0.75f, (int)1);
            this.myLanguage = language;
            new UiNotifyConnector((Component)((Object)grid.getComponent()), new Activatable(){

                public void hideNotify() {
                    myValueTextCache.clear();
                }
            });
        }

        @NotNull
        public static EditorTextFieldCellRenderer.AbbreviatingRendererComponent createComponent(@NotNull Project project, @Nullable Language language) {
            if (project == null) {
                TextRenderer.$$$reportNull$$$0(2);
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent component = language == PlainTextLanguage.INSTANCE ? new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, true) : new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, false, ' ');
            component.setBorder((Border)new JBEmptyBorder(0, 3, 0, 3));
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = component;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(3);
            }
            return abbreviatingRendererComponent;
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                TextRenderer.$$$reportNull$$$0(4);
            }
            if (column2 == null) {
                TextRenderer.$$$reportNull$$$0(5);
            }
            return 1;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> rowIdx, @NotNull ViewIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(6);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(7);
            }
            Pair<Integer, Integer> modelRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun(rowIdx.asInteger(), columnIdx.asInteger());
            ModelIndex<DataConsumer.Column> modelColumn = ModelIndex.forColumn(this.myGrid, (int)((Integer)modelRowAndColumn.second));
            JComponent jComponent = this.getComponent(rowIdx, columnIdx, value2, modelColumn);
            if (jComponent == null) {
                TextRenderer.$$$reportNull$$$0(8);
            }
            return jComponent;
        }

        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> rowIdx, @NotNull ViewIndex<DataConsumer.Column> columnIdx, @Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> modelColumn) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(9);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(10);
            }
            if (modelColumn == null) {
                TextRenderer.$$$reportNull$$$0(11);
            }
            if (this.myComponent == null) {
                this.myComponent = TextRenderer.createComponent(DataGridUtil.getProject(this.myGrid), this.myLanguage);
                ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myComponent).subscribe(EditorColorsManager.TOPIC, scheme -> {
                    this.myGrid.getComponent().globalSchemeChange(scheme);
                    this.myComponent.getEditor().reinitSettings();
                });
            }
            EditorEx editor = this.myComponent.getEditor();
            this.configureEditor(editor);
            boolean selected = this.myGrid.getSelectionModel().isSelected(rowIdx, columnIdx);
            TextAttributes attributes2 = TextRenderer.getAttributes(value2, (TextAttributesScheme)editor.getColorsScheme(), selected);
            String valueText = this.getValueText(modelColumn, value2 == null ? ReservedCellValue.NULL : value2);
            this.myComponent.setText(valueText, attributes2, selected);
            if (this.inlay != null) {
                Disposer.dispose(this.inlay);
            }
            this.inlay = null;
            String inlayMessage = TextRenderer.getInlayMessage(value2, modelColumn, this.myGrid);
            if (inlayMessage != null) {
                this.inlay = editor.getInlayModel().addInlineElement(0, (EditorCustomElementRenderer)new HintRenderer(inlayMessage));
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = this.myComponent;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(12);
            }
            return abbreviatingRendererComponent;
        }

        @Nullable
        private static String getInlayMessage(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> modelColumn, DataGrid grid) {
            if (modelColumn == null) {
                TextRenderer.$$$reportNull$$$0(13);
            }
            if (value2 instanceof byte[]) {
                return StringUtil.formatFileSize((long)((byte[])value2).length, (String)"");
            }
            if (!(value2 instanceof LobInfo)) {
                return null;
            }
            LobInfo info = (LobInfo)value2;
            if (!info.isTruncated()) {
                return value2 instanceof LobInfo.BlobInfo ? StringUtil.formatFileSize((long)info.length, (String)"") : null;
            }
            if (info instanceof LobInfo.ClobInfo && ((LobInfo.ClobInfo)info).data == null || info instanceof LobInfo.BlobInfo && ((LobInfo.BlobInfo)info).data == null) {
                DataConsumer.Column column2 = DefaultTextRendererFactory.getColumn(modelColumn, grid);
                return (String)(column2 == null ? "" : "(" + StringUtil.toUpperCase((String)column2.typeName) + ") ") + StringUtil.formatFileSize((long)info.length, (String)"");
            }
            return String.format("%s of %s", StringUtil.formatFileSize((long)info.getLoadedDataLength(), (String)""), StringUtil.formatFileSize((long)info.length, (String)""));
        }

        public static TextAttributes getAttributes(@Nullable Object value2, @NotNull TextAttributesScheme scheme, boolean selected) {
            if (scheme == null) {
                TextRenderer.$$$reportNull$$$0(14);
            }
            TextAttributesKey attributesKey = TextRenderer.getAttributesKey(value2);
            return !selected && attributesKey != null ? scheme.getAttributes(attributesKey) : null;
        }

        protected void configureEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(15);
            }
            TextRenderer.configureEditor(editor, this.myGrid);
        }

        public static void configureEditor(@NotNull EditorEx editor, @NotNull Grid<DataConsumer.Row, DataConsumer.Column> grid) {
            EditorColorsScheme scheme;
            boolean schemeAlreadySet;
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(16);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(17);
            }
            boolean bl = schemeAlreadySet = (scheme = editor.getColorsScheme()) instanceof DelegateColorScheme && ((DelegateColorScheme)scheme).getDelegate() == grid.getColorsScheme() && scheme.getEditorFontSize() == grid.getPreferredFocusedComponent().getFont().getSize();
            if (schemeAlreadySet) {
                return;
            }
            EditorColorsScheme bounded = editor.createBoundColorSchemeDelegate((EditorColorsScheme)grid.getColorsScheme());
            bounded.setEditorFontSize(grid.getPreferredFocusedComponent().getFont().getSize());
            editor.setColorsScheme(bounded);
        }

        @NotNull
        protected String getValueText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Object value2) {
            String cachedText;
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(18);
            }
            if (value2 == null) {
                TextRenderer.$$$reportNull$$$0(19);
            }
            String string = cachedText = value2 instanceof ReservedCellValue ? null : this.myValueTextCache.get(value2);
            if (cachedText != null) {
                String string2 = cachedText;
                if (string2 == null) {
                    TextRenderer.$$$reportNull$$$0(20);
                }
                return string2;
            }
            String text2 = TextRenderer.getText(columnIdx, value2, this.myGrid);
            if (!(value2 instanceof ReservedCellValue)) {
                this.myValueTextCache.put(value2, text2);
            }
            String string3 = text2;
            if (string3 == null) {
                TextRenderer.$$$reportNull$$$0(21);
            }
            return string3;
        }

        @NotNull
        private static String getText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Object value2, @NotNull DataGrid grid) {
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(22);
            }
            if (value2 == null) {
                TextRenderer.$$$reportNull$$$0(23);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(24);
            }
            String string = value2 instanceof ReservedCellValue ? ((ReservedCellValue)((Object)value2)).getDisplayName() : TextRenderer.getDisplayString(TextRenderer.getText(value2, columnIdx, grid));
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(25);
            }
            return string;
        }

        @NotNull
        private static String getText(@NotNull Object value2, @NotNull ModelIndex<DataConsumer.Column> columnIdx, DataGrid grid) {
            DataConsumer.Column column2;
            if (value2 == null) {
                TextRenderer.$$$reportNull$$$0(26);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(27);
            }
            String string = (column2 = DefaultTextRendererFactory.getColumn(columnIdx, grid)) != null ? grid.getObjectFormatter().getPlainValue(value2, column2, DataGridUtil.getDbms(grid)) : value2.toString();
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(28);
            }
            return string;
        }

        public static String getDisplayString(@NotNull String str) {
            int lineEnd;
            if (str == null) {
                TextRenderer.$$$reportNull$$$0(29);
            }
            if (DataGridUtil.isFailedToLoad(str) && (lineEnd = str.indexOf(10, "<failed to load>".length() + 1)) > -1) {
                str = str.substring("<failed to load>".length(), lineEnd).trim();
            }
            return TextRenderer.trimTrailingWhitespace(str);
        }

        private static String trimTrailingWhitespace(String s2) {
            int end2;
            for (end2 = s2.length(); end2 > 0 && s2.charAt(end2 - 1) <= ' ' && s2.charAt(end2 - 1) != '\n'; --end2) {
            }
            return s2.substring(0, end2);
        }

        @Override
        public void dispose() {
            if (this.myComponent != null) {
                Disposer.dispose((Disposable)this.myComponent);
            }
        }

        @Nullable
        public static TextAttributesKey getAttributesKey(@Nullable Object value2) {
            if (value2 == null || value2 == ReservedCellValue.UNSET) {
                return DatabaseColors.GRID_NULL_VALUE;
            }
            if (value2 instanceof ObjectFormatter.ImageInfo) {
                return DatabaseColors.GRID_IMAGE_VALUE;
            }
            if (DataGridUtil.isFailedToLoad(value2)) {
                return DatabaseColors.GRID_ERROR_VALUE;
            }
            if (value2 instanceof LobInfo.FileClobInfo || value2 instanceof LobInfo.FileBlobInfo) {
                return DatabaseColors.GRID_UPLOAD_VALUE;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 8: 
                case 12: 
                case 20: 
                case 21: 
                case 25: 
                case 28: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 8: 
                case 12: 
                case 20: 
                case 21: 
                case 25: 
                case 28: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 8: 
                case 12: 
                case 20: 
                case 21: 
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 7: 
                case 10: 
                case 18: 
                case 22: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelColumn";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 19: 
                case 23: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
                case 25: 
                case 28: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 3: 
                case 8: 
                case 12: 
                case 20: 
                case 21: 
                case 25: 
                case 28: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getInlayMessage";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributes";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "configureEditor";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "getDisplayString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 8: 
                case 12: 
                case 20: 
                case 21: 
                case 25: 
                case 28: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

