/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBEmptyBorder;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultBooleanRendererFactory
implements GridCellRendererFactory {
    private final DataGrid myGrid;
    private TextBooleanRenderer myTextRenderer;
    private CheckboxBooleanRenderer myCheckboxRenderer;

    DefaultBooleanRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @Override
    public boolean supportsDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    public boolean supportsColumn(@NotNull DataConsumer.Column column2) {
        if (column2 == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(2);
        }
        return ObjectFormatter.isBooleanColumn(column2);
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(3);
        }
        if (this.myGrid.getBooleanMode() == DatabaseSettings.BooleanMode.TEXT) {
            if (this.myTextRenderer == null) {
                this.myTextRenderer = new TextBooleanRenderer(this.myGrid);
                Disposer.register((Disposable)this.myGrid, (Disposable)this.myTextRenderer);
            }
            TextBooleanRenderer textBooleanRenderer = this.myTextRenderer;
            if (textBooleanRenderer == null) {
                DefaultBooleanRendererFactory.$$$reportNull$$$0(4);
            }
            return textBooleanRenderer;
        }
        if (this.myCheckboxRenderer == null) {
            this.myCheckboxRenderer = new CheckboxBooleanRenderer(this.myGrid);
            Disposer.register((Disposable)this.myGrid, (Disposable)this.myCheckboxRenderer);
        }
        CheckboxBooleanRenderer checkboxBooleanRenderer = this.myCheckboxRenderer;
        if (checkboxBooleanRenderer == null) {
            DefaultBooleanRendererFactory.$$$reportNull$$$0(5);
        }
        return checkboxBooleanRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsDialect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsColumn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CheckboxBooleanRenderer
    extends GridCellRenderer {
        final DefaultTextRendererFactory.TextRenderer reservedCellValuesRenderer;
        final JBCheckBox myComponent;

        public CheckboxBooleanRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(0);
            }
            super(grid);
            this.reservedCellValuesRenderer = new DefaultTextRendererFactory.TextRenderer(grid, (Language)PlainTextLanguage.INSTANCE);
            Disposer.register((Disposable)this, (Disposable)this.reservedCellValuesRenderer);
            this.myComponent = new JBCheckBox();
            this.myComponent.setHorizontalAlignment(0);
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(2);
            }
            return GridCellEditorsUtil.isBooleanCell(this.myGrid, row, column2) ? 1 : 0;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> row, @NotNull ViewIndex<DataConsumer.Column> column2, @Nullable Object value2) {
            if (row == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(4);
            }
            if (value2 instanceof Boolean) {
                this.myComponent.setSelected(((Boolean)value2).booleanValue());
                JBCheckBox jBCheckBox = this.myComponent;
                if (jBCheckBox == null) {
                    CheckboxBooleanRenderer.$$$reportNull$$$0(5);
                }
                return jBCheckBox;
            }
            JComponent jComponent = this.reservedCellValuesRenderer.getComponent(row, column2, value2);
            if (jComponent == null) {
                CheckboxBooleanRenderer.$$$reportNull$$$0(6);
            }
            return jComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$CheckboxBooleanRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$CheckboxBooleanRenderer";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TextBooleanRenderer
    extends DefaultTextRendererFactory.TextRenderer {
        private static final char BULLET = '\u2022';

        public TextBooleanRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                TextBooleanRenderer.$$$reportNull$$$0(0);
            }
            super(grid, (Language)PlainTextLanguage.INSTANCE);
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> rowIdx, @NotNull ViewIndex<DataConsumer.Column> columnIdx, @Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> modelColumn) {
            if (rowIdx == null) {
                TextBooleanRenderer.$$$reportNull$$$0(1);
            }
            if (columnIdx == null) {
                TextBooleanRenderer.$$$reportNull$$$0(2);
            }
            if (modelColumn == null) {
                TextBooleanRenderer.$$$reportNull$$$0(3);
            }
            JComponent component = super.getComponent(rowIdx, columnIdx, value2, modelColumn);
            component.setBorder((Border)new JBEmptyBorder(0, 1, 0, 3));
            JComponent jComponent = component;
            if (jComponent == null) {
                TextBooleanRenderer.$$$reportNull$$$0(4);
            }
            return jComponent;
        }

        @Override
        @NotNull
        protected String getValueText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Object value2) {
            if (columnIdx == null) {
                TextBooleanRenderer.$$$reportNull$$$0(5);
            }
            if (value2 == null) {
                TextBooleanRenderer.$$$reportNull$$$0(6);
            }
            String text2 = super.getValueText(columnIdx, value2);
            Object object = Boolean.TRUE.equals(value2) ? (this.myGrid.getResultView().isTransposed() ? text2 + " \u2022" : " \u2022 " + text2) : (this.myGrid.getResultView().isTransposed() ? text2 : "   " + text2);
            if (object == null) {
                TextBooleanRenderer.$$$reportNull$$$0(7);
            }
            return object;
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            if (row == null) {
                TextBooleanRenderer.$$$reportNull$$$0(8);
            }
            if (column2 == null) {
                TextBooleanRenderer.$$$reportNull$$$0(9);
            }
            return GridCellEditorsUtil.isBooleanCell(this.myGrid, row, column2) ? 1 : 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modelColumn";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$TextBooleanRenderer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultBooleanRendererFactory$TextBooleanRenderer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 4: 
                case 7: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

