/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorTextField
extends EditorTextField
implements Disposable {
    private final DataGrid myGrid;

    public GridCellEditorTextField(final Project project, @NotNull DataGrid grid, @NotNull Language language, boolean multiline, EventObject initiator, TextCompletionProvider provider, boolean autoPopup, final @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        boolean clear2;
        if (grid == null) {
            GridCellEditorTextField.$$$reportNull$$$0(0);
        }
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            GridCellEditorTextField.$$$reportNull$$$0(2);
        }
        if (valueFormatter == null) {
            GridCellEditorTextField.$$$reportNull$$$0(3);
        }
        super(GridCellEditorTextField.createDocument(language), project, (FileType)FileTypes.PLAIN_TEXT);
        boolean bl = clear2 = initiator instanceof KeyEvent && grid.isEditable();
        if (!clear2) {
            this.setText(valueFormatter);
        }
        this.putClientProperty("JBListTable.isTableCellEditor", Boolean.TRUE);
        this.myGrid = grid;
        this.installEditorSettingsProvider(multiline);
        GridCellEditorTextField.installCompletion(project, this.getDocument(), provider, autoPopup);
        this.myGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onCellLanguageChanged(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
                if (columnIdx == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (language == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!columnIdx.equals(column2)) {
                    return;
                }
                LightVirtualFile file = (LightVirtualFile)ObjectUtils.tryCast((Object)FileDocumentManager.getInstance().getFile(GridCellEditorTextField.this.getDocument()), LightVirtualFile.class);
                if (file == null) {
                    return;
                }
                file.setLanguage(language);
                EditorEx editor = (EditorEx)ObjectUtils.tryCast((Object)GridCellEditorTextField.this.getEditor(), EditorEx.class);
                if (editor != null) {
                    editor.setHighlighter(HighlighterFactory.createHighlighter((Project)project, (VirtualFile)file));
                }
                FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "columnIdx";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "language";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$1";
                objectArray[2] = "onCellLanguageChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    void setText(@NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (valueFormatter == null) {
            GridCellEditorTextField.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            GridCellEditorFactory.ValueFormatterResult result = valueFormatter.format();
            VirtualFile file = FileDocumentManager.getInstance().getFile(this.getDocument());
            if (file != null) {
                file.setCharset(result.charset);
                file.setBOM(result.bom);
            }
            this.setText(result.text);
        });
    }

    protected boolean shouldHaveBorder() {
        return false;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Editor editor = this.getEditor();
        if (editor instanceof EditorEx && !editor.isOneLineMode()) {
            JScrollBar horizontalScrollBar;
            JScrollPane scrollPane = ((EditorEx)editor).getScrollPane();
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                size.width += verticalScrollBar.getWidth();
            }
            if ((horizontalScrollBar = scrollPane.getHorizontalScrollBar()) != null) {
                size.height += horizontalScrollBar.getHeight();
            }
        }
        return size;
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GridCellEditorTextField.$$$reportNull$$$0(5);
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return FileDocumentManager.getInstance().getFile(this.getDocument());
        }
        if (CommonDataKeys.EDITOR.is(dataId) || CommonDataKeys.HOST_EDITOR.is(dataId)) {
            return this.getEditor();
        }
        if (AnActionEvent.injectedId((String)CommonDataKeys.CARET.getName()).equals(dataId)) {
            Editor editor = this.getEditor();
            return editor == null ? null : editor.getCaretModel().getCurrentCaret();
        }
        return super.getData(dataId);
    }

    public void dispose() {
    }

    protected boolean isEditable() {
        return this.myGrid.isEditable();
    }

    private void registerEnterAction(@NotNull Editor editor, final boolean multiline) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(6);
        }
        CustomShortcutSet enterAndControlEnter = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"ENTER"), KeyboardShortcut.fromString((String)"control ENTER")});
        DumbAwareAction action2 = new DumbAwareAction("insertNewLineOrStopEditing1"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                InputEvent inputEvent;
                boolean isCtrlEnter;
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean bl = isCtrlEnter = (inputEvent = e.getInputEvent()) instanceof KeyEvent && inputEvent.isControlDown();
                if (multiline && isCtrlEnter) {
                    this.performEditorEnter(e);
                } else {
                    GridCellEditorTextField.this.myGrid.stopEditing();
                }
            }

            private void performEditorEnter(@NotNull AnActionEvent e) {
                AnAction action2;
                if (e == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((action2 = ActionManager.getInstance().getAction("EditorEnter")) != null) {
                    action2.beforeActionPerformedUpdate(e);
                    if (e.getPresentation().isEnabled()) {
                        action2.actionPerformed(e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performEditorEnter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GridCellEditorTextField.registerAction(editor, (AnAction)action2, (ShortcutSet)enterAndControlEnter);
    }

    private void registerTabAction(@NotNull EditorEx editor) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(7);
        }
        CustomShortcutSet tabAndShiftTab = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)"TAB"), KeyboardShortcut.fromString((String)"shift TAB")});
        DumbAwareAction action2 = new DumbAwareAction("insertTabOrStopEditing"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
                e.getPresentation().setEnabledAndVisible(keyEvent != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                KeyStroke stroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                Object actionKey = gridComponent.getInputMap(1).get(stroke);
                Action tabAction = gridComponent.getActionMap().get(actionKey);
                if (tabAction != null) {
                    tabAction.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, (AnAction)action2, (ShortcutSet)tabAndShiftTab);
    }

    private void registerArrowAction(final @NotNull EditorEx editor) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(8);
        }
        final KeyboardShortcut up = KeyboardShortcut.fromString((String)"UP");
        KeyboardShortcut down = KeyboardShortcut.fromString((String)"DOWN");
        DumbAwareAction action2 = new DumbAwareAction("goToPreviousOrNextLineOrStopEditing"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (editor.getDocument().getLineCount() > 1) {
                    e.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                KeyEvent keyEvent = (KeyEvent)ObjectUtils.tryCast((Object)e.getInputEvent(), KeyEvent.class);
                e.getPresentation().setEnabledAndVisible(keyEvent != null && LookupManager.getActiveLookup((Editor)GridCellEditorTextField.this.getEditor()) == null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Action action2;
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                KeyEvent keyEvent = (KeyEvent)e.getInputEvent();
                JComponent gridComponent = GridCellEditorTextField.this.myGrid.getPreferredFocusedComponent();
                ActionMap actionMap = gridComponent.getActionMap();
                Action action3 = action2 = up.getFirstKeyStroke().getKeyCode() == keyEvent.getKeyCode() ? actionMap.get("selectPreviousRow") : actionMap.get("selectNextRow");
                if (action2 == null) {
                    return;
                }
                action2.actionPerformed(new ActionEvent(gridComponent, keyEvent.getID(), keyEvent.toString(), keyEvent.getWhen(), keyEvent.getModifiers()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GridCellEditorTextField.registerAction((Editor)editor, (AnAction)action2, (ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}));
    }

    private static void registerAction(@NotNull Editor editor, @NotNull AnAction action2, @NotNull ShortcutSet shortcutSet) {
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(9);
        }
        if (action2 == null) {
            GridCellEditorTextField.$$$reportNull$$$0(10);
        }
        if (shortcutSet == null) {
            GridCellEditorTextField.$$$reportNull$$$0(11);
        }
        action2.registerCustomShortcutSet(shortcutSet, editor.getComponent());
    }

    private void installEditorSettingsProvider(boolean multiline) {
        this.addSettingsProvider(editor -> {
            editor.setRendererMode(!this.isEditable());
            EditorColorsScheme scheme = editor.createBoundColorSchemeDelegate((EditorColorsScheme)this.myGrid.getColorsScheme());
            if (UISettings.getInstance().getPresentationMode()) {
                scheme.setEditorFontSize(UISettings.getInstance().getPresentationModeFontSize());
            }
            editor.setColorsScheme(scheme);
            editor.setBackgroundColor(scheme.getDefaultBackground());
            editor.setOneLineMode(!multiline);
            editor.setVerticalScrollbarVisible(multiline);
            editor.setHorizontalScrollbarVisible(multiline);
            editor.getSettings().setAdditionalColumnsCount(2);
            editor.getCaretModel().moveToOffset(0);
            if (this.isEditable() && (!multiline || this.getDocument().getLineCount() == 1)) {
                editor.getSelectionModel().setSelection(0, this.getDocument().getTextLength());
            }
            this.putReadOnlyText(editor);
            editor.installPopupHandler(new EditorPopupHandler(){

                public boolean handlePopup(@NotNull EditorMouseEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Component component = (Component)mouseEvent.getSource();
                    int x = mouseEvent.getX();
                    int y = mouseEvent.getY();
                    GridCellEditorsUtil.showCellEditorPopup(GridCellEditorTextField.this.myGrid, component, x, y);
                    event.consume();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField$5", "handlePopup"));
                }
            });
            this.registerEnterAction((Editor)editor, multiline);
            this.registerTabAction(editor);
            if (multiline) {
                this.registerArrowAction(editor);
            }
        });
    }

    private void putReadOnlyText(@NotNull EditorEx editor) {
        GridEditGuard guard;
        if (editor == null) {
            GridCellEditorTextField.$$$reportNull$$$0(12);
        }
        if ((guard = GridEditGuard.get(this.myGrid)) == null) {
            return;
        }
        EditorModificationUtil.setReadOnlyHint((Editor)editor, (String)guard.getReasonText(this.myGrid));
    }

    @NotNull
    private static Document createDocument(@NotNull Language language) {
        if (language == null) {
            GridCellEditorTextField.$$$reportNull$$$0(13);
        }
        PlainTextLanguage lang = language == Language.ANY ? PlainTextLanguage.INSTANCE : language;
        LightVirtualFile file = new LightVirtualFile("GridCellEditorTextField", (Language)lang, (CharSequence)"");
        Document doc = FileDocumentManager.getInstance().getDocument((VirtualFile)file);
        Document document = doc != null ? doc : EditorFactory.getInstance().createDocument((CharSequence)"");
        if (document == null) {
            GridCellEditorTextField.$$$reportNull$$$0(14);
        }
        return document;
    }

    private static void installCompletion(@NotNull Project project, @Nullable Document document, @Nullable TextCompletionProvider provider, boolean autoPopup) {
        if (project == null) {
            GridCellEditorTextField.$$$reportNull$$$0(15);
        }
        if (document == null || provider == null) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile != null) {
            TextCompletionUtil.installProvider((PsiFile)psiFile, (TextCompletionProvider)provider, (boolean)autoPopup);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorTextField";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerEnterAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerTabAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerArrowAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putReadOnlyText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

