/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatBasedGridCellEditorFactory
implements GridCellEditorFactory {
    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(2);
        }
        Project project = DataGridUtil.getProject(grid);
        Formatter formatter = this.getFormat(grid, row, column2);
        TextCompletionProvider provider = GridCellEditorsUtil.createCompletionProvider(grid, column2);
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column2);
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column2);
        NullCompletionProvider resultProvider = new NullCompletionProvider(dasColumn, provider);
        GridCellEditorFactory.ValueParser valueParser = this.getValueParser(grid, row, column2, object);
        GridCellEditorFactory.ValueFormatter valueFormatter = this.getValueFormatter(grid, row, column2, object);
        FormatBasedGridCellEditor formatBasedGridCellEditor = this.createEditorImpl(project, grid, formatter, nullValue, initiator, resultProvider, row, column2, valueParser, valueFormatter);
        if (formatBasedGridCellEditor == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(3);
        }
        return formatBasedGridCellEditor;
    }

    @NotNull
    private Formatter getFormat(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(4);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(5);
        }
        if (column2 == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(6);
        }
        Formatter baseFormatter = this.getFormatInner(grid, row, column2);
        Formatter formatter = this.makeFormatterLenient(grid) ? new LenientFormatter(baseFormatter) : baseFormatter;
        if (formatter == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(7);
        }
        return formatter;
    }

    @NotNull
    protected abstract Formatter getFormatInner(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    @Override
    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        GridCellEditorFactory.IsEditableChecker isEditableChecker = (dbms, value2) -> true;
        if (isEditableChecker == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(8);
        }
        return isEditableChecker;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, final @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object initialValue) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(9);
        }
        if (rowIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(10);
        }
        if (columnIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(11);
        }
        final Formatter format = this.getFormat(grid, rowIdx, columnIdx);
        final ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, columnIdx);
        return new GridCellEditorFactory.ValueParser(){

            @Override
            @NotNull
            public Object parse(@NotNull String text2, @NotNull Document document) {
                Object object;
                if (text2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (StringUtil.isEmptyOrSpaces((String)text2)) {
                    Object object2 = ObjectUtils.notNull((Object)((Object)nullValue), (Object)((Object)ReservedCellValue.NULL));
                    if (object2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return object2;
                }
                if (FormatBasedGridCellEditorFactory.isNull(text2, grid, columnIdx)) {
                    ReservedCellValue reservedCellValue = ReservedCellValue.NULL;
                    if (reservedCellValue == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return reservedCellValue;
                }
                try {
                    object = format.parse(text2);
                }
                catch (ParseException ignore) {
                    String string = text2;
                    if (string == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                if (object == null) {
                    1.$$$reportNull$$$0(4);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parse";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "parse";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueFormatter getValueFormatter(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(12);
        }
        if (rowIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(13);
        }
        if (columnIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(14);
        }
        Formatter format = this.getFormat(grid, rowIdx, columnIdx);
        GridCellEditorFactory.ValueFormatter valueFormatter = () -> {
            try {
                return new GridCellEditorFactory.ValueFormatterResult(value2 instanceof ReservedCellValue || value2 == null ? "" : format.format(value2));
            }
            catch (IllegalArgumentException iae) {
                if (DataGridUtil.LOG.isDebugEnabled()) {
                    Dbms dialectFamily = DataGridUtil.getDbms(grid);
                    String message2 = "Failed to format object " + value2 + " of class " + value2.getClass().getName() + " using format " + format + ". Dialect: " + dialectFamily + "\n";
                    DataGridUtil.LOG.debug(message2, (Throwable)iae);
                }
                return new GridCellEditorFactory.ValueFormatterResult("");
            }
        };
        if (valueFormatter == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(15);
        }
        return valueFormatter;
    }

    static boolean isNull(@Nullable String s2, @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        DasColumn column2;
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(16);
        }
        if (columnIdx == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(17);
        }
        return (column2 = DataGridUtil.getDatabaseColumn(grid, columnIdx)) != null && !column2.isNotNull() && StringUtil.findIgnoreCase((String)s2, (String[])new String[]{"null", "<null>"});
    }

    protected boolean makeFormatterLenient(@NotNull DataGrid grid) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(18);
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        return dbms.isSqlite();
    }

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(19);
        }
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(20);
        }
        if (format == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(21);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(22);
        }
        if (column2 == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(23);
        }
        if (valueParser == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(24);
        }
        if (valueFormatter == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(25);
        }
        return new FormatBasedGridCellEditor(project, grid, format, column2, row, nullValue, initiator, provider, valueParser, valueFormatter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 6: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIsEditableChecker";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFormat";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValueFormatter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isNull";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatterLenient";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullCompletionProvider
    implements TextCompletionProvider {
        private final DasColumn myColumn;
        private final TextCompletionProvider myDelegate;

        NullCompletionProvider(@Nullable DasColumn column2, @Nullable TextCompletionProvider delegate) {
            this.myColumn = column2;
            this.myDelegate = delegate;
        }

        @Nullable
        public String getAdvertisement() {
            return this.myDelegate == null ? null : this.myDelegate.getAdvertisement();
        }

        @Nullable
        public String getPrefix(@NotNull String text2, int offset) {
            if (text2 == null) {
                NullCompletionProvider.$$$reportNull$$$0(0);
            }
            return this.myDelegate == null ? null : this.myDelegate.getPrefix(text2, offset);
        }

        @NotNull
        public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result, @NotNull String prefix) {
            if (result == null) {
                NullCompletionProvider.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                NullCompletionProvider.$$$reportNull$$$0(2);
            }
            CompletionResultSet completionResultSet = this.myDelegate == null ? result : this.myDelegate.applyPrefixMatcher(result, prefix);
            if (completionResultSet == null) {
                NullCompletionProvider.$$$reportNull$$$0(3);
            }
            return completionResultSet;
        }

        @Nullable
        public CharFilter.Result acceptChar(char c2) {
            return this.myDelegate == null ? null : this.myDelegate.acceptChar(c2);
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                NullCompletionProvider.$$$reportNull$$$0(4);
            }
            if (prefix == null) {
                NullCompletionProvider.$$$reportNull$$$0(5);
            }
            if (result == null) {
                NullCompletionProvider.$$$reportNull$$$0(6);
            }
            if (parameters.getInvocationCount() == 0 && !NullCompletionProvider.isNullPrefix(prefix)) {
                return;
            }
            if (this.myDelegate != null) {
                this.myDelegate.fillCompletionVariants(parameters, prefix, result);
            }
            if (this.myColumn == null || this.myColumn.isNotNull()) {
                return;
            }
            String fileText = parameters.getOriginalFile().getText();
            if (fileText == null || !NullCompletionProvider.isNullPrefix(StringUtil.trim((String)fileText))) {
                return;
            }
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"null").withCaseSensitivity(false).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)1.0));
        }

        private static boolean isNullPrefix(@NotNull String trim) {
            if (trim == null) {
                NullCompletionProvider.$$$reportNull$$$0(7);
            }
            return StringUtil.startsWithIgnoreCase((String)"nul", (String)trim);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$NullCompletionProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$NullCompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPrefixMatcher";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fillCompletionVariants";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isNullPrefix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LenientFormatter
    extends Formatter.Wrapper {
        LenientFormatter(@NotNull Formatter formatter) {
            if (formatter == null) {
                LenientFormatter.$$$reportNull$$$0(0);
            }
            super(formatter);
        }

        @Override
        public Object parse(String value2) {
            try {
                return super.parse(value2);
            }
            catch (ParseException parseException) {
                return value2;
            }
        }

        @Override
        public Object parse(String value2, ParsePosition position) {
            Object parsed = super.parse(value2, position);
            if (parsed == null || position.getErrorIndex() != -1) {
                position.setErrorIndex(-1);
                return value2;
            }
            return parsed;
        }

        @Override
        public String format(Object value2) {
            try {
                return super.format(value2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return value2 == null ? null : value2.toString();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$LenientFormatter", "<init>"));
        }
    }
}

