/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorTextField;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.xdebugger.memory.utils.KeyboardUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.ParsePosition;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatBasedGridCellEditor
extends GridCellEditor.Adapter
implements GridCellEditor.EditorBased {
    private final Formatter myFormat;
    private final GridCellEditorFactory.ValueParser myValueParser;
    protected final ModelIndex<DataConsumer.Column> myColumn;
    protected final ModelIndex<DataConsumer.Row> myRow;
    private final ReservedCellValue myNullValue;
    private final GridCellEditorTextField myTextField;
    private final DataGrid myGrid;

    public FormatBasedGridCellEditor(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull ModelIndex<DataConsumer.Row> row, @Nullable ReservedCellValue nullValue, @Nullable EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
        if (project == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(1);
        }
        if (format == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(2);
        }
        if (column2 == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(3);
        }
        if (row == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(4);
        }
        if (valueParser == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(5);
        }
        if (valueFormatter == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(6);
        }
        this.myFormat = format;
        this.myColumn = column2;
        this.myRow = row;
        this.myNullValue = nullValue;
        this.myGrid = grid;
        this.myValueParser = valueParser;
        this.myTextField = new GridCellEditorTextField(project, grid, (Language)PlainTextLanguage.INSTANCE, false, initiator, provider, true, column2, valueFormatter);
        this.myTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                String editorText;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FormatBasedGridCellEditor.this.fireEditing(StringUtil.isEmpty((String)(editorText = FormatBasedGridCellEditor.this.myTextField.getDocument().getText())) ? FormatBasedGridCellEditor.this.myNullValue : editorText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$1", "documentChanged"));
            }
        });
        if (nullValue != null) {
            this.myTextField.addSettingsProvider(editor -> {
                editor.setPlaceholder((CharSequence)this.myNullValue.getDisplayName());
                editor.setShowPlaceholderWhenFocused(true);
            });
        }
        Disposer.register((Disposable)this, (Disposable)this.myTextField);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(7);
        }
        return gridCellEditorTextField;
    }

    @Override
    @NotNull
    public final Object getValue() {
        Object object = this.myValueParser.parse(this.myTextField.getText(), this.myTextField.getDocument());
        if (object == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(8);
        }
        return object;
    }

    @Override
    public boolean stop() {
        MarkupModel markupModel;
        String text2 = this.myTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)text2) || FormatBasedGridCellEditorFactory.isNull(text2, this.myGrid, this.myColumn)) {
            return true;
        }
        ParsePosition pos = new ParsePosition(0);
        this.myFormat.parse(text2, pos);
        if (pos.getErrorIndex() == -1 || text2.isEmpty()) {
            return true;
        }
        Editor editor = this.myTextField.getEditor();
        MarkupModel markupModel2 = markupModel = editor != null ? editor.getMarkupModel() : null;
        if (markupModel != null) {
            markupModel.removeAllHighlighters();
            markupModel.addRangeHighlighter(DatabaseColors.GRID_ERROR_VALUE, 0, editor.getDocument().getTextLength(), 3000, HighlighterTargetArea.EXACT_RANGE);
        }
        return false;
    }

    @NotNull
    protected GridCellEditorTextField getTextField() {
        GridCellEditorTextField gridCellEditorTextField = this.myTextField;
        if (gridCellEditorTextField == null) {
            FormatBasedGridCellEditor.$$$reportNull$$$0(9);
        }
        return gridCellEditorTextField;
    }

    @Nullable
    protected ReservedCellValue getNullValue() {
        return this.myNullValue;
    }

    protected final DataGrid getGrid() {
        return this.myGrid;
    }

    protected final Formatter getFormat() {
        return this.myFormat;
    }

    @Override
    public Editor getEditor() {
        return this.myTextField.getEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFormatter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class WithBrowseButton<T extends JComponent, V>
    extends BoundedFormatBasedGridCellEditor<V>
    implements ActionListener {
        private final ComponentWithBrowseButton<GridCellEditorTextField> myComponent;
        private final GridCellEditorFactory myFactory;
        private final Class<V> myClazz;

        public WithBrowseButton(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, final EventObject initiator, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> columnModelIndex, @NotNull Class<V> clazz, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter, @NotNull GridCellEditorFactory factory) {
            if (project == null) {
                WithBrowseButton.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                WithBrowseButton.$$$reportNull$$$0(1);
            }
            if (format == null) {
                WithBrowseButton.$$$reportNull$$$0(2);
            }
            if (row == null) {
                WithBrowseButton.$$$reportNull$$$0(3);
            }
            if (columnModelIndex == null) {
                WithBrowseButton.$$$reportNull$$$0(4);
            }
            if (clazz == null) {
                WithBrowseButton.$$$reportNull$$$0(5);
            }
            if (valueParser == null) {
                WithBrowseButton.$$$reportNull$$$0(6);
            }
            if (valueFormatter == null) {
                WithBrowseButton.$$$reportNull$$$0(7);
            }
            if (factory == null) {
                WithBrowseButton.$$$reportNull$$$0(8);
            }
            super(project, grid, format, nullValue, initiator, row, columnModelIndex, provider, valueParser, valueFormatter);
            this.myClazz = clazz;
            this.myFactory = factory;
            this.myComponent = new ComponentWithBrowseButton<GridCellEditorTextField>(this.getTextField(), (ActionListener)this){

                public void addNotify() {
                    KeyEvent event;
                    int code;
                    super.addNotify();
                    if (initiator instanceof KeyEvent && !KeyboardUtils.isEnterKey((int)(code = (event = (KeyEvent)initiator).getKeyCode())) && code != 32) {
                        return;
                    }
                    DbUIUtil.invokeLater(() -> this.actionPerformed(null));
                }
            };
            this.myComponent.getButton().setBorder(UIManager.getBorder("Button.border"));
            this.myComponent.setRequestFocusEnabled(true);
            this.getTextField().addSettingsProvider(editor -> editor.getSelectionModel().removeSelection());
        }

        @NotNull
        public ComponentWithBrowseButton<GridCellEditorTextField> getComponent() {
            ComponentWithBrowseButton<GridCellEditorTextField> componentWithBrowseButton = this.myComponent;
            if (componentWithBrowseButton == null) {
                WithBrowseButton.$$$reportNull$$$0(9);
            }
            return componentWithBrowseButton;
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            JBPopup popup = this.createPopup();
            this.showPopup(popup);
        }

        @NotNull
        private JBPopup createPopup() {
            Pair<T, JComponent> components = this.getPopupComponents();
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)components.getFirst(), (JComponent)components.getSecond()).setModalContext(false).setFocusable(true).setCancelOnClickOutside(true).setRequestFocus(true).setResizable(false).createPopup();
            this.configurePopup(popup, (JComponent)components.getFirst());
            Disposer.register((Disposable)this, (Disposable)popup);
            JBPopup jBPopup = popup;
            if (jBPopup == null) {
                WithBrowseButton.$$$reportNull$$$0(10);
            }
            return jBPopup;
        }

        @Override
        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                WithBrowseButton.$$$reportNull$$$0(11);
            }
            Dimension size = popup.getContent().getPreferredSize();
            FixedSizeButton button = this.getComponent().getButton();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        @Override
        @Nullable
        protected V getInternalValue() {
            String text2 = this.getTextField().getText();
            return (V)ObjectUtils.tryCast((Object)this.getFormat().parse(text2, new ParsePosition(0)), this.myClazz);
        }

        @Override
        protected String getInfinityString(@NotNull V internalValue) {
            if (internalValue == null) {
                WithBrowseButton.$$$reportNull$$$0(12);
            }
            GridModel model = this.getGrid().getDataModel(DataAccessType.DATABASE_DATA);
            BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(DataGridUtil.getDbms(this.getGrid()), (DataConsumer.Column)model.getColumn(this.myColumn));
            return resolver.getInfinityString(internalValue);
        }

        @Override
        protected void beforeStopEditing(@NotNull V internalValue) {
            if (internalValue == null) {
                WithBrowseButton.$$$reportNull$$$0(13);
            }
            Object object = this.convertInternalValue(internalValue);
            this.getTextField().setText(this.myFactory.getValueFormatter(this.getGrid(), this.myRow, this.myColumn, object));
        }

        @Override
        protected boolean isSameValueInEditor(@NotNull V internalValue, @NotNull String boundaryString) {
            if (internalValue == null) {
                WithBrowseButton.$$$reportNull$$$0(14);
            }
            if (boundaryString == null) {
                WithBrowseButton.$$$reportNull$$$0(15);
            }
            return StringUtil.equalsIgnoreWhitespaces((CharSequence)boundaryString, (CharSequence)this.getTextField().getText());
        }

        @NotNull
        protected abstract Pair<T, JComponent> getPopupComponents();

        protected abstract void configurePopup(@NotNull JBPopup var1, @NotNull T var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnModelIndex";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalValue";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boundaryString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$WithBrowseButton";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "showPopup";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getInfinityString";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeStopEditing";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "isSameValueInEditor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static abstract class BoundedFormatBasedGridCellEditor<T>
    extends FormatBasedGridCellEditor {
        private boolean adjusting;

        public BoundedFormatBasedGridCellEditor(Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable ReservedCellValue nullValue, EventObject initiator, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> columnModelIndex, @Nullable TextCompletionProvider provider, @NotNull GridCellEditorFactory.ValueParser valueParser, @NotNull GridCellEditorFactory.ValueFormatter valueFormatter) {
            if (grid == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(0);
            }
            if (format == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(1);
            }
            if (row == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(2);
            }
            if (columnModelIndex == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(3);
            }
            if (valueParser == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(4);
            }
            if (valueFormatter == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(5);
            }
            super(project, grid, format, columnModelIndex, row, nullValue, initiator, provider, valueParser, valueFormatter);
        }

        @Override
        public boolean stop() {
            return super.stop() && this.checkInRange();
        }

        private boolean checkInRange() {
            if (this.adjusting || this.getTextField().getText().isEmpty()) {
                return true;
            }
            T value2 = this.getInternalValue();
            return value2 == null || !this.outOfRange(value2, null, null);
        }

        protected final void processDate(@NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(6);
            }
            if (this.outOfRange(internalValue, onAccept, onDecline)) {
                return;
            }
            this.acceptValue(internalValue, onAccept);
        }

        protected void showPopup(@NotNull JBPopup popup) {
            if (popup == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(7);
            }
            Dimension size = popup.getContent().getPreferredSize();
            JComponent button = this.getComponent();
            popup.show(new RelativePoint((Component)button, new Point(button.getWidth() - size.width, button.getHeight())));
        }

        private boolean outOfRange(@NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            String boundary;
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(8);
            }
            if ((boundary = this.getInfinityString(internalValue)) != null && !this.isSameValueInEditor(internalValue, boundary)) {
                this.onOutOfRange(boundary, internalValue, onAccept, onDecline);
                return true;
            }
            return false;
        }

        private void onOutOfRange(@NotNull String boundary, @NotNull T internalValue, @Nullable Runnable onAccept, @Nullable Runnable onDecline) {
            if (boundary == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(9);
            }
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(10);
            }
            this.showPopup((JBPopup)JBPopupFactory.getInstance().createConfirmation(DatabaseBundle.message((String)"popup.title.value.out.range.set", (Object[])new Object[]{boundary}), CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), () -> this.acceptValue(internalValue, onAccept), (Runnable)ObjectUtils.notNull((Object)onDecline, () -> {}), 1));
        }

        private void acceptValue(@NotNull T internalValue, @Nullable Runnable onAccept) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(11);
            }
            try {
                this.adjusting = true;
                this.beforeStopEditing(internalValue);
                if (onAccept != null) {
                    onAccept.run();
                }
                this.getGrid().stopEditing();
            }
            finally {
                this.adjusting = false;
            }
        }

        protected void beforeStopEditing(@NotNull T internalValue) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(12);
            }
        }

        @NotNull
        protected Object convertInternalValue(@NotNull T internalValue) {
            if (internalValue == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(13);
            }
            T t = internalValue;
            if (t == null) {
                BoundedFormatBasedGridCellEditor.$$$reportNull$$$0(14);
            }
            return t;
        }

        protected abstract boolean isSameValueInEditor(@NotNull T var1, @NotNull String var2);

        @Nullable
        protected abstract T getInternalValue();

        @Nullable
        protected abstract String getInfinityString(@NotNull T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnModelIndex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueParser";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueFormatter";
                    break;
                }
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "internalValue";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boundary";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditor$BoundedFormatBasedGridCellEditor";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertInternalValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processDate";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "showPopup";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "outOfRange";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "onOutOfRange";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptValue";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "beforeStopEditing";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "convertInternalValue";
                    break;
                }
                case 14: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

