/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridFormattersUtil {
    public static final LocalDate START_DATE = LocalDate.of(1970, 1, 1);
    private static final Logger LOG = Logger.getInstance(DataGridFormattersUtil.class);
    private static final double START_JULIAN_DATE = 2440587.5;
    private static final int MS_PER_DAY = 86400000;
    private static final DateTimeFormatter OFFSET_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss G ZZZ", Locale.US);
    private static final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd G", Locale.US);
    private static final DateTimeFormatter LOCAL_DATE_FORMATTER_WITH_MILLI = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss G SSS", Locale.US);
    private static final DateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G Z", Locale.US);
    private static final DateFormat TIMESTAMP_FORMATTER_WITH_MILLI = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G SSS", Locale.US);
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd G", Locale.US);
    private static final DateFormat SHORT_TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss G", Locale.US);
    private static final int DEFAULT_ERA = 1;

    private DataGridFormattersUtil() {
    }

    public static int getEra(@NotNull TemporalAccessor date) {
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(0);
        }
        return date.isSupported(ChronoField.ERA) ? date.get(ChronoField.ERA) : 1;
    }

    public static boolean useLenientFormatterForTemporalObjects(@NotNull DataGrid grid) {
        Dbms dbms;
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(1);
        }
        if ((dbms = DataGridUtil.getDbms(grid)) != Dbms.MYSQL) {
            return dbms.isSqlite();
        }
        DbDataSource system = DataGridUtil.getDatabaseSystem(grid);
        LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)system);
        return dataSource2 != null && dataSource2.getExactDriverVersion().isOrGreater(new int[]{8});
    }

    @NotNull
    public static java.util.Date getBoundedValue(@NotNull Object value2, @NotNull ModelIndex<DataConsumer.Column> column2, @NotNull DataGrid grid) {
        if (value2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(2);
        }
        if (column2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(3);
        }
        if (grid == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(4);
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        DataConsumer.Column gridColumn = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2);
        BoundaryValueResolver resolver = BoundaryValueResolver.getResolver(dbms, gridColumn);
        java.util.Date date = resolver.bound(value2);
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(5);
        }
        return date;
    }

    @NotNull
    public static OffsetTime convert(@NotNull TimeZonedTime time) {
        if (time == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(6);
        }
        OffsetTime offsetTime = (OffsetTime)time.getValue();
        if (offsetTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(7);
        }
        return offsetTime;
    }

    @NotNull
    public static ZoneOffset getDefaultOffset() {
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        if (zoneOffset == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(8);
        }
        return zoneOffset;
    }

    @NotNull
    public static ZoneOffset getLocalTimeOffset() {
        ZoneOffset zoneOffset = ZonedDateTime.of(LocalDateTime.of(1970, 1, 1, 0, 0, 1), ZoneId.systemDefault()).getOffset();
        if (zoneOffset == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(9);
        }
        return zoneOffset;
    }

    @NotNull
    public static java.util.Date getDateFrom(@Nullable Object o) {
        return o instanceof String ? DataGridFormattersUtil.parseDateFromNumber((String)o) : (o instanceof Double ? new java.util.Date(DataGridFormattersUtil.fromJulian((Double)o)) : (o instanceof Number ? new java.util.Date(((Number)o).longValue()) : (o instanceof java.util.Date ? (java.util.Date)o : DataGridFormattersUtil.getUtcDate())));
    }

    @NotNull
    public static OffsetDateTime fromTimestamp(@NotNull Timestamp timestamp) {
        OffsetDateTime offsetDateTime;
        if (timestamp == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(10);
        }
        TIMESTAMP_FORMATTER.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            offsetDateTime = OFFSET_DATE_TIME_FORMATTER.parse((CharSequence)TIMESTAMP_FORMATTER.format(timestamp), OffsetDateTime::from).withNano(timestamp.getNanos()).withOffsetSameInstant(DataGridFormattersUtil.getDefaultOffset());
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            OffsetDateTime offsetDateTime2 = timestamp.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(DataGridFormattersUtil.getDefaultOffset());
            if (offsetDateTime2 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(12);
            }
            return offsetDateTime2;
        }
        if (offsetDateTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(11);
        }
        return offsetDateTime;
    }

    @NotNull
    public static LocalDateTime fromDateToLocalDateTime(@NotNull java.util.Date date) {
        LocalDateTime localDateTime;
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(13);
        }
        TIMESTAMP_FORMATTER_WITH_MILLI.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            localDateTime = LOCAL_DATE_FORMATTER_WITH_MILLI.parse((CharSequence)TIMESTAMP_FORMATTER_WITH_MILLI.format(date), LocalDateTime::from);
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            LocalDateTime localDateTime2 = LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).atOffset(DataGridFormattersUtil.getDefaultOffset()).toLocalDateTime();
            if (localDateTime2 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(15);
            }
            return localDateTime2;
        }
        if (localDateTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(14);
        }
        return localDateTime;
    }

    @NotNull
    public static LocalDate fromDate(@NotNull java.util.Date date) {
        LocalDate localDate;
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(16);
        }
        DATE_FORMATTER.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            localDate = LOCAL_DATE_FORMATTER.parse((CharSequence)DATE_FORMATTER.format(date), LocalDate::from);
        }
        catch (DateTimeParseException e) {
            LOG.warn((Throwable)e);
            LocalDate localDate2 = date instanceof Date ? ((Date)date).toLocalDate() : LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).atOffset(DataGridFormattersUtil.getDefaultOffset()).toLocalDate();
            if (localDate2 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(18);
            }
            return localDate2;
        }
        if (localDate == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(17);
        }
        return localDate;
    }

    @NotNull
    public static Timestamp fromOffsetDateTime(@NotNull OffsetDateTime offsetDateTime) {
        Timestamp timestamp;
        if (offsetDateTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(19);
        }
        TIMESTAMP_FORMATTER.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            java.util.Date date = (java.util.Date)TIMESTAMP_FORMATTER.parseObject(OFFSET_DATE_TIME_FORMATTER.format(offsetDateTime));
            Timestamp timestamp2 = new Timestamp(date.getTime());
            timestamp2.setNanos(offsetDateTime.getNano());
            timestamp = timestamp2;
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            Timestamp timestamp3 = Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            if (timestamp3 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(21);
            }
            return timestamp3;
        }
        if (timestamp == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(20);
        }
        return timestamp;
    }

    @NotNull
    public static java.util.Date fromLocalDateTime(@NotNull LocalDateTime dateTime) {
        java.util.Date date;
        if (dateTime == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(22);
        }
        TIMESTAMP_FORMATTER_WITH_MILLI.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            date = (java.util.Date)TIMESTAMP_FORMATTER_WITH_MILLI.parseObject(LOCAL_DATE_FORMATTER_WITH_MILLI.format(dateTime));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            java.util.Date date2 = java.util.Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
            if (date2 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(24);
            }
            return date2;
        }
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(23);
        }
        return date;
    }

    @NotNull
    public static java.util.Date fromLocalDate(@NotNull LocalDate date) {
        java.util.Date date2;
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(25);
        }
        DATE_FORMATTER.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            date2 = (java.util.Date)DATE_FORMATTER.parseObject(LOCAL_DATE_FORMATTER.format(date));
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            java.util.Date date3 = java.util.Date.from(date.atStartOfDay().toInstant(ZoneOffset.UTC));
            if (date3 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(27);
            }
            return date3;
        }
        if (date2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(26);
        }
        return date2;
    }

    @NotNull
    public static TimeZone getDefaultTimeZone() {
        TimeZone timeZone = JdbcNativeUtil.UTC;
        if (timeZone == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(28);
        }
        return timeZone;
    }

    @NotNull
    private static java.util.Date parseDateFromNumber(@NotNull String s2) {
        if (s2 == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(29);
        }
        try {
            return new java.util.Date(Long.parseLong(s2));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new java.util.Date(DataGridFormattersUtil.fromJulian(Double.parseDouble(s2)));
            }
            catch (NumberFormatException numberFormatException2) {
                return new java.util.Date();
            }
        }
    }

    private static long fromJulian(double d2) {
        return (long)(d2 - 2440587.5) * 86400000L;
    }

    @NotNull
    private static java.util.Date getUtcDate() {
        java.util.Date date;
        java.util.Date currentDate = new java.util.Date();
        SHORT_TIMESTAMP_FORMATTER.setTimeZone(TimeZone.getDefault());
        String formattedInLocalTz = SHORT_TIMESTAMP_FORMATTER.format(currentDate);
        SHORT_TIMESTAMP_FORMATTER.setTimeZone(DataGridFormattersUtil.getDefaultTimeZone());
        try {
            date = SHORT_TIMESTAMP_FORMATTER.parse(formattedInLocalTz);
        }
        catch (ParseException e) {
            LOG.warn((Throwable)e);
            java.util.Date date2 = currentDate;
            if (date2 == null) {
                DataGridFormattersUtil.$$$reportNull$$$0(31);
            }
            return date2;
        }
        if (date == null) {
            DataGridFormattersUtil.$$$reportNull$$$0(30);
        }
        return date;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetDateTime";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateTime";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/DataGridFormattersUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundedValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOffset";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTimeOffset";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTimestamp";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDateToLocalDateTime";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromOffsetDateTime";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLocalDateTime";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fromLocalDate";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTimeZone";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtcDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEra";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "useLenientFormatterForTemporalObjects";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBoundedValue";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fromTimestamp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromDateToLocalDateTime";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fromDate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fromOffsetDateTime";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fromLocalDateTime";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fromLocalDate";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseDateFromNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

