/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridMainPanel
extends JBLoadingPanel
implements EditorColorsListener {
    private final DataGrid myGrid;
    private final OnePixelSplitter myHorizontalSplitter;
    private final OnePixelSplitter myVerticalSplitter;

    public GridMainPanel(@NotNull DataGrid grid) {
        if (grid == null) {
            GridMainPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout(), (Disposable)grid);
        this.myGrid = grid;
        this.myVerticalSplitter = new OnePixelSplitter(true, 0.7f);
        this.add((Component)this.myVerticalSplitter, "Center");
        this.myHorizontalSplitter = new OnePixelSplitter(false, 0.7f);
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myHorizontalSplitter);
    }

    public Color getBackground() {
        return (Color)ObjectUtils.chooseNotNull(this.myGrid != null ? this.myGrid.getColorsScheme().getDefaultBackground() : null, (Object)UIUtil.getTableBackground());
    }

    public void remove(@NotNull Component comp) {
        if (comp == null) {
            GridMainPanel.$$$reportNull$$$0(1);
        }
        this.getContentPanel().remove(comp);
    }

    @Nullable
    public Component getTopComponent() {
        return this.getComponentAt("North");
    }

    public void setCenterComponent(@NotNull JComponent component) {
        if (component == null) {
            GridMainPanel.$$$reportNull$$$0(2);
        }
        this.myHorizontalSplitter.setFirstComponent(component);
    }

    public void setTopComponent(@Nullable Component topComponent) {
        this.replaceComponentAt("North", topComponent);
    }

    public void setBottomComponent(@Nullable Component bottomComponent) {
        this.replaceComponentAt("South", bottomComponent);
    }

    public void setBottomView(@Nullable JComponent bottomComponent) {
        this.myVerticalSplitter.setSecondComponent(bottomComponent);
    }

    @Nullable
    public JComponent getBottomView() {
        return this.myVerticalSplitter.getSecondComponent();
    }

    @Nullable
    public JComponent getRightView() {
        return this.myHorizontalSplitter.getSecondComponent();
    }

    public void setRightView(@Nullable JComponent component) {
        this.myHorizontalSplitter.setSecondComponent(component);
    }

    private void replaceComponentAt(@NotNull String location, @Nullable Component with) {
        Component toReplace;
        if (location == null) {
            GridMainPanel.$$$reportNull$$$0(3);
        }
        if ((toReplace = this.getComponentAt(location)) != null) {
            this.remove(toReplace);
        }
        if (with != null) {
            this.add(with, location);
        }
        this.getContentPanel().revalidate();
        this.repaint();
    }

    @Nullable
    private Component getComponentAt(@NotNull String location) {
        if (location == null) {
            GridMainPanel.$$$reportNull$$$0(4);
        }
        return this.getContentLayout().getLayoutComponent(location);
    }

    @NotNull
    private BorderLayout getContentLayout() {
        BorderLayout borderLayout = (BorderLayout)this.getContentPanel().getLayout();
        if (borderLayout == null) {
            GridMainPanel.$$$reportNull$$$0(5);
        }
        return borderLayout;
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.myGrid.getColorsScheme().setDelegate(scheme);
    }

    public void removeComponent(JComponent component) {
        if (this.myHorizontalSplitter.getSecondComponent() == component) {
            this.myHorizontalSplitter.setSecondComponent(null);
        } else if (this.myVerticalSplitter.getSecondComponent() == component) {
            this.myVerticalSplitter.setSecondComponent(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridMainPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCenterComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceComponentAt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAt";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

