/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterPanel
extends EditorHeaderComponent
implements EditorColorsListener,
DataProvider {
    private final Project myProject;
    private final DataGrid myGrid;
    private final EditorEx myEditor;
    private JBPopup myFilterHistoryPopup;

    public GridFilterPanel(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            GridFilterPanel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridFilterPanel.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myGrid = grid;
        final GridFilteringModel filteringModel = this.myGrid.getDataHookup().getFilteringModel();
        Document document = filteringModel != null ? filteringModel.getFilterDocument() : EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = this.createEditor(document);
        Disposer.register((Disposable)this.myGrid, () -> EditorFactory.getInstance().releaseEditor((Editor)this.myEditor));
        GridDataHookUp hookUp = this.myGrid.getDataHookup();
        if (filteringModel != null) {
            filteringModel.addListener(() -> {
                DbDataSource dataSource2 = hookUp instanceof DataBusGridDataHookUp ? ((DataBusGridDataHookUp)hookUp).getDataSource() : null;
                SqlLanguageDialect filterLanguage = dataSource2 != null ? DbSqlUtil.getSqlDialect((DbElement)dataSource2) : GridHelper.get(DataGridUtil.getDbms(this.myGrid)).getFilterLanguage();
                SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)filterLanguage, (Project)this.myProject, null);
                LexerEditorHighlighter lexerHighlighter = new LexerEditorHighlighter(highlighter, (EditorColorsScheme)this.myGrid.getColorsScheme());
                this.myEditor.setHighlighter((EditorHighlighter)lexerHighlighter);
            }, this.myGrid);
        }
        if (hookUp instanceof DataBusGridDataHookUp) {
            ((DataBusGridDataHookUp)hookUp).getLoader().updateQueryText();
        }
        JBLabel filterHistoryLabel = new JBLabel(AllIcons.Actions.SearchWithHistory);
        filterHistoryLabel.setOpaque(false);
        filterHistoryLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridFilterPanel.this.showFilterHistoryPopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$1", "mousePressed"));
            }
        });
        final JBLabel clearFieldLabel = new JBLabel(StartupUiUtil.isUnderDarcula() ? AllIcons.Actions.CloseHovered : AllIcons.Actions.Close);
        clearFieldLabel.setOpaque(false);
        clearFieldLabel.setVisible(document.getTextLength() != 0);
        clearFieldLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                boolean wasApplied = filteringModel != null && !StringUtil.isEmpty((String)filteringModel.getAppliedText());
                GridFilterPanel.this.setFilterText("", -1);
                if (wasApplied) {
                    GridFilterPanel.this.myGrid.applyFilter();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$2", "mouseReleased"));
            }
        });
        this.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                clearFieldLabel.setVisible(event.getDocument().getTextLength() != 0);
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                if (document == null) {
                    3.$$$reportNull$$$0(1);
                }
                clearFieldLabel.setVisible(document.getTextLength() != 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridFilterPanel$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "bulkUpdateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myGrid);
        this.setLayout(new BorderLayout());
        this.add((Component)clearFieldLabel, "East");
        this.add((Component)filterHistoryLabel, "West");
        this.add(this.myEditor.getComponent(), "Center");
        this.setBorder(new CompoundBorder((Border)new CustomLineBorder(JBColor.border(), 0, 0, 1, 0), (Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6)));
    }

    protected Graphics getComponentGraphics(Graphics g) {
        return IdeBackgroundUtil.withEditorBackground((Graphics)g, (JComponent)((Object)this));
    }

    public Color getBackground() {
        return this.myEditor == null ? super.getBackground() : this.myEditor.getBackgroundColor();
    }

    public void setFilterText(String filter2, int caretPosition) {
        GridFilteringModel model = this.myGrid.getDataHookup().getFilteringModel();
        if (model == null) {
            return;
        }
        model.setFilterText(filter2);
        if (caretPosition < 0) {
            return;
        }
        this.requestFocusInWindow();
        this.myEditor.getCaretModel().moveToOffset(caretPosition);
    }

    @NotNull
    public String getFilterText() {
        GridFilteringModel model = this.myGrid.getDataHookup().getFilteringModel();
        String string = model == null ? "" : model.getFilterText();
        if (string == null) {
            GridFilterPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void onError(@NotNull Throwable error2) {
        if (error2 == null) {
            GridFilterPanel.$$$reportNull$$$0(3);
        }
        JComponent component = this.myEditor.getContentComponent();
        DataSourceUiUtil.showErrorBalloon(error2, component, GridFilterPanel.getFilterEditorCaretPoint(this.myEditor), true, false);
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getComponent(), true));
    }

    public boolean requestFocusInWindow() {
        boolean b2 = this.myEditor.getContentComponent().requestFocusInWindow();
        if (!this.myEditor.isDisposed()) {
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        return b2;
    }

    private void showFilterHistoryPopup() {
        GridFilteringModel model;
        if (this.myFilterHistoryPopup != null) {
            this.myFilterHistoryPopup.cancel();
            this.myFilterHistoryPopup = null;
        }
        if ((model = this.myGrid.getDataHookup().getFilteringModel()) == null) {
            return;
        }
        JBList history = new JBList((Collection)ContainerUtil.filter(model.getHistory(), value2 -> !value2.isEmpty()));
        Runnable itemChosenCallback = () -> this.lambda$showFilterHistoryPopup$5((JList)history);
        this.myFilterHistoryPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)history).setMovable(false).setRequestFocus(true).setItemChoosenCallback(itemChosenCallback).createPopup();
        this.myFilterHistoryPopup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                GridFilterPanel.this.myFilterHistoryPopup = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridFilterPanel$4", "onClosed"));
            }
        });
        if (this.myGrid.getComponent().isShowing()) {
            this.myFilterHistoryPopup.showUnderneathOf((Component)((Object)this));
        }
    }

    @NotNull
    private static Point getFilterEditorCaretPoint(@NotNull EditorEx editor) {
        if (editor == null) {
            GridFilterPanel.$$$reportNull$$$0(4);
        }
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        Point point = editor.visualPositionToXY(caretPosition);
        point.translate(0, editor.getContentComponent().getHeight());
        Point point2 = point;
        if (point2 == null) {
            GridFilterPanel.$$$reportNull$$$0(5);
        }
        return point2;
    }

    @NotNull
    private EditorEx createEditor(@NotNull Document document) {
        if (document == null) {
            GridFilterPanel.$$$reportNull$$$0(6);
        }
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject);
        editor.putUserData(EditorTextField.SUPPLEMENTARY_KEY, (Object)true);
        editor.setOneLineMode(true);
        editor.getSettings().setCaretRowShown(false);
        editor.getSettings().setShowIntentionBulb(false);
        EditorTextField.setupTextFieldEditor((EditorEx)editor);
        editor.getComponent().setFocusable(false);
        editor.setPlaceholder((CharSequence)DatabaseBundle.message((String)"DataView.filter.placeholder", (Object[])new Object[0]));
        editor.getComponent().setOpaque(false);
        editor.getComponent().setBorder((Border)JBUI.Borders.empty((int)0, (int)7));
        editor.setEmbeddedIntoDialogWrapper(true);
        editor.getContentComponent().setOpaque(false);
        JComponent editorComp = editor.getComponent();
        new ApplyAction().registerCustomShortcutSet(CommonShortcuts.ENTER, editorComp);
        new CancelAction().registerCustomShortcutSet(CommonShortcuts.ESCAPE, editorComp);
        new ShowHistoryAction().registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 512)), editorComp);
        GridFilterPanel.setScheme(editor, (EditorColorsScheme)this.myGrid.getColorsScheme());
        EditorEx editorEx = editor;
        if (editorEx == null) {
            GridFilterPanel.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    private static void setScheme(@NotNull EditorEx editor, @NotNull EditorColorsScheme scheme) {
        if (editor == null) {
            GridFilterPanel.$$$reportNull$$$0(8);
        }
        if (scheme == null) {
            GridFilterPanel.$$$reportNull$$$0(9);
        }
        editor.setColorsScheme(scheme);
        editor.setBackgroundColor(editor.getBackgroundColor());
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        GridFilterPanel.setScheme(this.myEditor, (EditorColorsScheme)this.myGrid.getColorsScheme());
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            GridFilterPanel.$$$reportNull$$$0(10);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return TextEditorProvider.getInstance().getTextEditor((Editor)this.myEditor);
        }
        return null;
    }

    private /* synthetic */ void lambda$showFilterHistoryPopup$5(JList history) {
        String selectedFilter = (String)history.getSelectedValue();
        if (selectedFilter != null) {
            WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
                DocumentEx document = this.myEditor.getDocument();
                document.replaceString(0, document.getTextLength(), (CharSequence)selectedFilter);
                CaretModel caretModel = this.myEditor.getCaretModel();
                if (caretModel.getOffset() >= document.getTextLength()) {
                    caretModel.moveToOffset(document.getTextLength());
                }
            });
            this.myGrid.applyFilter();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridFilterPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridFilterPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterEditorCaretPoint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilterEditorCaretPoint";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ShowHistoryAction
    extends FilterFieldAction {
        ShowHistoryAction() {
            super(DatabaseBundle.message((String)"action.ShowHistoryAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            GridFilterPanel filterPanel;
            if (e == null) {
                ShowHistoryAction.$$$reportNull$$$0(0);
            }
            GridFilterPanel gridFilterPanel = filterPanel = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridFilterPanel)((Object)ObjectUtils.tryCast((Object)((Object)grid.getFilterPanel()), GridFilterPanel.class));
            if (filterPanel != null) {
                filterPanel.showFilterHistoryPopup();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$ShowHistoryAction", "actionPerformed"));
        }
    }

    private static class CancelAction
    extends FilterFieldAction {
        CancelAction() {
            super(DatabaseBundle.message((String)"action.CancelAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            GridFilterPanel filterPanel;
            if (e == null) {
                CancelAction.$$$reportNull$$$0(0);
            }
            GridFilterPanel gridFilterPanel = filterPanel = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridFilterPanel)((Object)ObjectUtils.tryCast((Object)((Object)grid.getFilterPanel()), GridFilterPanel.class));
            if (filterPanel == null) {
                return;
            }
            IdeFocusManager.findInstanceByComponent((Component)((Object)filterPanel.myGrid.getComponent())).requestFocus((Component)filterPanel.myGrid.getPreferredFocusedComponent(), true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$CancelAction", "actionPerformed"));
        }
    }

    public static class ApplyAction
    extends FilterFieldAction {
        public ApplyAction() {
            super(DatabaseBundle.message((String)"action.ApplyAction.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            GridFilterPanel filterPanel;
            if (e == null) {
                ApplyAction.$$$reportNull$$$0(0);
            }
            GridFilterPanel gridFilterPanel = filterPanel = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridFilterPanel)((Object)ObjectUtils.tryCast((Object)((Object)grid.getFilterPanel()), GridFilterPanel.class));
            if (filterPanel == null) {
                return;
            }
            if (ApplyAction.isValidFilterEntered(filterPanel, e.getProject())) {
                grid.applyFilter();
            } else {
                ApplyAction.showInvalidFilterCriteriaBalloon(filterPanel);
            }
        }

        private static boolean isValidFilterEntered(GridFilterPanel filterPanel, Project project) {
            DocumentEx document = filterPanel.myEditor.getDocument();
            String filter2 = document.getText();
            if (StringUtil.isEmptyOrSpaces((String)filter2) || filter2.startsWith("--") || filter2.startsWith("#") || filter2.startsWith("//") || filter2.startsWith("/*")) {
                return true;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)document);
            return psi == null || psi.getLanguage().getID().equals("GenericSQL") || !PsiTreeUtil.hasErrorElements((PsiElement)psi);
        }

        private static void showInvalidFilterCriteriaBalloon(GridFilterPanel filterPanel) {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"popup.content.invalid.filter.criteria", (Object[])new Object[0]), MessageType.WARNING, null).setShowCallout(true).setHideOnAction(true).setHideOnClickOutside(true).createBalloon();
            Point point = GridFilterPanel.getFilterEditorCaretPoint(filterPanel.myEditor);
            balloon.show(new RelativePoint((Component)filterPanel.myEditor.getComponent(), point), Balloon.Position.below);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$ApplyAction", "actionPerformed"));
        }
    }

    private static abstract class FilterFieldAction
    extends DumbAwareAction {
        FilterFieldAction(@Nullable @NlsActions.ActionText String text2) {
            super(text2);
        }

        public void update(@NotNull AnActionEvent e) {
            DataGrid grid;
            GridFilterPanel filterPanel;
            if (e == null) {
                FilterFieldAction.$$$reportNull$$$0(0);
            }
            GridFilterPanel gridFilterPanel = filterPanel = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : (GridFilterPanel)((Object)ObjectUtils.tryCast((Object)((Object)grid.getFilterPanel()), GridFilterPanel.class));
            if (filterPanel == null) {
                return;
            }
            e.getPresentation().setEnabled(LookupManager.getActiveLookup((Editor)filterPanel.myEditor) == null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/grid/GridFilterPanel$FilterFieldAction", "update"));
        }
    }
}

