/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridColumnLayout;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class DefaultGridColumnLayout
implements GridColumnLayout<DataConsumer.Row, DataConsumer.Column> {
    private static final Key<Integer> MAX_CELL_WIDTH_KEY = new Key("MaxCellWidth");
    private static final double GOLD = 0.5 * (3.0 - Math.sqrt(5.0));
    private static final int ADDITIONAL_COLUMN_WIDTH = 8;
    private static final int MIN_COLUMN_WIDTH = 40;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION = 100;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION_LOTS_OF_COLUMNS = 5;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION = 10000;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION_LOTS_OF_COLUMNS = 10;
    private static final int FIRST_ROWS_FOR_SIZE_CALCULATION_TRANSPOSED = 10;
    private static final int MAX_ROW_IDX_FOR_SIZE_CALCULATION_TRANSPOSED = 10;
    private final TableResultView myResultView;
    private final DataGrid myGrid;
    private boolean myTransposed;
    private boolean myInvalidateWidestCellValues;

    public DefaultGridColumnLayout(@NotNull TableResultView resultView, @NotNull DataGrid grid) {
        if (resultView == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(1);
        }
        this.myResultView = resultView;
        this.myGrid = grid;
    }

    @Override
    public boolean resetLayout() {
        return this.doLayout((this.myTransposed ? this.myGrid.getVisibleRows() : this.myGrid.getVisibleColumns()).asList());
    }

    @Override
    public void newColumnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        this.updateWidestCellValueCaches(this.myGrid.getVisibleRows(), columnIndices);
    }

    @Override
    public void newRowsAdded(ModelIndexSet<DataConsumer.Row> rowIndices) {
        this.updateWidestCellValueCaches(rowIndices, this.myGrid.getVisibleColumns());
    }

    @Override
    public void columnsShown(ModelIndexSet<?> columnDataIndices) {
        this.doLayout(columnDataIndices.asList());
    }

    @Override
    public void setTransposed(boolean transposed) {
        if (transposed != this.myTransposed) {
            this.myInvalidateWidestCellValues = true;
        }
        this.myTransposed = transposed;
    }

    private boolean doLayout(List<? extends ModelIndex<?>> columnDataIndices) {
        class LayoutInfo {
            int min;
            int preferred;
            int full;

            LayoutInfo() {
            }
        }
        LayoutInfo layoutInfo;
        int availableWidth;
        if (this.myInvalidateWidestCellValues) {
            this.updateWidestCellValueCaches(this.myGrid.getVisibleRows(), this.myGrid.getVisibleColumns());
        }
        int allColumnsPreferredWidth = 0;
        int extraWidth = 0;
        int allColumnsFullWidth = 0;
        HashMap<GridColumn, LayoutInfo> columnWidths = new HashMap<GridColumn, LayoutInfo>();
        HashSet columnsToResize = new HashSet(columnDataIndices);
        List visibleColumnDataIndices = (this.myTransposed ? this.myGrid.getVisibleRows() : this.myGrid.getVisibleColumns()).asList();
        GridMainPanel gridPanel = this.myGrid.getComponent();
        JScrollPane scrollPane = (JScrollPane)UIUtil.findComponentOfType((JComponent)((Object)gridPanel), JScrollPane.class);
        int n = availableWidth = scrollPane != null ? scrollPane.getViewportBorderBounds().width : ((JComponent)((Object)gridPanel)).getWidth();
        if (availableWidth == 0) {
            return false;
        }
        for (ModelIndex columnDataIdx : visibleColumnDataIndices) {
            GridColumn column2 = this.myResultView.getLayoutColumn(columnDataIdx);
            if (column2 == null) continue;
            if (columnsToResize.contains(columnDataIdx)) {
                layoutInfo = new LayoutInfo();
                layoutInfo.min = Math.max(40, DefaultGridColumnLayout.computeHeaderWidth(column2));
                layoutInfo.full = Math.max(layoutInfo.min, DefaultGridColumnLayout.computeColumnWidth(column2));
                layoutInfo.preferred = Math.min(layoutInfo.full, (int)((double)availableWidth * GOLD));
                columnWidths.put(column2, layoutInfo);
                allColumnsPreferredWidth += layoutInfo.preferred;
                extraWidth += layoutInfo.min == layoutInfo.full ? layoutInfo.preferred : 0;
                allColumnsFullWidth += layoutInfo.full;
                continue;
            }
            int currentWidth = column2.getColumnWidth();
            allColumnsPreferredWidth += currentWidth;
            extraWidth += currentWidth;
            allColumnsFullWidth += currentWidth;
        }
        if (columnDataIndices.size() == 1 && visibleColumnDataIndices.size() > 1) {
            GridColumn insertedColumn;
            ModelIndex<?> insertedIdx = columnDataIndices.get(0);
            boolean insertedIdxIsValid = this.myTransposed && this.myGrid.isInsertedRow(DefaultGridColumnLayout.cast(insertedIdx));
            GridColumn gridColumn = insertedColumn = insertedIdxIsValid ? this.myResultView.getLayoutColumn(insertedIdx) : null;
            if (insertedColumn != null) {
                layoutInfo = (LayoutInfo)columnWidths.get(insertedColumn);
                int averageColumnWidth = (allColumnsPreferredWidth - layoutInfo.preferred) / (visibleColumnDataIndices.size() - 1);
                if (averageColumnWidth > layoutInfo.preferred) {
                    extraWidth -= layoutInfo.preferred;
                    allColumnsPreferredWidth -= layoutInfo.preferred;
                    allColumnsFullWidth -= layoutInfo.full;
                    layoutInfo.min = Math.min(averageColumnWidth, layoutInfo.min);
                    layoutInfo.preferred = averageColumnWidth;
                    layoutInfo.full = averageColumnWidth;
                    extraWidth += layoutInfo.preferred;
                    allColumnsPreferredWidth += layoutInfo.preferred;
                    allColumnsFullWidth += layoutInfo.full;
                }
            }
        }
        int requiredWidth = availableWidth >= allColumnsFullWidth ? allColumnsFullWidth : Math.max(availableWidth, allColumnsPreferredWidth);
        int requiredPlusExtra = requiredWidth + extraWidth;
        int widthToDistribute = visibleColumnDataIndices.isEmpty() || availableWidth <= requiredWidth ? 0 : (int)(((double)requiredPlusExtra < GOLD * (double)availableWidth ? GOLD * (double)availableWidth : ((double)requiredPlusExtra < (1.0 - GOLD) * (double)availableWidth ? (1.0 - GOLD) * (double)availableWidth : (double)availableWidth)) - (double)allColumnsPreferredWidth);
        for (GridColumn column3 : columnWidths.keySet()) {
            LayoutInfo layoutInfo2 = (LayoutInfo)columnWidths.get(column3);
            int expandedWidth = layoutInfo2.preferred + (int)((double)(widthToDistribute * layoutInfo2.full) / (double)allColumnsFullWidth);
            column3.setColumnWidth(Math.min(availableWidth, Math.min(expandedWidth, (int)((double)layoutInfo2.full * 1.2))));
        }
        return true;
    }

    private static int computeColumnWidth(GridColumn column2) {
        return (Integer)ObjectUtils.notNull((Object)((Integer)column2.getUserData(MAX_CELL_WIDTH_KEY)), (Object)0) + 8;
    }

    private static int computeHeaderWidth(GridColumn column2) {
        return column2.getPreferredHeaderWidth() + 8;
    }

    private void updateWidestCellValueCaches(ModelIndexSet<DataConsumer.Row> rowIndices, ModelIndexSet<DataConsumer.Column> columnIndices) {
        JBIterable viewRowIndices = (this.myTransposed ? columnIndices : rowIndices).toView(this.myGrid).asIterable();
        JBIterable columnDataIndices = (this.myTransposed ? rowIndices : columnIndices).asIterable();
        ArrayList<ModelIndex> toLayOut = new ArrayList<ModelIndex>();
        int columnNum = 0;
        for (ModelIndex columnDataIdx : columnDataIndices) {
            ViewIndex viewColumnIdx;
            GridColumn layoutColumn = this.myResultView.getLayoutColumn(columnDataIdx, viewColumnIdx = columnDataIdx.toView(this.myGrid));
            if (layoutColumn == null) continue;
            Integer cachedMaxCellWidth = this.myInvalidateWidestCellValues ? null : (Integer)layoutColumn.getUserData(MAX_CELL_WIDTH_KEY);
            int maxCellWidth = this.getMaximumPreferredWidth(viewRowIndices, viewColumnIdx, columnNum++);
            if (!this.myInvalidateWidestCellValues && cachedMaxCellWidth == null) {
                toLayOut.add(columnDataIdx);
            }
            if (cachedMaxCellWidth != null && maxCellWidth <= cachedMaxCellWidth) continue;
            layoutColumn.putUserData(MAX_CELL_WIDTH_KEY, maxCellWidth > 0 ? Integer.valueOf(maxCellWidth) : null);
        }
        this.myInvalidateWidestCellValues = false;
        if (!toLayOut.isEmpty()) {
            this.doLayout(toLayOut);
        }
    }

    private int getMaximumPreferredWidth(JBIterable<? extends ViewIndex<?>> viewRowIndices, ViewIndex<?> viewColumnIdx, int columnNum) {
        ViewIndex viewRowIdx;
        int rowIdxInt;
        int maxRowForSizeCalc;
        int widestCell = 0;
        int n = columnNum > 100 ? 10 : (maxRowForSizeCalc = this.myTransposed ? 10 : 10000);
        int firstRowsForSizeCalc = columnNum > 100 ? 5 : (this.myTransposed ? 10 : 100);
        Iterator iterator = viewRowIndices.iterator();
        while (iterator.hasNext() && (rowIdxInt = (viewRowIdx = (ViewIndex)iterator.next()).toModel(this.myGrid).asInteger()) <= maxRowForSizeCalc) {
            ViewIndex<DataConsumer.Column> columnIdx;
            ViewIndex<DataConsumer.Row> rowIdx;
            JComponent component;
            if (rowIdxInt > firstRowsForSizeCalc && rowIdxInt % firstRowsForSizeCalc != 0 || (component = this.myResultView.getCellRendererComponent(rowIdx = this.myTransposed ? DefaultGridColumnLayout.cast(viewColumnIdx) : DefaultGridColumnLayout.cast(viewRowIdx), columnIdx = this.myTransposed ? DefaultGridColumnLayout.cast(viewRowIdx) : DefaultGridColumnLayout.cast(viewColumnIdx), false)) == null) continue;
            widestCell = Math.max(widestCell, component.getPreferredSize().width);
        }
        return widestCell;
    }

    @NotNull
    private static <T> ViewIndex<T> cast(@NotNull ViewIndex<?> idx) {
        if (idx == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(2);
        }
        ViewIndex<?> viewIndex = idx;
        if (viewIndex == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(3);
        }
        return viewIndex;
    }

    @NotNull
    private static <T> ModelIndex<T> cast(@NotNull ModelIndex<?> idx) {
        if (idx == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(4);
        }
        ModelIndex<?> modelIndex = idx;
        if (modelIndex == null) {
            DefaultGridColumnLayout.$$$reportNull$$$0(5);
        }
        return modelIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/DefaultGridColumnLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/DefaultGridColumnLayout";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

