/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ImageCellViewer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/run/ui/ImageCellViewer;", "Lcom/intellij/database/run/ui/CellViewer;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "alarm", "Lcom/intellij/util/Alarm;", "Lorg/jetbrains/annotations/NotNull;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "panel", "Ljavax/swing/JPanel;", "preferedFocusComponent", "getPreferedFocusComponent", "clearContent", "", "dispose", "showImage", "image", "Ljava/awt/image/BufferedImage;", "update", "info", "Lcom/intellij/database/extractors/ObjectFormatter$ImageInfo;", "editedValue", "", "intellij.database.impl"})
public final class ImageCellViewer
implements CellViewer {
    private final JPanel panel;
    private final Alarm alarm;
    @NotNull
    private final JComponent component;
    @Nullable
    private final JComponent preferedFocusComponent;
    private final DataGrid grid;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @Nullable
    public JComponent getPreferedFocusComponent() {
        return this.preferedFocusComponent;
    }

    @Override
    public void update() {
        ObjectFormatter.ImageInfo info;
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex rowIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex columnIdx = modelIndex2;
        if (!rowIdx.isValid(this.grid) || !columnIdx.isValid(this.grid)) {
            this.clearContent();
            return;
        }
        Object object = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(rowIdx, columnIdx);
        if (!(object instanceof ObjectFormatter.ImageInfo)) {
            object = null;
        }
        if ((info = (ObjectFormatter.ImageInfo)object) == null) {
            this.clearContent();
        } else {
            this.update(info);
        }
    }

    private final void clearContent() {
        LayoutManager layoutManager = this.panel.getLayout();
        if (layoutManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.BorderLayout");
        }
        Component prev = ((BorderLayout)layoutManager).getLayoutComponent("Center");
        if (prev != null) {
            this.panel.remove(prev);
            if (prev instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)prev));
            }
        }
    }

    private final void showImage(BufferedImage image) {
        this.clearContent();
        ImageEditorUI imageEditorUI = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
        Intrinsics.checkNotNullExpressionValue((Object)imageEditorUI, (String)"ImageEditorManagerImpl.createImageEditorUI(image)");
        JComponent ui = (JComponent)imageEditorUI;
        if (ui instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)ui));
        }
        this.panel.add((Component)ui, "Center");
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Override
    public void update(@Nullable Object editedValue) {
        if (editedValue instanceof ObjectFormatter.ImageInfo) {
            this.update((ObjectFormatter.ImageInfo)editedValue);
        } else {
            this.clearContent();
        }
    }

    private final void update(ObjectFormatter.ImageInfo info) {
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(new Runnable(this, info){
            final /* synthetic */ ImageCellViewer this$0;
            final /* synthetic */ ObjectFormatter.ImageInfo $info;

            public final void run() {
                BufferedImage bufferedImage = this.$info.createImage();
                if (bufferedImage == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"info.createImage() ?: return@addRequest");
                BufferedImage image = bufferedImage;
                ApplicationManager.getApplication().invokeLater(new Runnable(this, image){
                    final /* synthetic */ update.1 this$0;
                    final /* synthetic */ BufferedImage $image;

                    public final void run() {
                        if (!Disposer.isDisposed((Disposable)this.this$0.this$0)) {
                            ImageCellViewer.access$showImage(this.this$0.this$0, this.$image);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$image = bufferedImage;
                    }
                });
            }
            {
                this.this$0 = imageCellViewer;
                this.$info = imageInfo;
            }
        }, 0);
    }

    public void dispose() {
    }

    public ImageCellViewer(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.panel = new JPanel(new BorderLayout());
        Alarm alarm2 = AlarmFactory.getInstance().create(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)alarm2, (String)"AlarmFactory.getInstance\u2026oUse.POOLED_THREAD, this)");
        this.alarm = alarm2;
        this.component = this.panel;
    }

    public static final /* synthetic */ void access$showImage(ImageCellViewer $this, BufferedImage image) {
        $this.showImage(image);
    }
}

