/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GridEditGuard {
    READ_ONLY_PREVIEW{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                1.$$$reportNull$$$0(0);
            }
            DatabaseGridDataHookUp up = DataGridUtil.getDatabaseHookUp(grid);
            return up instanceof GridDataHookUpManager.ReadOnlyDatabaseGridDataHookUp;
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                1.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                1.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                1.$$$reportNull$$$0(3);
            }
            String string = GridEditGuard.defaultMessage();
            if (string == null) {
                1.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    WRONG_KIND{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                2.$$$reportNull$$$0(0);
            }
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            Dbms dbms = DataGridUtil.getDbms(grid);
            return table != null && !DbImplUtil.isEditableTable(dbms, table.getKind());
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                2.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                2.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                2.$$$reportNull$$$0(3);
            }
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            Dbms dbms = DataGridUtil.getDbms(grid);
            ObjectKind kind = table.getKind();
            String string = DatabaseBundle.message((String)"hint.text.can.t.edit", (Object[])new Object[]{DbPresentation.getPresentableName(kind, dbms)});
            if (string == null) {
                2.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$2";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    READ_ONLY_CONNECTION{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            DbDataSource system;
            if (grid == null) {
                3.$$$reportNull$$$0(0);
            }
            return (system = DataGridUtil.getDatabaseSystem(grid)) != null && !system.isWritable();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                3.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                3.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                3.$$$reportNull$$$0(3);
            }
            String string = DatabaseBundle.message((String)"hint.text.connection.read.only", (Object[])new Object[0]);
            if (string == null) {
                3.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$3";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    MISSING_IDENTIFIER{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                4.$$$reportNull$$$0(0);
            }
            return !DataGridUtil.canBuildWhereClause(grid);
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                4.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message((String)"hint.text.missing.row.identifier", (Object[])new Object[0]);
            if (string == null) {
                4.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$4";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$4";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    UNRESOLVED_TABLE{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                5.$$$reportNull$$$0(0);
            }
            return DataGridUtil.getDatabaseHookUp(grid) != null && DataGridUtil.getDatabaseTable(grid) == null;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                5.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message((String)"hint.text.unresolved.table.reference", (Object[])new Object[0]);
            if (string == null) {
                5.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$5";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$5";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    MODAL_IMPORT{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                6.$$$reportNull$$$0(0);
            }
            return DataImporter.isBusy(DataGridUtil.getDatabaseTable(grid));
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                6.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message((String)"hint.text.it.using.in.data.import", (Object[])new Object[0]);
            if (string == null) {
                6.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$6";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$6";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    SEARCH_PATH_MISMATCH{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                7.$$$reportNull$$$0(0);
            }
            return !grid.isReady();
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                7.$$$reportNull$$$0(1);
            }
            String string = DatabaseBundle.message((String)"hint.text.search.path.mismatch", (Object[])new Object[0]);
            if (string == null) {
                7.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$7";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$7";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
    ,
    READ_ONLY_FILE{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            DocumentDataHookUp up;
            if (grid == null) {
                8.$$$reportNull$$$0(0);
            }
            return (up = DataGridUtil.getDocumentDataHookUp(grid)) != null && up.isReadOnly();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                8.$$$reportNull$$$0(1);
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                8.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                8.$$$reportNull$$$0(3);
            }
            String string = GridEditGuard.defaultMessage();
            if (string == null) {
                8.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard$8";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard$8";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReasonInner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "rejectEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonText";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getReasonInner";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };


    @NotNull
    @NlsContexts.HintText
    public String getReasonText(@NotNull DataGrid grid) {
        if (grid == null) {
            GridEditGuard.$$$reportNull$$$0(0);
        }
        String string = DatabaseBundle.message((String)"hint.text.div.style.text.align.center.table.read.only.br.div", (Object[])new Object[]{this.getReasonInner(grid)});
        if (string == null) {
            GridEditGuard.$$$reportNull$$$0(1);
        }
        return string;
    }

    abstract boolean rejectEdit(@NotNull DataGrid var1);

    @NlsContexts.HintText
    @NotNull
    abstract String getReasonInner(@NotNull DataGrid var1);

    @Nullable
    public static GridEditGuard get(@NotNull DataGrid grid) {
        if (grid == null) {
            GridEditGuard.$$$reportNull$$$0(2);
        }
        for (GridEditGuard guard : GridEditGuard.values()) {
            if (!guard.rejectEdit(grid)) continue;
            return guard;
        }
        return null;
    }

    @NlsContexts.HintText
    @NotNull
    private static String defaultMessage() {
        String string = EditorBundle.message((String)"editing.viewer.hint", (Object[])new Object[0]);
        if (string == null) {
            GridEditGuard.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/GridEditGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/GridEditGuard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReasonText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReasonText";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

