/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.EditorCellViewer$sam$com_intellij_openapi_actionSystem_DataProvider$0;
import com.intellij.database.run.ui.FormattedModeHandler;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ValueParserCache;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.renderers.DefaultTextRendererFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.LineSeparator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 :2\u00020\u0001:\u0002:;B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0'H\u0002J\b\u0010(\u001a\u00020%H\u0016J\u0014\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019J\u0006\u00100\u001a\u00020%J,\u00101\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020*2\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\f\u00105\u001a\b\u0012\u0004\u0012\u00020603H\u0002J\b\u00107\u001a\u00020%H\u0016J\u0012\u00107\u001a\u00020%2\b\u00108\u001a\u0004\u0018\u00010*H\u0016J\b\u00109\u001a\u00020%H\u0002J.\u00109\u001a\u00020%2\b\u0010\u0011\u001a\u0004\u0018\u00010*2\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\f\u00105\u001a\b\u0012\u0004\u0012\u00020603H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer;", "Lcom/intellij/database/run/ui/CellViewer;", "project", "Lcom/intellij/openapi/project/Project;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "editable", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/datagrid/DataGrid;Z)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "formattedModeHandler", "Lcom/intellij/database/run/ui/FormattedModeHandler;", "value", "isFormattedMode", "()Z", "setFormattedMode", "(Z)V", "isFormattedModeSupported", "isSoftWraps", "setSoftWraps", "", "offset", "getOffset", "()I", "setOffset", "(I)V", "preferedFocusComponent", "getPreferedFocusComponent", "updateDocumentListener", "Lcom/intellij/database/run/ui/EditorCellViewer$UpdateDocumentListener;", "createEditor", "disableUpdateListener", "", "action", "Lkotlin/Function0;", "dispose", "getData", "", "dataId", "", "select", "start", "end", "selectAll", "setText", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "columnIdx", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "update", "editedValue", "updateText", "Companion", "UpdateDocumentListener", "intellij.database.impl"})
public final class EditorCellViewer
implements CellViewer {
    private final EditorEx editor;
    private final UpdateDocumentListener updateDocumentListener;
    private final FormattedModeHandler formattedModeHandler;
    private final Project project;
    private final DataGrid grid;
    private static final String SOFT_WRAPS_DISABLED = "EditMaximizedView.SOFT_WRAPS_DISABLED";
    private static final Key<LineSeparator> LINE_SEPARATOR_KEY;
    public static final Companion Companion;

    public final boolean isSoftWraps() {
        EditorSettings editorSettings = this.editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        return editorSettings.isUseSoftWraps();
    }

    public final void setSoftWraps(boolean value2) {
        PropertiesComponent.getInstance().setValue(SOFT_WRAPS_DISABLED, !value2);
        EditorSettings editorSettings = this.editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        editorSettings.setUseSoftWraps(value2);
    }

    public final boolean isFormattedModeSupported() {
        return this.formattedModeHandler.supportsCurrentValue();
    }

    public final boolean isFormattedMode() {
        return this.formattedModeHandler.isEnabled();
    }

    public final void setFormattedMode(boolean value2) {
        if (value2 == this.formattedModeHandler.isEnabled()) {
            return;
        }
        this.formattedModeHandler.setEnabled(value2);
        if (value2) {
            this.formattedModeHandler.reformat();
        } else {
            this.updateText();
        }
    }

    public final int getOffset() {
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        return caretModel.getOffset();
    }

    public final void setOffset(int value2) {
        if (value2 >= 0) {
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
            if (value2 <= documentEx.getTextLength()) {
                this.editor.getCaretModel().moveToOffset(value2);
                this.editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            }
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.editor.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getPreferedFocusComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        return jComponent;
    }

    private final void disableUpdateListener(Function0<Unit> action2) {
        this.editor.getDocument().removeDocumentListener((DocumentListener)this.updateDocumentListener);
        action2.invoke();
        this.editor.getDocument().addDocumentListener((DocumentListener)this.updateDocumentListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Object getData(String dataId) {
        UserDataHolder userDataHolder;
        String string;
        block3: {
            block2: {
                string = dataId;
                DataKey dataKey = CommonDataKeys.EDITOR;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"CommonDataKeys.EDITOR");
                if (Intrinsics.areEqual((Object)string, (Object)dataKey.getName())) break block2;
                DataKey dataKey2 = CommonDataKeys.HOST_EDITOR;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"CommonDataKeys.HOST_EDITOR");
                if (Intrinsics.areEqual((Object)string, (Object)dataKey2.getName())) break block2;
                DataKey dataKey3 = CommonDataKeys.EDITOR;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"CommonDataKeys.EDITOR");
                if (!Intrinsics.areEqual((Object)string, (Object)AnActionEvent.injectedId((String)dataKey3.getName()))) break block3;
            }
            userDataHolder = (UserDataHolder)this.editor;
            return userDataHolder;
        }
        DataKey dataKey = CommonDataKeys.CARET;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"CommonDataKeys.CARET");
        if (!Intrinsics.areEqual((Object)string, (Object)AnActionEvent.injectedId((String)dataKey.getName()))) return null;
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        userDataHolder = (UserDataHolder)caretModel.getCurrentCaret();
        return userDataHolder;
    }

    public void dispose() {
        if (!this.editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        }
    }

    @Override
    public void update(@Nullable Object editedValue) {
        this.editor.getSelectionModel().removeSelection();
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex = selectionModel.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> columnIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex2 = selectionModel2.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> rowIdx = modelIndex2;
        this.updateText(editedValue, rowIdx, columnIdx);
    }

    @Override
    public void update() {
        this.editor.getSelectionModel().removeSelection();
        this.updateText();
    }

    private final EditorEx createEditor(boolean editable) {
        EditorEx editorEx;
        LightVirtualFile virtualFile = new LightVirtualFile("EditMaximized", (Language)PlainTextLanguage.INSTANCE, (CharSequence)"");
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile);
        if (document == null) {
            document = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ance().createDocument(\"\")");
        Document document2 = document;
        if (editable) {
            Editor editor = EditorFactory.getInstance().createEditor(document2, this.project);
            if (editor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            editorEx = (EditorEx)editor;
        } else {
            Editor editor = EditorFactory.getInstance().createViewer(document2, this.project);
            if (editor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            editorEx = (EditorEx)editor;
        }
        EditorEx editor = editorEx;
        JScrollPane jScrollPane = editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        jScrollPane.setBorder(null);
        editor.setShowPlaceholderWhenFocused(true);
        editor.setContextMenuGroupId("Console.TableResult.CellEditor.Popup");
        EditorSettings editorSettings = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        editorSettings.setUseSoftWraps(!PropertiesComponent.getInstance().getBoolean(SOFT_WRAPS_DISABLED));
        return editor;
    }

    private final void updateText() {
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> rowIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> columnIdx = modelIndex2;
        if (!rowIdx.isValid(this.grid) || !columnIdx.isValid(this.grid)) {
            return;
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue(gridModel, (String)"grid.getDataModel(DataAc\u2026Type.DATA_WITH_MUTATIONS)");
        GridModel<DataConsumer.Row, DataConsumer.Column> model = gridModel;
        Object value2 = model.getValueAt(rowIdx, columnIdx);
        this.updateText(value2, rowIdx, columnIdx);
    }

    private final void updateText(Object value2, ModelIndex<DataConsumer.Row> rowIdx, ModelIndex<DataConsumer.Column> columnIdx) {
        Object object = value2;
        if (object == null) {
            object = ReservedCellValue.NULL;
        }
        this.setText(object, rowIdx, columnIdx);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile((Document)this.editor.getDocument());
        if (!(virtualFile instanceof LightVirtualFile)) {
            virtualFile = null;
        }
        LightVirtualFile lightVirtualFile = (LightVirtualFile)virtualFile;
        if (lightVirtualFile == null) {
            return;
        }
        LightVirtualFile virtualFile2 = lightVirtualFile;
        Language language = DefaultTextRendererFactory.getLanguage(columnIdx, this.grid);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"DefaultTextRendererFacto\u2026Language(columnIdx, grid)");
        Language language2 = language;
        if (Intrinsics.areEqual((Object)virtualFile2.getLanguage(), (Object)language2) ^ true) {
            virtualFile2.setLanguage(language2);
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((Project)this.project, (VirtualFile)((VirtualFile)virtualFile2));
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"HighlighterFactory.creat\u2026ter(project, virtualFile)");
            EditorHighlighter highlighter = editorHighlighter;
            this.editor.setHighlighter(highlighter);
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{(VirtualFile)virtualFile2});
        }
        this.formattedModeHandler.reformat();
    }

    public final void select(int start2, int end2) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        int len = documentEx.getTextLength();
        int n = 0;
        boolean bl = false;
        n = Math.max(n, start2);
        bl = false;
        int n2 = Math.min(len, n);
        n = 0;
        this.editor.getSelectionModel().setSelection(n2, Math.min(len, end2));
    }

    public final void selectAll() {
        com.intellij.openapi.editor.SelectionModel selectionModel = this.editor.getSelectionModel();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        selectionModel.setSelection(0, documentEx.getTextLength());
    }

    private final void setText(Object value2, ModelIndex<DataConsumer.Row> rowIdx, ModelIndex<DataConsumer.Column> columnIdx) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        this.disableUpdateListener((Function0<Unit>)((Function0)new Function0<Unit>(this, rowIdx, columnIdx, value2, document){
            final /* synthetic */ EditorCellViewer this$0;
            final /* synthetic */ ModelIndex $rowIdx;
            final /* synthetic */ ModelIndex $columnIdx;
            final /* synthetic */ Object $value;
            final /* synthetic */ DocumentEx $document;

            public final void invoke() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(this){
                    final /* synthetic */ setText.1 this$0;

                    public final void run() {
                        VirtualFile file;
                        int offsetBefore = this.this$0.this$0.getOffset();
                        ResultView resultView = EditorCellViewer.access$getGrid$p(this.this$0.this$0).getResultView();
                        Intrinsics.checkNotNullExpressionValue((Object)resultView, (String)"grid.resultView");
                        Object object = resultView.getEditorFactoryProvider();
                        if (object == null || (object = object.getEditorFactory(EditorCellViewer.access$getGrid$p(this.this$0.this$0), this.this$0.$rowIdx, this.this$0.$columnIdx)) == null || (object = object.getValueFormatter(EditorCellViewer.access$getGrid$p(this.this$0.this$0), this.this$0.$rowIdx, this.this$0.$columnIdx, this.this$0.$value)) == null) {
                            object = new GridCellEditorFactory.DefaultValueToText(EditorCellViewer.access$getGrid$p(this.this$0.this$0), this.this$0.$columnIdx, this.this$0.$value);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"grid.resultView.editorFa\u2026t(grid, columnIdx, value)");
                        Object formatter = object;
                        GridCellEditorFactory.ValueFormatterResult valueFormatterResult = formatter.format();
                        Intrinsics.checkNotNullExpressionValue((Object)valueFormatterResult, (String)"formatter.format()");
                        GridCellEditorFactory.ValueFormatterResult result = valueFormatterResult;
                        VirtualFile virtualFile = file = FileDocumentManager.getInstance().getFile((Document)this.this$0.$document);
                        if (virtualFile != null) {
                            virtualFile.setCharset(result.charset);
                        }
                        VirtualFile virtualFile2 = file;
                        if (virtualFile2 != null) {
                            virtualFile2.setBOM(result.bom);
                        }
                        Document document = (Document)this.this$0.$document;
                        String string = result.text;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.text");
                        com.intellij.database.run.ui.EditorCellViewer$Companion.access$setText(EditorCellViewer.Companion, document, string);
                        int n = this.this$0.$document.getTextLength();
                        boolean bl = false;
                        this.this$0.this$0.setOffset(Math.min(offsetBefore, n));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (this.$value instanceof ReservedCellValue) {
                    EditorCellViewer.access$getEditor$p(this.this$0).setPlaceholder((CharSequence)((ReservedCellValue)((Object)this.$value)).getDisplayName());
                } else {
                    EditorCellViewer.access$getEditor$p(this.this$0).setPlaceholder(null);
                }
            }
            {
                this.this$0 = editorCellViewer;
                this.$rowIdx = modelIndex;
                this.$columnIdx = modelIndex2;
                this.$value = object;
                this.$document = documentEx;
                super(0);
            }
        }));
    }

    public EditorCellViewer(@NotNull Project project, @NotNull DataGrid grid, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.project = project;
        this.grid = grid;
        this.editor = this.createEditor(editable);
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        this.formattedModeHandler = new FormattedModeHandler(this.grid, (Document)documentEx, this.project, (Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>(this){

            public final void invoke(@NotNull Function0<Unit> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                EditorCellViewer.access$disableUpdateListener((EditorCellViewer)this.receiver, p1);
            }
        }));
        this.updateDocumentListener = new UpdateDocumentListener();
        this.editor.getDocument().addDocumentListener((DocumentListener)this.updateDocumentListener);
        Function1 function1 = (Function1)new Function1<String, Object>(this){

            @Nullable
            public final Object invoke(@Nullable String p1) {
                return ((EditorCellViewer)this.receiver).getData(p1);
            }
        };
        DataManager.registerDataProvider((JComponent)this.editor.getComponent(), (DataProvider)new EditorCellViewer$sam$com_intellij_openapi_actionSystem_DataProvider$0(function1));
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"EDIT_MAXIMIZED_ETF_LINE_SEPARATOR");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"EDIT_MAXIMIZED_ETF_LINE_SEPARATOR\")");
        LINE_SEPARATOR_KEY = key;
    }

    public static final /* synthetic */ void access$disableUpdateListener(EditorCellViewer $this, Function0 action2) {
        $this.disableUpdateListener((Function0<Unit>)action2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer$UpdateDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/database/run/ui/EditorCellViewer;)V", "valueParserCache", "Lcom/intellij/database/run/ui/ValueParserCache;", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.database.impl"})
    private final class UpdateDocumentListener
    implements DocumentListener {
        private final ValueParserCache valueParserCache;

        public void documentChanged(@NotNull DocumentEvent event) {
            String string;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EditorCellViewer.this.editor.setPlaceholder(null);
            SelectionModel selectionModel = EditorCellViewer.this.grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
            ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
            Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
            ModelIndex<DataConsumer.Row> row = modelIndex;
            SelectionModel selectionModel2 = EditorCellViewer.this.grid.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
            ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
            Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
            ModelIndex<DataConsumer.Column> column2 = modelIndex2;
            if (!row.isValid(EditorCellViewer.this.grid) || !column2.isValid(EditorCellViewer.this.grid)) {
                return;
            }
            GridCellEditorFactory.ValueParser parser2 = this.valueParserCache.getValueParser(row, column2);
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)EditorCellViewer.this.project).commitDocument(document2);
            PsiFile file = PsiDocumentManager.getInstance((Project)EditorCellViewer.this.project).getPsiFile(document2);
            if (file != null) {
                string = Companion.getText(document2, EditorCellViewer.this.formattedModeHandler.minimize(file));
            } else {
                String string2 = document2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
                string = Companion.getText(document2, string2);
            }
            String text2 = string;
            Object object = parser2.parse(text2, document2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parser.parse(text, document)");
            Object value2 = object;
            EditorCellViewer.this.grid.getResultView().setValueAt(value2, row, column2, false, EditorCellViewer.this);
        }

        public UpdateDocumentListener() {
            this.valueParserCache = new ValueParserCache(EditorCellViewer.this.grid);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/run/ui/EditorCellViewer$Companion;", "", "()V", "LINE_SEPARATOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/util/LineSeparator;", "SOFT_WRAPS_DISABLED", "", "getText", "document", "Lcom/intellij/openapi/editor/Document;", "text", "setText", "", "intellij.database.impl"})
    public static final class Companion {
        private final String getText(Document document, String text2) {
            String string;
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
            if (separator == null) {
                string = text2;
            } else {
                String string2 = StringUtil.convertLineSeparators((String)text2, (String)separator.getSeparatorString());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.convertLineSe\u2026eparator.separatorString)");
            }
            return string;
        }

        private final void setText(Document document, String text2) {
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document);
            if (separator == null) {
                separator = StringUtil.detectSeparators((CharSequence)text2);
            }
            LINE_SEPARATOR_KEY.set((UserDataHolder)document, (Object)separator);
            document.setText((CharSequence)StringUtil.convertLineSeparators((String)text2));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$setText(Companion $this, Document document, String text2) {
            $this.setText(document, text2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

