/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.CellViewerFactory;
import com.intellij.database.run.ui.EditMaximizedViewKt$sam$com_intellij_openapi_actionSystem_DataProvider$0;
import com.intellij.database.run.ui.EditorCellViewerFactory;
import com.intellij.database.run.ui.EmptyCellViewerFactory;
import com.intellij.database.run.ui.ImageCellViewerFactory;
import com.intellij.database.run.ui.ReadonlyEditorCellViewerFactory;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0017\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0014J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\b\u0010 \u001a\u00020\u0019H\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/run/ui/EditMaximizedView;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "(Lcom/intellij/database/datagrid/DataGrid;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "currentViewerFactory", "Lcom/intellij/database/run/ui/CellViewerFactory;", "preferedFocusComponent", "Ljavax/swing/JComponent;", "getPreferedFocusComponent", "()Ljavax/swing/JComponent;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "getToolbar", "()Lcom/intellij/openapi/actionSystem/ActionToolbar;", "viewer", "Lcom/intellij/database/run/ui/CellViewer;", "viewerFactories", "", "chooseViewerFactory", "dispose", "", "getData", "", "dataId", "", "getViewer", "updateViewer", "updateViewerComponent", "Companion", "intellij.database.impl"})
public final class EditMaximizedView
extends JPanel
implements Disposable {
    private final Logger LOG;
    private CellViewerFactory currentViewerFactory;
    private final List<CellViewerFactory> viewerFactories;
    private CellViewer viewer;
    @NotNull
    private final ActionToolbar toolbar;
    private final DataGrid grid;
    @JvmField
    @NotNull
    public static final DataKey<EditMaximizedView> EDIT_MAXIMIZED_KEY;
    @JvmField
    @NotNull
    public static final Key<EditMaximizedView> EDIT_MAXIMIZED_GRID_KEY;
    public static final Companion Companion;

    @NotNull
    public final ActionToolbar getToolbar() {
        return this.toolbar;
    }

    @Nullable
    public final JComponent getPreferedFocusComponent() {
        return this.viewer.getPreferedFocusComponent();
    }

    private final CellViewerFactory chooseViewerFactory() {
        CellViewerFactory cellViewerFactory;
        CellViewerFactory factory;
        Object v4;
        SelectionModel selectionModel = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Row> modelIndex = selectionModel.getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"grid.selectionModel.leadSelectionRow");
        ModelIndex<DataConsumer.Row> rowIdx = modelIndex;
        SelectionModel selectionModel2 = this.grid.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue(selectionModel2, (String)"grid.selectionModel");
        ModelIndex<DataConsumer.Column> modelIndex2 = selectionModel2.getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"grid.selectionModel.leadSelectionColumn");
        ModelIndex<DataConsumer.Column> columnIdx = modelIndex2;
        Iterable $this$maxBy$iv = this.viewerFactories;
        boolean $i$f$maxBy = false;
        Iterable $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v4 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v4 = maxElem$iv$iv;
            } else {
                CellViewerFactory it2 = (CellViewerFactory)maxElem$iv$iv;
                boolean bl = false;
                Comparable maxValue$iv$iv = (Comparable)((Object)it2.getSuitability(this.grid, rowIdx, columnIdx));
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    CellViewerFactory it3 = (CellViewerFactory)e$iv$iv;
                    $i$a$-maxBy-EditMaximizedView$chooseViewerFactory$factory$1 = false;
                    Comparable v$iv$iv = (Comparable)((Object)it3.getSuitability(this.grid, rowIdx, columnIdx));
                    if (maxValue$iv$iv.compareTo(v$iv$iv) >= 0) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v4 = maxElem$iv$iv;
            }
        }
        if ((factory = (CellViewerFactory)v4) == null) {
            this.LOG.error("Cannot find cell viewer factory for " + rowIdx + ' ' + columnIdx);
        }
        if ((cellViewerFactory = factory) == null) {
            cellViewerFactory = EmptyCellViewerFactory.INSTANCE;
        }
        return cellViewerFactory;
    }

    @NotNull
    public final CellViewer getViewer() {
        return this.viewer;
    }

    private final void updateViewer() {
        CellViewerFactory factory = this.chooseViewerFactory();
        if (Intrinsics.areEqual((Object)this.currentViewerFactory, (Object)factory) ^ true) {
            Disposer.dispose((Disposable)this.viewer);
            this.currentViewerFactory = factory;
            this.viewer = factory.createViewer(this.grid);
            this.updateViewerComponent();
        }
    }

    private final void updateViewerComponent() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.BorderLayout");
        }
        Component oldComponent = ((BorderLayout)layoutManager).getLayoutComponent("Center");
        if (oldComponent != null) {
            this.remove(oldComponent);
        }
        this.add((Component)this.viewer.getComponent(), "Center");
        this.toolbar.setTargetComponent(this.viewer.getComponent());
    }

    private final Object getData(String dataId) {
        String string = dataId;
        return Intrinsics.areEqual((Object)string, (Object)EDIT_MAXIMIZED_KEY.getName()) ? this : null;
    }

    public void dispose() {
        this.grid.putUserData(EDIT_MAXIMIZED_GRID_KEY, null);
        Disposer.dispose((Disposable)this.viewer);
    }

    public EditMaximizedView(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        super(new BorderLayout());
        this.grid = grid;
        Logger logger2 = Logger.getInstance(EditMaximizedView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(EditMaximizedView::class.java)");
        this.LOG = logger2;
        this.viewerFactories = CollectionsKt.listOf((Object[])new CellViewerFactory[]{EditorCellViewerFactory.INSTANCE, ReadonlyEditorCellViewerFactory.INSTANCE, EmptyCellViewerFactory.INSTANCE, ImageCellViewerFactory.INSTANCE});
        this.currentViewerFactory = this.chooseViewerFactory();
        this.viewer = this.currentViewerFactory.createViewer(this.grid);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Console.TableResult.EditMaximized.Group");
        if (anAction == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        }
        ActionGroup actions = (ActionGroup)anAction;
        EditorHeaderComponent header = new EditorHeaderComponent();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", actions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"actionManager.createActi\u2026_TOOLBAR, actions, false)");
        this.toolbar = actionToolbar;
        this.toolbar.setReservePlaceAutoPopupIcon(false);
        header.add((Component)this.toolbar.getComponent(), (Object)"Center");
        header.setBorder((Border)new CustomLineBorder(JBColor.border(), 0, 1, 0, 0));
        this.add((Component)header, "East");
        this.updateViewerComponent();
        this.viewer.update();
        this.grid.addDataGridListener(new DataGridListener(){

            @Override
            public void onContentChanged(@NotNull DataGrid dataGrid, @Nullable Object requestor) {
                Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
                if (Intrinsics.areEqual((Object)requestor, (Object)viewer) ^ true) {
                    viewer.update();
                }
            }

            @Override
            public void onCellLanguageChanged(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
                Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
                Intrinsics.checkNotNullParameter((Object)language, (String)"language");
                viewer.update();
                this.getToolbar().updateActionsImmediately();
            }

            @Override
            public void onSelectionChanged(@Nullable DataGrid dataGrid) {
                this.updateViewer();
                viewer.update();
                this.getToolbar().updateActionsImmediately();
                this.revalidate();
                this.repaint();
            }

            @Override
            public void onValueEdited(@Nullable DataGrid dataGrid, @Nullable Object value2) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this, value2){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ Object $value;

                    public final void run() {
                        EditMaximizedView.access$getViewer$p(this.this$0.this).update(this.$value);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$value = object;
                    }
                });
            }
        }, this);
        this.grid.putUserData(EDIT_MAXIMIZED_GRID_KEY, this);
        Function1 function1 = (Function1)new Function1<String, Object>(this){

            @Nullable
            public final Object invoke(@Nullable String p1) {
                return ((EditMaximizedView)this.receiver).getData(p1);
            }
        };
        DataManager.registerDataProvider((JComponent)this, (DataProvider)new EditMaximizedViewKt$sam$com_intellij_openapi_actionSystem_DataProvider$0(function1));
    }

    static {
        Companion = new Companion(null);
        DataKey dataKey = DataKey.create((String)"EDIT_MAXIMIZED_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DataKey.create(\"EDIT_MAXIMIZED_KEY\")");
        EDIT_MAXIMIZED_KEY = dataKey;
        EDIT_MAXIMIZED_GRID_KEY = new Key("EDIT_MAXIMIZED_KEY");
    }

    public static final /* synthetic */ void access$setViewer$p(EditMaximizedView $this, CellViewer cellViewer) {
        $this.viewer = cellViewer;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/run/ui/EditMaximizedView$Companion;", "", "()V", "EDIT_MAXIMIZED_GRID_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/run/ui/EditMaximizedView;", "EDIT_MAXIMIZED_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

