/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.SubmitMutations;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TransactionAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(0);
        }
        DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
        Dbms family = TransactionAction.getDbms(owner);
        if (owner != null && family != null && TransactionAction.isTransactionsSupported(family)) {
            this.update(owner, e);
        } else {
            DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            e.getPresentation().setVisible(grid != null && DataGridUtil.getDatabaseTable(grid) != null);
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataRequest.OwnerEx owner;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(1);
        }
        if ((owner = TransactionAction.getRequestOwner(e)) == null) {
            return;
        }
        this.actionPerformed(owner, e);
    }

    @Nullable
    public static Dbms getDbms(@Nullable DataRequest.Owner owner) {
        DbDataSource system = owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDataSource() : (owner instanceof JdbcConsole ? ((JdbcConsole)owner).getDataSource() : (owner instanceof DatabaseSession ? (DasDataSource)((DatabaseSession)owner).getTarget() : null));
        return system == null ? null : system.getDbms();
    }

    private static void stopEditingIfNecessary(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(2);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && !dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
    }

    public static boolean isTransactionsSupported(@NotNull Dbms family) {
        if (family == null) {
            TransactionAction.$$$reportNull$$$0(3);
        }
        return DbImplUtil.getJdbcHelper(family).supportsTransactions();
    }

    @Nullable
    private static DasTable getTable(@NotNull DataRequest.OwnerEx owner) {
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(4);
        }
        return owner instanceof DatabaseGridDataHookUp ? ((DatabaseGridDataHookUp)owner).getDatabaseTable() : null;
    }

    private static void switchIsolationLevel(@NotNull TxIsolation isolation, @NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
        if (isolation == null) {
            TransactionAction.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(6);
        }
        String message2 = DatabaseBundle.message((String)"notification.content.transaction.isolation.level.switched.to", (Object[])new Object[]{StringUtil.toLowerCase((String)isolation.getName())});
        TransactionAction.performAfterCommit(e, owner, message2, () -> ObjectUtils.consumeIfCast((Object)owner, DataRequest.TxIsolationOwner.class, txOwner -> txOwner.setTxIsolation(isolation.getIsolation())));
    }

    private static void selectTxMode(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, boolean auto) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(7);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(8);
        }
        String mode = StringUtil.toLowerCase((String)(auto ? DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]) : DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0])));
        String message2 = DatabaseBundle.message((String)"notification.content.transaction.mode.on", (Object[])new Object[]{mode});
        TransactionAction.performAfterCommit(e, owner, message2, () -> owner.setAutoCommit(auto));
    }

    private static void performAfterCommit(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner, @NlsContexts.NotificationContent @NotNull String message2, @NotNull Runnable action2) {
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(9);
        }
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(10);
        }
        if (message2 == null) {
            TransactionAction.$$$reportNull$$$0(11);
        }
        if (action2 == null) {
            TransactionAction.$$$reportNull$$$0(12);
        }
        TransactionAction.stopEditingIfNecessary(e);
        DataRequest request = DataRequest.newTxCommit(owner);
        request.getPromise().onSuccess(aVoid -> {
            action2.run();
            DataBus.shortCircuit(owner.getMessageBus()).getDataAuditor().print(DataRequest.newContext(owner, null, ""), message2);
        });
        owner.getMessageBus().getDataProducer().processRequest(request);
    }

    @Nullable
    private static DataRequest.OwnerEx getRequestOwner(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            TransactionAction.$$$reportNull$$$0(13);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isEditable() ? DataGridUtil.getDataBusHookUp(dataGrid) : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        if (console != null) {
            return console;
        }
        VisibleDatabaseSessionClient client = (VisibleDatabaseSessionClient)ObjectUtils.tryCast((Object)e.getData(SessionClientHolder.CLIENT_KEY), VisibleDatabaseSessionClient.class);
        if (client != null) {
            return client.isValid() ? client : null;
        }
        return (DataRequest.OwnerEx)ObjectUtils.tryCast((Object)e.getData(Session.SESSION_KEY), DatabaseSession.class);
    }

    @Nullable
    private static JComponent getComponent(AnActionEvent e) {
        return (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
    }

    @Nullable
    private static DataRequest.TxIsolationOwner getTxIsolationOwner(AnActionEvent e) {
        return (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)TransactionAction.getRequestOwner(e), DataRequest.TxIsolationOwner.class);
    }

    protected abstract void actionPerformed(@NotNull DataRequest.OwnerEx var1, @NotNull AnActionEvent var2);

    protected abstract void update(@NotNull DataRequest.OwnerEx var1, AnActionEvent var2);

    private static boolean canChangeTx(@NotNull DataRequest.OwnerEx owner) {
        DataRequest.TxMarker marker;
        DataRequest.Owner txOwner;
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(14);
        }
        return (txOwner = (marker = owner.getCurrentTx()).getOwner()) == null || TransactionAction.canOwnTx(owner);
    }

    private static boolean canOwnTx(@NotNull DataRequest.OwnerEx owner) {
        DataRequest.TxMarker marker;
        DataRequest.Owner txOwner;
        if (owner == null) {
            TransactionAction.$$$reportNull$$$0(15);
        }
        return (txOwner = (marker = owner.getCurrentTx()).getOwner()) == owner || txOwner instanceof DataRequest.OwnerEx && ((DataRequest.OwnerEx)txOwner).isChildOf(owner) || marker == DataRequest.IN_PROGRESS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isolation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/TransactionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "stopEditingIfNecessary";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTransactionsSupported";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "switchIsolationLevel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "selectTxMode";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "performAfterCommit";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequestOwner";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeTx";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "canOwnTx";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum TxIsolation {
        DEFAULT(DatabaseBundle.message((String)"transaction.mode.database.default", (Object[])new Object[0]), -1),
        READ_UNCOMMITTED(DatabaseBundle.message((String)"transaction.mode.read.uncommitted", (Object[])new Object[0]), 1){

            @Override
            public boolean isSupported(@NotNull Dbms id, @Nullable DasTable table) {
                if (id == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !id.isOracle() && !id.isPostgres() && !id.isHsqldb() && !id.isVertica() && this.availableIfSybase(id, table);
            }

            private boolean availableIfSybase(@NotNull Dbms id, @Nullable DasTable table) {
                if (id == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !id.isSybase() || table == null || table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class).filter(i2 -> i2.isUnique()).first() != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "id";
                objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxIsolation$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSupported";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "availableIfSybase";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        READ_COMMITTED(DatabaseBundle.message((String)"transaction.mode.read.committed", (Object[])new Object[0]), 2),
        REPEATABLE_READ(DatabaseBundle.message((String)"transaction.mode.repeatable.read", (Object[])new Object[0]), 4){

            @Override
            public boolean isSupported(@NotNull Dbms id, @Nullable DasTable table) {
                if (id == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !id.isH2() && !id.isOracle() && !id.isHsqldb() && !id.isVertica();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/run/actions/TransactionAction$TxIsolation$2", "isSupported"));
            }
        }
        ,
        SERIALIZABLE(DatabaseBundle.message((String)"transaction.mode.serializable", (Object[])new Object[0]), 8);

        private final int myIsolation;
        private final @NlsContexts.Checkbox String myName;

        private TxIsolation(String name, int isolation) {
            if (name == null) {
                TxIsolation.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myIsolation = isolation;
        }

        @NotNull
        @NlsContexts.Checkbox
        public String getName() {
            String string = this.myName;
            if (string == null) {
                TxIsolation.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getIsolation() {
            return this.myIsolation;
        }

        public boolean isSupported(@NotNull Dbms id, @Nullable DasTable table) {
            if (id == null) {
                TxIsolation.$$$reportNull$$$0(2);
            }
            return true;
        }

        @NotNull
        public static TxIsolation of(int value2) {
            for (TxIsolation isolation : TxIsolation.values()) {
                if (isolation.myIsolation != value2) continue;
                TxIsolation txIsolation = isolation;
                if (txIsolation == null) {
                    TxIsolation.$$$reportNull$$$0(3);
                }
                return txIsolation;
            }
            TxIsolation txIsolation = DEFAULT;
            if (txIsolation == null) {
                TxIsolation.$$$reportNull$$$0(4);
            }
            return txIsolation;
        }

        public static boolean levelsSupported(@NotNull Dbms id) {
            if (id == null) {
                TxIsolation.$$$reportNull$$$0(5);
            }
            return ArrayUtil.contains((Object)id, (Object[])new Dbms[]{Dbms.ORACLE, Dbms.MYSQL, Dbms.MYSQL_AURORA, Dbms.MARIA, Dbms.MEMSQL, Dbms.POSTGRES, Dbms.MSSQL, Dbms.AZURE, Dbms.SYBASE, Dbms.DB2_LUW, Dbms.DB2_IS, Dbms.DB2_ZOS, Dbms.DB2, Dbms.HSQL, Dbms.H2, Dbms.DERBY, Dbms.VERTICA});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$TxIsolation";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxIsolation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupported";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "levelsSupported";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class PreferencesUserActivityWrapper
    extends JPanel
    implements UserActivityProviderComponent,
    DescriptionPopup.TxPopup.TxSelector {
        private final List<ChangeListener> myListeners;

        public PreferencesUserActivityWrapper(@NotNull JComponent component) {
            if (component == null) {
                PreferencesUserActivityWrapper.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            this.myListeners = new ArrayList<ChangeListener>();
            this.add((Component)component, "Center");
            component.setBorder((Border)JBUI.Borders.empty());
        }

        @NotNull
        protected abstract DescriptionPopup.TxPopup.TxSelector getSelector();

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                PreferencesUserActivityWrapper.$$$reportNull$$$0(1);
            }
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                PreferencesUserActivityWrapper.$$$reportNull$$$0(2);
            }
            this.myListeners.remove(changeListener);
        }

        @Override
        public void toggle(@Nullable AnActionEvent e, boolean auto) {
            this.getSelector().toggle(e, auto);
            this.fireUpdate();
        }

        @Override
        public boolean isAuto() {
            return this.getSelector().isAuto();
        }

        private void fireStateChanged() {
            ChangeEvent event = new ChangeEvent(this);
            this.myListeners.forEach(l -> l.stateChanged(event));
        }

        protected void fireUpdate() {
            Container toolbar2 = SwingUtilities.getAncestorOfClass(ActionToolbar.class, this);
            if (toolbar2 != null) {
                ((ActionToolbar)toolbar2).updateActionsImmediately();
            }
            this.fireStateChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeListener";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$PreferencesUserActivityWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class PreferencesTxModeAction
    extends AlignedIconWithTextAction.Group
    implements DumbAware {
        @NotNull
        public abstract DescriptionPopup.TxPopup.TxSelector getSelector();

        @NotNull
        protected abstract PreferencesUserActivityWrapper createActivityWrapper(@NotNull JComponent var1);

        @Nullable
        protected abstract DescriptionPopup.TxPopup createPopup(@NotNull PreferencesUserActivityWrapper var1);

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            String text2 = this.getSelector().isAuto() ? DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]) : DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0]);
            presentation.setEnabledAndVisible(true);
            presentation.setText(text2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PreferencesUserActivityWrapper activityWrapper;
            if (e == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(1);
            }
            if ((activityWrapper = (PreferencesUserActivityWrapper)ObjectUtils.tryCast((Object)TransactionAction.getComponent(e), PreferencesUserActivityWrapper.class)) == null) {
                return;
            }
            DescriptionPopup.TxPopup popup = this.createPopup(activityWrapper);
            if (popup == null) {
                return;
            }
            popup.build(e.getDataContext()).showUnderneathOf((Component)activityWrapper);
        }

        @Override
        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(2);
            }
            if (place == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(3);
            }
            JComponent component = super.createCustomComponent(presentation, place);
            PreferencesUserActivityWrapper preferencesUserActivityWrapper = this.createActivityWrapper(component);
            if (preferencesUserActivityWrapper == null) {
                PreferencesTxModeAction.$$$reportNull$$$0(4);
            }
            return preferencesUserActivityWrapper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$PreferencesTxModeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$PreferencesTxModeAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RevertAndRollback
    extends GridTransactionAction {
        @Override
        @NotNull
        ActionCallback prepareGrid(@NotNull AnActionEvent e, @NotNull DataGrid grid) {
            GridDataSupport support;
            if (e == null) {
                RevertAndRollback.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                RevertAndRollback.$$$reportNull$$$0(1);
            }
            if (!(support = grid.getDataSupport()).hasPendingChanges()) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    RevertAndRollback.$$$reportNull$$$0(2);
                }
                return actionCallback;
            }
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            ModelIndexSet<DataConsumer.Row> rows = model.getRowIndices();
            ModelIndexSet<DataConsumer.Column> columns = model.getColumnIndices();
            support.revert(rows, columns);
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                RevertAndRollback.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        @Override
        boolean isEnabledWithoutTx(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner) {
            if (e == null) {
                RevertAndRollback.$$$reportNull$$$0(4);
            }
            if (owner == null) {
                RevertAndRollback.$$$reportNull$$$0(5);
            }
            return false;
        }

        @Override
        protected void performTxAction(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                RevertAndRollback.$$$reportNull$$$0(6);
            }
            DataRequest request = DataRequest.newTxRollback(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$RevertAndRollback";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$RevertAndRollback";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGrid";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledWithoutTx";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "performTxAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SubmitAndCommit
    extends GridTransactionAction {
        @Override
        @NotNull
        ActionCallback prepareGrid(@NotNull AnActionEvent e, @NotNull DataGrid grid) {
            if (e == null) {
                SubmitAndCommit.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                SubmitAndCommit.$$$reportNull$$$0(1);
            }
            ActionCallback actionCallback = SubmitMutations.submitChangesIfExists(e);
            if (actionCallback == null) {
                SubmitAndCommit.$$$reportNull$$$0(2);
            }
            return actionCallback;
        }

        @Override
        boolean isEnabledWithoutTx(@NotNull AnActionEvent e, @NotNull DataRequest.OwnerEx owner) {
            if (e == null) {
                SubmitAndCommit.$$$reportNull$$$0(3);
            }
            if (owner == null) {
                SubmitAndCommit.$$$reportNull$$$0(4);
            }
            return owner.getCurrentTx() == DataRequest.START_NEW && SubmitMutations.hasChangesToSubmit(e);
        }

        @Override
        protected void performTxAction(@NotNull DataRequest.OwnerEx owner) {
            if (owner == null) {
                SubmitAndCommit.$$$reportNull$$$0(5);
            }
            DataRequest request = DataRequest.newTxCommit(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$SubmitAndCommit";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$SubmitAndCommit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareGrid";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabledWithoutTx";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "performTxAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class GridTransactionAction
    extends TransactionAction {
        private GridTransactionAction() {
        }

        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                GridTransactionAction.$$$reportNull$$$0(0);
            }
            if (e == null) {
                GridTransactionAction.$$$reportNull$$$0(1);
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            if (grid == null) {
                return;
            }
            this.prepareGrid(e, grid).doWhenDone(() -> this.performTxAction(owner));
        }

        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                GridTransactionAction.$$$reportNull$$$0(2);
            }
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            boolean isGrid = owner instanceof DatabaseGridDataHookUp && grid != null;
            boolean enabled = isGrid && (TransactionAction.canOwnTx(owner) || this.isEnabledWithoutTx(e, owner));
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(enabled);
            presentation.setVisible(isGrid);
        }

        @NotNull
        abstract ActionCallback prepareGrid(@NotNull AnActionEvent var1, @NotNull DataGrid var2);

        abstract boolean isEnabledWithoutTx(@NotNull AnActionEvent var1, @NotNull DataRequest.OwnerEx var2);

        protected abstract void performTxAction(@NotNull DataRequest.OwnerEx var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$GridTransactionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Rollback
    extends NonGridTxAction {
        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                Rollback.$$$reportNull$$$0(0);
            }
            if (e == null) {
                Rollback.$$$reportNull$$$0(1);
            }
            DataRequest request = DataRequest.newTxRollback(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/TransactionAction$Rollback";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Commit
    extends NonGridTxAction {
        @Override
        protected void actionPerformed(@NotNull DataRequest.OwnerEx owner, @NotNull AnActionEvent e) {
            if (owner == null) {
                Commit.$$$reportNull$$$0(0);
            }
            if (e == null) {
                Commit.$$$reportNull$$$0(1);
            }
            TransactionAction.stopEditingIfNecessary(e);
            DataRequest request = DataRequest.newTxCommit(owner);
            owner.getMessageBus().getDataProducer().processRequest(request);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/TransactionAction$Commit";
            objectArray[2] = "actionPerformed";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class NonGridTxAction
    extends TransactionAction {
        private NonGridTxAction() {
        }

        @Override
        protected void update(@NotNull DataRequest.OwnerEx owner, AnActionEvent e) {
            if (owner == null) {
                NonGridTxAction.$$$reportNull$$$0(0);
            }
            boolean isGrid = DataGridUtil.getDataGrid(e.getDataContext()) != null;
            e.getPresentation().setEnabled(!isGrid && TransactionAction.canOwnTx(owner));
            e.getPresentation().setVisible(!isGrid);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/TransactionAction$NonGridTxAction", "update"));
        }
    }

    private static abstract class TxMode
    extends CheckboxAction
    implements DumbAware {
        private final boolean myAuto;

        private TxMode(@NlsActions.ActionText @NotNull String text2, @NlsActions.ActionDescription @NotNull String description, boolean auto) {
            if (text2 == null) {
                TxMode.$$$reportNull$$$0(0);
            }
            if (description == null) {
                TxMode.$$$reportNull$$$0(1);
            }
            super(text2, description, null);
            this.myAuto = auto;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TxMode.$$$reportNull$$$0(2);
            }
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            e.getPresentation().setEnabledAndVisible(owner != null && TransactionAction.canChangeTx(owner));
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            DataRequest.OwnerEx owner;
            if (e == null) {
                TxMode.$$$reportNull$$$0(3);
            }
            return (owner = TransactionAction.getRequestOwner(e)) != null && this.isSelected(owner);
        }

        protected abstract boolean isSelected(DataRequest.OwnerEx var1);

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                TxMode.$$$reportNull$$$0(4);
            }
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            if (!state || owner == null) {
                return;
            }
            TransactionAction.selectTxMode(e, owner, this.myAuto);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TxSettings
    extends DefaultActionGroup
    implements CustomComponentAction,
    DumbAware {
        private final PopupState<JBPopup> myPopupState = PopupState.forPopup();

        public TxSettings() {
            this.setPopup(true);
            this.add((AnAction)new TxMode(DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]), DatabaseBundle.message((String)"transaction.mode.auto.description", (Object[])new Object[0]), true){

                @Override
                protected boolean isSelected(DataRequest.OwnerEx owner) {
                    return owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
                }
            });
            this.add((AnAction)new TxMode(DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0]), DatabaseBundle.message((String)"transaction.mode.manual.description", (Object[])new Object[0]), false){

                @Override
                protected boolean isSelected(DataRequest.OwnerEx owner) {
                    return owner.getCurrentTx() != DataRequest.AUTO_COMMIT;
                }
            });
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TxSettings.$$$reportNull$$$0(0);
            }
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            Presentation presentation = e.getPresentation();
            Dbms family = TransactionAction.getDbms(owner);
            boolean enabled = owner != null && family != null && TransactionAction.isTransactionsSupported(family) && TransactionAction.canChangeTx(owner);
            DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            owner = owner != null ? owner : DataGridUtil.getDataBusHookUp(grid);
            boolean visible = enabled || DataGridUtil.getDatabaseTable(grid) != null && owner != null;
            presentation.setVisible(visible);
            if (!visible) {
                return;
            }
            presentation.setEnabled(enabled);
            String mode = owner.getCurrentTx() == DataRequest.AUTO_COMMIT ? DatabaseBundle.message((String)"transaction.mode.auto", (Object[])new Object[0]) : DatabaseBundle.message((String)"transaction.mode.manual", (Object[])new Object[0]);
            String text2 = e.isFromActionToolbar() ? DatabaseBundle.message((String)"action.tx.text", (Object[])new Object[]{mode}) : DatabaseBundle.message((String)"action.tx.mode.text", (Object[])new Object[]{mode});
            presentation.setText(text2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TxSettings.$$$reportNull$$$0(1);
            }
            if (this.myPopupState.isRecentlyHidden()) {
                return;
            }
            DataRequest.OwnerEx owner = TransactionAction.getRequestOwner(e);
            JComponent component = TransactionAction.getComponent(e);
            if (owner == null) {
                return;
            }
            JBPopup popup = TxSettings.getPopup(owner, e.getDataContext());
            if (component == null) {
                DbUIUtil.showPopup(popup, null, e);
                return;
            }
            this.myPopupState.prepareToShow((Object)popup);
            popup.showUnderneathOf((Component)component);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                TxSettings.$$$reportNull$$$0(2);
            }
            if (place == null) {
                TxSettings.$$$reportNull$$$0(3);
            }
            JComponent jComponent = AlignedIconWithTextAction.createCustomComponentImpl((AnAction)this, presentation, place);
            if (jComponent == null) {
                TxSettings.$$$reportNull$$$0(4);
            }
            return jComponent;
        }

        @NotNull
        private static JBPopup getPopup(final @NotNull DataRequest.OwnerEx owner, @NotNull DataContext context) {
            if (owner == null) {
                TxSettings.$$$reportNull$$$0(5);
            }
            if (context == null) {
                TxSettings.$$$reportNull$$$0(6);
            }
            DasTable table = TransactionAction.getTable(owner);
            Dbms family = TransactionAction.getDbms(owner);
            final DataRequest.TxIsolationOwner txOwner = (DataRequest.TxIsolationOwner)ObjectUtils.tryCast((Object)owner, DataRequest.TxIsolationOwner.class);
            JBPopup jBPopup = new DescriptionPopup.TxSettingsPopup(TxSettings.getAvailableLevels(txOwner, family, table), new DescriptionPopup.TxPopup.TxIsolationSelector(){

                @Override
                public boolean isSelected(@NotNull TxIsolation isolation) {
                    if (isolation == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return Objects.requireNonNull(txOwner).getTxIsolation() == isolation.getIsolation();
                }

                @Override
                public void select(@NotNull TxIsolation isolation, AnActionEvent e) {
                    if (isolation == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    TransactionAction.switchIsolationLevel(isolation, Objects.requireNonNull(txOwner), e);
                }

                @Override
                public void toggle(@Nullable AnActionEvent e, boolean auto) {
                    TransactionAction.selectTxMode(Objects.requireNonNull(e), owner, auto);
                }

                @Override
                public boolean isAuto() {
                    return owner.getCurrentTx() == DataRequest.AUTO_COMMIT;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "isolation";
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxSettings$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "select";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).build(context);
            if (jBPopup == null) {
                TxSettings.$$$reportNull$$$0(7);
            }
            return jBPopup;
        }

        @NotNull
        private static List<TxIsolation> getAvailableLevels(@Nullable DataRequest.TxIsolationOwner owner, @Nullable Dbms id, @Nullable DasTable table) {
            List list = id != null && owner != null && TxIsolation.levelsSupported(id) ? ContainerUtil.filter((Object[])TxIsolation.values(), isolation -> isolation.isSupported(id, table)) : ContainerUtil.emptyList();
            if (list == null) {
                TxSettings.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/TransactionAction$TxSettings";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$TxSettings";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPopup";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPopup";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class IsolationLevelAction
    extends CheckboxAction
    implements DumbAware {
        private final TxIsolation myIsolation;

        private IsolationLevelAction(@NotNull TxIsolation isolation) {
            if (isolation == null) {
                IsolationLevelAction.$$$reportNull$$$0(0);
            }
            super(isolation.getName(), StringUtil.removeHtmlTags((String)DescriptionPopup.TxSettingsPopup.DESCRIPTIONS.get((Object)isolation)), null);
            this.myIsolation = isolation;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                IsolationLevelAction.$$$reportNull$$$0(1);
            }
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            Dbms family = TransactionAction.getDbms(owner);
            e.getPresentation().setEnabledAndVisible(owner != null && family != null && this.myIsolation.isSupported(family, TransactionAction.getTable(owner)));
            super.update(e);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            DataRequest.TxIsolationOwner owner;
            if (e == null) {
                IsolationLevelAction.$$$reportNull$$$0(2);
            }
            return (owner = TransactionAction.getTxIsolationOwner(e)) != null && owner.getTxIsolation() == this.myIsolation.getIsolation();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                IsolationLevelAction.$$$reportNull$$$0(3);
            }
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            if (!state || owner == null) {
                return;
            }
            TransactionAction.switchIsolationLevel(this.myIsolation, owner, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isolation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/TransactionAction$IsolationLevelAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ChangeIsolationLevel
    extends DefaultActionGroup
    implements DumbAware {
        public ChangeIsolationLevel() {
            this.setPopup(true);
            for (TxIsolation isolation : TxIsolation.values()) {
                this.add((AnAction)new IsolationLevelAction(isolation));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeIsolationLevel.$$$reportNull$$$0(0);
            }
            DataRequest.TxIsolationOwner owner = TransactionAction.getTxIsolationOwner(e);
            Dbms family = TransactionAction.getDbms(owner);
            boolean enabled = owner != null && family != null && TransactionAction.isTransactionsSupported(family) && TxIsolation.levelsSupported(family);
            e.getPresentation().setEnabledAndVisible(enabled);
            if (enabled && ActionPlaces.isPopupPlace((String)e.getPlace())) {
                e.getPresentation().setText(DatabaseBundle.messagePointer((String)"action.tx.isolation.text", (Object[])new Object[]{TxIsolation.of(owner.getTxIsolation()).getName()}));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/TransactionAction$ChangeIsolationLevel", "update"));
        }
    }
}

