/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.ConsumerColumnRef;
import com.intellij.database.data.types.CustomPlaceholder;
import com.intellij.database.data.types.EqualsPredicateOperation;
import com.intellij.database.data.types.GreaterPredicateOperation;
import com.intellij.database.data.types.LessPredicateOperation;
import com.intellij.database.data.types.LikePredicateOperation;
import com.intellij.database.data.types.NotEqualsPredicateOperation;
import com.intellij.database.data.types.NullPredicateValue;
import com.intellij.database.data.types.PredicateOperation;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.StringPredicateValue;
import com.intellij.database.data.types.domain.LikeOpType;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.ide.actions.SmartPopupActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColumnFilterByGroup
extends ActionGroup
implements DumbAware {
    private static final FilterTemplate[] NULL_FILTER_TEMPLATES = new FilterTemplate[]{new NullFilterTemplate(false), new NullFilterTemplate(true)};
    private static final FilterTemplate[] FILTER_TEMPLATES = new FilterTemplate[]{new FilterTemplate(new EqualsPredicateOperation()), new FilterTemplate(NotEqualsPredicateOperation.INSTANCE), new FilterTemplate(GreaterPredicateOperation.INSTANCE), new FilterTemplate(LessPredicateOperation.INSTANCE), new LikeFilterTemplate(false), new LikeFilterTemplate(true)};

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(0);
        }
        boolean enabled = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && dataGrid.isFilteringSupported();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        DataGrid dataGrid;
        DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        if (dataGrid == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFilterByGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        if (selectionModel.getSelectedColumnCount() != 1 || selectionModel.getSelectedRowCount() != 1) {
            if (EMPTY_ARRAY == null) {
                ColumnFilterByGroup.$$$reportNull$$$0(2);
            }
            return EMPTY_ARRAY;
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        DataConsumer.Row row = (DataConsumer.Row)model.getRow(selectionModel.getSelectedRow());
        DataConsumer.Column column2 = (DataConsumer.Column)model.getColumn(selectionModel.getSelectedColumn());
        if (row == null || column2 == null) {
            if (EMPTY_ARRAY == null) {
                ColumnFilterByGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        boolean mergeNullAndComparePredicates = DataGridUtil.getDbms(dataGrid).isMongo();
        ArrayList<AnAction> children2 = new ArrayList<AnAction>();
        if (!mergeNullAndComparePredicates) {
            ColumnFilterByGroup.addActions(children2, dataGrid, row, column2);
            children2.add((AnAction)new Separator());
        }
        ColumnFilterByGroup.addGroupedByOperatorActions(children2, dataGrid, row, column2, mergeNullAndComparePredicates);
        AnAction[] anActionArray = children2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static void addActions(@NotNull List<AnAction> actions, @NotNull DataGrid grid, @NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2) {
        if (actions == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(6);
        }
        if (row == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(7);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(8);
        }
        for (FilterTemplate template : NULL_FILTER_TEMPLATES) {
            ContainerUtil.addIfNotNull(actions, (Object)((Object)ColumnFilterByGroup.createFilterAction(template, grid, new GridOperand(grid, row, column2), column2)));
        }
    }

    private static void addGroupedByOperatorActions(@NotNull List<AnAction> result, @NotNull DataGrid grid, @NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, boolean mergeNullAndComparePredicates) {
        if (result == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(9);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(10);
        }
        if (row == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(11);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(12);
        }
        for (FilterTemplate template : FILTER_TEMPLATES) {
            DdlBuilder groupNameBuilder = DbImplUtil.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), (DasObject)DataGridUtil.getDatabaseTable(grid));
            Dbms dbms = DataGridUtil.getDbms(grid);
            PredicateValue groupPresentationOperand = dbms.isMongo() ? PlaceholderOperand.INSTANCE.getPresentableValue() : new CustomPlaceholder("");
            ColumnFilterByGroup.produceWhereClause(groupNameBuilder, column2, grid, groupPresentationOperand, template.myOperation);
            @NlsSafe String groupName = groupNameBuilder.getStatement();
            if (groupName.isEmpty() || groupName.equals(DmlUtilKt.dmlGenerator(dbms).getEmptyWhereClause())) continue;
            SmartPopupActionGroup group = new SmartPopupActionGroup();
            group.getTemplatePresentation().setText(StringUtil.escapeMnemonics((String)groupName.trim()));
            ColumnFilterAction placeholderAction = ColumnFilterByGroup.createFilterAction(template, grid, PlaceholderOperand.INSTANCE, column2);
            GridOperand cellOperand = new GridOperand(grid, row, column2);
            ClipboardOperand clipboardOperand = new ClipboardOperand();
            boolean equalOperands = StringUtil.equals((CharSequence)cellOperand.getValue().getStr(), (CharSequence)clipboardOperand.getValue().getStr());
            ColumnFilterAction cellAction = ColumnFilterByGroup.createFilterAction(template, grid, cellOperand, column2);
            boolean addNullOperation = mergeNullAndComparePredicates && (template.myOperation instanceof EqualsPredicateOperation || template.myOperation instanceof NotEqualsPredicateOperation);
            ColumnFilterAction nullAction = addNullOperation ? ColumnFilterByGroup.createFilterAction(template, grid, NullOperand.INSTANCE, column2) : null;
            ColumnFilterAction clipboardAction = equalOperands ? null : ColumnFilterByGroup.createFilterAction(template, grid, clipboardOperand, column2);
            ArrayList actions = new ArrayList();
            ContainerUtil.addIfNotNull(actions, (Object)((Object)cellAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)clipboardAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)nullAction));
            ContainerUtil.addIfNotNull(actions, (Object)((Object)placeholderAction));
            group.addAll(actions);
            result.add((AnAction)group);
        }
    }

    @Nullable
    private static ColumnFilterAction createFilterAction(@NotNull FilterTemplate template, @NotNull DataGrid grid, @NotNull Operand operand, @NotNull DataConsumer.Column column2) {
        PreparedColumnFilterExpression preparedExpression;
        if (template == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(13);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(14);
        }
        if (operand == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(15);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(16);
        }
        return (preparedExpression = template.prepare(grid, column2, operand)) == null ? null : new ColumnFilterAction(preparedExpression);
    }

    static void produceWhereClause(@NotNull DdlBuilder builder, @NotNull DataConsumer.Column column2, @NotNull DataGrid grid, @NotNull PredicateValue value2, @NotNull PredicateOperation operation) {
        if (builder == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(17);
        }
        if (column2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(18);
        }
        if (grid == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(19);
        }
        if (value2 == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(20);
        }
        if (operation == null) {
            ColumnFilterByGroup.$$$reportNull$$$0(21);
        }
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        ValuesWhereClause whereClause2 = new ValuesWhereClause(Collections.singletonList(new Triple((Object)new ConsumerColumnRef(column2), (Object)value2, (Object)ContainerUtil.set((Object[])new PredicateOperation[]{operation}))), "", null);
        DbDataSource system = DataGridUtil.getDatabaseSystem(grid);
        SelectTask task = DmlTaskKt.allColumns(table).version(system == null ? null : system.getVersion()).build();
        DmlUtilKt.dmlGenerator(DataGridUtil.getDbms(grid)).produce(whereClause2, builder, task);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ColumnFilterByGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGroupedByOperatorActions";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFilterAction";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "produceWhereClause";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ColumnFilterAction
    extends DumbAwareAction {
        private final PreparedColumnFilterExpression myPreparedExpression;

        private ColumnFilterAction(@NotNull PreparedColumnFilterExpression expression) {
            if (expression == null) {
                ColumnFilterAction.$$$reportNull$$$0(0);
            }
            super(expression.getPresentableText());
            this.myPreparedExpression = expression;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                ColumnFilterAction.$$$reportNull$$$0(1);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            int completionOffset = this.myPreparedExpression.getCompletionOffset();
            GridHelper.get(DataGridUtil.getDbms(dataGrid)).setFilterText(dataGrid, this.myPreparedExpression.getText(), completionOffset);
            if (completionOffset == -1) {
                dataGrid.applyFilter();
            }
        }

        @NotNull
        public PreparedColumnFilterExpression getPreparedExpression() {
            PreparedColumnFilterExpression preparedColumnFilterExpression = this.myPreparedExpression;
            if (preparedColumnFilterExpression == null) {
                ColumnFilterAction.$$$reportNull$$$0(2);
            }
            return preparedColumnFilterExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnFilterByGroup$ColumnFilterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$ColumnFilterAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreparedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PreparedColumnFilterExpression {
        private final String myText;
        private final @NlsActions.ActionText String myPresentableText;
        private final int myCompletionOffset;

        PreparedColumnFilterExpression(@NotNull String fullText2, @NotNull @NlsActions.ActionText String presentableText, int completionOffset) {
            if (fullText2 == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(0);
            }
            if (presentableText == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(1);
            }
            this.myText = fullText2;
            this.myPresentableText = presentableText;
            this.myCompletionOffset = completionOffset;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int getCompletionOffset() {
            return this.myCompletionOffset;
        }

        @NlsActions.ActionText
        @NotNull
        public String getPresentableText() {
            String string = this.myPresentableText;
            if (string == null) {
                PreparedColumnFilterExpression.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnFilterByGroup$PreparedColumnFilterExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$PreparedColumnFilterExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NullFilterTemplate
    extends FilterTemplate {
        NullFilterTemplate(boolean isNotNull) {
            super(isNotNull ? NotEqualsPredicateOperation.INSTANCE : new EqualsPredicateOperation());
        }

        @Override
        @Nullable
        public PreparedColumnFilterExpression prepare(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @NotNull Operand operand) {
            if (grid == null) {
                NullFilterTemplate.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                NullFilterTemplate.$$$reportNull$$$0(1);
            }
            if (operand == null) {
                NullFilterTemplate.$$$reportNull$$$0(2);
            }
            return super.prepare(grid, column2, NullOperand.INSTANCE);
        }

        @Override
        protected boolean isAvailableFor(@NotNull Operand operand, @NotNull DataConsumer.Column column2) {
            if (operand == null) {
                NullFilterTemplate.$$$reportNull$$$0(3);
            }
            if (column2 == null) {
                NullFilterTemplate.$$$reportNull$$$0(4);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$NullFilterTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LikeFilterTemplate
    extends FilterTemplate {
        LikeFilterTemplate(boolean isNotLike) {
            super(new LikePredicateOperation(LikeOpType.CONTAINS, true, isNotLike));
        }

        @Override
        protected boolean isAvailableFor(@NotNull Operand operand, @NotNull DataConsumer.Column column2) {
            if (operand == null) {
                LikeFilterTemplate.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                LikeFilterTemplate.$$$reportNull$$$0(1);
            }
            return super.isAvailableFor(operand, column2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operand";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$LikeFilterTemplate";
            objectArray[2] = "isAvailableFor";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilterTemplate {
        private final PredicateOperation myOperation;

        FilterTemplate(@NotNull PredicateOperation operation) {
            if (operation == null) {
                FilterTemplate.$$$reportNull$$$0(0);
            }
            this.myOperation = operation;
        }

        @Nullable
        public PreparedColumnFilterExpression prepare(@NotNull DataGrid grid, @NotNull DataConsumer.Column column2, @NotNull Operand operand) {
            if (grid == null) {
                FilterTemplate.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(2);
            }
            if (operand == null) {
                FilterTemplate.$$$reportNull$$$0(3);
            }
            if (!this.isAvailableFor(operand, column2)) {
                return null;
            }
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            DdlBuilder presentableTextBuilder = DbImplUtil.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), (DasObject)table);
            DdlBuilder textBuilder = DbImplUtil.createBuilderForUIExec(DataGridUtil.getDatabaseDialect(grid), (DasObject)table);
            ColumnFilterByGroup.produceWhereClause(presentableTextBuilder, column2, grid, operand.getPresentableValue(), this.myOperation);
            ColumnFilterByGroup.produceWhereClause(textBuilder, column2, grid, operand.getValue(), this.myOperation);
            String text2 = textBuilder.getStatement();
            String presentableText = StringUtil.escapeMnemonics((String)presentableTextBuilder.getStatement());
            Dbms dbms = DataGridUtil.getDbms(grid);
            if (text2.isEmpty() || text2.equals(DmlUtilKt.dmlGenerator(dbms).getEmptyWhereClause()) || presentableText.isEmpty() || text2.contains("\n")) {
                return null;
            }
            int completionOffset = operand instanceof PlaceholderOperand ? FilterTemplate.guessCompletionOffset(dbms, text2) : -1;
            return new PreparedColumnFilterExpression(text2, presentableText, completionOffset);
        }

        private static int guessCompletionOffset(@NotNull Dbms dbms, @NotNull String text2) {
            if (dbms == null) {
                FilterTemplate.$$$reportNull$$$0(4);
            }
            if (text2 == null) {
                FilterTemplate.$$$reportNull$$$0(5);
            }
            if (dbms.isMongo()) {
                int offset = text2.length() - 1;
                while (text2.charAt(offset) == '}') {
                    --offset;
                }
                while (text2.charAt(offset) == ')') {
                    --offset;
                }
                if (text2.charAt(offset) == '\'' || text2.charAt(offset) == '\"') {
                    --offset;
                }
                return offset + 1;
            }
            return text2.endsWith("'%%'") ? text2.length() - 2 : (text2.endsWith("''") ? text2.length() - 1 : (text2.endsWith("\"\"") ? text2.length() - 1 : text2.length()));
        }

        protected boolean isAvailableFor(@NotNull Operand op, @NotNull DataConsumer.Column column2) {
            if (op == null) {
                FilterTemplate.$$$reportNull$$$0(6);
            }
            if (column2 == null) {
                FilterTemplate.$$$reportNull$$$0(7);
            }
            return op.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "op";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$FilterTemplate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guessCompletionOffset";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClipboardOperand
    implements Operand {
        private ClipboardOperand() {
        }

        @Override
        @NotNull
        public StringPredicateValue getValue() {
            return new StringPredicateValue((String)ObjectUtils.notNull((Object)ClipboardOperand.getContent(), (Object)""), true);
        }

        @Override
        @NotNull
        public PredicateValue getPresentableValue() {
            return new StringPredicateValue(StringUtil.trimMiddle((String)((String)ObjectUtils.notNull((Object)ClipboardOperand.getContent(), (Object)"")), (int)50), true);
        }

        @Override
        public boolean isValid() {
            return ClipboardOperand.getContent() != null;
        }

        @Nullable
        private static String getContent() {
            return StringUtil.nullize((String)((String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor)));
        }
    }

    private static class GridOperand
    implements Operand {
        private final DataGrid myGrid;
        private final DataConsumer.Row myRow;
        private final DataConsumer.Column myColumn;

        GridOperand(@NotNull DataGrid grid, @NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2) {
            if (grid == null) {
                GridOperand.$$$reportNull$$$0(0);
            }
            if (row == null) {
                GridOperand.$$$reportNull$$$0(1);
            }
            if (column2 == null) {
                GridOperand.$$$reportNull$$$0(2);
            }
            this.myGrid = grid;
            this.myRow = row;
            this.myColumn = column2;
        }

        @Override
        @NotNull
        public StringPredicateValue getValue() {
            return new StringPredicateValue(this.myGrid.getObjectFormatter().getPlainValue(this.myColumn, this.myRow, DataGridUtil.getDbms(this.myGrid)), false);
        }

        @Override
        @NotNull
        public PredicateValue getPresentableValue() {
            String value2 = this.myGrid.getObjectFormatter().getPlainValue(this.myColumn, this.myRow, DataGridUtil.getDbms(this.myGrid));
            return new StringPredicateValue(StringUtil.trimMiddle((String)value2, (int)50), false);
        }

        @Override
        public boolean isValid() {
            Object value2 = this.myColumn.getValue(this.myRow);
            return value2 != null && value2 != ReservedCellValue.UNSET;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/ColumnFilterByGroup$GridOperand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NullOperand
    implements Operand {
        static final Operand INSTANCE = new NullOperand();

        private NullOperand() {
        }

        @Override
        @NotNull
        public NullPredicateValue getValue() {
            NullPredicateValue nullPredicateValue = NullPredicateValue.INSTANCE;
            if (nullPredicateValue == null) {
                NullOperand.$$$reportNull$$$0(0);
            }
            return nullPredicateValue;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ColumnFilterByGroup$NullOperand", "getValue"));
        }
    }

    private static class PlaceholderOperand
    implements Operand {
        static final Operand INSTANCE = new PlaceholderOperand();

        private PlaceholderOperand() {
        }

        @Override
        @NotNull
        public StringPredicateValue getValue() {
            return new StringPredicateValue("", false);
        }

        @Override
        @NotNull
        public PredicateValue getPresentableValue() {
            return new CustomPlaceholder("...");
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    private static interface Operand {
        @NotNull
        public PredicateValue getValue();

        @NotNull
        default public PredicateValue getPresentableValue() {
            PredicateValue predicateValue = this.getValue();
            if (predicateValue == null) {
                Operand.$$$reportNull$$$0(0);
            }
            return predicateValue;
        }

        public boolean isValid();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/ColumnFilterByGroup$Operand", "getPresentableValue"));
        }
    }
}

