/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColumnAction
extends DumbAwareAction {
    protected boolean isEnabled(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns, AnActionEvent e) {
        return true;
    }

    protected boolean availableInTable() {
        return false;
    }

    protected abstract void actionPerformed(DataGrid var1, List<ModelIndex<DataConsumer.Column>> var2);

    public void update(@NotNull AnActionEvent e) {
        List<ModelIndex<DataConsumer.Column>> columns;
        if (e == null) {
            ColumnAction.$$$reportNull$$$0(0);
        }
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        boolean enabled = false;
        if (dataGrid != null && !(columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable())).isEmpty()) {
            enabled = this.isEnabled(dataGrid, columns, e);
        }
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ColumnAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        List<ModelIndex<DataConsumer.Column>> columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
        if (columns.isEmpty()) {
            return;
        }
        this.actionPerformed(dataGrid, columns);
    }

    private static List<ModelIndex<DataConsumer.Column>> getSelectedColumns(@Nullable DataGrid dataGrid, @NotNull DataContext dataContext, boolean allowInTable) {
        PsiElement[] selectedPsi;
        if (dataContext == null) {
            ColumnAction.$$$reportNull$$$0(2);
        }
        if ((selectedPsi = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext)) == null) {
            return allowInTable && dataGrid != null ? dataGrid.getSelectionModel().getSelectedColumns().asList() : Collections.emptyList();
        }
        ArrayList<ModelIndex<DataConsumer.Column>> result = new ArrayList<ModelIndex<DataConsumer.Column>>(selectedPsi.length);
        for (PsiElement element2 : selectedPsi) {
            DataGridPomTarget.Cell cell;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(element2);
            if (target != null && target.dataGrid == dataGrid) {
                result.add(target.column);
                continue;
            }
            DataGridPomTarget.Cell cell2 = cell = allowInTable ? DataGridPomTarget.unwrapCell(element2) : null;
            if (cell == null || cell.dataGrid != dataGrid) continue;
            cell.columns.asIterable().addAllTo(result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/ColumnAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectedColumns";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SortReset
    extends SortAction {
        @Override
        protected RowSortOrder.Type getSortOrder() {
            return RowSortOrder.Type.UNSORTED;
        }
    }

    public static class SortDesc
    extends SortAction {
        @Override
        protected RowSortOrder.Type getSortOrder() {
            return RowSortOrder.Type.DESC;
        }
    }

    public static class SortAsc
    extends SortAction {
        @Override
        protected RowSortOrder.Type getSortOrder() {
            return RowSortOrder.Type.ASC;
        }
    }

    private static abstract class SortAction
    extends ColumnAction {
        private SortAction() {
        }

        @Override
        protected boolean availableInTable() {
            return true;
        }

        protected abstract RowSortOrder.Type getSortOrder();

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns) {
            dataGrid.sortColumns(columns, this.getSortOrder());
        }
    }

    public static class Visibility
    extends ColumnAction {
        @Override
        protected boolean isEnabled(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns, AnActionEvent e) {
            boolean toShow = Visibility.toShow(dataGrid, columns);
            boolean single = columns.size() == 1;
            e.getPresentation().setText((toShow ? DatabaseBundle.message((String)"action.ColumnAction.Visibility.show.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.ColumnAction.Visibility.hide.text", (Object[])new Object[0])) + " " + (single ? DatabaseBundle.message((String)"action.ColumnAction.Visibility.column.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.ColumnAction.Visibility.columns.text", (Object[])new Object[0])));
            return true;
        }

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns) {
            boolean toShow = Visibility.toShow(dataGrid, columns);
            for (ModelIndex<DataConsumer.Column> c2 : columns) {
                dataGrid.setColumnEnabled(c2, toShow);
            }
        }

        private static boolean toShow(DataGrid dataGrid, List<ModelIndex<DataConsumer.Column>> columns) {
            ModelIndex column2 = (ModelIndex)ContainerUtil.getFirstItem(columns);
            return column2 != null && !dataGrid.isColumnEnabled(column2);
        }
    }
}

