/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.actions.AddRowAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.treetable.TreeTableResultView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CloneRowAction
extends DumbAwareAction
implements GridAction {
    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            CloneRowAction.$$$reportNull$$$0(0);
        }
        boolean available = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && dataGrid.getSelectionModel().getSelectedRowCount() == 1 && AddRowAction.canAddRow(dataGrid) && !dataGrid.isEditing();
        e.getPresentation().setEnabledAndVisible(available);
    }

    private static boolean hasTruncatedData(DataConsumer.Row row) {
        for (Object value2 : row.values) {
            if (!(value2 instanceof LobInfo) || !((LobInfo)value2).isTruncated()) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        ModelIndex<DataConsumer.Row> selectedRow;
        if (e == null) {
            CloneRowAction.$$$reportNull$$$0(1);
        }
        ModelIndex<DataConsumer.Row> modelIndex = selectedRow = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null ? dataGrid.getSelectionModel().getSelectedRow() : null;
        if (selectedRow != null && selectedRow.isValid(dataGrid)) {
            DataConsumer.Row row = (DataConsumer.Row)dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRow(selectedRow);
            if (row != null && CloneRowAction.hasTruncatedData(row)) {
                String message2 = DatabaseBundle.message((String)"Console.TableResult.cannotCloneRow", (Object[])new Object[0]);
                CloneRowAction.showBalloon(dataGrid, message2);
            } else {
                dataGrid.cloneRow(selectedRow);
            }
        }
    }

    private static void showBalloon(@NotNull DataGrid dataGrid, @NlsContexts.PopupContent @NotNull String message2) {
        RelativePoint point;
        if (dataGrid == null) {
            CloneRowAction.$$$reportNull$$$0(2);
        }
        if (message2 == null) {
            CloneRowAction.$$$reportNull$$$0(3);
        }
        ResultView view2 = dataGrid.getResultView();
        Balloon.Position position = Balloon.Position.below;
        if (view2 instanceof TableResultView) {
            point = JBPopupFactory.getInstance().guessBestPopupLocation(view2.getComponent());
        } else if (view2 instanceof TreeTableResultView) {
            point = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)((TreeTableResultView)view2).getComponent().getTree());
        } else {
            GridMainPanel component = dataGrid.getComponent();
            point = new RelativePoint((Component)((Object)component), new Point(component.getWidth() / 3, component.getHeight()));
            position = Balloon.Position.above;
        }
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.WARNING, null).createBalloon().show(point, position);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/actions/CloneRowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showBalloon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

