/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.popup.PopupState;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooseSchemaAction
extends AlignedIconWithTextAction.Group
implements DumbAware {
    private final PopupState<JBPopup> myPopupState = PopupState.forPopup();
    private static final Comparator<ObjectPath> PATH_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    private static final FileAttribute LEGACY_SEARCH_PATH_ATTRIBUTE = new FileAttribute("datasource_namespace", 2, true);
    private static final PerProjectFileAttributes ourSearchPathAttributes = new PerProjectFileAttributes("datasource.namespace", 1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(0);
        }
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        if (console == null) {
            return;
        }
        WizardPopup popup = ChooseSchemaAction.createPopupForStep(console.getProject(), null, ChooseSchemaAction.createInitialStep(console), null);
        this.myPopupState.prepareToShow((Object)popup);
        DbUIUtil.showPopup((JBPopup)popup, null, e);
        popup.pack(true, true);
    }

    public void update(@NotNull AnActionEvent e) {
        ObjectKind kind;
        if (e == null) {
            ChooseSchemaAction.$$$reportNull$$$0(1);
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        Presentation presentation = e.getPresentation();
        ObjectKind objectKind = kind = console == null ? null : DbImplUtil.getDatabaseDialect(console).getSearchPathObjectKind();
        if (console == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        List schemas = SearchPath.getElements((SearchPath)console.getSearchPath());
        if (schemas.isEmpty() || ((ObjectPath)schemas.get((int)0)).kind == ObjectKind.NONE) {
            schemas = SearchPath.getElements((SearchPath)((SearchPath)DatabaseDataKeys.SEARCH_PATH_KEY.get((UserDataHolder)console.getFile())));
        }
        ObjectKind expected = (ObjectKind)ObjectUtils.chooseNotNull((Object)kind, (Object)ObjectKind.SCHEMA);
        boolean shorter = !schemas.isEmpty() && ((ObjectPath)schemas.get((int)0)).kind != expected;
        boolean isToolbar = e.isFromActionToolbar();
        String schemasText = isToolbar && !schemas.isEmpty() ? DbImplUtil.searchPathPresentation(schemas) : "";
        String placeholder = StringUtil.toLowerCase((String)expected.name());
        String text2 = !isToolbar ? DatabaseBundle.message((String)"action.ChooseSchema.text", (Object[])new Object[0]) : StringUtil.shortenTextWithEllipsis((String)(StringUtil.isEmpty((String)schemasText) ? "<" + placeholder + ">" : (shorter ? schemasText + ".<" + placeholder + ">" : schemasText)), (int)30, (int)0);
        presentation.setText(text2, false);
        presentation.setDescription(DatabaseBundle.message((String)"action.ChooseSchema.description", (Object[])new Object[0]));
        presentation.setIcon(e.isFromActionToolbar() ? DbPresentation.getIcon(expected) : null);
    }

    private static WizardPopup createPopupForStep(@Nullable Project project, @Nullable WizardPopup parent2, @NotNull ListPopupStep<ObjectPath> step, @Nullable ObjectPath parentValue) {
        if (step == null) {
            ChooseSchemaAction.$$$reportNull$$$0(2);
        }
        if (step instanceof SearchPathStep) {
            return new SearchPathPopup(project, parent2, (SearchPathStep)step, parentValue);
        }
        if (step instanceof DbScStep) {
            return new DbScListPopup(project, parent2, (DbScStep)step, parentValue);
        }
        return new SimpleListPopup(project, parent2, step, parentValue);
    }

    @NotNull
    private static ListPopupStep<ObjectPath> createInitialStep(@NotNull JdbcConsole console) {
        DatabaseDialectEx dialect;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(3);
        }
        if ((dialect = DbImplUtil.getDatabaseDialect(console)).getSearchPathObjectKind() != ObjectKind.DATABASE && (JdbcUrlParserUtil.isDatabaseBounded((DatabaseConnectionPoint)console.getTarget()) || dialect.sqlSetSearchPath(SearchPath.of((ObjectPath)ObjectPath.create((String)"test", (ObjectKind)ObjectKind.DATABASE))) != null)) {
            DbScStep dbScStep = DbScStep.create(console);
            if (dbScStep == null) {
                ChooseSchemaAction.$$$reportNull$$$0(4);
            }
            return dbScStep;
        }
        BaseStep baseStep = dialect.supportsSearchPath() ? new SearchPathStep(console) : SingleScOrDbStep.create(console);
        if (baseStep == null) {
            ChooseSchemaAction.$$$reportNull$$$0(5);
        }
        return baseStep;
    }

    public static void scheduleSavedSchemaSwitch(@NotNull JdbcConsole console) {
        SearchPath o;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(6);
        }
        if ((o = ChooseSchemaAction.getSchemaToSwitchToInner(console)) == null) {
            return;
        }
        SearchPath path = DbImplUtil.getAutoSwitchPath(console.getDataSource(), o);
        if (path == null) {
            return;
        }
        console.switchSchema(path, false);
        DatabaseDataKeys.SEARCH_PATH_KEY.set((UserDataHolder)console.getFile(), (Object)path);
    }

    @Nullable
    private static SearchPath getSchemaToSwitchToInner(@NotNull JdbcConsole console) {
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(7);
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
        SearchPath schemaPaths = ChooseSchemaAction.getSelectedSearchPath(console.getProject(), console.getVirtualFile(), dialect);
        if (schemaPaths != null && schemaPaths.getCurrent().kind != ObjectKind.NONE) {
            LocalDataSource localDataSource = console.getDataSource();
            if (localDataSource.isLoading()) {
                DataSourceUiUtil.promiseFacadeUpdate(DbPsiFacade.getInstance((Project)console.getProject()), console).onProcessed(o -> ChooseSchemaAction.scheduleSavedSchemaSwitch(console));
            } else {
                return SearchPath.of((List)JBIterable.from((Iterable)SearchPath.getElements((SearchPath)schemaPaths)).filter(p2 -> (p2.kind == ObjectKind.SCHEMA || p2.kind == ObjectKind.DATABASE) && DatabaseEditorHelper.findNamespace(console.getProject(), localDataSource, p2) != null).toList());
            }
        }
        return null;
    }

    public static void setSelectedSearchPath(@NotNull Project project, @NotNull VirtualFile file, @Nullable SearchPath schemaPaths) {
        FileAttribute attribute;
        if (project == null) {
            ChooseSchemaAction.$$$reportNull$$$0(8);
        }
        if (file == null) {
            ChooseSchemaAction.$$$reportNull$$$0(9);
        }
        if ((attribute = ourSearchPathAttributes.get(project)) != null) {
            DbImplUtil.writeVFSAttributeSafe(file, attribute, ChooseSchemaAction.serialize(schemaPaths));
        }
    }

    @Nullable
    private static SearchPath getSelectedSearchPath(@NotNull Project project, @NotNull VirtualFile file, @NotNull DatabaseDialectEx dialect) {
        if (project == null) {
            ChooseSchemaAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ChooseSchemaAction.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            ChooseSchemaAction.$$$reportNull$$$0(12);
        }
        BasicMetaModel metaModel = DbImplUtil.getMetaModel(dialect.getDbms());
        String legacyValue = DbImplUtil.readVFSAttributeSafe(file, LEGACY_SEARCH_PATH_ATTRIBUTE);
        if (legacyValue != null) {
            DbImplUtil.writeVFSAttributeSafe(file, LEGACY_SEARCH_PATH_ATTRIBUTE, null);
            FileAttribute attributes2 = ourSearchPathAttributes.get(project);
            if (attributes2 != null) {
                DbImplUtil.writeVFSAttributeSafe(file, attributes2, legacyValue);
            }
            return ChooseSchemaAction.deserializeList(legacyValue, metaModel);
        }
        FileAttribute attribute = ourSearchPathAttributes.get(project);
        if (attribute == null) {
            return null;
        }
        String value2 = DbImplUtil.readVFSAttributeSafe(file, attribute);
        return ChooseSchemaAction.deserializeList(value2, metaModel);
    }

    @Nullable
    private static SearchPath deserializeList(@Nullable String o, @NotNull MetaModel metaModel) {
        if (metaModel == null) {
            ChooseSchemaAction.$$$reportNull$$$0(13);
        }
        if (o == null) {
            return null;
        }
        return SearchPath.of((List)JBIterable.of((Object[])o.split(",")).transform(x -> ObjectPaths.deserialize(x, metaModel)).toList());
    }

    @Contract(value="!null->!null")
    private static String serialize(@Nullable SearchPath o) {
        if (o == null) {
            return null;
        }
        return StringUtil.join((Collection)o.elements, ObjectPaths::serialize, (String)",");
    }

    @NlsContexts.Label
    @NotNull
    private static String getText(ObjectPath value2) {
        if (value2 == null) {
            return "";
        }
        String text2 = value2.getName();
        String string = text2.isEmpty() ? DatabaseBundle.message((String)"label.unnamed", (Object[])new Object[]{value2.kind.getPresentableName()}) : text2;
        if (string == null) {
            ChooseSchemaAction.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static boolean canSwitchTo(DatabaseDialectEx dialect, ObjectPath path) {
        return DbImplUtil.canSwitchTo(SearchPath.of((ObjectPath)path), dialect);
    }

    private static void switchSearchPath(@NotNull JdbcConsole console, @NotNull SearchPath path) {
        DatabaseDialectEx dialect;
        if (console == null) {
            ChooseSchemaAction.$$$reportNull$$$0(15);
        }
        if (path == null) {
            ChooseSchemaAction.$$$reportNull$$$0(16);
        }
        if ((dialect = DbImplUtil.getDatabaseDialect(console)).getSearchPathObjectKind() != null) {
            ApplicationManager.getApplication().invokeLater(() -> console.switchSchema(path, true));
            return;
        }
        final ObjectPath current = path.getCurrent();
        console.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(console){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection2) throws Exception {
                RemoteConnection c2 = connection2.getRemoteConnection();
                if (current.kind == ObjectKind.SCHEMA) {
                    c2.setSchema(current.getName());
                    if (!Objects.equals(current.getName(), c2.getSchema())) {
                        throw new UnsupportedOperationException(DatabaseBundle.message((String)"action.ChooseSchema.jdbc.switch.sc", (Object[])new Object[0]));
                    }
                } else if (current.kind == ObjectKind.DATABASE) {
                    c2.setCatalog(current.getName());
                    if (!Objects.equals(current.getName(), c2.getCatalog())) {
                        throw new UnsupportedOperationException(DatabaseBundle.message((String)"action.ChooseSchema.jdbc.switch.db", (Object[])new Object[0]));
                    }
                } else {
                    throw new UnsupportedOperationException(StringUtil.capitalize((String)StringUtil.toLowerCase((String)current.kind.toString())) + " switch is not supported by driver");
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaModel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitialStep";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPopupForStep";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStep";
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scheduleSavedSchemaSwitch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaToSwitchToInner";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedSearchPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedSearchPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "switchSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class ElementWithControlRenderer<T>
    extends PopupListElementRenderer<T> {
        private int myControlIndex;
        public final Color UNFOCUSED;

        ElementWithControlRenderer(final @NotNull ListPopupImpl popup) {
            if (popup == null) {
                ElementWithControlRenderer.$$$reportNull$$$0(0);
            }
            super(popup);
            this.myControlIndex = -1;
            this.UNFOCUSED = UIUtil.mix((Color)this.getSelectionBackground(), (Color)this.getBackground(), (double)0.2);
            popup.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    int i2;
                    JList list = popup.getList();
                    int i0 = myControlIndex;
                    int i1 = list.locationToIndex(e.getPoint());
                    int n = i2 = i1 != -1 && !this.isInControlZone(i1, e.getPoint()) ? -1 : i1;
                    if (i0 < 0 && i1 < 0) {
                        return;
                    }
                    myControlIndex = i2;
                    Rectangle bounds = list.getCellBounds(i0 < 0 ? i1 : i0, i1 < 0 ? i0 : i1);
                    list.repaint(bounds);
                }
            });
            this.myNextStepLabel.setHorizontalAlignment(0);
            this.myNextStepLabel.setOpaque(true);
            ((JComponent)this.myTextLabel.getParent()).setBorder((Border)JBUI.Borders.empty((int)UIUtil.getListCellVPadding(), (int)0));
        }

        protected void highlightZones(JList<? extends T> list, T value2) {
            boolean ctrl = this.isControl(list, value2);
            if (ctrl) {
                UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)this.UNFOCUSED);
            }
            if (this.myNextStepLabel.getIcon() != null) {
                this.myNextStepLabel.setBackground(ctrl ? this.getSelectionBackground() : this.UNFOCUSED);
            }
        }

        protected boolean isControl(JList<? extends T> list, T value2) {
            return this.myControlIndex != -1 && this.myControlIndex < list.getModel().getSize() && list.getModel().getElementAt(this.myControlIndex) == value2;
        }

        protected abstract boolean isInControlZone(int var1, Point var2);

        protected Border getDefaultItemComponentBorder() {
            return JBUI.Borders.emptyLeft((int)UIUtil.getListCellHPadding());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/database/run/actions/ChooseSchemaAction$ElementWithControlRenderer", "<init>"));
        }
    }

    private static class DbScListPopup
    extends SimpleListPopup {
        private static final int ZONE_SIZE = 20;

        DbScListPopup(@Nullable Project project, @Nullable WizardPopup parent2, @NotNull DbScStep step, @Nullable ObjectPath parentValue) {
            if (step == null) {
                DbScListPopup.$$$reportNull$$$0(0);
            }
            super(project, parent2, step, parentValue);
            Dimension sz = new Dimension(0, 0);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.updateAdvertisement(i2 % 2 == 0, i2 / 2 == 0);
                Dimension pref = this.getContent().getPreferredSize();
                sz.width = Math.max(sz.width, pref.width);
                sz.height = Math.max(sz.height, pref.height);
            }
            sz.width = this.trimWidth(sz.width + 20);
            this.getContent().setPreferredSize(sz);
            this.updateAdvertisement(this.getMousePos());
            this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateAdvertisement(e.getPoint());
                }
            });
            Insets padding = UIUtil.getListViewportPadding();
            this.getList().setBorder((Border)JBUI.Borders.empty((int)padding.top, (int)padding.left, (int)padding.bottom, (int)0));
        }

        private void updateAdvertisement(@NotNull Point pt) {
            int idx;
            if (pt == null) {
                DbScListPopup.$$$reportNull$$$0(1);
            }
            this.updateAdvertisement((idx = this.getList().locationToIndex(pt)) != -1 && this.isInControlZone(idx, pt), idx != -1 && idx == this.getStep().getDefaultOptionIndex());
        }

        private void updateAdvertisement(boolean ctrl, boolean cur2) {
            if (ctrl) {
                this.setAdText(DatabaseBundle.message((String)"action.ChooseSchema.db.configure.ad", (Object[])new Object[0]));
            } else if (cur2) {
                this.setAdText(DatabaseBundle.message((String)"action.ChooseSchema.db.default.ad", (Object[])new Object[0]));
            } else {
                this.setAdText(DatabaseBundle.message((String)"action.ChooseSchema.db.connect.ad", (Object[])new Object[0]));
            }
        }

        protected boolean handleFinalChoices(MouseEvent e, Object selectedValue, ListPopupStep<Object> listStep) {
            int index2 = this.getList().locationToIndex(e.getPoint());
            if (index2 == -1) {
                return super.handleFinalChoices(e, selectedValue, listStep);
            }
            return !this.isInControlZone(index2, e.getPoint());
        }

        public void handleSelect(boolean handleFinalChoices) {
            if (handleFinalChoices) {
                this.disposeChildren();
            }
            super.handleSelect(handleFinalChoices);
        }

        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (handleFinalChoices) {
                this.disposeChildren();
            }
            super.handleSelect(handleFinalChoices, e);
        }

        public DbScStep getStep() {
            return (DbScStep)super.getStep();
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        private boolean isInControlZone(int index2, Point pt) {
            Rectangle bounds = this.getList().getCellBounds(index2, index2);
            ObjectPath val = this.getList().getModel().getElementAt(index2);
            return bounds.contains(pt) && pt.x > bounds.x + bounds.width - 20 && this.getStep().hasSubstep(val);
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new ElementWithControlRenderer<ObjectPath>((ListPopupImpl)this){
                {
                    super(popup);
                    this.myNextStepLabel.setPreferredSize(new Dimension(20, 20));
                }

                protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value2, boolean isSelected) {
                    super.customizeComponent(list, (Object)value2, isSelected);
                    if (isSelected) {
                        this.highlightZones(list, value2);
                    } else if (myChild instanceof SimpleListPopup && myChild.isVisible() && ((SimpleListPopup)myChild).getParentValue() == value2) {
                        UIUtil.setBackgroundRecursively((Component)this.myComponent, (Color)UIUtil.getListSelectionBackground((boolean)false));
                    }
                }

                @Override
                protected boolean isInControlZone(int idx, Point pt) {
                    return this.isInControlZone(idx, pt);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pt";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScListPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAdvertisement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SearchPathPopup
    extends SimpleListPopup {
        private static final int ZONE_SIZE = 30;
        private final JComponent myButtonsPanel;

        SearchPathPopup(@Nullable Project project, @Nullable WizardPopup parent2, @NotNull SearchPathStep step, @Nullable ObjectPath parentValue) {
            if (step == null) {
                SearchPathPopup.$$$reportNull$$$0(0);
            }
            super(project, parent2, step, parentValue);
            this.registerAction("Select schema", 10, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.replaceItem(this.getSelectedValue(), this.getStep());
                    this.apply();
                }
            });
            this.registerAction("Apply schemas", 10, 2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.apply();
                }
            });
            this.registerAction("Toggle schema", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.toggleItem(this.getSelectedValue());
                }
            });
            new AnAction(ApplicationBundle.message((String)"arrangement.action.rule.move.up.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.moveItem(this.getSelectedValue(), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup$4", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_UP, this.getList());
            new AnAction(ApplicationBundle.message((String)"arrangement.action.rule.move.down.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    this.moveItem(this.getSelectedValue(), false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup$5", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.MOVE_DOWN, this.getList());
            this.getList().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    boolean ctrl;
                    int listIdx = this.getList().locationToIndex(e.getPoint());
                    if (listIdx == -1) {
                        return;
                    }
                    ObjectPath item = this.getList().getModel().getElementAt(listIdx);
                    if (item == null) {
                        return;
                    }
                    SearchPathStep step = this.getStep();
                    boolean bl = ctrl = (e.getModifiers() & 2) != 0 || this.isInControlZone(listIdx, e.getPoint());
                    if (ctrl) {
                        this.toggleItem(item);
                    } else {
                        this.replaceItem(item, step);
                    }
                }
            });
            RowsDnDSupport.install(this.getList(), (EditableModel)new EditableModel(){

                public void addRow() {
                    throw new UnsupportedOperationException();
                }

                public void exchangeRows(int oldIndex, int newIndex) {
                    SearchPathStep step = this.getStep();
                    ObjectPath item = step.getValues().get(oldIndex);
                    List<ObjectPath> path = step.getPathItems();
                    if (newIndex <= path.size()) {
                        step.moveInPath(item, newIndex);
                    } else if (path.contains(item)) {
                        step.removeFromPath(item);
                    } else {
                        return;
                    }
                    this.update(item);
                }

                public boolean canExchangeRows(int oldIndex, int newIndex) {
                    List<ObjectPath> path = this.getStep().getPathItems();
                    return oldIndex <= path.size() || newIndex <= path.size();
                }

                public void removeRow(int idx) {
                    throw new UnsupportedOperationException();
                }
            });
            Dimension sz = new Dimension(0, 0);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.updateAdvertisement(i2 % 2 == 0, i2 / 2 == 0);
                Dimension pref = this.getContent().getPreferredSize();
                sz.width = Math.max(sz.width, pref.width);
                sz.height = Math.max(sz.height, pref.height);
            }
            int extra = 20;
            if (step.getPathItems().isEmpty()) {
                sz.height += extra;
            }
            if (step.getPathItems().size() == step.getValues().size()) {
                sz.height += extra;
            }
            sz.width = this.trimWidth(sz.width + extra);
            this.getContent().setPreferredSize(sz);
            this.updateAdvertisement(this.getMousePos());
            this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.updateAdvertisement(e.getPoint());
                }
            });
            Insets padding = UIUtil.getListViewportPadding();
            this.getList().setBorder((Border)JBUI.Borders.empty((int)padding.top, (int)padding.left, (int)padding.bottom, (int)0));
            this.myButtonsPanel = new JPanel(new GridLayout(1, 2));
            this.getContent().add((Component)JBUI.Panels.simplePanel().addToCenter((Component)this.getComponent()).addToBottom((Component)this.myButtonsPanel), "Center");
            GridConstraints constraints = new GridConstraints();
            this.myButtonsPanel.add((Component)new JButton(new AbstractAction(CommonBundle.getOkButtonText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.apply();
                }
            }), constraints);
            constraints.setColumn(1);
            this.myButtonsPanel.add(new JButton(new AbstractAction(CommonBundle.getCancelButtonText()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchPathStep step = this.getStep();
                    step.reset();
                    this.update(null);
                }
            }));
            this.myButtonsPanel.setVisible(false);
        }

        public void apply() {
            SearchPathStep step = this.getStep();
            JdbcConsole console = step.getConsole();
            SearchPath p2 = SearchPath.of(step.getPathItems());
            if (p2 != null && !p2.equals((Object)console.getSearchPath())) {
                ChooseSchemaAction.switchSearchPath(console, p2);
            }
            this.closeOk(null);
            this.disposeAllParents(null);
        }

        public void replaceItem(ObjectPath item, SearchPathStep step) {
            if (item == null) {
                return;
            }
            int idx = step.getValues().indexOf(item);
            for (ObjectPath path : new ArrayList<ObjectPath>(step.getPathItems())) {
                step.removeFromPath(path);
            }
            step.moveInPath(item, 0);
            if (idx != -1) {
                item = step.getValues().get(idx);
            }
            this.update(item);
        }

        public JList<ObjectPath> getList() {
            return super.getList();
        }

        @Nullable
        private ObjectPath getSelectedValue() {
            return this.getList().getSelectedValue();
        }

        private boolean isInControlZone(int index2, Point pt) {
            ObjectPath val = this.getList().getModel().getElementAt(index2);
            List<ObjectPath> items2 = this.getStep().getPathItems();
            if (items2.size() < 2 && items2.contains(val)) {
                return false;
            }
            Rectangle bounds = this.getList().getCellBounds(index2, index2);
            return bounds.contains(pt) && pt.x > bounds.x + bounds.width - 30;
        }

        private void toggleItem(@Nullable ObjectPath item) {
            if (item == null) {
                return;
            }
            SearchPathStep step = this.getStep();
            List<ObjectPath> path = step.getPathItems();
            int idx = path.indexOf(item);
            if (idx != -1 && path.size() < 2) {
                return;
            }
            if (idx != -1) {
                step.removeFromPath(item);
                item = idx < path.size() ? path.get(idx) : path.get(path.size() - 1);
            } else {
                List<ObjectPath> values2 = step.getValues();
                idx = values2.indexOf(item);
                step.moveInPath(item, path.size());
                values2 = step.getValues();
                item = idx + 1 < values2.size() ? values2.get(idx + 1) : values2.get(values2.size() - 1);
            }
            this.update(item);
        }

        private void moveItem(@Nullable ObjectPath item, boolean up) {
            if (item == null) {
                return;
            }
            SearchPathStep step = this.getStep();
            List<ObjectPath> path = step.getPathItems();
            int idx = path.indexOf(item);
            if (idx != -1) {
                if (!up && idx + 1 == path.size() || up && idx == 0) {
                    if (path.size() < 2) {
                        return;
                    }
                    step.removeFromPath(item);
                } else {
                    step.moveInPath(item, idx + (up ? -1 : 2));
                }
            } else {
                step.moveInPath(item, up ? path.size() : 0);
            }
            this.update(item);
        }

        public SearchPathStep getStep() {
            return (SearchPathStep)super.getStep();
        }

        private void updateAdvertisement(Point pt) {
            int idx = this.getList().locationToIndex(pt);
            this.updateAdvertisement(idx < this.getStep().getPathItems().size(), idx != -1 && this.isInControlZone(idx, pt));
        }

        private void updateAdvertisement(boolean inPath, boolean ctrl) {
            if (!ctrl) {
                this.setAdText(inPath ? DatabaseBundle.message((String)"action.ChooseSchema.in.path.ad", (Object[])new Object[]{KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_UP.getShortcuts()), KeymapUtil.getShortcutsText((Shortcut[])CommonShortcuts.MOVE_DOWN.getShortcuts())}) : DatabaseBundle.message((String)"action.ChooseSchema.out.path.ad", (Object[])new Object[0]));
            } else {
                this.setAdText(inPath ? DatabaseBundle.message((String)"action.ChooseSchema.in.path.ctrl.ad", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.ChooseSchema.out.path.ctrl.ad", (Object[])new Object[0]));
            }
        }

        public void cancel(InputEvent e) {
            if (e instanceof MouseEvent) {
                this.setOk(true);
            }
            super.cancel(e);
        }

        public void setOk(boolean ok) {
            this.myOk = ok;
            super.setOk(ok);
        }

        protected boolean isActionClick(MouseEvent e) {
            return false;
        }

        private void update(ObjectPath item) {
            this.getListModel().updateOriginalList();
            if (item != null) {
                this.getList().setSelectedValue(item, true);
            }
            this.getList().validate();
            this.getList().repaint();
            this.myButtonsPanel.setVisible(this.getStep().changed());
        }

        protected ListCellRenderer<ObjectPath> getListElementRenderer() {
            return new ElementWithControlRenderer<ObjectPath>((ListPopupImpl)this){
                {
                    super(popup);
                    Font font = this.mySeparatorComponent.getFont();
                    this.mySeparatorComponent.setFont(font.deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI)));
                    this.myNextStepLabel.setPreferredSize(new Dimension(30, 20));
                }

                protected void customizeComponent(JList<? extends ObjectPath> list, ObjectPath value2, boolean isSelected) {
                    super.customizeComponent(list, (Object)value2, isSelected);
                    this.myNextStepLabel.setVisible(isSelected);
                    SearchPathStep step = this.getStep();
                    if (isSelected) {
                        boolean ctrl = this.isControl(list, value2);
                        Icon add = ctrl ? DatabaseIcons.AddHover : DatabaseIcons.Add;
                        Icon del = ctrl ? AllIcons.Welcome.Project.RemoveHover : AllIcons.Welcome.Project.Remove;
                        List<ObjectPath> path = step.getPathItems();
                        if (path.size() < 2) {
                            del = null;
                        }
                        Icon icon = path.contains(value2) ? del : add;
                        this.highlightZones(list, value2);
                        this.myNextStepLabel.setIcon(icon);
                    }
                }

                @Override
                protected boolean isInControlZone(int idx, Point pt) {
                    return this.isInControlZone(idx, pt);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathPopup", "<init>"));
        }
    }

    private static class SimpleListPopup
    extends ListPopupImpl {
        private final ObjectPath myParentValue;

        SimpleListPopup(@Nullable Project project, @Nullable WizardPopup parent2, @NotNull ListPopupStep<ObjectPath> step, @Nullable ObjectPath parentValue) {
            if (step == null) {
                SimpleListPopup.$$$reportNull$$$0(0);
            }
            super(project, parent2, step, (Object)parentValue);
            this.setMaxRowCount(15);
            this.myParentValue = parentValue;
            final ListPopupImpl popup = (ListPopupImpl)ObjectUtils.tryCast((Object)parent2, ListPopupImpl.class);
            if (popup != null) {
                this.getList().addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (!Comparing.equal(popup.getList().getSelectedValue(), (Object)myParentValue)) {
                            popup.getList().setSelectedValue(myParentValue, false);
                        }
                    }
                });
            }
        }

        protected WizardPopup createPopup(WizardPopup parent2, PopupStep step, Object parentValue) {
            return step instanceof ListPopupStep ? ChooseSchemaAction.createPopupForStep(this.getProject(), parent2, (ListPopupStep<ObjectPath>)((ListPopupStep)step), (ObjectPath)ObjectUtils.tryCast((Object)parentValue, ObjectPath.class)) : super.createPopup(parent2, step, parentValue);
        }

        @NotNull
        protected Point getMousePos() {
            PointerInfo info = MouseInfo.getPointerInfo();
            Point pt = info == null ? new Point(0, 0) : info.getLocation();
            SwingUtilities.convertPointFromScreen(pt, this.getList());
            Point point = pt;
            if (point == null) {
                SimpleListPopup.$$$reportNull$$$0(1);
            }
            return point;
        }

        protected int trimWidth(int width) {
            FontMetrics fm = this.getList().getFontMetrics(UIUtil.getListFont());
            return Math.min(fm.stringWidth("Long enough schema name123"), width);
        }

        @NotNull
        public ObjectPath getParentValue() {
            ObjectPath objectPath = this.myParentValue;
            if (objectPath == null) {
                SimpleListPopup.$$$reportNull$$$0(2);
            }
            return objectPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SimpleListPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SimpleListPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMousePos";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParentValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DbScStep
    extends ObjectPathsStep {
        private final JdbcConsole myConsole;

        static DbScStep create(@NotNull JdbcConsole console) {
            ObjectPath dbPath;
            if (console == null) {
                DbScStep.$$$reportNull$$$0(0);
            }
            LocalDataSource dataSource2 = console.getDataSource();
            ArrayList<ObjectPath> paths = new ArrayList<ObjectPath>();
            TreePattern scope = dataSource2.getIntrospectionScope();
            int sep = 0;
            for (DasObject namespace : (JBTreeTraverser)dataSource2.getModel().traverser().expand(Conditions.alwaysFalse())) {
                ObjectPath path = ObjectPaths.of(namespace);
                if (path == null || path.kind != ObjectKind.DATABASE) continue;
                paths.add(DataSourceSchemaMapping.isIntrospected(scope, namespace) ? sep++ : paths.size(), path);
            }
            ObjectPath cur2 = SearchPath.getCurrent((SearchPath)console.getSearchPath());
            if (cur2 != null && (dbPath = cur2.findParent(ObjectKind.DATABASE, false)) != null && !paths.contains(dbPath)) {
                paths.add(dbPath);
            }
            return new DbScStep(console, paths, cur2, sep);
        }

        DbScStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @Nullable ObjectPath current, int introspectedEnd) {
            if (console == null) {
                DbScStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                DbScStep.$$$reportNull$$$0(2);
            }
            super(paths, introspectedEnd, current);
            this.myConsole = console;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            if (finalChoice || selectedValue == null) {
                if (selectedValue != null) {
                    ChooseSchemaAction.switchSearchPath(this.myConsole, SearchPath.of((ObjectPath)selectedValue));
                }
                return FINAL_CHOICE;
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(this.myConsole);
            ArrayList<ObjectPath> paths = new ArrayList<ObjectPath>();
            int sep = 0;
            TreePattern scope = this.myConsole.getDataSource().getIntrospectionScope();
            for (DasObject schema : this.getSchemas(selectedValue)) {
                boolean introspected = DataSourceSchemaMapping.isIntrospected(scope, schema);
                ObjectPath p2 = ObjectPaths.of(schema);
                if (!introspected) {
                    paths.add(p2);
                    continue;
                }
                paths.add(sep++, p2);
            }
            ArrayList<ObjectPath> searchPath = new ArrayList<ObjectPath>(SearchPath.getElements((SearchPath)this.myConsole.getSearchPath()));
            Iterator it2 = searchPath.iterator();
            while (it2.hasNext()) {
                ObjectPath p3 = (ObjectPath)it2.next();
                if (p3.kind == ObjectKind.SCHEMA && p3.parent != null && p3.parent.name.equals(selectedValue.getName())) continue;
                it2.remove();
            }
            if (dialect.supportsSearchPath()) {
                return new SearchPathStep(this.myConsole, paths, searchPath, new HashSet<ObjectPath>(paths.subList(0, sep)));
            }
            ObjectPath cur2 = (ObjectPath)ContainerUtil.getFirstItem(searchPath);
            if (cur2 != null && !paths.contains(cur2)) {
                cur2 = null;
            }
            return new SingleScOrDbStep(this.myConsole, paths, cur2, sep);
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return !this.getSchemas(selectedValue).isEmpty();
        }

        @NotNull
        public JBIterable<? extends DasObject> getSchemas(@Nullable ObjectPath selectedValue) {
            LocalDataSource dataSource2 = this.myConsole.getDataSource();
            if (selectedValue == null || dataSource2.getSchemaControl() == DatabaseDriver.SchemaControl.FORBID) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    DbScStep.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)dataSource2.getModel().traverser().expandAndSkip(x -> x.getKind() == ObjectKind.DATABASE && x.getName().equals(selectedValue.getName()))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).traverse();
            if (jBIterable == null) {
                DbScStep.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$DbScStep";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemas";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SearchPathStep
    extends BaseStep<ObjectPath>
    implements ListPopupStep<ObjectPath> {
        private final ListSeparator mySearchPathSeparator;
        private final ListSeparator myAvailSeparator;
        private final ListSeparator myIntrospectedSep;
        private final JdbcConsole myConsole;
        private final List<ObjectPath> mySearchPath;
        private final List<ObjectPath> myInitialPath;
        private final List<ObjectPath> myRest;
        private final List<ObjectPath> myPaths;
        private boolean myPathsDirty;
        private final Set<ObjectPath> myIntrospected;

        SearchPathStep(@NotNull JdbcConsole console) {
            if (console == null) {
                SearchPathStep.$$$reportNull$$$0(0);
            }
            this.mySearchPathSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.search.path", (Object[])new Object[0]));
            this.myAvailSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.add.to.search.path", (Object[])new Object[0]));
            this.myIntrospectedSep = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.non.introspected", (Object[])new Object[0]));
            this.myPaths = new ArrayList<ObjectPath>();
            this.myPathsDirty = true;
            this.myConsole = console;
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
            LocalDataSource dataSource2 = console.getDataSource();
            this.mySearchPath = new ArrayList<ObjectPath>();
            for (ObjectPath path : SearchPath.getElements((SearchPath)console.getSearchPath())) {
                if (!ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                this.mySearchPath.add(path);
            }
            this.myRest = new ArrayList<ObjectPath>();
            this.myIntrospected = new HashSet<ObjectPath>();
            TreePattern scope = dataSource2.getIntrospectionScope();
            for (DasObject namespace : (JBTreeTraverser)dataSource2.getModel().traverser().expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))) {
                ObjectPath path = ObjectPaths.of(namespace);
                if (path == null || !ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                this.myRest.add(path);
                if (!DataSourceSchemaMapping.isIntrospected(scope, namespace)) continue;
                this.myIntrospected.add(path);
            }
            this.myRest.removeAll(this.mySearchPath);
            this.myInitialPath = new ArrayList<ObjectPath>(this.mySearchPath);
        }

        SearchPathStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @NotNull List<ObjectPath> searchPath, @NotNull Set<ObjectPath> introspected) {
            if (console == null) {
                SearchPathStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                SearchPathStep.$$$reportNull$$$0(2);
            }
            if (searchPath == null) {
                SearchPathStep.$$$reportNull$$$0(3);
            }
            if (introspected == null) {
                SearchPathStep.$$$reportNull$$$0(4);
            }
            this.mySearchPathSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.search.path", (Object[])new Object[0]));
            this.myAvailSeparator = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.add.to.search.path", (Object[])new Object[0]));
            this.myIntrospectedSep = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.non.introspected", (Object[])new Object[0]));
            this.myPaths = new ArrayList<ObjectPath>();
            this.myPathsDirty = true;
            this.myConsole = console;
            this.mySearchPath = new ArrayList<ObjectPath>(searchPath);
            this.myRest = new ArrayList<ObjectPath>(paths);
            this.myRest.removeAll(this.mySearchPath);
            this.myInitialPath = new ArrayList<ObjectPath>(this.mySearchPath);
            this.myIntrospected = introspected;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        @NotNull
        public String getTextFor(ObjectPath value2) {
            String string = ChooseSchemaAction.getText(value2);
            if (string == null) {
                SearchPathStep.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public List<ObjectPath> getValues() {
            if (this.myPathsDirty) {
                ContainerUtil.sort(this.myRest, Comparator.comparing(p2 -> !this.myIntrospected.contains(p2)).thenComparing(PATH_COMPARATOR));
                this.myPaths.clear();
                this.myPaths.addAll(this.mySearchPath);
                this.myPaths.addAll(this.myRest);
            }
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                SearchPathStep.$$$reportNull$$$0(6);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            return null;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return false;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value2) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value2) {
            if (Comparing.equal((Object)value2, (Object)((ObjectPath)ContainerUtil.getFirstItem(this.mySearchPath)))) {
                return this.mySearchPathSeparator;
            }
            if (Comparing.equal((Object)value2, (Object)((ObjectPath)ContainerUtil.getFirstItem(this.myRest)))) {
                return this.myAvailSeparator;
            }
            if (this.myIntrospected.contains(value2)) {
                return null;
            }
            int idx = this.myRest.indexOf(value2);
            if (idx < 1) {
                return null;
            }
            if (this.myIntrospected.contains(this.myRest.get(idx - 1))) {
                return this.myIntrospectedSep;
            }
            return null;
        }

        public int getDefaultOptionIndex() {
            return 0;
        }

        @NotNull
        public JdbcConsole getConsole() {
            JdbcConsole jdbcConsole = this.myConsole;
            if (jdbcConsole == null) {
                SearchPathStep.$$$reportNull$$$0(7);
            }
            return jdbcConsole;
        }

        @NotNull
        public List<ObjectPath> getPathItems() {
            List<ObjectPath> list = this.mySearchPath;
            if (list == null) {
                SearchPathStep.$$$reportNull$$$0(8);
            }
            return list;
        }

        public boolean changed() {
            return !this.mySearchPath.equals(this.myInitialPath);
        }

        public void removeFromPath(ObjectPath item) {
            if (!this.mySearchPath.remove(item)) {
                return;
            }
            this.myRest.add(item);
            this.myPathsDirty = true;
        }

        public void moveInPath(ObjectPath item, int idx) {
            int prevIdx = this.mySearchPath.indexOf(item);
            if (prevIdx == idx) {
                return;
            }
            if (prevIdx != -1) {
                this.mySearchPath.remove(prevIdx);
            } else {
                this.myRest.remove(item);
            }
            if (prevIdx != -1 && idx > prevIdx) {
                --idx;
            }
            this.mySearchPath.add(idx, item);
            this.myPathsDirty = true;
        }

        public void reset() {
            HashSet<ObjectPath> values2 = new HashSet<ObjectPath>(this.getValues());
            this.mySearchPath.clear();
            this.mySearchPath.addAll(this.myInitialPath);
            values2.removeAll(this.mySearchPath);
            this.myRest.clear();
            this.myRest.addAll(values2);
            this.myPathsDirty = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchPath";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "introspected";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SearchPathStep";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsole";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SingleScOrDbStep
    extends ObjectPathsStep {
        private final JdbcConsole myConsole;

        static SingleScOrDbStep create(@NotNull JdbcConsole console) {
            if (console == null) {
                SingleScOrDbStep.$$$reportNull$$$0(0);
            }
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(console);
            ObjectKind kind = dialect.getSearchPathObjectKind();
            LocalDataSource dataSource2 = console.getDataSource();
            boolean sensitive = console.getDataSource().getCaseModes().quoted.sensitive;
            Map allPaths = sensitive ? CollectionFactory.createSmallMemoryFootprintMap() : new Object2ObjectOpenCustomHashMap(ObjectPaths.INSENSITIVE_STRATEGY);
            ObjectPath cur2 = null;
            for (Object path : SearchPath.getElements((SearchPath)console.getSearchPath())) {
                if (kind != null && !ChooseSchemaAction.canSwitchTo(dialect, (ObjectPath)path)) continue;
                if (cur2 == null) {
                    cur2 = path;
                }
                allPaths.put(path, false);
            }
            TreePattern scope = dataSource2.getIntrospectionScope();
            for (DasObject namespace : (JBTreeTraverser)dataSource2.getModel().traverser().expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))) {
                ObjectPath path = ObjectPaths.of(namespace);
                if (path == null || kind != null && !ChooseSchemaAction.canSwitchTo(dialect, path)) continue;
                allPaths.put(path, DataSourceSchemaMapping.isIntrospected(scope, namespace));
            }
            ArrayList<ObjectPath> paths = new ArrayList<ObjectPath>(allPaths.size());
            int sep = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                boolean introspected = i2 == 0;
                for (Map.Entry entry : allPaths.entrySet()) {
                    if (introspected != (Boolean)entry.getValue()) continue;
                    paths.add((ObjectPath)entry.getKey());
                }
                if (!introspected) continue;
                sep = paths.size();
            }
            return new SingleScOrDbStep(console, paths, cur2, sep);
        }

        SingleScOrDbStep(@NotNull JdbcConsole console, @NotNull List<ObjectPath> paths, @Nullable ObjectPath current, int introspectedEnd) {
            if (console == null) {
                SingleScOrDbStep.$$$reportNull$$$0(1);
            }
            if (paths == null) {
                SingleScOrDbStep.$$$reportNull$$$0(2);
            }
            super(paths, introspectedEnd, current);
            this.myConsole = console;
        }

        @Nullable
        public PopupStep<?> onChosen(@Nullable ObjectPath selectedValue, boolean finalChoice) {
            if (selectedValue != null) {
                ChooseSchemaAction.switchSearchPath(this.myConsole, SearchPath.of((ObjectPath)selectedValue));
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(ObjectPath selectedValue) {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/ChooseSchemaAction$SingleScOrDbStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ObjectPathsStep
    extends BaseStep<ObjectPath>
    implements ListPopupStep<ObjectPath> {
        private final ListSeparator myIntrospectedSep = new ListSeparator(DatabaseBundle.message((String)"action.ChooseSchema.non.introspected", (Object[])new Object[0]));
        protected final List<ObjectPath> myPaths;
        protected final int myIntrospectedEnd;
        protected final ObjectPath myCurrent;

        protected ObjectPathsStep(List<ObjectPath> paths, int end2, ObjectPath current) {
            this.myPaths = paths;
            this.myIntrospectedEnd = end2;
            this.myCurrent = current;
            this.myPaths.subList(0, this.myIntrospectedEnd).sort(PATH_COMPARATOR);
            this.myPaths.subList(this.myIntrospectedEnd, this.myPaths.size()).sort(PATH_COMPARATOR);
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        @NotNull
        public String getTextFor(ObjectPath value2) {
            String string = ChooseSchemaAction.getText(value2);
            if (string == null) {
                ObjectPathsStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public List<ObjectPath> getValues() {
            List<ObjectPath> list = this.myPaths;
            if (list == null) {
                ObjectPathsStep.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Nullable
        public String getTitle() {
            return null;
        }

        public void canceled() {
        }

        public boolean isSelectable(ObjectPath value2) {
            return true;
        }

        @Nullable
        public Icon getIconFor(ObjectPath aValue) {
            return null;
        }

        @Nullable
        public ListSeparator getSeparatorAbove(ObjectPath value2) {
            return this.myIntrospectedEnd < this.myPaths.size() && value2.equals(this.myPaths.get(this.myIntrospectedEnd)) ? this.myIntrospectedSep : null;
        }

        public int getDefaultOptionIndex() {
            return this.myPaths.indexOf(this.myCurrent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/actions/ChooseSchemaAction$ObjectPathsStep";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

