/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Consumer;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleDataRequest
extends DataRequest.QueryRequest
implements DataRequest.CoupledWithEditor {
    @RegExp
    private static final String TITLE_PREFIX_PATTERN = "(--|/\\*|//)?\\s*%s([^\\s].+(\\*[^/]?|[^*/]))\\s*($|\\*/)";
    private final Shared shared;
    private final TextRange myInitialRange;
    public final int queryIndex;
    public final boolean hasNext;
    public final boolean newTab;
    public final Set<JdbcEngine.ExecutionConcession> concessions;
    private final SubQueriesInfo mySubQueriesInfo;
    private static final Key<ErrorPanelInfo> ERROR_PANEL_KEY = Key.create((String)"ERROR_PANEL_KEY");
    private static final Accepter WARNING = (request, errorInfo) -> errorInfo.isWarning();
    private static final Accepter WARNING_NOT_LAST = (request, errorInfo) -> errorInfo.isWarning() && !request.isLastInChain();
    private static final Accepter ERROR = (request, errorInfo) -> !errorInfo.isWarning();
    private static final Accepter ERROR_NOT_LAST = (request, errorInfo) -> !errorInfo.isWarning() && !request.isLastInChain();
    private static final Accepter NOT_LAST = (request, errorInfo) -> !request.isLastInChain();

    @Nullable
    public static ConsoleDataRequest newConsoleRequest(@NotNull JdbcConsole console, @NotNull Editor editor, @NotNull ScriptModel<?> model, boolean newTab) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ConsoleDataRequest.$$$reportNull$$$0(2);
        }
        DataRequest.Constraints constraints = ConsoleDataRequest.newConstraints();
        Shared shared = new Shared(editor, model, constraints);
        shared.queries.advance();
        return ConsoleDataRequest.newConsoleRequest(console, shared, 0, newTab, EnumSet.noneOf(JdbcEngine.ExecutionConcession.class));
    }

    @Nullable
    private static ConsoleDataRequest newConsoleRequest(@NotNull JdbcConsole console, @NotNull Shared shared, int queryIndex, boolean newTab, @NotNull Set<JdbcEngine.ExecutionConcession> concessions) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(3);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(4);
        }
        if (concessions == null) {
            ConsoleDataRequest.$$$reportNull$$$0(5);
        }
        QueryTextResult queryTextResult = ConsoleDataRequest.currentQueryTextResult(console, shared);
        ConsoleDataRequest newRequest = new ConsoleDataRequest(console, queryTextResult.getText(), shared, queryIndex, newTab, concessions);
        TranslateException translateException = queryTextResult.getTranslateException();
        if (translateException != null) {
            DataRequest.CoupledWithEditor.ErrorNavigator navigator = newRequest.onError(translateException.getMessage(), null, null);
            DbUIUtil.invokeLater(() -> {
                if (navigator != null && navigator.canNavigate()) {
                    navigator.navigate();
                }
            });
            return null;
        }
        return newRequest;
    }

    private ConsoleDataRequest(@NotNull JdbcConsole console, @NotNull String query, @NotNull Shared shared, int queryIndex, boolean newTab, @NotNull Set<JdbcEngine.ExecutionConcession> concessions) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(6);
        }
        if (query == null) {
            ConsoleDataRequest.$$$reportNull$$$0(7);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(8);
        }
        if (concessions == null) {
            ConsoleDataRequest.$$$reportNull$$$0(9);
        }
        super(console, query, shared.constraints, null);
        this.shared = shared;
        this.queryIndex = queryIndex;
        this.newTab = newTab;
        this.concessions = concessions;
        ScriptModel.StatementIt currentQuery = (ScriptModel.StatementIt)shared.queries.current();
        this.mySubQueriesInfo = ConsoleDataRequest.computeSubQueriesInfo(currentQuery, console, shared.scriptModel.getLanguage(), shared.scriptModel.getTextRange());
        this.hasNext = shared.queries.hasNext();
        this.myInitialRange = this.getRange();
    }

    @Nullable
    public static <E> String computeTitle(@Nullable E object, @NotNull SyntaxTraverser.Api<E> api, @NotNull Project project) {
        String[] lines;
        String commentText;
        if (api == null) {
            ConsoleDataRequest.$$$reportNull$$$0(10);
        }
        if (project == null) {
            ConsoleDataRequest.$$$reportNull$$$0(11);
        }
        DatabaseSettings settings = DatabaseSettings.getSettings();
        if (object == null || !settings.resultsTitlePrefixEnabled) {
            return null;
        }
        Object comment = SqlPsiFacade.getInstance((Project)project).getNotebookManager().getPrecedingComment(object, api);
        String string = commentText = comment == null ? null : api.textOf(comment).toString();
        if (commentText == null) {
            return null;
        }
        String patternText = StringUtil.isEmptyOrSpaces((String)settings.resultsTitlePrefix) ? "" : Pattern.quote(settings.resultsTitlePrefix) + "\\s+";
        Pattern pattern = Pattern.compile(String.format(TITLE_PREFIX_PATTERN, patternText));
        for (String line : lines = StringUtil.splitByLines((String)commentText)) {
            Matcher lineMatcher = pattern.matcher(line);
            if (!lineMatcher.matches()) continue;
            return lineMatcher.group(2);
        }
        return null;
    }

    @NotNull
    private static <E> SubQueriesInfo computeSubQueriesInfo(@NotNull ScriptModel.StatementIt<E> statementIt, @NotNull JdbcConsole console, @NotNull Language language, @Nullable TextRange range) {
        Object object;
        if (statementIt == null) {
            ConsoleDataRequest.$$$reportNull$$$0(12);
        }
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(13);
        }
        if (language == null) {
            ConsoleDataRequest.$$$reportNull$$$0(14);
        }
        if (!((object = statementIt.object()) instanceof PsiElement)) {
            return new SubQueriesInfo(false, Collections.emptyList());
        }
        PsiElement o = (PsiElement)object;
        EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(language);
        boolean canContainStatements = helper.canContainStatements().value((Object)o) && ScriptModelUtil.getSelectionOption(range) != 1;
        SyntaxTraverser s2 = canContainStatements ? (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)o).expand(helper.canContainStatements())).filter(helper.isStatement()) : (SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)o).expand(Conditions.alwaysFalse());
        boolean justOne = s2.traverse().take(2).size() == 1;
        List resultSetSubQueries = s2.traverse().map(st -> {
            String query = s2.api.textOf(st).toString();
            String title = ConsoleDataRequest.computeTitle(st, s2.api, console.getProject());
            SqlTableType resultType = DbSqlUtil.parseQueryTableType(console, language, query);
            return resultType != null || justOne ? new ResultSetSubQuery(query, title, resultType) : null;
        }).filter(Objects::nonNull).toList();
        return new SubQueriesInfo(justOne, resultSetSubQueries);
    }

    @NotNull
    private static String handleQueryText(@NotNull JdbcConsole console, String text2) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(15);
        }
        String lineSeparator = (String)ObjectUtils.notNull((Object)console.getVirtualFile().getDetectedLineSeparator(), (Object)LineSeparator.getSystemLineSeparator().getSeparatorString());
        String string = StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
        if (string == null) {
            ConsoleDataRequest.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static QueryTextResult currentQueryTextResult(@NotNull JdbcConsole console, @NotNull Shared shared) {
        if (console == null) {
            ConsoleDataRequest.$$$reportNull$$$0(17);
        }
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(18);
        }
        ScriptModel.PStorage storage = console.getPStorage();
        try {
            String currentText = ((ScriptModel.StatementIt)shared.queries.current()).text(storage, Conditions.alwaysFalse());
            return new QueryTextResult(ConsoleDataRequest.handleQueryText(console, currentText), null);
        }
        catch (TranslateException e) {
            String currentRawText = ((ScriptModel.StatementIt)shared.queries.current()).text();
            return new QueryTextResult(ConsoleDataRequest.handleQueryText(console, currentRawText), e);
        }
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.shared.sourceEditor;
    }

    @Override
    @NotNull
    public DataRequest getRequest() {
        ConsoleDataRequest consoleDataRequest = this;
        if (consoleDataRequest == null) {
            ConsoleDataRequest.$$$reportNull$$$0(19);
        }
        return consoleDataRequest;
    }

    @NotNull
    private JdbcConsole getConsole() {
        JdbcConsole jdbcConsole = (JdbcConsole)this.owner;
        if (jdbcConsole == null) {
            ConsoleDataRequest.$$$reportNull$$$0(20);
        }
        return jdbcConsole;
    }

    @NotNull
    private DataProducer getDataProducer() {
        DataProducer dataProducer = this.getConsole().getMessageBus().getDataProducer();
        if (dataProducer == null) {
            ConsoleDataRequest.$$$reportNull$$$0(21);
        }
        return dataProducer;
    }

    @NotNull
    public UserDataHolder getSharedDataHolder() {
        Shared shared = this.shared;
        if (shared == null) {
            ConsoleDataRequest.$$$reportNull$$$0(22);
        }
        return shared;
    }

    public boolean containSingleSubQuery() {
        return this.mySubQueriesInfo.containSingleSubQuery();
    }

    public boolean produceResultSet() {
        ResultSetSubQuery subQuery = this.getResultSetSubquery(1);
        return subQuery != null && subQuery.resultType != null;
    }

    @Nullable
    public ResultSetSubQuery getResultSetSubquery(int resultSetIndex) {
        return this.mySubQueriesInfo.getResultSetSubquery(resultSetIndex);
    }

    @Override
    @Nullable
    public DataRequest.CoupledWithEditor.ErrorNavigator onError(@Nullable String message2, @Nullable Throwable th, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
        return message2 != null ? this.reportError(ConsoleDataRequest.createThrowable(message2, th), ErrorInfo.ERROR, null, fixes) : (th != null ? this.reportError(th, ErrorInfo.ERROR, null, fixes) : null);
    }

    @Override
    public void onWarning(@Nullable String message2, @Nullable Runnable suppressAction, @NotNull JdbcEngine.ExecutionConcession concession) {
        if (concession == null) {
            ConsoleDataRequest.$$$reportNull$$$0(23);
        }
        if (message2 != null) {
            this.reportError(ConsoleDataRequest.createThrowable(message2, null), suppressAction == null ? ErrorInfo.WARNING : new ErrorInfo(true, suppressAction), concession, null);
        }
    }

    public void onFinished() {
        if (!this.isExecutionStopper()) {
            this.processNextRequest();
        }
    }

    public boolean isExecutionStopper() {
        return this.isLastInChain() || this.hasPendingProblems();
    }

    public boolean isLastInChain() {
        return !this.hasNext;
    }

    private boolean hasPendingProblems() {
        return JBIterable.of((Object[])new ProblemSolver[]{this.shared.errorsSolver, this.shared.warningsSolver}).filter(ProblemSolver::isEnabled).isNotEmpty();
    }

    private void processNextRequest() {
        ConsoleDataRequest nextRequest = this.nextRequest();
        if (nextRequest != null) {
            this.getDataProducer().processRequest(nextRequest);
        }
    }

    @Nullable
    private ConsoleDataRequest nextRequest() {
        this.shared.queries.advance();
        JdbcConsole console = this.getConsole();
        return ConsoleDataRequest.newConsoleRequest(console, this.shared, this.queryIndex + 1, this.newTab, EnumSet.copyOf(this.shared.warningsSolver.getConcessions()));
    }

    private void processClonedRequest() {
        ConsoleDataRequest clonedRequest = this.cloneRequest();
        if (clonedRequest != null) {
            this.getDataProducer().processRequest(clonedRequest);
        }
    }

    @Nullable
    private ConsoleDataRequest cloneRequest() {
        JdbcConsole console = this.getConsole();
        EnumSet<JdbcEngine.ExecutionConcession> concessions = EnumSet.copyOf(this.concessions);
        concessions.addAll(this.shared.warningsSolver.getConcessions());
        return ConsoleDataRequest.newConsoleRequest(console, this.shared, this.queryIndex, this.newTab, concessions);
    }

    public void onStarted() {
        DbUIUtil.invokeLater(() -> {
            if (!this.hasNext || this.shared.lastUpdateTime < 0L || System.currentTimeMillis() - this.shared.lastUpdateTime > 100L) {
                this.updateConsoleUI(false);
            }
        });
        this.shared.lastUpdateTime = System.currentTimeMillis();
    }

    private void updateConsoleUI(boolean scrollToQuery) {
        TextRange range;
        this.closeErrorPanel();
        if (scrollToQuery && (range = this.getRange()) != null) {
            this.scrollToRange(range, false);
        }
        this.updateHighlighting();
    }

    private DataRequest.CoupledWithEditor.ErrorNavigator reportError(@NotNull Throwable error2, @NotNull ErrorInfo errorInfo, @Nullable JdbcEngine.ExecutionConcession concession, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(24);
        }
        if (errorInfo == null) {
            ConsoleDataRequest.$$$reportNull$$$0(25);
        }
        ProblemSolver solver = errorInfo.isWarning() ? this.shared.warningsSolver : this.shared.errorsSolver;
        solver.newProblem(concession);
        DataRequest.CoupledWithEditor.ErrorNavigator navigator = this.createErrorNavigator(error2);
        ErrorsSolver errorsSolver = new ErrorsSolver();
        DbUIUtil.invokeLater(() -> {
            this.updateConsoleUI(errorsSolver.isEnabled());
            if (!solver.isEnabled()) {
                return;
            }
            this.handleQueryError(navigator, error2, fixes, (Consumer<Decision>)((Consumer)feedback -> {
                this.closeErrorPanel();
                solver.solve((Decision)((Object)((Object)feedback)), this, concession);
            }), errorInfo);
        });
        return navigator;
    }

    public void closeErrorPanel() {
        ConsoleDataRequest.hideErrorPanel(this.shared.sourceEditor);
    }

    private void handleQueryError(@NotNull DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull Throwable error2, @Nullable List<DatabaseErrorHandler.Fix> fixes, @Nullable Consumer<Decision> feedbackListener, @NotNull ErrorInfo errorInfo) {
        if (navigator == null) {
            ConsoleDataRequest.$$$reportNull$$$0(26);
        }
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(27);
        }
        if (errorInfo == null) {
            ConsoleDataRequest.$$$reportNull$$$0(28);
        }
        if (error2 instanceof ProcessCanceledException) {
            return;
        }
        if (feedbackListener == null && !DatabaseSettings.getSettings().isShowErrorInEditor()) {
            return;
        }
        if (!this.shared.sourceEditor.getContentComponent().isShowing()) {
            return;
        }
        Project project = this.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(navigator, this.shared.sourceEditor, error2, feedbackListener, errorInfo, fixes);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent2 = errorPanel.getParent();
            if (parent2 instanceof JComponent) {
                ((JComponent)parent2).setBorder((Border)JBUI.Borders.empty());
            }
            ERROR_PANEL_KEY.set((UserDataHolder)this.shared.sourceEditor, (Object)new ErrorPanelInfo(errorPanel, feedbackListener));
            this.shared.sourceEditor.getContentComponent().requestFocusInWindow();
            if (navigator.canNavigate()) {
                navigator.navigate();
            }
        }
    }

    @NotNull
    private DataRequest.CoupledWithEditor.ErrorNavigator createErrorNavigator(@NotNull Throwable error2) {
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(29);
        }
        Project project = this.getConsole().getProject();
        Dbms dbms = ((LocalDataSource)this.getConsole().getTarget()).getDbms();
        final int position = ((DatabaseErrorHandler)DatabaseErrorHandler.EP.forDbms(dbms)).getErrorOffsetFromException(project, error2, this.query);
        return new DataRequest.CoupledWithEditor.ErrorNavigator(){

            @Override
            public void navigate() {
                int resultOffset = this.getOffset();
                if (resultOffset != -1) {
                    ConsoleDataRequest.this.scrollToRange(TextRange.create((int)resultOffset, (int)resultOffset), true);
                    return;
                }
                TextRange range = ConsoleDataRequest.this.getRange();
                if (range != null) {
                    ConsoleDataRequest.this.scrollToRange(range, false);
                }
            }

            @Override
            public boolean canNavigate() {
                return this.getOffset() != -1 || ConsoleDataRequest.this.getRange() != null;
            }

            private int getOffset() {
                TextRange currentRange = ConsoleDataRequest.this.getRange();
                if (currentRange == null || ConsoleDataRequest.this.myInitialRange != null && !ConsoleDataRequest.this.myInitialRange.equals((Object)currentRange)) {
                    return -1;
                }
                int offset = position >= 0 ? position + currentRange.getStartOffset() : -1;
                return offset >= currentRange.getEndOffset() ? currentRange.getEndOffset() : offset;
            }
        };
    }

    @NotNull
    private static Throwable createThrowable(@NotNull String message2, @Nullable Throwable th) {
        if (message2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(30);
        }
        Throwable throwable = new Throwable(message2);
        throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
        Throwable throwable2 = throwable;
        if (throwable2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(31);
        }
        return throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range, boolean strict) {
        Editor editor;
        if (range == null) {
            ConsoleDataRequest.$$$reportNull$$$0(32);
        }
        if ((editor = this.shared.sourceEditor).isDisposed() || !editor.getContentComponent().isShowing()) {
            return;
        }
        CaretModel caretModel = editor.getCaretModel();
        if (!strict && range.contains(caretModel.getOffset())) {
            return;
        }
        int offset = range.getEndOffset();
        caretModel.moveToOffset(offset);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        TextRange existing = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (!existing.containsOffset(offset)) {
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    private void updateHighlighting() {
        Project project = this.getConsole().getProject();
        if (!project.isOpen() || this.shared.sourceEditor.isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.shared.sourceEditor.getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file);
        }
    }

    @Override
    @Nullable
    public TextRange getRange() {
        return this.shared.adjustedRange(this.queryIndex);
    }

    @NotNull
    private ErrorNotificationPanel createErrorNotificationPanel(final @NotNull DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull Editor sourceEditor, @NotNull Throwable error2, @Nullable Consumer<Decision> feedbackListener, @NotNull ErrorInfo errorInfo, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
        if (navigator == null) {
            ConsoleDataRequest.$$$reportNull$$$0(33);
        }
        if (sourceEditor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(34);
        }
        if (error2 == null) {
            ConsoleDataRequest.$$$reportNull$$$0(35);
        }
        if (errorInfo == null) {
            ConsoleDataRequest.$$$reportNull$$$0(36);
        }
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error2, sourceEditor.getContentComponent());
        if (fixes != null && !fixes.isEmpty()) {
            for (DatabaseErrorHandler.Fix fix : fixes) {
                builder.addLink(fix.getName(), fix.getName(), () -> DataSourceUiUtil.applyFix(this.getConsole().getProject(), fix, null));
            }
            builder.addSpace();
        }
        Iterable<ErrorPanelConfigurator> configurators = ErrorPanelConfigurator.filterFor(this, errorInfo);
        configurators.forEach(c2 -> c2.configure(builder, this, feedbackListener, errorInfo));
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.getContent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                navigator.navigate();
                ConsoleDataRequest.this.shared.sourceEditor.getContentComponent().requestFocusInWindow();
                ConsoleDataRequest.this.updateHighlighting();
            }
        });
        ErrorNotificationPanel errorNotificationPanel = notificationPanel;
        if (errorNotificationPanel == null) {
            ConsoleDataRequest.$$$reportNull$$$0(37);
        }
        return errorNotificationPanel;
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        ErrorPanelInfo epInfo;
        if (sourceEditor == null) {
            ConsoleDataRequest.$$$reportNull$$$0(38);
        }
        if ((epInfo = (ErrorPanelInfo)ERROR_PANEL_KEY.get((UserDataHolder)sourceEditor)) == null || sourceEditor.getProject() == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)sourceEditor.getProject()).getPsiFile(sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)sourceEditor.getProject());
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.errorPanel);
            ERROR_PANEL_KEY.set((UserDataHolder)sourceEditor, null);
            sourceEditor.getContentComponent().requestFocusInWindow();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concessions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementIt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concession";
                break;
            }
            case 24: 
            case 27: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 25: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "handleQueryText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataProducer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedDataHolder";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createThrowable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConsoleRequest";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeTitle";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeSubQueriesInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryText";
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 37: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "currentQueryTextResult";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onWarning";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryError";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNavigator";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createThrowable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRange";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNotificationPanel";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hideErrorPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class WarningsSolver
    implements ProblemSolver {
        private final EnumSet<JdbcEngine.ExecutionConcession> myConcessions = EnumSet.noneOf(JdbcEngine.ExecutionConcession.class);
        private final EnumSet<JdbcEngine.ExecutionConcession> myRequiredConcessions = EnumSet.noneOf(JdbcEngine.ExecutionConcession.class);
        private final EnumSet<JdbcEngine.ExecutionConcession> myIgnoredConcessions = EnumSet.noneOf(JdbcEngine.ExecutionConcession.class);

        private WarningsSolver() {
        }

        @Override
        public void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request, @Nullable JdbcEngine.ExecutionConcession concession) {
            if (decision == null) {
                WarningsSolver.$$$reportNull$$$0(0);
            }
            if (request == null) {
                WarningsSolver.$$$reportNull$$$0(1);
            }
            if (concession != null) {
                this.myRequiredConcessions.remove((Object)concession);
            }
            switch (decision) {
                case FORCE_EXECUTE: {
                    if (concession != null) {
                        request.concessions.add(concession);
                    }
                    request.processClonedRequest();
                    break;
                }
                case FORCE_EXECUTE_ALL: {
                    if (concession != null) {
                        this.myConcessions.add(concession);
                    }
                    request.processClonedRequest();
                    break;
                }
                case RETRY: {
                    request.processClonedRequest();
                    break;
                }
                case IGNORE: {
                    request.processNextRequest();
                    break;
                }
                case IGNORE_ALL: {
                    if (concession != null) {
                        this.myIgnoredConcessions.add(concession);
                    }
                    request.processNextRequest();
                    break;
                }
            }
        }

        @Override
        public void newProblem(@Nullable JdbcEngine.ExecutionConcession concession) {
            if (concession != null && !this.myIgnoredConcessions.contains((Object)concession)) {
                this.myRequiredConcessions.add(concession);
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.myConcessions.containsAll(this.myRequiredConcessions);
        }

        @NotNull
        EnumSet<JdbcEngine.ExecutionConcession> getConcessions() {
            EnumSet<JdbcEngine.ExecutionConcession> enumSet = this.myConcessions;
            if (enumSet == null) {
                WarningsSolver.$$$reportNull$$$0(2);
            }
            return enumSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$WarningsSolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConcessions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "solve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ErrorsSolver
    implements ProblemSolver {
        private boolean myEnabled = true;
        private int myCount;

        private ErrorsSolver() {
        }

        @Override
        public void solve(@NotNull Decision decision, @NotNull ConsoleDataRequest request, @Nullable JdbcEngine.ExecutionConcession concession) {
            if (decision == null) {
                ErrorsSolver.$$$reportNull$$$0(0);
            }
            if (request == null) {
                ErrorsSolver.$$$reportNull$$$0(1);
            }
            --this.myCount;
            switch (decision) {
                case RETRY: {
                    request.processClonedRequest();
                    break;
                }
                case IGNORE_ALL: {
                    this.myEnabled = false;
                    request.processNextRequest();
                    break;
                }
                case IGNORE: {
                    request.processNextRequest();
                    break;
                }
            }
        }

        @Override
        public void newProblem(@Nullable JdbcEngine.ExecutionConcession concession) {
            if (this.myEnabled) {
                ++this.myCount;
            }
        }

        @Override
        public boolean isEnabled() {
            return this.myCount > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "decision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ConsoleDataRequest$ErrorsSolver";
            objectArray[2] = "solve";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ProblemSolver {
        public void solve(@NotNull Decision var1, @NotNull ConsoleDataRequest var2, @Nullable JdbcEngine.ExecutionConcession var3);

        public void newProblem(@Nullable JdbcEngine.ExecutionConcession var1);

        public boolean isEnabled();
    }

    private static class LinkConfigurator
    implements Configurator {
        private final Decision myDecision;
        private final String myText;
        private final @NlsActions.ActionText String myLinkHtml;
        private final boolean mySuppress;

        LinkConfigurator(@NotNull Decision decision, @NotNull String text2, @NlsActions.ActionText @NotNull String linkHtml) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LinkConfigurator.$$$reportNull$$$0(1);
            }
            if (linkHtml == null) {
                LinkConfigurator.$$$reportNull$$$0(2);
            }
            this(decision, text2, linkHtml, false);
        }

        LinkConfigurator(@NotNull Decision decision, @NotNull String text2, @NlsActions.ActionText @NotNull String linkHtml, boolean suppress) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(3);
            }
            if (text2 == null) {
                LinkConfigurator.$$$reportNull$$$0(4);
            }
            if (linkHtml == null) {
                LinkConfigurator.$$$reportNull$$$0(5);
            }
            this.myDecision = decision;
            this.myText = text2;
            this.myLinkHtml = linkHtml;
            this.mySuppress = suppress;
        }

        @Override
        public void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<Decision> listener2, @NotNull ErrorInfo errorInfo) {
            if (builder == null) {
                LinkConfigurator.$$$reportNull$$$0(6);
            }
            if (request == null) {
                LinkConfigurator.$$$reportNull$$$0(7);
            }
            if (errorInfo == null) {
                LinkConfigurator.$$$reportNull$$$0(8);
            }
            if (listener2 != null) {
                builder.addLink(this.myText, this.myLinkHtml, () -> {
                    listener2.consume((Object)this.myDecision);
                    if (this.mySuppress) {
                        assert (errorInfo.getSuppressAction() != null);
                        errorInfo.getSuppressAction().run();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkHtml";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$LinkConfigurator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Accepter {
        public boolean accept(@NotNull ConsoleDataRequest var1, @NotNull ErrorInfo var2);
    }

    private static interface Configurator {
        public void configure(@NotNull ErrorNotificationPanel.Builder var1, @NotNull ConsoleDataRequest var2, @Nullable Consumer<Decision> var3, @NotNull ErrorInfo var4);
    }

    private static enum ErrorPanelConfigurator {
        STOP(NOT_LAST, new LinkConfigurator(Decision.STOP, "&stop", DatabaseBundle.message((String)"action.span.style.text.decoration.underline.s.span.top.text", (Object[])new Object[0]))),
        RETRY(ERROR_NOT_LAST, new LinkConfigurator(Decision.RETRY, "&retry", DatabaseBundle.message((String)"action.span.style.text.decoration.underline.r.span.etry.text", (Object[])new Object[0]))),
        IGNORE_ERROR(ERROR_NOT_LAST, new LinkConfigurator(Decision.IGNORE, "&ignore", DatabaseBundle.message((String)"action.span.style.text.decoration.underline.i.span.gnore.text", (Object[])new Object[0]))),
        IGNORE_ALL_ERRORS(ERROR_NOT_LAST, new LinkConfigurator(Decision.IGNORE_ALL, "ignore_&all", DatabaseBundle.message((String)"action.ignore.span.style.text.decoration.underline.span.ll.text", (Object[])new Object[0]))),
        SKIP(WARNING_NOT_LAST, new LinkConfigurator(Decision.IGNORE, "&skip", DatabaseBundle.message((String)"action.span.style.text.decoration.underline.s.span.kip.text", (Object[])new Object[0]))),
        SKIP_ALL(WARNING_NOT_LAST, new LinkConfigurator(Decision.IGNORE_ALL, "skip &all", DatabaseBundle.message((String)"action.skip.span.style.text.decoration.underline.span.ll.text", (Object[])new Object[0]))),
        FORCE_EXECUTE(WARNING, new LinkConfigurator(Decision.FORCE_EXECUTE, "&execute", DatabaseBundle.message((String)"action.span.style.text.decoration.underline.e.span.xecute.text", (Object[])new Object[0]))),
        FORCE_EXECUTE_AND_SUPPRESS((r, e) -> e.getSuppressAction() != null, new LinkConfigurator(Decision.FORCE_EXECUTE, "exec_s&uppress", DatabaseBundle.message((String)"action.execute.s.span.style.text.decoration.underline.u.span.ppress.text", (Object[])new Object[0]), true)),
        FORCE_EXECUTE_ALL(WARNING_NOT_LAST, new LinkConfigurator(Decision.FORCE_EXECUTE_ALL, "execute_&all", DatabaseBundle.message((String)"action.execute.span.style.text.decoration.underline.span.ll.text", (Object[])new Object[0]))),
        WARNING_MESSAGE_TYPE(WARNING, (b2, r, l, e) -> b2.messageType(MessageType.WARNING)),
        ERROR_MESSAGE_TYPE(ERROR, (b2, r, l, e) -> b2.messageType(MessageType.ERROR)),
        CLOSE((r, e) -> true, (b2, r, l, e) -> b2.addCloseButton(() -> ConsoleDataRequest.hideErrorPanel(r.shared.sourceEditor)));

        private final Accepter myAccepter;
        private final Configurator myConfigurator;

        private ErrorPanelConfigurator(Accepter accepter, Configurator configurator) {
            if (accepter == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(0);
            }
            if (configurator == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(1);
            }
            this.myAccepter = accepter;
            this.myConfigurator = configurator;
        }

        boolean isAcceptable(@NotNull ConsoleDataRequest request, @NotNull ErrorInfo errorInfo) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(2);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(3);
            }
            return this.myAccepter.accept(request, errorInfo);
        }

        void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<Decision> listener2, @NotNull ErrorInfo errorInfo) {
            if (builder == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(4);
            }
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(5);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(6);
            }
            this.myConfigurator.configure(builder, request, listener2, errorInfo);
        }

        @NotNull
        static Iterable<ErrorPanelConfigurator> filterFor(@NotNull ConsoleDataRequest request, @NotNull ErrorInfo errorInfo) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(7);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(8);
            }
            JBIterable jBIterable = JBIterable.of((Object[])ErrorPanelConfigurator.values()).filter(v -> v.isAcceptable(request, errorInfo));
            if (jBIterable == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accepter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$ErrorPanelConfigurator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$ErrorPanelConfigurator";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "configure";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFor";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(0);
            }
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            ConsoleDataRequest.hideErrorPanel(editor);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                EscapeHandler.$$$reportNull$$$0(2);
            }
            return ERROR_PANEL_KEY.get((UserDataHolder)editor) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$EscapeHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ErrorPanelInfo {
        public final ErrorNotificationPanel errorPanel;
        public final Consumer<Decision> decisionConsumer;

        ErrorPanelInfo(@NotNull ErrorNotificationPanel errorPanel, @Nullable Consumer<Decision> decisionConsumer) {
            if (errorPanel == null) {
                ErrorPanelInfo.$$$reportNull$$$0(0);
            }
            this.errorPanel = errorPanel;
            this.decisionConsumer = decisionConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/database/run/ConsoleDataRequest$ErrorPanelInfo", "<init>"));
        }
    }

    private static class QueryTextResult {
        private final String myText;
        private final TranslateException myTranslateException;

        QueryTextResult(@NotNull String text2, @Nullable TranslateException translateException) {
            if (text2 == null) {
                QueryTextResult.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myTranslateException = translateException;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                QueryTextResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public TranslateException getTranslateException() {
            return this.myTranslateException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequest$QueryTextResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequest$QueryTextResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SubQueriesInfo {
        public final boolean myContainSingleSubQuery;
        public final List<ResultSetSubQuery> myResultSetSubQueries;

        SubQueriesInfo(boolean containSingleSubQuery, @NotNull List<ResultSetSubQuery> resultSetSubQueries) {
            if (resultSetSubQueries == null) {
                SubQueriesInfo.$$$reportNull$$$0(0);
            }
            this.myContainSingleSubQuery = containSingleSubQuery;
            this.myResultSetSubQueries = resultSetSubQueries;
        }

        public boolean containSingleSubQuery() {
            return this.myContainSingleSubQuery;
        }

        @Nullable
        public ResultSetSubQuery getResultSetSubquery(int resultSetIndex) {
            return this.myResultSetSubQueries.size() >= resultSetIndex ? this.myResultSetSubQueries.get(resultSetIndex - 1) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSetSubQueries", "com/intellij/database/run/ConsoleDataRequest$SubQueriesInfo", "<init>"));
        }
    }

    public static class ResultSetSubQuery {
        public final String query;
        public final String title;
        public final SqlTableType resultType;

        ResultSetSubQuery(@NotNull String query, @Nullable String title, @Nullable SqlTableType resultType) {
            if (query == null) {
                ResultSetSubQuery.$$$reportNull$$$0(0);
            }
            this.query = query;
            this.title = title;
            this.resultType = resultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/run/ConsoleDataRequest$ResultSetSubQuery", "<init>"));
        }
    }

    private static class ErrorInfo {
        static ErrorInfo WARNING = new ErrorInfo(true);
        static ErrorInfo ERROR = new ErrorInfo(false);
        private final boolean myIsWarning;
        @Nullable
        private final Runnable mySuppressAction;

        ErrorInfo(boolean isWarning, @Nullable Runnable suppressAction) {
            this.myIsWarning = isWarning;
            this.mySuppressAction = suppressAction;
        }

        private ErrorInfo(boolean isWarning) {
            this.myIsWarning = isWarning;
            this.mySuppressAction = null;
        }

        public boolean isWarning() {
            return this.myIsWarning;
        }

        @Nullable
        public Runnable getSuppressAction() {
            return this.mySuppressAction;
        }
    }

    private static class Shared
    extends UserDataHolderBase {
        final Editor sourceEditor;
        final ScriptModel<?> scriptModel;
        final DataRequest.Constraints constraints;
        final JBIterator<? extends ScriptModel.StatementIt<?>> queries;
        final List<RangeMarker> rangeMarkers;
        long lastUpdateTime = -1L;
        ProblemSolver errorsSolver = new ErrorsSolver();
        WarningsSolver warningsSolver = new WarningsSolver();

        Shared(Editor sourceEditor, ScriptModel<?> scriptModel, DataRequest.Constraints constraints) {
            this.queries = JBIterator.from((Iterator)scriptModel.statements().iterator());
            this.sourceEditor = sourceEditor;
            this.scriptModel = scriptModel;
            this.constraints = constraints;
            Document document = sourceEditor.getDocument();
            this.rangeMarkers = scriptModel.statements().transform(it2 -> {
                TextRange range = it2.range().shiftRight((int)it2.rangeOffset());
                return range.getEndOffset() <= document.getTextLength() ? document.createRangeMarker(range) : null;
            }).toList();
        }

        @Nullable
        TextRange adjustedRange(int idx) {
            return (TextRange)ApplicationManager.getApplication().runReadAction(() -> {
                RangeMarker marker = this.rangeMarkers.get(idx);
                return marker != null && marker.isValid() ? TextRange.create((Segment)marker) : null;
            });
        }
    }

    public static enum Decision {
        STOP,
        RETRY,
        IGNORE,
        IGNORE_ALL,
        FORCE_EXECUTE,
        FORCE_EXECUTE_ALL;

    }
}

