/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelNameIndex {
    private final AtomicReference<NameIndex> myNameIndex = new AtomicReference();

    @NotNull
    protected abstract DasModel getModel();

    @Nullable
    protected DasObject getRoot() {
        return null;
    }

    public void clear() {
        this.myNameIndex.set(null);
    }

    @NotNull
    public Collection<String> getAllNames() {
        ObjectSet objectSet = this.getNameIndex().objects.keySet();
        if (objectSet == null) {
            ModelNameIndex.$$$reportNull$$$0(0);
        }
        return objectSet;
    }

    @NotNull
    public Collection<DasObject> getObjectsByName(@NotNull String name) {
        if (name == null) {
            ModelNameIndex.$$$reportNull$$$0(1);
        }
        Collection<DasObject> collection = this.getNameIndex().getObjects(name);
        if (collection == null) {
            ModelNameIndex.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public JBIterable<DasObject> getObjectsByNameInsensitive(@NotNull String name) {
        if (name == null) {
            ModelNameIndex.$$$reportNull$$$0(3);
        }
        NameIndex index2 = this.getNameIndex();
        Set names = (Set)index2.insensitive.get((Object)name);
        JBIterable jBIterable = names == null ? JBIterable.empty() : JBIterable.from((Iterable)names).flatten(index2::getObjects);
        if (jBIterable == null) {
            ModelNameIndex.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private NameIndex getNameIndex() {
        NameIndex res2;
        DasObject root2 = this.getRoot();
        DasModel model = this.getModel();
        do {
            NameIndex result;
            if ((result = this.myNameIndex.get()) != null) {
                NameIndex nameIndex = result;
                if (nameIndex == null) {
                    ModelNameIndex.$$$reportNull$$$0(5);
                }
                return nameIndex;
            }
            res2 = new NameIndex();
            if (root2 != null) {
                res2.put(root2.getName(), root2);
            }
            int i2 = 0;
            TreePattern scope = DbImplUtil.getIntrospectionScope((DasDataSource)ObjectUtils.tryCast((Object)root2, DasDataSource.class));
            JBTreeTraverser traverser = (JBTreeTraverser)model.traverser().expand(o -> o.getKind() != ObjectKind.ROUTINE && DbImplUtil.isExpandable(o, scope));
            for (DasObject o2 : traverser.bfsTraversal()) {
                if (++i2 % 1000 == 0 && (result = this.myNameIndex.get()) != null) {
                    NameIndex nameIndex = result;
                    if (nameIndex == null) {
                        ModelNameIndex.$$$reportNull$$$0(6);
                    }
                    return nameIndex;
                }
                String name = o2.getName();
                res2.put(name, o2);
            }
            res2.compact();
        } while (!this.myNameIndex.compareAndSet(null, res2));
        NameIndex nameIndex = res2;
        if (nameIndex == null) {
            ModelNameIndex.$$$reportNull$$$0(7);
        }
        return nameIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/ModelNameIndex";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/ModelNameIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInsensitive";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInsensitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NameIndex {
        final Object2ObjectOpenHashMap<String, List<DasObject>> objects = new Object2ObjectOpenHashMap();
        private final Object2ObjectOpenCustomHashMap<String, THashSet<String>> insensitive = new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());

        private NameIndex() {
        }

        void put(@NotNull String name, @NotNull DasObject object) {
            List objectsBucket;
            if (name == null) {
                NameIndex.$$$reportNull$$$0(0);
            }
            if (object == null) {
                NameIndex.$$$reportNull$$$0(1);
            }
            if ((objectsBucket = (List)this.objects.get((Object)name)) == null) {
                objectsBucket = new SmartList();
                this.objects.put((Object)name, (Object)objectsBucket);
            }
            objectsBucket.add(object);
            THashSet namesBucket = (THashSet)this.insensitive.get((Object)name);
            if (namesBucket == null) {
                namesBucket = new SmartHashSet();
                this.insensitive.put((Object)name, (Object)namesBucket);
            }
            namesBucket.add((Object)name);
        }

        void compact() {
            this.objects.trim();
            for (THashSet value2 : this.insensitive.values()) {
                value2.compact();
            }
            this.insensitive.trim();
        }

        @NotNull
        Collection<DasObject> getObjects(@NotNull String name) {
            if (name == null) {
                NameIndex.$$$reportNull$$$0(2);
            }
            Collection collection = (Collection)ObjectUtils.chooseNotNull((Object)((List)this.objects.get((Object)name)), Collections.emptyList());
            if (collection == null) {
                NameIndex.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/ModelNameIndex$NameIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/ModelNameIndex$NameIndex";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

