/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.psi.SqlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbViewGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if (!(psiElement instanceof DasObject)) {
            List list = Collections.emptyList();
            if (list == null) {
                DbViewGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        final ArrayList<GotoRelatedItem> result = new ArrayList<GotoRelatedItem>();
        if (psiElement instanceof DasColumn) {
            DasColumn columnInfo = (DasColumn)psiElement;
            if (DasUtil.isForeign((DasColumn)columnInfo)) {
                for (DasForeignKey keyInfo : ModelRelationManager.getForeignKeys(psiElement.getProject(), columnInfo.getTable())) {
                    MultiRef.It it2 = keyInfo.getColumnsRef().iterate();
                    while (it2.hasNext()) {
                        String next = (String)it2.next();
                        if (!Objects.equals(next, columnInfo.getName())) continue;
                        DbViewGotoRelatedProvider.addItem(result, (DasObject)it2.resolve());
                    }
                }
                ArrayList<GotoRelatedItem> arrayList = result;
                if (arrayList == null) {
                    DbViewGotoRelatedProvider.$$$reportNull$$$0(2);
                }
                return arrayList;
            }
        } else {
            BasicElement element2;
            if (psiElement instanceof DasTableChild) {
                if (psiElement instanceof DasForeignKey) {
                    this.addItems(result, (MultiRef<? extends DasTypedObject>)((DasForeignKey)psiElement).getRefColumns(), DatabaseBundle.message((String)"separator.referenced", (Object[])new Object[0]));
                }
                if (psiElement instanceof DasConstraint) {
                    String group = psiElement instanceof DasForeignKey ? DatabaseBundle.message((String)"separator.referring", (Object[])new Object[0]) : "";
                    this.addItems(result, (MultiRef<? extends DasTypedObject>)((DasConstraint)psiElement).getColumnsRef(), group);
                } else if (psiElement instanceof DasIndex) {
                    this.addItems(result, (MultiRef<? extends DasTypedObject>)((DasIndex)psiElement).getColumnsRef(), "");
                }
                ArrayList<GotoRelatedItem> arrayList = result;
                if (arrayList == null) {
                    DbViewGotoRelatedProvider.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            if (psiElement instanceof DasSynonym) {
                DbViewGotoRelatedProvider.addItem(result, ((DasSynonym)psiElement).resolveTarget());
                ArrayList<GotoRelatedItem> arrayList = result;
                if (arrayList == null) {
                    DbViewGotoRelatedProvider.$$$reportNull$$$0(4);
                }
                return arrayList;
            }
            if (psiElement instanceof DasDataSource) {
                VirtualFile dsRoot;
                String uniqueId = ((DasDataSource)psiElement).getUniqueId();
                final DbConsoleRootType rootType = DbConsoleRootType.getInstance();
                VirtualFile root2 = LocalFileSystem.getInstance().findFileByPath(ScratchFileService.getInstance().getRootPath((RootType)rootType));
                VirtualFile virtualFile = dsRoot = root2 != null && root2.isDirectory() ? root2.findChild(uniqueId) : null;
                if (dsRoot != null && dsRoot.isDirectory()) {
                    final PsiManager psiManager = psiElement.getManager();
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)dsRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                        public boolean visitFile(final @NotNull VirtualFile file) {
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (file.isDirectory()) {
                                return true;
                            }
                            PsiFile psiFile = psiManager.findFile(file);
                            if (psiFile instanceof SqlFile) {
                                result.add(new GotoRelatedItem((PsiElement)psiFile){

                                    @NlsSafe
                                    @Nullable
                                    public String getCustomName() {
                                        return rootType.substituteName(psiManager.getProject(), file);
                                    }

                                    public String getCustomContainerName() {
                                        return "(" + rootType.getDisplayName() + ")";
                                    }

                                    @Nullable
                                    public Icon getCustomIcon() {
                                        return rootType.substituteIcon(psiManager.getProject(), file);
                                    }
                                });
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbViewGotoRelatedProvider$1", "visitFile"));
                        }
                    });
                    ArrayList<GotoRelatedItem> arrayList = result;
                    if (arrayList == null) {
                        DbViewGotoRelatedProvider.$$$reportNull$$$0(5);
                    }
                    return arrayList;
                }
            } else if (psiElement instanceof DbElement && (element2 = DbImplUtil.getMaybeBasicElement((DasObject)((DbElement)psiElement))) != null) {
                DbDataSource ds = ((DbElement)psiElement).getDataSource();
                Iterator<? extends BasicElement> iterator = element2.getPredecessors().iterator();
                if (iterator.hasNext()) {
                    BasicElement predecessor = iterator.next();
                    DbElement tgt = DbImplUtil.findElement(ds, predecessor);
                    if (tgt != null) {
                        DbViewGotoRelatedProvider.addItem(result, (DasObject)tgt);
                    }
                    ArrayList<GotoRelatedItem> arrayList = result;
                    if (arrayList == null) {
                        DbViewGotoRelatedProvider.$$$reportNull$$$0(6);
                    }
                    return arrayList;
                }
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            DbViewGotoRelatedProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void addItems(List<GotoRelatedItem> result, MultiRef<? extends DasTypedObject> columns, @NlsContexts.Separator String title) {
        for (DasTypedObject column2 : columns.resolveObjects()) {
            DbViewGotoRelatedProvider.addItem(result, (DasObject)column2, title);
        }
    }

    private static void addItem(List<GotoRelatedItem> result, DasObject target) {
        DbViewGotoRelatedProvider.addItem(result, target, "");
    }

    private static void addItem(List<GotoRelatedItem> result, DasObject target, @NlsContexts.Separator String title) {
        if (target instanceof DbElement) {
            final PsiElement navElement = new DatabaseTargetElementEvaluator().getGotoDeclarationTarget((PsiElement)((DbElement)target), null);
            result.add(new GotoRelatedItem((PsiElement)((DbElement)target), title){

                public void navigate() {
                    Objects.requireNonNull((Navigatable)navElement).navigate(true);
                }
            });
        } else if (target instanceof PsiElement) {
            result.add(new GotoRelatedItem((PsiElement)target, title));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbViewGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

