/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.codeInsight.hint.ImplementationViewSession;
import com.intellij.codeInsight.hint.ImplementationViewSessionFactory;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbImplementationViewSession
implements ImplementationViewSession {
    private final ImplementationViewSessionFactory myFactory;
    private final DbElement myElement;
    private final Editor myEditor;

    public DbImplementationViewSession(@NotNull ImplementationViewSessionFactory factory, @NotNull DbElement element2, @Nullable Editor editor) {
        if (factory == null) {
            DbImplementationViewSession.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DbImplementationViewSession.$$$reportNull$$$0(1);
        }
        this.myFactory = factory;
        this.myElement = element2;
        this.myEditor = editor;
    }

    @NotNull
    public ImplementationViewSessionFactory getFactory() {
        ImplementationViewSessionFactory implementationViewSessionFactory = this.myFactory;
        if (implementationViewSessionFactory == null) {
            DbImplementationViewSession.$$$reportNull$$$0(2);
        }
        return implementationViewSessionFactory;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myElement.getProject();
        if (project == null) {
            DbImplementationViewSession.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public List<ImplementationViewElement> getImplementationElements() {
        List<ImplementationViewElement> list = Collections.singletonList(new ImplementationViewElement(){

            @NotNull
            public Project getProject() {
                Project project = DbImplementationViewSession.this.myElement.getProject();
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return project;
            }

            public boolean isNamed() {
                return true;
            }

            @Nullable
            public String getName() {
                return DbImplementationViewSession.this.myElement.getName();
            }

            @NotNull
            public String getPresentableText() {
                String string = DbImplementationViewSession.this.myElement.getName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public VirtualFile getContainingFile() {
                return DbImplUtil.findSourceVirtualFile(DbImplementationViewSession.this.myElement, false);
            }

            @Nullable
            public String getText() {
                VirtualFile file = DbSrcUtils.findDbSrcFile(DbImplementationViewSession.this.myElement.getDataSource(), (DasObject)DbImplementationViewSession.this.myElement, true);
                if (file != null) {
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    return document == null ? null : document.getText();
                }
                return DbImplementationViewSession.this.myElement.getText();
            }

            @Nullable
            public String getLocationText() {
                return null;
            }

            @Nullable
            public Icon getLocationIcon() {
                return null;
            }

            @NotNull
            public ImplementationViewElement getContainingMemberOrSelf() {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return v0;
            }

            @Nullable
            public PsiElement getElementForShowUsages() {
                return DbImplementationViewSession.this.myElement;
            }

            public void navigate(boolean focusEditor) {
                DatabaseTargetElementEvaluator.navigateToSource(DbImplementationViewSession.this.myElement, focusEditor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/psi/DbImplementationViewSession$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPresentableText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContainingMemberOrSelf";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        if (list == null) {
            DbImplementationViewSession.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public VirtualFile getFile() {
        return DbImplUtil.findSourceVirtualFile(this.myElement, false);
    }

    @Nullable
    public String getText() {
        return this.myElement.getName();
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public List<ImplementationViewElement> searchImplementationsInBackground(@NotNull ProgressIndicator indicator, @NotNull Processor<? super ImplementationViewElement> processor) {
        if (indicator == null) {
            DbImplementationViewSession.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            DbImplementationViewSession.$$$reportNull$$$0(6);
        }
        List<ImplementationViewElement> list = Collections.emptyList();
        if (list == null) {
            DbImplementationViewSession.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean elementRequiresIncludeSelf() {
        return false;
    }

    public boolean needUpdateInBackground() {
        return false;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbImplementationViewSession";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbImplementationViewSession";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "searchImplementationsInBackground";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "searchImplementationsInBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements ImplementationViewSessionFactory {
        @Nullable
        public ImplementationViewSession createSession(@NotNull DataContext dataContext, @NotNull Project project, boolean isSearchDeep, boolean alwaysIncludeSelf) {
            PsiElement element2;
            DbElement dbElement;
            if (dataContext == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return (dbElement = (DbElement)ObjectUtils.tryCast((Object)(element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), DbElement.class)) == null ? null : new DbImplementationViewSession(this, dbElement, (Editor)CommonDataKeys.EDITOR.getData(dataContext));
        }

        @Nullable
        public ImplementationViewSession createSessionForLookupElement(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, @Nullable Object lookupItemObject, boolean isSearchDeep, boolean alwaysIncludeSelf) {
            DbElement dbElement;
            if (project == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return (dbElement = (DbElement)ObjectUtils.tryCast((Object)lookupItemObject, DbElement.class)) == null ? null : new DbImplementationViewSession(this, dbElement, editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/psi/DbImplementationViewSession$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSession";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSessionForLookupElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

