/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.TypePresentationService;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbFavoriteNodeProvider
extends FavoriteNodeProvider {
    private final Project myProject;

    public DbFavoriteNodeProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        Project project;
        PsiElement[] psiElements;
        if (viewSettings == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        PsiElement[] psiElementArray = psiElements = (project = (Project)CommonDataKeys.PROJECT.getData(context)) == null ? null : (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context);
        if (psiElements == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (PsiElement psi : psiElements) {
            AbstractTreeNode<?> node = this.createNode(project, psi, viewSettings);
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    @Nullable
    public AbstractTreeNode<?> createNode(Project project, Object element2, @NotNull ViewSettings viewSettings) {
        if (viewSettings == null) {
            DbFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        if (!(element2 instanceof DbElement)) {
            return null;
        }
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((DbElement)element2).getVirtualFile();
        return file == null ? null : new DbElementNode(project, file, viewSettings);
    }

    public boolean elementContainsFile(Object element2, VirtualFile vFile) {
        return false;
    }

    public int getElementWeight(Object element2, boolean isSortByType) {
        return 0;
    }

    @Nullable
    public String getElementLocation(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        DbElement dbElement = ((DatabaseElementVirtualFileImpl)((Object)element2)).findElement(this.myProject);
        DbElement parent2 = dbElement == null ? null : dbElement.getDasParent();
        return parent2 == null ? null : ((DatabaseElementVirtualFileImpl)parent2.getVirtualFile()).getPresentablePath();
    }

    public boolean isInvalidElement(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return false;
        }
        return !((DatabaseElementVirtualFileImpl)((Object)element2)).isValid();
    }

    @NotNull
    public String getFavoriteTypeId() {
        return "database";
    }

    @Nullable
    public String getElementUrl(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        return ((DatabaseElementVirtualFileImpl)((Object)element2)).getUrl();
    }

    @Nullable
    public String getElementModuleName(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        DbElement dbElement = ((DatabaseElementVirtualFileImpl)((Object)element2)).findElement(this.myProject);
        SqlElement sql = dbElement != null ? (SqlElement)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlSourceElement(dbElement), SqlElement.class) : null;
        Module module = sql == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)sql);
        return module != null && !ModuleType.isInternal((Module)module) ? module.getName() : null;
    }

    @Nullable
    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        Object[] objectArray;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file instanceof DatabaseElementVirtualFileImpl) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = file;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Nullable
    public PsiElement getPsiElement(Object element2) {
        if (!(element2 instanceof DatabaseElementVirtualFileImpl)) {
            return null;
        }
        return ((DatabaseElementVirtualFileImpl)((Object)element2)).findElement(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "viewSettings";
        objectArray2[1] = "com/intellij/database/psi/DbFavoriteNodeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DbElementNode
    extends AbstractPsiBasedNode<DatabaseElementVirtualFileImpl> {
        public DbElementNode(Project project, @NotNull DatabaseElementVirtualFileImpl value2, ViewSettings settings) {
            if (value2 == null) {
                DbElementNode.$$$reportNull$$$0(0);
            }
            super(project, (Object)value2, settings);
        }

        @Nullable
        protected PsiElement extractPsiFromValue() {
            DatabaseElementVirtualFileImpl value2 = (DatabaseElementVirtualFileImpl)((Object)this.getValue());
            return value2 == null ? null : value2.findElement(this.getProject());
        }

        @Nullable
        protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
            return null;
        }

        protected void updateImpl(@NotNull PresentationData presentation) {
            DatabaseElementVirtualFileImpl value2;
            if (presentation == null) {
                DbElementNode.$$$reportNull$$$0(1);
            }
            if ((value2 = (DatabaseElementVirtualFileImpl)((Object)this.getValue())) == null) {
                return;
            }
            presentation.setPresentableText(value2.getPresentableName());
            presentation.setIcon(TypePresentationService.getService().getIcon((Object)value2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/psi/DbFavoriteNodeProvider$DbElementNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

