/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.serialization.FixHierarchicalStreamReader;
import com.intellij.database.model.serialization.FixHierarchicalStreamWriter;
import com.intellij.database.model.serialization.ImportException;
import com.intellij.database.model.serialization.ModelExporter;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.util.TreePattern;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u001a*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"deserialize", "Lcom/intellij/database/model/basic/BasicModModel;", "reader", "Lcom/thoughtworks/xstream/io/HierarchicalStreamReader;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "dataSourceName", "", "importer", "Lcom/intellij/database/model/serialization/ModelImporter;", "serialize", "", "model", "Lcom/intellij/database/model/DasModel;", "writer", "Lcom/thoughtworks/xstream/io/HierarchicalStreamWriter;", "exporter", "Lcom/intellij/database/model/serialization/ModelExporter;", "scope", "Lcom/intellij/database/util/TreePattern;", "intellij.database.impl"})
public final class ModelSerializerKt {
    public static final void serialize(@NotNull DasModel model, @NotNull HierarchicalStreamWriter writer, @Nullable TreePattern scope) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ModelSerializerKt.serialize(model, writer, new ModelExporter(), scope);
    }

    @NotNull
    public static final BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelFactory modelFactory, @Nullable String dataSourceName) throws ImportException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        return ModelSerializerKt.deserialize(reader, new ModelImporter(modelFactory), dataSourceName);
    }

    public static /* synthetic */ BasicModModel deserialize$default(HierarchicalStreamReader hierarchicalStreamReader, ModelFactory modelFactory, String string, int n, Object object) throws ImportException {
        if ((n & 4) != 0) {
            string = null;
        }
        return ModelSerializerKt.deserialize(hierarchicalStreamReader, modelFactory, string);
    }

    private static final void serialize(DasModel model, HierarchicalStreamWriter writer, ModelExporter exporter, TreePattern scope) {
        DasModel dasModel = model;
        if (!(dasModel instanceof BasicModel)) {
            throw (Throwable)new IllegalArgumentException("Unknown how to export model class " + model.getClass().getSimpleName());
        }
        exporter.saveModel((BasicModel)model, new FixHierarchicalStreamWriter(writer), scope);
    }

    @NotNull
    public static final BasicModModel deserialize(@NotNull HierarchicalStreamReader reader, @NotNull ModelImporter importer, @Nullable String dataSourceName) throws ImportException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)importer, (String)"importer");
        ModelMem modelMem = importer.deserializeModel(new FixHierarchicalStreamReader(reader), dataSourceName);
        Intrinsics.checkNotNullExpressionValue((Object)modelMem, (String)"importer.deserializeMode\u2026(reader), dataSourceName)");
        ModelMem modelMem2 = modelMem;
        BasicModModel basicModModel = importer.importModel(modelMem2);
        Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"importer.importModel(modelMem)");
        return basicModModel;
    }
}

