/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ColumnKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.util.CalendarFun;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PropertyConverter {
    public static final Logger ourLog = Logger.getInstance(PropertyConverter.class);
    public static final BasicMetaType<Boolean> T_BOOLEAN = new BasicMetaType<Boolean>(Boolean.TYPE, PropertyConverter::importBoolean, PropertyConverter::export);
    public static final BasicMetaType<Byte> T_BYTE = new BasicMetaType<Byte>(Byte.TYPE, PropertyConverter::importByte, PropertyConverter::export);
    public static final BasicMetaType<Short> T_SHORT = new BasicMetaType<Short>(Short.TYPE, PropertyConverter::importShort, PropertyConverter::export);
    public static final BasicMetaType<Integer> T_INT = new BasicMetaType<Integer>(Integer.TYPE, PropertyConverter::importInt, PropertyConverter::export);
    public static final BasicMetaType<Long> T_LONG = new BasicMetaType<Long>(Long.TYPE, PropertyConverter::importLong, PropertyConverter::export);
    public static final BasicMetaType<Float> T_FLOAT = new BasicMetaType<Float>(Float.TYPE, PropertyConverter::importFloat, PropertyConverter::export);
    public static final BasicMetaType<Double> T_DOUBLE = new BasicMetaType<Double>(Double.TYPE, PropertyConverter::importDouble, PropertyConverter::export);
    public static final BasicMetaType<String> T_STRING = new BasicMetaType<String>(String.class, PropertyConverter::importString, PropertyConverter::export);
    public static final BasicMetaType<OneTimeString> T_ONE_TIME_STRING = new BasicMetaType<OneTimeString>(OneTimeString.class, PropertyConverter::importOneTimeString, PropertyConverter::export);
    public static final BasicMetaType<Date> T_DATE = new BasicMetaType<Date>(Date.class, PropertyConverter::importDate, PropertyConverter::export);
    public static final BasicMetaType<ObjectKind> T_OBJECT_KIND = new BasicMetaType<ObjectKind>(ObjectKind.class, PropertyConverter::importObjectKind, PropertyConverter::export);
    public static final BasicMetaType<BigInteger> T_BIG_INTEGER = new BasicMetaType<BigInteger>(BigInteger.class, PropertyConverter::importBigInteger, PropertyConverter::export);
    public static final BasicMetaType<DataType> T_DATA_TYPE = new BasicMetaType<DataType>(DataType.class, PropertyConverter::importDataType, PropertyConverter::export);
    public static final BasicMetaType<SequenceIdentity> T_SEQUENCE_IDENTITY = new BasicMetaType<SequenceIdentity>(SequenceIdentity.class, PropertyConverter::importSequenceIdentity, PropertyConverter::export);
    public static final BasicMetaType<ArgumentDirection> T_ARGUMENT_DIRECTION = new BasicMetaType<ArgumentDirection>(ArgumentDirection.class, PropertyConverter::importArgumentDirection, PropertyConverter::export);
    public static final BasicMetaType<Casing> T_CASING = new BasicMetaType<Casing>(Casing.class, PropertyConverter::importCasing, PropertyConverter::export);
    public static final BasicMetaType<CascadeRule> T_CASCADE_RULE = new BasicMetaType<CascadeRule>(CascadeRule.class, PropertyConverter::importCascadeRule, PropertyConverter::export);
    public static final BasicMetaType<DasRoutine.Kind> T_DAS_ROUTINE_KIND = new BasicMetaType<DasRoutine.Kind>(DasRoutine.Kind.class, PropertyConverter::importDasRoutineKind, PropertyConverter::export);
    public static final BasicMetaType<TrigTurn> T_TRIG_TURN = new BasicMetaType<TrigTurn>(TrigTurn.class, PropertyConverter::importTrigTurn, PropertyConverter::export);
    public static final BasicMetaType<ColumnKind> T_COLUMN_KIND = new BasicMetaType<ColumnKind>(ColumnKind.class, PropertyConverter::importColumnKind, PropertyConverter::export);
    public static final BasicMetaType<ClusterType> T_CLUSTER_TYPE = new BasicMetaType<ClusterType>(ClusterType.class, PropertyConverter::importClusterType, PropertyConverter::export);
    public static final BasicMetaType<Version> T_VERSION = new BasicMetaType<Version>(Version.class, PropertyConverter::importVersion, PropertyConverter::export);
    public static final BasicMetaType<Dbms> T_DBMS = new BasicMetaType<Dbms>(Dbms.class, PropertyConverter::importDbms, PropertyConverter::export);
    public static final BasicMetaType<List<Short>> T_LIST_OF_SHORT = new BasicMetaType.CollectionMetaType<Short, List<Short>>(List.class, Short.class, PropertyConverter::importListOfShort, PropertyConverter::exportListOfShort);
    public static final BasicMetaType<List<Long>> T_LIST_OF_LONG = new BasicMetaType.CollectionMetaType<Long, List<Long>>(List.class, Long.class, PropertyConverter::importListOfLong, PropertyConverter::exportListOfLong);
    public static final BasicMetaType<List<Integer>> T_LIST_OF_INTEGER = new BasicMetaType.CollectionMetaType<Integer, List<Integer>>(List.class, Integer.class, PropertyConverter::importListOfInteger, PropertyConverter::exportListOfInteger);
    public static final BasicMetaType<Set<Long>> T_SET_OF_LONG = new BasicMetaType.CollectionMetaType<Long, Set<Long>>(Set.class, Long.class, PropertyConverter::importSetOfLong, PropertyConverter::exportSetOfLong);
    public static final BasicMetaType<List<String>> T_LIST_OF_STRING = new BasicMetaType.CollectionMetaType<String, List<String>>(List.class, String.class, PropertyConverter::importListOfString, PropertyConverter::exportListOfString);
    public static final BasicMetaType<Set<String>> T_SET_OF_STRING = new BasicMetaType.CollectionMetaType<String, Set<String>>(Set.class, String.class, PropertyConverter::importSetOfString, PropertyConverter::exportSetOfString);
    public static final BasicMetaType<List<NameValue>> T_LIST_OF_NAME_VALUE = new BasicMetaType.CollectionMetaType<NameValue, List<NameValue>>(List.class, NameValue.class, PropertyConverter::importListOfNameValue, PropertyConverter::exportListOfNameValue);
    public static final BasicMetaType<List<NameValueType>> T_LIST_OF_NAME_VALUE_TYPE = new BasicMetaType.CollectionMetaType<NameValueType, List<NameValueType>>(List.class, NameValueType.class, PropertyConverter::importListOfNameValueType, PropertyConverter::exportListOfNameValueType);
    public static final BasicMetaType<Set<TrigEvent>> T_SET_OF_TRIG_EVENT = new BasicMetaType.CollectionMetaType<TrigEvent, Set<TrigEvent>>(Set.class, TrigEvent.class, PropertyConverter::importSetOfTrigEvent, PropertyConverter::exportSetOfTrigEvent);
    public static final BasicMetaType<List<IndexColumn>> T_LIST_OF_INDEX_COLUMN = new BasicMetaType.CollectionMetaType<IndexColumn, List<IndexColumn>>(List.class, IndexColumn.class, PropertyConverter::importListOfIndexColumn, PropertyConverter::exportListOfIndexColumn);
    public static final BasicMetaType<List<SourceError>> T_LIST_OF_SOURCE_ERROR = new BasicMetaType.CollectionMetaType<SourceError, List<SourceError>>(List.class, SourceError.class, PropertyConverter::importListOfSourceError, PropertyConverter::exportListOfSourceError);

    public static String export(boolean value2) {
        return value2 ? "1" : "0";
    }

    public static String export(byte value2) {
        return Byte.toString(value2);
    }

    public static String export(short value2) {
        return Short.toString(value2);
    }

    public static String export(int value2) {
        return Integer.toString(value2);
    }

    public static String export(long value2) {
        return Long.toString(value2);
    }

    public static String export(float value2) {
        return Float.toString(value2);
    }

    public static String export(double value2) {
        return Double.toString(value2);
    }

    @Nullable
    public static String export(@NotNull String string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(0);
        }
        return StringUtil.nullize((String)string);
    }

    @Nullable
    public static String export(@NotNull OneTimeString string) {
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(1);
        }
        return string.toString(false);
    }

    public static String export(@NotNull Date timestamp) {
        if (timestamp == null) {
            PropertyConverter.$$$reportNull$$$0(2);
        }
        return CalendarFun.export(timestamp);
    }

    public static String export(@NotNull ObjectKind kind) {
        if (kind == null) {
            PropertyConverter.$$$reportNull$$$0(3);
        }
        return kind.code();
    }

    public static String export(@NotNull BigInteger bigInteger) {
        if (bigInteger == null) {
            PropertyConverter.$$$reportNull$$$0(4);
        }
        return bigInteger.toString();
    }

    public static String export(@NotNull DataType dt) {
        if (dt == null) {
            PropertyConverter.$$$reportNull$$$0(5);
        }
        return DataTypeFactory.serialize(dt);
    }

    public static String export(@NotNull SequenceIdentity si) {
        if (si == null) {
            PropertyConverter.$$$reportNull$$$0(6);
        }
        return si.getSpecification();
    }

    public static String export(@NotNull Enum item) {
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(7);
        }
        return StringUtil.toLowerCase((String)item.name()).replace('_', '-');
    }

    public static String export(@NotNull ArgumentDirection dir) {
        if (dir == null) {
            PropertyConverter.$$$reportNull$$$0(8);
        }
        return Character.toString(dir.code);
    }

    public static String export(@NotNull Casing casing) {
        if (casing == null) {
            PropertyConverter.$$$reportNull$$$0(9);
        }
        return casing.specification();
    }

    public static String export(@NotNull Version version) {
        if (version == null) {
            PropertyConverter.$$$reportNull$$$0(10);
        }
        return version.toString();
    }

    public static String export(@NotNull Dbms dbms) {
        if (dbms == null) {
            PropertyConverter.$$$reportNull$$$0(11);
        }
        return dbms.getName();
    }

    public static String exportEnumCode(@NotNull Enum item) {
        Object value2;
        if (item == null) {
            PropertyConverter.$$$reportNull$$$0(12);
        }
        Class<?> clazz = item.getClass();
        try {
            Field field = clazz.getField("code");
            value2 = field.get(item);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Failed to serialize an item " + item.name() + " of class " + clazz.getName(), e);
        }
        return value2 != null ? value2.toString() : null;
    }

    @Nullable
    public static String exportListOfShort(@NotNull List<Short> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(13);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfLong(@NotNull List<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(14);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportListOfInteger(@NotNull List<Integer> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(15);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportSetOfLong(@NotNull Set<Long> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(16);
        }
        return PropertyConverter.exportCollectionOfNumber(numbers);
    }

    @Nullable
    public static String exportCollectionOfNumber(@NotNull Collection<? extends Number> numbers) {
        if (numbers == null) {
            PropertyConverter.$$$reportNull$$$0(17);
        }
        int n = numbers.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return numbers.iterator().next().toString();
            }
        }
        return StringUtil.join(numbers, (String)",");
    }

    @Nullable
    public static String exportListOfString(@NotNull List<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(18);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportListOfNameValue(@NotNull List<NameValue> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(19);
        }
        if (strings.isEmpty()) {
            return null;
        }
        return StringUtil.join(strings, nv -> nv.getName() + "\n" + nv.getValue(), (String)"\n");
    }

    @Nullable
    public static String exportListOfNameValueType(@NotNull List<NameValueType> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(20);
        }
        if (strings.isEmpty()) {
            return null;
        }
        return StringUtil.join(strings, nv -> nv.getName() + "\n" + nv.getValue() + "\n" + nv.getType(), (String)"\n");
    }

    @Nullable
    public static String exportSetOfString(@NotNull Set<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(21);
        }
        return PropertyConverter.exportCollectionOfString(strings);
    }

    @Nullable
    public static String exportCollectionOfString(@NotNull Collection<String> strings) {
        if (strings == null) {
            PropertyConverter.$$$reportNull$$$0(22);
        }
        int n = strings.size();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return PropertyConverter.escapeSlashN(strings.iterator().next());
            }
        }
        return StringUtil.join(strings, s2 -> PropertyConverter.escapeSlashN(s2), (String)"\n");
    }

    @NotNull
    public static String escapeSlashN(String s2) {
        String string = s2.replace("\\", "\\\\").replace("\n", "\\n");
        if (string == null) {
            PropertyConverter.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static String exportSetOfTrigEvent(@NotNull Set<TrigEvent> events) {
        if (events == null) {
            PropertyConverter.$$$reportNull$$$0(24);
        }
        StringBuilder b2 = new StringBuilder(events.size());
        for (TrigEvent event : events) {
            b2.append(event.code);
        }
        return b2.toString();
    }

    public static String exportListOfIndexColumn(List<IndexColumn> indexColumns) {
        StringBuilder sb = new StringBuilder();
        for (IndexColumn indexColumn : indexColumns) {
            sb.append(indexColumn.export()).append("\n");
        }
        return sb.toString();
    }

    public static String exportListOfSourceError(List<SourceError> errors) {
        StringBuilder sb = new StringBuilder();
        for (SourceError error2 : errors) {
            sb.append(PropertyConverter.escapeSlashN(error2.export())).append("\n");
        }
        return sb.toString();
    }

    public static boolean importBoolean(String text2) {
        char c2 = text2 != null && !text2.isEmpty() ? text2.charAt(0) : (char)'\u0000';
        c2 = Character.toUpperCase(c2);
        return c2 >= '1' && c2 <= '9' || c2 == 'Y' || c2 == 'T' || c2 == '+';
    }

    public static byte importByte(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Byte.parseByte(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short importShort(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Short.parseShort(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int importInt(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long importLong(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float importFloat(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double importDouble(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(text2.trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static BigInteger importBigInteger(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return BigInteger.ZERO;
        }
        try {
            return new BigInteger(text2.trim());
        }
        catch (NumberFormatException e) {
            return BigInteger.ZERO;
        }
    }

    public static String importString(String text2) {
        return DbUtil.intern((String)text2);
    }

    public static OneTimeString importOneTimeString(String text2) {
        return text2 == null ? null : new OneTimeString(text2);
    }

    public static ObjectKind importObjectKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return (ObjectKind)ObjectKind.ourKinds.get(StringUtil.toLowerCase((String)text2.trim()));
    }

    public static DataType importDataType(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DataTypeFactory.deserialize(text2);
    }

    public static <E extends Enum> E importEnumByCode(Class<E> enumClass, String text2) {
        if (text2 == null) {
            return null;
        }
        int length = text2.length();
        Enum enumItem = null;
        try {
            Object o;
            Method methodWithChar = PropertyConverter.getStaticMethod(enumClass, "of", Character.TYPE);
            Method methodWithString = PropertyConverter.getStaticMethod(enumClass, "of", String.class);
            if (methodWithChar == null && methodWithString == null) {
                throw new IllegalArgumentException(String.format("Cannot import property of type %s: no static method of.", enumClass));
            }
            if (length == 1) {
                if (methodWithChar != null) {
                    Character c2 = Character.valueOf(text2.charAt(0));
                    o = methodWithChar.invoke(null, c2);
                } else {
                    o = methodWithString.invoke(null, text2);
                }
            } else if (methodWithString != null) {
                o = methodWithString.invoke(null, text2);
            } else {
                Character c3 = Character.valueOf(text2.charAt(0));
                o = methodWithChar.invoke(null, c3);
            }
            enumItem = (Enum)o;
        }
        catch (Exception e) {
            String message2 = String.format("Failed to import property value \"%s\" as enum %s: exception %s: %s", text2, enumClass.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            if (ourLog.isDebugEnabled()) {
                ourLog.warn(message2, (Throwable)e);
            }
            ourLog.warn(message2);
        }
        return (E)enumItem;
    }

    public static DasRoutine.Kind importDasRoutineKind(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return DasRoutine.Kind.byChar((char)text2.charAt(0));
    }

    public static ArgumentDirection importArgumentDirection(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return ArgumentDirection.of((char)text2.charAt(0));
    }

    @Contract(value="null -> null")
    public static Date importDate(String text2) {
        if (text2 == null) {
            return null;
        }
        return CalendarFun.importSqlDateTime(text2);
    }

    @Contract(value="null -> null")
    public static Version importVersion(String text2) {
        if (text2 == null) {
            return null;
        }
        try {
            return Version.of((String)text2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Contract(value="null -> null")
    public static Dbms importDbms(String text2) {
        if (text2 == null) {
            return null;
        }
        return Dbms.byName((String)text2);
    }

    @NotNull
    public static List<Short> importListOfShort(String text2) {
        List<Long> listOfLong = PropertyConverter.importListOfLong(text2);
        ArrayList<Short> listOfShort = new ArrayList<Short>(listOfLong.size());
        for (long value2 : listOfLong) {
            if (value2 < -32768L || value2 > 32767L) continue;
            listOfShort.add(new Short((short)value2));
        }
        ArrayList<Short> arrayList = listOfShort;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    public static Set<Long> importSetOfLong(String text2) {
        return PropertyConverter.convertListToSet(PropertyConverter.importListOfLong(text2));
    }

    @NotNull
    public static List<Integer> importListOfInteger(String text2) {
        return PropertyConverter.importList(text2, Integer::parseInt);
    }

    @NotNull
    public static List<Long> importListOfLong(String text2) {
        return PropertyConverter.importList(text2, Long::parseLong);
    }

    @NotNull
    public static <T> List<T> importList(@Nullable String text2, @NotNull Function<String, T> converter) {
        if (converter == null) {
            PropertyConverter.$$$reportNull$$$0(26);
        }
        if (text2 == null || text2.length() == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(27);
            }
            return list;
        }
        List strings = StringUtil.split((String)text2, (String)",");
        int n = strings.size();
        if (n == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(28);
            }
            return list;
        }
        ArrayList<Object> values2 = new ArrayList<Object>(n);
        for (String string : strings) {
            try {
                Object value2 = converter.fun((Object)string);
                values2.add(value2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        switch (values2.size()) {
            case 0: {
                List list = Collections.emptyList();
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(29);
                }
                return list;
            }
            case 1: {
                List list = Collections.singletonList(values2.get(0));
                if (list == null) {
                    PropertyConverter.$$$reportNull$$$0(30);
                }
                return list;
            }
        }
        ArrayList<Object> arrayList = values2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static Set<String> importSetOfString(String text2) {
        if (text2 == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(32);
            }
            return set;
        }
        if (text2.length() == 0) {
            Set<String> set = Collections.singleton("");
            if (set == null) {
                PropertyConverter.$$$reportNull$$$0(33);
            }
            return set;
        }
        List items2 = StringUtil.split((String)text2, (String)"\n");
        PropertyConverter.internElements(items2);
        return PropertyConverter.convertListToSet(items2);
    }

    @NotNull
    public static <T> Set<T> convertListToSet(@NotNull List<T> items2) {
        if (items2 == null) {
            PropertyConverter.$$$reportNull$$$0(34);
        }
        int n = items2.size();
        switch (n) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(35);
                }
                return set;
            }
            case 1: {
                Set<T> set = Collections.singleton(items2.get(0));
                if (set == null) {
                    PropertyConverter.$$$reportNull$$$0(36);
                }
                return set;
            }
        }
        return new TreeSet<T>(items2);
    }

    @NotNull
    public static List<String> importListOfString(String text2) {
        if (text2 == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (text2.length() == 0) {
            List<String> list = Collections.singletonList("");
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(38);
            }
            return list;
        }
        List res2 = StringUtil.split((String)text2, (String)"\n");
        for (int i2 = 0; i2 < res2.size(); ++i2) {
            res2.set(i2, StringUtil.unescapeStringCharacters((String)((String)res2.get(i2))));
        }
        PropertyConverter.internElements(res2);
        List list = res2;
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public static List<NameValue> importListOfNameValue(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<NameValue> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(40);
            }
            return list;
        }
        ArrayList<NameValue> res2 = new ArrayList<NameValue>();
        StringTokenizer tok2 = new StringTokenizer(text2, "\n", false);
        while (tok2.hasMoreTokens()) {
            String name = tok2.nextToken();
            String value2 = tok2.hasMoreTokens() ? tok2.nextToken() : "";
            res2.add(new NameValue(DbUtil.intern((String)name), DbUtil.intern((String)value2)));
        }
        ArrayList<NameValue> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @NotNull
    public static List<NameValueType> importListOfNameValueType(String text2) {
        if (text2 == null || text2.length() == 0) {
            List<NameValueType> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(42);
            }
            return list;
        }
        ArrayList<NameValueType> res2 = new ArrayList<NameValueType>();
        StringTokenizer tok2 = new StringTokenizer(text2, "\n", false);
        while (tok2.hasMoreTokens()) {
            String name = tok2.nextToken();
            String value2 = tok2.hasMoreTokens() ? tok2.nextToken() : "";
            String type = tok2.hasMoreTokens() ? tok2.nextToken() : "";
            res2.add(new NameValueType(DbUtil.intern((String)name), DbUtil.intern((String)value2), DbUtil.intern((String)type)));
        }
        ArrayList<NameValueType> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    public static SequenceIdentity importSequenceIdentity(String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        return SequenceIdentity.of(text2);
    }

    @NotNull
    public static Set<TrigEvent> importSetOfTrigEvent(String text2) {
        EnumSet<TrigEvent> events = EnumSet.noneOf(TrigEvent.class);
        for (TrigEvent e : TrigEvent.values()) {
            if (text2.indexOf(e.code) < 0) continue;
            events.add(e);
        }
        EnumSet<TrigEvent> enumSet = events;
        if (enumSet == null) {
            PropertyConverter.$$$reportNull$$$0(44);
        }
        return enumSet;
    }

    public static TrigEvent importTrigEvent(String text2) {
        return PropertyConverter.importEnum(TrigEvent.class, text2);
    }

    public static TrigTurn importTrigTurn(String text2) {
        return PropertyConverter.importEnum(TrigTurn.class, text2);
    }

    public static CascadeRule importCascadeRule(String text2) {
        return PropertyConverter.importEnumLC(CascadeRule.class, text2);
    }

    public static Casing importCasing(String text2) {
        return Casing.of((String)text2);
    }

    public static ClusterType importClusterType(String text2) {
        return ClusterType.of((String)text2);
    }

    public static <E extends Enum<E>> E importEnum(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = StringUtil.toUpperCase((String)text2.trim().replace('-', '_'));
        return Enum.valueOf(enumClass, big);
    }

    public static <E extends Enum<E>> E importEnumLC(Class<E> enumClass, String text2) {
        if (text2 == null || text2.length() == 0) {
            return null;
        }
        String big = text2.trim().replace('-', '_');
        return Enum.valueOf(enumClass, big);
    }

    @Nullable
    public static ColumnKind importColumnKind(String kind) {
        return PropertyConverter.importEnum(ColumnKind.class, kind);
    }

    @NotNull
    public static List<IndexColumn> importListOfIndexColumn(String text2) {
        String[] lines;
        if (text2 == null || text2.length() == 0) {
            List<IndexColumn> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(45);
            }
            return list;
        }
        ArrayList<IndexColumn> res2 = new ArrayList<IndexColumn>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            res2.add(IndexColumn.read(line));
        }
        ArrayList<IndexColumn> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    @NotNull
    public static List<SourceError> importListOfSourceError(String text2) {
        String[] lines;
        if (text2 == null || text2.length() == 0) {
            List<SourceError> list = Collections.emptyList();
            if (list == null) {
                PropertyConverter.$$$reportNull$$$0(47);
            }
            return list;
        }
        ArrayList<SourceError> res2 = new ArrayList<SourceError>();
        for (String line : lines = StringUtil.splitByLines((String)text2)) {
            res2.add(SourceError.importError(StringUtil.unescapeStringCharacters((String)line)));
        }
        ArrayList<SourceError> arrayList = res2;
        if (arrayList == null) {
            PropertyConverter.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    public static void internElements(@NotNull List<String> list) {
        if (list == null) {
            PropertyConverter.$$$reportNull$$$0(49);
        }
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String s2 = list.get(i2);
            if (s2 == null) continue;
            list.set(i2, DbUtil.intern((String)s2));
        }
    }

    public static <E extends Enum> Method getStaticMethod(@NotNull Class<E> clazz, @NotNull String name, Class<?> ... parameterTypes) {
        Method method;
        if (clazz == null) {
            PropertyConverter.$$$reportNull$$$0(50);
        }
        if (name == null) {
            PropertyConverter.$$$reportNull$$$0(51);
        }
        try {
            method = clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalStateException(String.format("Method %s.%s(%s) must be static", clazz.getSimpleName(), name, StringUtil.join((Object[])parameterTypes, t -> t.getSimpleName(), (String)", ")));
        }
        method.setAccessible(true);
        return method;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigInteger";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "si";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numbers";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/PropertyConverter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashN";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfShort";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "importList";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfString";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "convertListToSet";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfString";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValue";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfNameValueType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "importSetOfTrigEvent";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfIndexColumn";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "importListOfSourceError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "exportEnumCode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfShort";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfLong";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfInteger";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfLong";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfNumber";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "exportListOfNameValueType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfString";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "exportCollectionOfString";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "exportSetOfTrigEvent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "importList";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "convertListToSet";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "internElements";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

