/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.remote.jdba.util.Function;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaUtils {
    public static final Comparator<BasicMetaProperty<?>> PROPERTY_COMPARATOR = Comparator.comparing(p1 -> p1.name);

    @Nullable
    public static <T extends BasicModElement> BasicMetaObject<T> findChild(@Nullable BasicMetaObject<?> obj, @NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaUtils.$$$reportNull$$$0(0);
        }
        if (obj == null) {
            return null;
        }
        for (BasicMetaObject<?> child : obj.children) {
            if (child.kind != kind) continue;
            return child;
        }
        return null;
    }

    public static void copyProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(1);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(2);
        }
        BasicMetaObject<?> meta = to.getMetaObject();
        assert (meta.apiClass.isAssignableFrom(from.getClass())) : "Trying to copy " + from.getClass().getName() + " to " + to.getClass().getName();
        try {
            for (BasicMetaProperty<?> p2 : meta.properties) {
                BasicMetaUtils.copyProperty(from, to, p2);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
        BasicMetaUtils.copySources(from, to, withSources);
    }

    public static void copySources(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(3);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(4);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o = withSources ? (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class) : null;
            BasicModModel model = to.getModel();
            if (model != null) {
                model.writeSources(() -> ((BasicModSourceAware)to).setSourceText(o == null ? null : o.getSourceText()));
            }
        }
    }

    public static void copyMatchedProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean resetOther, boolean withSources) {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(5);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(6);
        }
        BasicMetaObject<?> toMeta = to.getMetaObject();
        try {
            BasicMetaProperty<?>[] properties = toMeta.properties;
            for (int i2 = 0; i2 < properties.length; ++i2) {
                BasicMetaUtils.copyMatchedProperty(from, to, properties[i2], i2, resetOther);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)throwable);
        }
        if (to instanceof BasicModSourceAware) {
            BasicSourceAware o = (BasicSourceAware)ObjectUtils.tryCast((Object)from, BasicSourceAware.class);
            if (withSources && (o != null || resetOther)) {
                ((BasicModSourceAware)to).setSourceText(o == null ? null : o.getSourceText());
            }
        }
    }

    protected static <T> void copyMatchedProperty(@NotNull BasicElement from, @NotNull BasicModElement to, @NotNull BasicMetaProperty<T> p2, int idx, boolean resetOther) throws Throwable {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(7);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(8);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(9);
        }
        BasicMetaProperty<T> p1 = BasicMetaUtils.findMatchingProperty(from.getMetaObject().properties, p2);
        boolean copied = false;
        if (p1 != null) {
            copied = BasicMetaUtils.copyProperty(from, p1, to, p2);
        }
        if (!copied && resetOther) {
            p2.setter.invoke(to, to.getMetaObject().getDefault(p2, idx));
        }
    }

    public static BasicMetaProperty<?> findProperty(BasicMetaProperty<?>[] properties, String name) {
        for (BasicMetaProperty<?> property : properties) {
            if (!property.name.equals(name)) continue;
            return property;
        }
        return null;
    }

    private static <T> BasicMetaProperty<T> findMatchingProperty(BasicMetaProperty<?>[] properties, BasicMetaProperty<T> p2) {
        int i2 = Arrays.binarySearch(properties, 0, properties.length, p2, PROPERTY_COMPARATOR);
        if (i2 < 0) {
            return null;
        }
        BasicMetaProperty<?> res2 = properties[i2];
        if (!res2.getter.type().returnType().equals(p2.getter.type().returnType())) {
            return null;
        }
        return res2;
    }

    private static <T> void copyProperty(@NotNull BasicElement from, @NotNull BasicModElement to, @NotNull BasicMetaProperty<T> prop) throws Throwable {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(10);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(11);
        }
        if (prop == null) {
            BasicMetaUtils.$$$reportNull$$$0(12);
        }
        BasicMetaUtils.copyPropertyInner(from, prop, to, prop, null);
    }

    private static <T, U> void copyPropertyInner(@NotNull BasicElement from, @NotNull BasicMetaProperty<T> p1, @NotNull BasicModElement to, @NotNull BasicMetaProperty<U> p2, @Nullable Function<T, U> converter) throws Throwable {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(13);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(14);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(15);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(16);
        }
        Object val = p1.getter.invoke(from);
        p2.setter.invoke(to, converter == null ? val : converter.apply(val));
    }

    private static <T, U> boolean copyProperty(@NotNull BasicElement from, @NotNull BasicMetaProperty<T> p1, @NotNull BasicModElement to, @NotNull BasicMetaProperty<U> p2) throws Throwable {
        if (from == null) {
            BasicMetaUtils.$$$reportNull$$$0(17);
        }
        if (p1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(18);
        }
        if (to == null) {
            BasicMetaUtils.$$$reportNull$$$0(19);
        }
        if (p2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(20);
        }
        Function cvt = null;
        if (p1.type != p2.type && (cvt = BasicMetaUtils.getConverter(p1.type, p2.type)) == null) {
            return false;
        }
        BasicMetaUtils.copyPropertyInner(from, p1, to, p2, cvt);
        return true;
    }

    private static <U, T> Function<T, U> getConverter(BasicMetaType<T> from, BasicMetaType<U> to) {
        if (from == to) {
            return x -> x;
        }
        if (to.valueClass.isAssignableFrom(String.class)) {
            return x -> x.toString();
        }
        if (to.valueClass.isAssignableFrom(Number.class) && from.valueClass.isAssignableFrom(Number.class)) {
            return x -> {
                try {
                    return to.importer.fun((Object)x.toString());
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        return null;
    }

    public static int hashCode(@Nullable BasicElement e) {
        if (e == null) {
            return 0;
        }
        BasicMetaObject<?> meta = e.getMetaObject();
        int hash = meta.hashCode();
        try {
            for (BasicMetaProperty<?> property : meta.properties) {
                hash = Comparing.hashcode((Object)hash, (Object)property.getter.invoke(e));
            }
        }
        catch (Throwable t) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return hash;
    }

    public static boolean equals(@NotNull BasicElement e1, @NotNull BasicElement e2) {
        BasicMetaObject<?> meta2;
        BasicMetaObject<?> meta1;
        if (e1 == null) {
            BasicMetaUtils.$$$reportNull$$$0(21);
        }
        if (e2 == null) {
            BasicMetaUtils.$$$reportNull$$$0(22);
        }
        if ((meta1 = e1.getMetaObject()) != (meta2 = e2.getMetaObject())) {
            return false;
        }
        try {
            for (BasicMetaProperty<?> property : meta1.properties) {
                if (Comparing.equal((Object)property.getter.invoke(e1), (Object)property.getter.invoke(e2))) continue;
                return false;
            }
        }
        catch (Throwable t) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/model/meta/BasicMetaUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findChild";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "copyProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "copySources";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "copyMatchedProperties";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyMatchedProperty";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "copyProperty";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "copyPropertyInner";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "equals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

