/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.Dbms;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaModel
implements MetaModel {
    public final Dbms dbms;
    public final BasicMetaObject<?> root;
    public final Class<? extends BasicModModel> apiClass;
    private final MultiMap<ObjectKind, BasicMetaObject<?>> myObjects = MultiMap.create();

    public BasicMetaModel(Dbms dbms, BasicMetaObject<?> root2, Class<? extends BasicModModel> apiClass) {
        this.dbms = dbms;
        this.root = root2;
        this.apiClass = apiClass;
        root2.setModel(this);
        for (BasicMetaObject object : this.traverse().traverse(TreeTraversal.INTERLEAVED_DFS)) {
            this.myObjects.putValue((Object)object.kind, (Object)object);
        }
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.dbms;
        if (dbms == null) {
            BasicMetaModel.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Nullable
    public BasicMetaObject<?> findBestMetaObject(@Nullable BasicMetaObject<?> t) {
        Collection candidates2;
        Collection collection = candidates2 = t == null ? null : this.myObjects.get((Object)t.kind);
        if (ContainerUtil.isEmpty(candidates2)) {
            return null;
        }
        if (candidates2.size() == 1) {
            return (BasicMetaObject)ContainerUtil.getFirstItem((Collection)candidates2);
        }
        BasicMetaObject best = null;
        int bestGrade = -1;
        for (BasicMetaObject candidate : candidates2) {
            int g = BasicMetaModel.grade(candidate, t);
            if (g <= bestGrade) continue;
            best = candidate;
            bestGrade = g;
        }
        return best;
    }

    private static int grade(@NotNull BasicMetaObject<?> candidate, @NotNull BasicMetaObject<?> t) {
        if (candidate == null) {
            BasicMetaModel.$$$reportNull$$$0(1);
        }
        if (t == null) {
            BasicMetaModel.$$$reportNull$$$0(2);
        }
        int res2 = -1;
        BasicMetaObject<?> cp = candidate;
        for (BasicMetaObject<?> tp = t; cp != null && tp != null && cp.kind == tp.kind; cp = cp.getParent(), tp = tp.getParent()) {
            ++res2;
        }
        return res2;
    }

    @NotNull
    public JBIterable<ObjectKind> getChildKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaModel.$$$reportNull$$$0(3);
        }
        JBIterable jBIterable = this.findMetaObjects(kind).flatten(o -> JBIterable.of((Object[])o.children)).map(o -> o.kind).unique();
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getParentKinds(@NotNull ObjectKind kind) {
        if (kind == null) {
            BasicMetaModel.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = this.findMetaObjects(kind).filterMap(BasicMetaObject::getParent).map(o -> o.kind).unique();
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() {
        JBIterable jBIterable = JBIterable.of((Object[])this.root.children).transform(o -> o.kind);
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getNamespaces() {
        Set set = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.of(o -> o.children).withRoots((Iterable)JBIterable.of((Object[])this.root.children))).expandAndFilter(o -> BasicNamespace.class.isAssignableFrom(o.apiClass))).traverse().transform(o -> o.kind).filter(o -> o == ObjectKind.SCHEMA || o == ObjectKind.DATABASE || o == ObjectKind.EXTERNAL_SCHEMA).toSet();
        if (set == null) {
            BasicMetaModel.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(ObjectKind kind) {
        JBIterable jBIterable = this.findMetaObjects(kind).transform(o -> JBIterable.generate((Object)o, x -> x.getParent()).transform(x -> x.kind).toList());
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<BasicMetaObject<?>> findMetaObjects(ObjectKind kind) {
        JBIterable jBIterable = JBIterable.from((Iterable)this.myObjects.get((Object)kind));
        if (jBIterable == null) {
            BasicMetaModel.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private JBTreeTraverser<BasicMetaObject<?>> traverse() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.of(o -> o.children).withRoot(this.root);
        if (jBTreeTraverser == null) {
            BasicMetaModel.$$$reportNull$$$0(11);
        }
        return jBTreeTraverser;
    }

    @Nullable
    public ObjectKind findKind(@Nullable String code) {
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(code);
        return this.myObjects.containsKey((Object)kind) ? kind : null;
    }

    @Nullable
    public Iterable<ObjectKind> getKinds() {
        return this.myObjects.keySet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentKinds";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNamespaceKinds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToRoot";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findMetaObjects";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "grade";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentKinds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

