/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.util.JdbcUtil;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DbMigrationAction
extends IconWithTextAction
implements DirDiffModelHolder {
    private final Direction myDirection;
    private DirDiffModel myModel;

    public DbMigrationAction(Direction direction) {
        super(DatabaseBundle.message((String)(direction == Direction.FORWARD ? "apply.right.to.the.left" : "apply.left.to.the.right"), (Object[])new Object[0]));
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
        this.myDirection = direction;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(!this.myModel.getElements().isEmpty());
        JComponent component = (JComponent)e.getPresentation().getClientProperty(COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(e.getPresentation().getDescription());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ScriptingResult script;
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(1);
        }
        DirDiffModel m = this.myModel;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        try {
            script = DbMigrationAction.createMigration(m, this.myDirection);
        }
        catch (UnsupportedOperationException uoe) {
            Component source = e.getInputEvent().getComponent();
            Messages.showErrorDialog((Component)source, (String)JdbcUtil.getMessage((Throwable)uoe), (String)DatabaseBundle.message((String)"dialog.title.migration.available", (Object[])new Object[0]));
            return;
        }
        DbDiffElement forDialect = (DbDiffElement)(this.myDirection == Direction.FORWARD ? m.getSourceDir() : m.getTargetDir());
        Language language = forDialect.getRoot().getLanguage();
        String sqlFileContent = script.getScriptText();
        final EditorFactory instance = Objects.requireNonNull(EditorFactory.getInstance());
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("migration.sql", language, (CharSequence)sqlFileContent);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        final Editor editor = instance.createViewer(document);
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)psiFile.getVirtualFile());
        ((EditorEx)editor).setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        dialogBuilder.setCenterPanel(editor.getComponent());
        dialogBuilder.addCloseButton();
        DiffElement source = this.myDirection == Direction.FORWARD ? m.getSourceDir() : m.getTargetDir();
        DiffElement target = this.myDirection == Direction.FORWARD ? m.getTargetDir() : m.getSourceDir();
        dialogBuilder.setTitle(DatabaseBundle.message((String)"dialog.title.to.migration", (Object[])new Object[]{source.getPresentablePath(), target.getPresentablePath()}));
        dialogBuilder.showModal(false);
        dialogBuilder.addDisposable(new Disposable(){

            public void dispose() {
                instance.releaseEditor(editor);
            }
        });
    }

    private static BasicModel getModel(DirDiffModel model, boolean src, boolean isPrimary) {
        DbDiffRoot r = ((DbDiffElement)(src ? model.getSourceDir() : model.getTargetDir())).getRoot();
        if (isPrimary) {
            return r.getModel();
        }
        return (BasicModel)ObjectUtils.notNull((Object)r.getAltModel(), (Object)r.getModel());
    }

    private static BasicElement getElement(DTree d2, boolean src, boolean isPrimary) {
        DbDiffElement e = (DbDiffElement)(src ? d2.getSource() : d2.getTarget());
        if (e == null) {
            return null;
        }
        if (isPrimary || e.getRoot().getAltModel() == null) {
            return e.getValue();
        }
        return e.getAltElement();
    }

    public static ScriptingResult createMigration(DirDiffModel model, Direction direction) {
        boolean ignoreAlter;
        List elements = model.getElements();
        Map diffs = ContainerUtil.map2Map((Collection)elements, e -> Pair.create((Object)Couple.of((Object)e.getSource(), (Object)e.getTarget()), (Object)e.getOperation()));
        DTree rt = (DTree)JBIterable.generate((Object)((DirDiffElementImpl)elements.get(0)).getNode(), DTree::getParent).last();
        boolean isFromSrc = direction == Direction.FORWARD;
        BasicModel src = DbMigrationAction.getModel(model, isFromSrc, true);
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
        boolean ignoreCreate = !model.getSettings().showNewOnSource;
        boolean ignoreDrop = !model.getSettings().showNewOnTarget;
        boolean bl = ignoreAlter = !model.getSettings().showDifferent;
        if (isFromSrc) {
            boolean tmp = ignoreCreate;
            ignoreCreate = ignoreDrop;
            ignoreDrop = tmp;
        }
        ScriptingAlterTaskBuilder task = new ScriptingAlterTaskBuilder(src, tgt);
        for (DTree e2 : (JBTreeTraverser)JBTreeTraverser.from(DTree::getChildren).withRoot((Object)rt)) {
            if (DbMigrationAction.isIgnored(diffs, e2)) continue;
            BasicElement srcE = DbMigrationAction.getElement(e2, isFromSrc, true);
            BasicElement tgtE = DbMigrationAction.getElement(e2, !isFromSrc, false);
            if (srcE == null && ignoreCreate || tgtE == null && ignoreDrop || srcE != null && tgtE != null && e2.getType() == DiffType.CHANGED && ignoreAlter) continue;
            task.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
        }
        DbDiffRoot root2 = ((DbDiffElement)(isFromSrc ? model.getTargetDir() : model.getSourceDir())).getRoot();
        task.setOptions(root2.createOptions());
        return ScriptGenerators.INSTANCE.byModel(src).makeScript(root2.getProject(), task.build());
    }

    private static boolean isIgnored(Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e) {
        if (DbMigrationAction.getOperation(diffs, e) == DirDiffOperation.NONE) {
            return true;
        }
        Collection children2 = e.getChildren();
        if (ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL) == null) {
            return false;
        }
        return ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL && DbMigrationAction.getOperation(diffs, c2) != DirDiffOperation.NONE) == null;
    }

    private static DirDiffOperation getOperation(Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e) {
        return diffs.get(Pair.create((Object)e.getSource(), (Object)e.getTarget()));
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
        String source = this.myModel.getSourceDir().getPresentablePath();
        String target = this.myModel.getTargetDir().getPresentablePath();
        this.getTemplatePresentation().setDescription(DatabaseBundle.message((String)"action.DbMigrationAction.migrate.to.state.description", (Object[])new Object[]{this.myDirection == Direction.FORWARD ? target : source, this.myDirection == Direction.FORWARD ? source : target}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/model/diff/DbMigrationAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

