/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiffRoot {
    private final DbDataSource myDataSource;
    private final DirDiffSettings mySettings;
    private final BasicModel myModel;
    private final BasicModModel myAltModel;
    private final BasicElement myRootElement;
    private final Condition<DasObject> myFilter;

    public DbDiffRoot(@NotNull DbDataSource source, @NotNull DirDiffSettings settings, @NotNull Dbms dbms, @NotNull BasicElement rootElement) {
        if (source == null) {
            DbDiffRoot.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DbDiffRoot.$$$reportNull$$$0(1);
        }
        if (dbms == null) {
            DbDiffRoot.$$$reportNull$$$0(2);
        }
        if (rootElement == null) {
            DbDiffRoot.$$$reportNull$$$0(3);
        }
        this.myDataSource = source;
        this.mySettings = settings;
        this.myRootElement = rootElement;
        this.myModel = (BasicModel)this.myDataSource.getDelegate().getModel();
        this.myAltModel = new ModelFactory(new MemoryTextStorage()).createModel(dbms);
        this.myFilter = (Condition)ObjectUtils.notNull(DatabaseStructure.buildFilter((DasDataSource)this.myDataSource), (Object)Conditions.alwaysTrue());
    }

    @NotNull
    public BasicElement getRootElement() {
        BasicElement basicElement = this.myRootElement;
        if (basicElement == null) {
            DbDiffRoot.$$$reportNull$$$0(4);
        }
        return basicElement;
    }

    @NotNull
    public DbDataSource getDataSource() {
        DbDataSource dbDataSource = this.myDataSource;
        if (dbDataSource == null) {
            DbDiffRoot.$$$reportNull$$$0(5);
        }
        return dbDataSource;
    }

    @NotNull
    public DirDiffSettings getSettings() {
        DirDiffSettings dirDiffSettings = this.mySettings;
        if (dirDiffSettings == null) {
            DbDiffRoot.$$$reportNull$$$0(6);
        }
        return dirDiffSettings;
    }

    @NotNull
    public BasicModel getModel() {
        BasicModel basicModel = this.myModel;
        if (basicModel == null) {
            DbDiffRoot.$$$reportNull$$$0(7);
        }
        return basicModel;
    }

    @Nullable
    public BasicModModel getAltModel() {
        return this.myAltModel;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myDataSource.getProject();
        if (project == null) {
            DbDiffRoot.$$$reportNull$$$0(8);
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)this.myDataSource);
        if (sqlLanguageDialect == null) {
            DbDiffRoot.$$$reportNull$$$0(9);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public ScriptingOptions createOptions() {
        HashMap opts = new HashMap();
        opts.put(ScriptingOptionStatic.IGNORE_OWNER, this.mySettings.customSettings.get("PG_IGNORE_OWNER"));
        opts.put(ScriptingOptionStatic.IGNORE_ORDER, this.mySettings.customSettings.get("IGNORE_ORDER"));
        opts.put(ScriptingOptionStatic.IGNORE_DEFINER, this.mySettings.customSettings.get("MYSQL_IGNORE_DEFINER"));
        opts.put(ScriptingOptionStatic.IGNORE_CASE_CHANGES, this.mySettings.customSettings.get("IGNORE_CASE"));
        return new CustomScriptingOptions(opts);
    }

    @NotNull
    public Condition<DasObject> getFilter() {
        Condition<DasObject> condition = this.myFilter;
        if (condition == null) {
            DbDiffRoot.$$$reportNull$$$0(10);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbDiffRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbDiffRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

