/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSynonym;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicMixinSynonym
extends DasSynonym {
    default public boolean isRemote() {
        return ((BasicSynonym)this).getTargetDbLinkName() != null;
    }

    @Nullable
    default public BasicSchema getTargetSchema() {
        BasicSynonym self = (BasicSynonym)this;
        if (self.getTargetDbLinkName() != null) {
            return null;
        }
        BasicSchema mySchema = self.getSchema();
        String refSchemaName = self.getTargetSchemaName();
        if (refSchemaName == null) {
            return mySchema;
        }
        return mySchema != null ? mySchema.getSibling(refSchemaName) : null;
    }

    @Nullable
    default public BasicMajorObject getTargetObject() {
        BasicSynonym self = (BasicSynonym)this;
        if (self.getTargetDbLinkName() != null) {
            return null;
        }
        ObjectKind targetObjectKind = self.getTargetObjectKind();
        String targetObjectName = self.getTargetObjectName();
        if (targetObjectName == null || targetObjectName.isEmpty()) {
            return null;
        }
        BasicSchema targetSchema = this.getTargetSchema();
        if (targetSchema == null) {
            return null;
        }
        if (targetObjectKind != ObjectKind.NONE) {
            return BasicMixinElement.findChild((BasicElement)targetSchema, targetObjectKind, targetObjectName, BasicMajorObject.class);
        }
        for (ObjectKind kind : targetSchema.getFamilyKinds()) {
            BasicMajorObject child = BasicMixinElement.findChild((BasicElement)targetSchema, kind, targetObjectName, BasicMajorObject.class);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    default public BasicMajorObject getOrigin() {
        BasicMajorObject targetObject = this.getTargetObject();
        while (targetObject instanceof BasicMixinSynonym) {
            targetObject = ((BasicMixinSynonym)((Object)targetObject)).getTargetObject();
        }
        return targetObject;
    }

    @Deprecated
    @Nullable
    default public DasObject resolveTarget() {
        return this.getTargetObject();
    }

    @NotNull
    default public Iterable<String> getTargetPath() {
        BasicSynonym self = (BasicSynonym)this;
        String targetObjectName = self.getTargetObjectName();
        if (targetObjectName == null || targetObjectName.length() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BasicMixinSynonym.$$$reportNull$$$0(0);
            }
            return list;
        }
        BasicElement parent2 = self.getParent();
        String parentName = parent2 != null ? parent2.getRealName() : null;
        String targetSchemaName = self.getTargetSchemaName();
        List<String> list = targetSchemaName == null || targetSchemaName.equals(parentName) ? Collections.singletonList(targetObjectName) : Arrays.asList(targetSchemaName, targetObjectName);
        if (list == null) {
            BasicMixinSynonym.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicMixinSynonym", "getTargetPath"));
    }
}

