/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicMixinElement
extends DasObject,
BasicNode {
    @NotNull
    public BasicMetaObject<?> getMetaObject();

    @NotNull
    public static <P extends BasicElement> P parent(@NotNull BasicElement element2, @NotNull Class<P> parentClass) throws IllegalArgumentException {
        if (element2 == null) {
            BasicMixinElement.$$$reportNull$$$0(0);
        }
        if (parentClass == null) {
            BasicMixinElement.$$$reportNull$$$0(1);
        }
        for (BasicElement p2 = element2.getParent(); p2 != null; p2 = p2.getParent()) {
            if (parentClass.isAssignableFrom(p2.getClass())) {
                BasicElement basicElement = p2;
                if (basicElement == null) {
                    BasicMixinElement.$$$reportNull$$$0(2);
                }
                return (P)basicElement;
            }
            if (p2 instanceof BasicRoot) break;
        }
        throw new IllegalArgumentException(String.format("Class %s has no parent of class %s", element2.getClass().getSimpleName(), parentClass.getSimpleName()));
    }

    @Nullable
    public BasicDatabase getDatabase();

    @Nullable
    public BasicSchema getSchema();

    public @Nullable Family<@NotNull ? extends BasicElement> getParentFamily();

    @NotNull
    public String getDisplayOrder();

    @NotNull
    public String calculateDisplayOrder();

    @NotNull
    public String identity();

    @NotNull
    public String identity(boolean var1);

    @NotNull
    public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies();

    @NotNull
    public @NotNull List<@NotNull ObjectKind> getFamilyKinds();

    public @Nullable Family<@NotNull ? extends BasicElement> familyOf(@NotNull ObjectKind var1);

    @Nullable
    public BasicElement getParent();

    @NotNull
    public @NotNull JBIterable<@NotNull ? extends BasicElement> getChildren();

    @NotNull
    public @NotNull JBIterable<@NotNull ? extends BasicElement> getDasChildren(@Nullable ObjectKind var1);

    public boolean hasChildren();

    @Nullable
    public static <E extends BasicElement> E findChild(@NotNull BasicElement element2, @NotNull Collection<ObjectKind> kinds, @NotNull String name, @NotNull Class<E> clazz) {
        if (element2 == null) {
            BasicMixinElement.$$$reportNull$$$0(3);
        }
        if (kinds == null) {
            BasicMixinElement.$$$reportNull$$$0(4);
        }
        if (name == null) {
            BasicMixinElement.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            BasicMixinElement.$$$reportNull$$$0(6);
        }
        for (ObjectKind kind : kinds) {
            E result = BasicMixinElement.findChild(element2, kind, name, clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static <E extends BasicElement> E findChild(@NotNull BasicElement element2, @NotNull ObjectKind kind, @NotNull String name, @NotNull Class<E> clazz) {
        Family<? extends BasicElement> elements;
        if (element2 == null) {
            BasicMixinElement.$$$reportNull$$$0(7);
        }
        if (kind == null) {
            BasicMixinElement.$$$reportNull$$$0(8);
        }
        if (name == null) {
            BasicMixinElement.$$$reportNull$$$0(9);
        }
        if (clazz == null) {
            BasicMixinElement.$$$reportNull$$$0(10);
        }
        if ((elements = element2.familyOf(kind)) == null) {
            return null;
        }
        if (!1.$assertionsDisabled && !(elements instanceof NamingFamily)) {
            throw new AssertionError((Object)"Attempted to find an element by name when the family is not naming");
        }
        Object e = ((NamingFamily)elements).get(name);
        if (e != null && clazz.isAssignableFrom(e.getClass())) {
            return e;
        }
        return null;
    }

    public void exportProperties(@NotNull NameValueConsumer<String> var1);

    public boolean isElementSurrogate();

    public boolean isAutoCreated();

    @NotNull
    public Iterable<? extends BasicElement> getPredecessors();

    @Nullable
    public static CasingProvider getCasingProvider(@Nullable BasicElement element2) {
        if (element2 == null) {
            return null;
        }
        if (element2 instanceof CasingProvider) {
            return (CasingProvider)element2;
        }
        BasicElement parent2 = element2.getParent();
        return parent2 != null ? BasicMixinElement.getCasingProvider(parent2) : null;
    }

    @Nullable
    public String getRealName();

    @Nullable
    public String getNaturalName();

    default public boolean isQuoted() {
        return DbSqlUtil.isQuoted(this);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/BasicMixinElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/BasicMixinElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parent";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

