/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SequenceIdentity
implements Cloneable,
Serializable {
    public static final SequenceIdentity UNKNOWN = SequenceIdentity.of(null, null, 1L, null);
    @Nullable
    public final BigInteger min;
    @Nullable
    public final BigInteger next;
    @NotNull
    public final BigInteger increment;
    @Nullable
    public final BigInteger max;
    private static final Pattern SPECIFICATION_PATTERN = Pattern.compile("^\\s*([-+]?\\d+)\\s*(\\(\\s*([-+]?\\d+)\\s*\\)\\s*)?(([-+]\\d+)\\s*)?(\\.\\.([-+]?\\d+)\\s*)?$");

    @NotNull
    public static SequenceIdentity of(@NotNull String specification) {
        String s2;
        Matcher m;
        if (specification == null) {
            SequenceIdentity.$$$reportNull$$$0(0);
        }
        if ((m = SPECIFICATION_PATTERN.matcher(s2 = specification.replace("null", "000"))).matches()) {
            int signum;
            BigInteger grpFrom = SequenceIdentity.grp(m, 1);
            BigInteger grpNext = SequenceIdentity.grp(m, 3);
            BigInteger grpInc = SequenceIdentity.grp(m, 5);
            BigInteger grpTill = SequenceIdentity.grp(m, 7);
            int n = signum = grpInc != null ? grpInc.signum() : 0;
            if (signum >= 0) {
                return SequenceIdentity.of(grpFrom, grpNext, grpInc, grpTill);
            }
            return SequenceIdentity.of(grpTill, grpNext, grpInc, grpFrom);
        }
        throw new IllegalArgumentException("The string '" + specification + "' is not a valid sequence specification");
    }

    @Nullable
    private static BigInteger grp(Matcher matcher, int groupNr) {
        String s2 = matcher.group(groupNr);
        return s2 != null && !s2.equalsIgnoreCase("000") ? new BigInteger(s2) : null;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable Long min, @Nullable Long next, @Nullable Long increment, @Nullable Long max) {
        return new SequenceIdentity(min == null ? null : BigInteger.valueOf(min), next == null ? null : BigInteger.valueOf(next), increment == null ? null : BigInteger.valueOf(increment), max == null ? null : BigInteger.valueOf(max));
    }

    @NotNull
    public static SequenceIdentity of(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        return new SequenceIdentity(min, next, increment, max);
    }

    private SequenceIdentity(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        this.min = min;
        this.next = next;
        this.increment = increment == null ? BigInteger.ONE : increment;
        this.max = max;
    }

    public final String getSpecification() {
        StringBuilder b2 = new StringBuilder(16);
        switch (this.increment.signum()) {
            case 1: {
                b2.append(this.min != null ? this.min : "null");
                if (!this.increment.equals(BigInteger.ONE)) {
                    b2.append("+").append(this.increment);
                }
                if (this.max == null) break;
                b2.append('.').append('.').append(this.max);
                break;
            }
            case -1: {
                b2.append(this.max != null ? this.max : "null");
                b2.append(this.increment);
                if (this.min == null) break;
                b2.append('.').append('.').append(this.min);
                break;
            }
            default: {
                if (this.min == null && this.max == null) {
                    b2.append("0");
                    break;
                }
                if (this.min != null) {
                    b2.append(this.min);
                }
                b2.append('.').append('.');
                if (this.max == null) break;
                b2.append(this.max);
            }
        }
        return b2.toString();
    }

    public String toString() {
        return this.getSpecification();
    }

    protected Object clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceIdentity that = (SequenceIdentity)o;
        return this.equalsIgnoreNext(that) && Objects.equals(this.next, that.next);
    }

    public boolean equalsIgnoreNext(@Nullable SequenceIdentity o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return Objects.equals(this.min, o.min) && Objects.equals(this.increment, o.increment) && Objects.equals(this.max, o.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.next, this.increment, this.max);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specification", "com/intellij/database/model/SequenceIdentity", "of"));
    }
}

