/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0005\u0019\u001a\u001b\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0007J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u00020\u0018\"\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor;", "Lcom/intellij/database/extractors/DataExtractor$Binary;", "myFormatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "(Lcom/intellij/database/extractors/ObjectFormatter;)V", "maxRowsPerSheet", "", "stringsBuffer", "getFileExtension", "", "setMaxRowsPerSheet", "", "v", "setStringsBuffer", "startExtraction", "Lcom/intellij/database/extractors/DataExtractor$Extraction;", "out", "Ljava/io/OutputStream;", "dbms", "Lcom/intellij/database/Dbms;", "allColumns", "", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "selectedColumns", "", "Companion", "SharedStrings", "XlsxExtraction", "XlsxSheetBuilder", "XlsxWorkbook", "intellij.database.impl"})
public final class XlsxValuesExtractor
implements DataExtractor.Binary {
    private int maxRowsPerSheet;
    private int stringsBuffer;
    private final ObjectFormatter myFormatter;
    private static final Logger LOG;
    @NotNull
    public static final String RELS_NAME = "_rels/.rels";
    @NotNull
    public static final String WORKBOOK_NAME = "xl/workbook.xml";
    @NotNull
    public static final String WORKSHEETS_DIR = "xl/worksheets";
    @NotNull
    public static final String WORKBOOK_RELS_NAME = "xl/_rels/workbook.xml.rels";
    @NotNull
    public static final String SHARED_STRINGS_NAME = "xl/sharedStrings.xml";
    @NotNull
    public static final String CONTENT_TYPES_NAME = "[Content_Types].xml";
    @NotNull
    public static final String RELS_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n  <Relationship Id=\"rId1\" Target=\"xl/workbook.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\"/>\n</Relationships>";
    @NotNull
    public static final String WORKBOOK_RELS_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n<Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/>";
    @NotNull
    public static final String WORKBOOK_RELS_FOOTER = "</Relationships>";
    @NotNull
    public static final String WORKBOOK_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n<workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"0\"/></bookViews>\n<sheets>";
    @NotNull
    public static final String WORKBOOK_FOOTER = "</sheets>\n</workbook>";
    @NotNull
    public static final String CONTENT_TYPES_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n<Default ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" Extension=\"rels\"/>\n<Default ContentType=\"application/xml\" Extension=\"xml\"/>\n<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\" PartName=\"/xl/sharedStrings.xml\"/>\n<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\" PartName=\"/xl/workbook.xml\"/>";
    @NotNull
    public static final String CONTENT_TYPES_FOOTER = "</Types>";
    @NotNull
    public static final String SHEET_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"><sheetData>";
    @NotNull
    public static final String SHEET_FOOTER = "</sheetData></worksheet>";
    @NotNull
    public static final String SHARED_STRINGS_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    @NotNull
    private static final Regex INVALID_XML_CHARS;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getFileExtension() {
        return "xlsx";
    }

    @NotNull
    public DataExtractor.Extraction startExtraction(@NotNull OutputStream out, @NotNull Dbms dbms, @NotNull List<? extends DataConsumer.Column> allColumns, int ... selectedColumns) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(allColumns, (String)"allColumns");
        Intrinsics.checkNotNullParameter((Object)selectedColumns, (String)"selectedColumns");
        return new XlsxExtraction(this.myFormatter, out, dbms, allColumns, selectedColumns, this.maxRowsPerSheet, this.stringsBuffer);
    }

    @TestOnly
    public final void setMaxRowsPerSheet(int v) {
        this.maxRowsPerSheet = v;
    }

    @TestOnly
    public final void setStringsBuffer(int v) {
        this.stringsBuffer = v;
    }

    public XlsxValuesExtractor(@NotNull ObjectFormatter myFormatter) {
        Intrinsics.checkNotNullParameter((Object)myFormatter, (String)"myFormatter");
        this.myFormatter = myFormatter;
        this.maxRowsPerSheet = 0x100000;
        this.stringsBuffer = 0x500000;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(XlsxValuesExtractor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(XlsxV\u2026uesExtractor::class.java)");
        LOG = logger2;
        INVALID_XML_CHARS = new Regex("[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\tH\u0016J\b\u00101\u001a\u00020.H\u0016J\b\u00102\u001a\u00020.H\u0002J\u001b\u00103\u001a\u00020.2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\n05H\u0016\u00a2\u0006\u0002\u00106R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00067"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxExtraction;", "Lcom/intellij/database/extractors/DataExtractor$Extraction;", "formatter", "Lcom/intellij/database/extractors/ObjectFormatter;", "out", "Ljava/io/OutputStream;", "dbms", "Lcom/intellij/database/Dbms;", "allColumns", "", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "selectedColumnIndices", "", "maxRowsPerSheet", "", "stringsBuffer", "(Lcom/intellij/database/extractors/ObjectFormatter;Ljava/io/OutputStream;Lcom/intellij/database/Dbms;Ljava/util/List;[III)V", "getAllColumns", "()Ljava/util/List;", "setAllColumns", "(Ljava/util/List;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "getFormatter", "()Lcom/intellij/database/extractors/ObjectFormatter;", "headerAppended", "", "getHeaderAppended", "()Z", "setHeaderAppended", "(Z)V", "getSelectedColumnIndices", "()[I", "workbook", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "getWorkbook", "()Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "writer", "Ljava/io/BufferedWriter;", "getWriter", "()Ljava/io/BufferedWriter;", "zip", "Ljava/util/zip/ZipOutputStream;", "getZip", "()Ljava/util/zip/ZipOutputStream;", "addData", "", "rows", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "complete", "setHeader", "updateColumns", "columns", "", "([Lcom/intellij/database/datagrid/DataConsumer$Column;)V", "intellij.database.impl"})
    private static final class XlsxExtraction
    implements DataExtractor.Extraction {
        @NotNull
        private final ZipOutputStream zip;
        @NotNull
        private final BufferedWriter writer;
        @NotNull
        private final XlsxWorkbook workbook;
        private boolean headerAppended;
        @NotNull
        private final ObjectFormatter formatter;
        @NotNull
        private final Dbms dbms;
        @NotNull
        private List<? extends DataConsumer.Column> allColumns;
        @NotNull
        private final int[] selectedColumnIndices;

        @NotNull
        public final ZipOutputStream getZip() {
            return this.zip;
        }

        @NotNull
        public final BufferedWriter getWriter() {
            return this.writer;
        }

        @NotNull
        public final XlsxWorkbook getWorkbook() {
            return this.workbook;
        }

        public final boolean getHeaderAppended() {
            return this.headerAppended;
        }

        public final void setHeaderAppended(boolean bl) {
            this.headerAppended = bl;
        }

        @Override
        public void updateColumns(@NotNull DataConsumer.Column[] columns) {
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            this.allColumns = CollectionsKt.listOf((Object[])Arrays.copyOf(columns, columns.length));
            this.setHeader();
        }

        /*
         * WARNING - void declaration
         */
        public void addData(@NotNull List<? extends DataConsumer.Row> rows) {
            Intrinsics.checkNotNullParameter(rows, (String)"rows");
            if (!this.headerAppended) {
                this.setHeader();
                this.headerAppended = true;
            }
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.allColumns, this.selectedColumnIndices);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.allColumns);
            for (DataConsumer.Row row : rows) {
                Collection<Serializable> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue((Object)selectedColumns, (String)"selectedColumns");
                int[] nArray = selectedColumns;
                XlsxWorkbook xlsxWorkbook = this.workbook;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var11_11 = $this$mapTo$iv$iv;
                int n = ((void)var11_11).length;
                for (int j = 0; j < n; ++j) {
                    Object value2;
                    void selectedColumn;
                    void item$iv$iv;
                    void var15_15 = item$iv$iv = var11_11[j];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get((int)selectedColumn);
                    Serializable serializable = column2 == null ? null : ((value2 = column2.getValue(row)) == null || value2 == ReservedCellValue.UNSET ? null : (value2 instanceof Number ? (Serializable)value2 : (value2 instanceof Boolean ? (Serializable)value2 : (Serializable)((Object)this.formatter.objectToString(value2, column2, this.dbms, ObjectFormatter.Mode.DEFAULT)))));
                    collection.add(serializable);
                }
                collection = (List)destination$iv$iv;
                xlsxWorkbook.appendRow((List<? extends Object>)collection);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void setHeader() {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int[] selectedColumns = ExtractorsUtil.getNonEmptySelection(this.allColumns, this.selectedColumnIndices);
            TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.allColumns);
            Intrinsics.checkNotNullExpressionValue((Object)selectedColumns, (String)"selectedColumns");
            int[] nArray = selectedColumns;
            XlsxWorkbook xlsxWorkbook = this.workbook;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var8_9 = $this$mapTo$iv$iv;
            int n = ((void)var8_9).length;
            for (int j = 0; j < n; ++j) {
                void selectedColumn;
                void item$iv$iv;
                void var12_13 = item$iv$iv = var8_9[j];
                collection = destination$iv$iv;
                boolean bl = false;
                DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get((int)selectedColumn);
                String string = column2 != null ? column2.name : null;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            xlsxWorkbook.setHeader((List<String>)collection);
        }

        @Override
        public void complete() {
            this.workbook.end();
            this.writer.flush();
            this.zip.finish();
        }

        @NotNull
        public final ObjectFormatter getFormatter() {
            return this.formatter;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        @NotNull
        public final List<DataConsumer.Column> getAllColumns() {
            return this.allColumns;
        }

        public final void setAllColumns(@NotNull List<? extends DataConsumer.Column> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.allColumns = list;
        }

        @NotNull
        public final int[] getSelectedColumnIndices() {
            return this.selectedColumnIndices;
        }

        public XlsxExtraction(@NotNull ObjectFormatter formatter, @NotNull OutputStream out, @NotNull Dbms dbms, @NotNull List<? extends DataConsumer.Column> allColumns, @NotNull int[] selectedColumnIndices, int maxRowsPerSheet, int stringsBuffer) {
            Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter(allColumns, (String)"allColumns");
            Intrinsics.checkNotNullParameter((Object)selectedColumnIndices, (String)"selectedColumnIndices");
            this.formatter = formatter;
            this.dbms = dbms;
            this.allColumns = allColumns;
            this.selectedColumnIndices = selectedColumnIndices;
            this.zip = new ZipOutputStream(out, StandardCharsets.UTF_8);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.zip, StandardCharsets.UTF_8));
            this.workbook = new XlsxWorkbook(this.zip, this.writer, maxRowsPerSheet, stringsBuffer);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0011R-\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0004R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0004R\u001a\u0010\u001b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0016\"\u0004\b\u001d\u0010\u0004\u00a8\u0006$"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;", "", "stringsBuffer", "", "(I)V", "sharedStrings", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getSharedStrings", "()Ljava/util/LinkedHashMap;", "tmpFile", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "getTmpFile", "()Ljava/io/File;", "tmpWriter", "Ljava/io/BufferedWriter;", "getTmpWriter", "()Ljava/io/BufferedWriter;", "totalLength", "getTotalLength", "()I", "setTotalLength", "totalStringsCount", "getTotalStringsCount", "setTotalStringsCount", "uniqueCount", "getUniqueCount", "setUniqueCount", "flushToTempFile", "", "getId", "v", "write", "writer", "intellij.database.impl"})
    private static final class SharedStrings {
        private int totalStringsCount;
        private int uniqueCount;
        private int totalLength;
        @NotNull
        private final LinkedHashMap<String, Integer> sharedStrings;
        @NotNull
        private final File tmpFile;
        @NotNull
        private final BufferedWriter tmpWriter;
        private final int stringsBuffer;

        public final int getTotalStringsCount() {
            return this.totalStringsCount;
        }

        public final void setTotalStringsCount(int n) {
            this.totalStringsCount = n;
        }

        public final int getUniqueCount() {
            return this.uniqueCount;
        }

        public final void setUniqueCount(int n) {
            this.uniqueCount = n;
        }

        public final int getTotalLength() {
            return this.totalLength;
        }

        public final void setTotalLength(int n) {
            this.totalLength = n;
        }

        @NotNull
        public final LinkedHashMap<String, Integer> getSharedStrings() {
            return this.sharedStrings;
        }

        @NotNull
        public final File getTmpFile() {
            return this.tmpFile;
        }

        @NotNull
        public final BufferedWriter getTmpWriter() {
            return this.tmpWriter;
        }

        public final int getId(@NotNull String v) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            int n = this.totalStringsCount;
            this.totalStringsCount = n + 1;
            Map $this$getOrPut$iv = this.sharedStrings;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(v);
            if (value$iv == null) {
                boolean bl = false;
                this.totalLength += v.length();
                int n2 = this.uniqueCount;
                this.uniqueCount = n2 + 1;
                Integer answer$iv = n2;
                $this$getOrPut$iv.put(v, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            int res2 = ((Number)object).intValue();
            if (this.totalLength >= this.stringsBuffer) {
                this.flushToTempFile();
            }
            return res2;
        }

        private final void flushToTempFile() {
            Set<String> set = this.sharedStrings.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"sharedStrings.keys");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String str = (String)element$iv;
                boolean bl = false;
                Writer writer = this.tmpWriter.append("<si><t>");
                String string = StringUtil.escapeXmlEntities((String)str);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.escapeXmlEntities(str)");
                CharSequence charSequence = string;
                Regex regex = Companion.getINVALID_XML_CHARS();
                String string2 = "?";
                boolean bl2 = false;
                writer.append(regex.replace(charSequence, string2)).append("</t></si>");
            }
            this.tmpWriter.append("\n");
            this.tmpWriter.flush();
            this.totalLength = 0;
            this.sharedStrings.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(@NotNull BufferedWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Object object = this.sharedStrings;
            boolean bl = false;
            if (!object.isEmpty()) {
                this.flushToTempFile();
            }
            this.tmpWriter.close();
            writer.append(XlsxValuesExtractor.SHARED_STRINGS_HEADER);
            writer.append("<sst count=\"").append(String.valueOf(this.totalStringsCount)).append("\" uniqueCount=\"").append(String.valueOf(this.uniqueCount)).append("\" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
            object = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(this.tmpFile)), StandardCharsets.UTF_8));
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl3 = false;
                Sequence $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)reader);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl4 = false;
                    writer.append(line).append("\n");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            writer.append("</sst>");
        }

        public SharedStrings(int stringsBuffer) {
            this.stringsBuffer = stringsBuffer;
            this.sharedStrings = new LinkedHashMap();
            File file = FileUtil.createTempFile((String)"xlsxExtractor", (String)".gz", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempFile(\u2026xExtractor\", \".gz\", true)");
            this.tmpFile = file;
            this.tmpWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(this.tmpFile)), StandardCharsets.UTF_8));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000bJ\u0006\u0010\u001f\u001a\u00020\u001dJ\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u0016H\u0002R$\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxWorkbook;", "", "zip", "Ljava/util/zip/ZipOutputStream;", "writer", "Ljava/io/BufferedWriter;", "maxRowsPerSheet", "", "stringsBuffer", "(Ljava/util/zip/ZipOutputStream;Ljava/io/BufferedWriter;II)V", "header", "", "", "getHeader", "()Ljava/util/List;", "setHeader", "(Ljava/util/List;)V", "getMaxRowsPerSheet", "()I", "sharedStrings", "Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;", "sheet", "Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxSheetBuilder;", "sheetsCount", "getWriter", "()Ljava/io/BufferedWriter;", "getZip", "()Ljava/util/zip/ZipOutputStream;", "appendRow", "", "row", "end", "endSheet", "newSheet", "intellij.database.impl"})
    private static final class XlsxWorkbook {
        private final SharedStrings sharedStrings;
        private int sheetsCount;
        private XlsxSheetBuilder sheet;
        @Nullable
        private List<String> header;
        @NotNull
        private final ZipOutputStream zip;
        @NotNull
        private final BufferedWriter writer;
        private final int maxRowsPerSheet;

        @Nullable
        public final List<String> getHeader() {
            return this.header;
        }

        public final void setHeader(@Nullable List<String> list) {
            this.header = list;
        }

        public final void appendRow(@NotNull List<? extends Object> row) {
            Intrinsics.checkNotNullParameter(row, (String)"row");
            try {
                if (this.sheet.getRowCount() >= this.maxRowsPerSheet) {
                    this.endSheet();
                    this.sheet = this.newSheet();
                }
                if (this.sheet.getRowCount() == 0) {
                    List<String> list = this.header;
                    if (list != null) {
                        List<String> list2 = list;
                        boolean bl = false;
                        boolean bl2 = false;
                        List<String> h = list2;
                        boolean bl3 = false;
                        this.sheet.appendRow(this.writer, h);
                    }
                }
                this.sheet.appendRow(this.writer, row);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw (Throwable)e;
            }
        }

        private final void endSheet() {
            this.sheet.end(this.writer);
            this.writer.flush();
            this.zip.closeEntry();
        }

        private final XlsxSheetBuilder newSheet() {
            int n = this.sheetsCount;
            this.sheetsCount = n + 1;
            this.zip.putNextEntry(new ZipEntry("xl/worksheets/sheet" + this.sheetsCount + ".xml"));
            return new XlsxSheetBuilder(this.sharedStrings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void end() {
            try {
                this.endSheet();
                Function2<String, Function0<? extends Unit>, Unit> $fun$entry$1 = new Function2<String, Function0<? extends Unit>, Unit>(this){
                    final /* synthetic */ XlsxWorkbook this$0;

                    public final void invoke(@NotNull String name, @NotNull Function0<Unit> block) {
                        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                        Intrinsics.checkNotNullParameter(block, (String)"block");
                        this.this$0.getZip().putNextEntry(new ZipEntry(name));
                        block.invoke();
                        this.this$0.getWriter().flush();
                        this.this$0.getZip().closeEntry();
                    }
                    {
                        this.this$0 = xlsxWorkbook;
                        super(2);
                    }
                };
                $fun$entry$1.invoke(XlsxValuesExtractor.RELS_NAME, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ XlsxWorkbook this$0;

                    public final void invoke() {
                        this.this$0.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n  <Relationship Id=\"rId1\" Target=\"xl/workbook.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\"/>\n</Relationships>");
                    }
                    {
                        this.this$0 = xlsxWorkbook;
                        super(0);
                    }
                }));
                $fun$entry$1.invoke(XlsxValuesExtractor.WORKBOOK_RELS_NAME, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ XlsxWorkbook this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        this.this$0.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">\n<Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/>");
                        int n = 0;
                        int n2 = XlsxWorkbook.access$getSheetsCount$p(this.this$0);
                        while (n < n2) {
                            void i2;
                            this.this$0.getWriter().append("<Relationship Id=\"rId" + (int)(i2 + 2) + "\" Target=\"worksheets/sheet" + (int)(i2 + true) + ".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\"/>");
                            ++i2;
                        }
                        this.this$0.getWriter().append("</Relationships>");
                    }
                    {
                        this.this$0 = xlsxWorkbook;
                        super(0);
                    }
                }));
                $fun$entry$1.invoke(XlsxValuesExtractor.SHARED_STRINGS_NAME, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ XlsxWorkbook this$0;

                    public final void invoke() {
                        XlsxWorkbook.access$getSharedStrings$p(this.this$0).write(this.this$0.getWriter());
                    }
                    {
                        this.this$0 = xlsxWorkbook;
                        super(0);
                    }
                }));
                $fun$entry$1.invoke(XlsxValuesExtractor.WORKBOOK_NAME, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ XlsxWorkbook this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        this.this$0.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n<workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"0\"/></bookViews>\n<sheets>");
                        int n = 0;
                        int n2 = XlsxWorkbook.access$getSheetsCount$p(this.this$0);
                        while (n < n2) {
                            void i2;
                            this.this$0.getWriter().append("<sheet name=\"result " + (int)(i2 + true) + "\" r:id=\"rId" + (int)(i2 + 2) + "\" sheetId=\"" + (int)(i2 + true) + "\"/>");
                            ++i2;
                        }
                        this.this$0.getWriter().append("</sheets>\n</workbook>");
                    }
                    {
                        this.this$0 = xlsxWorkbook;
                        super(0);
                    }
                }));
                $fun$entry$1.invoke(XlsxValuesExtractor.CONTENT_TYPES_NAME, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ XlsxWorkbook this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        this.this$0.getWriter().append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\">\n<Default ContentType=\"application/vnd.openxmlformats-package.relationships+xml\" Extension=\"rels\"/>\n<Default ContentType=\"application/xml\" Extension=\"xml\"/>\n<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\" PartName=\"/xl/sharedStrings.xml\"/>\n<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\" PartName=\"/xl/workbook.xml\"/>");
                        int n = 0;
                        int n2 = XlsxWorkbook.access$getSheetsCount$p(this.this$0);
                        while (n < n2) {
                            void i2;
                            this.this$0.getWriter().append("<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\" PartName=\"/xl/worksheets/sheet" + (int)(i2 + true) + ".xml\"/>");
                            ++i2;
                        }
                        this.this$0.getWriter().append("</Types>");
                    }
                    {
                        this.this$0 = xlsxWorkbook;
                        super(0);
                    }
                }));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw (Throwable)e;
            }
            finally {
                this.sharedStrings.getTmpFile().delete();
            }
        }

        @NotNull
        public final ZipOutputStream getZip() {
            return this.zip;
        }

        @NotNull
        public final BufferedWriter getWriter() {
            return this.writer;
        }

        public final int getMaxRowsPerSheet() {
            return this.maxRowsPerSheet;
        }

        public XlsxWorkbook(@NotNull ZipOutputStream zip, @NotNull BufferedWriter writer, int maxRowsPerSheet, int stringsBuffer) {
            Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            this.zip = zip;
            this.writer = writer;
            this.maxRowsPerSheet = maxRowsPerSheet;
            this.sharedStrings = new SharedStrings(stringsBuffer);
            this.sheet = this.newSheet();
        }

        public static final /* synthetic */ int access$getSheetsCount$p(XlsxWorkbook $this) {
            return $this.sheetsCount;
        }

        public static final /* synthetic */ void access$setSheetsCount$p(XlsxWorkbook $this, int n) {
            $this.sheetsCount = n;
        }

        public static final /* synthetic */ SharedStrings access$getSharedStrings$p(XlsxWorkbook $this) {
            return $this.sharedStrings;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$XlsxSheetBuilder;", "", "sharedStrings", "Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;", "(Lcom/intellij/database/extractors/XlsxValuesExtractor$SharedStrings;)V", "headerAppended", "", "rowCount", "", "getRowCount", "()I", "setRowCount", "(I)V", "appendRow", "", "writer", "Ljava/io/BufferedWriter;", "row", "", "end", "intellij.database.impl"})
    private static final class XlsxSheetBuilder {
        private boolean headerAppended;
        private int rowCount;
        private final SharedStrings sharedStrings;

        public final int getRowCount() {
            return this.rowCount;
        }

        public final void setRowCount(int n) {
            this.rowCount = n;
        }

        public final void appendRow(@NotNull BufferedWriter writer, @NotNull List<? extends Object> row) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter(row, (String)"row");
            int n = this.rowCount;
            this.rowCount = n + 1;
            if (!this.headerAppended) {
                writer.append(XlsxValuesExtractor.SHEET_HEADER);
                this.headerAppended = true;
            }
            writer.append("<row>");
            for (Object object : row) {
                if (object == null) {
                    writer.append("<c/>");
                    continue;
                }
                String type = null;
                String value2 = null;
                Object object2 = object;
                if (object2 instanceof Number) {
                    type = "n";
                    value2 = object.toString();
                } else if (object2 instanceof Boolean) {
                    type = "b";
                    value2 = (Boolean)object != false ? "1" : "0";
                } else {
                    type = "s";
                    value2 = String.valueOf(this.sharedStrings.getId(object.toString()));
                }
                writer.append("<c t=\"").append(type).append("\"><v>").append(value2).append("</v></c>");
            }
            writer.append("</row>");
        }

        public final void end(@NotNull BufferedWriter writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.append(XlsxValuesExtractor.SHEET_FOOTER);
        }

        public XlsxSheetBuilder(@NotNull SharedStrings sharedStrings) {
            Intrinsics.checkNotNullParameter((Object)sharedStrings, (String)"sharedStrings");
            this.sharedStrings = sharedStrings;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/extractors/XlsxValuesExtractor$Companion;", "", "()V", "CONTENT_TYPES_FOOTER", "", "CONTENT_TYPES_HEADER", "CONTENT_TYPES_NAME", "INVALID_XML_CHARS", "Lkotlin/text/Regex;", "getINVALID_XML_CHARS", "()Lkotlin/text/Regex;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RELS_CONTENT", "RELS_NAME", "SHARED_STRINGS_HEADER", "SHARED_STRINGS_NAME", "SHEET_FOOTER", "SHEET_HEADER", "WORKBOOK_FOOTER", "WORKBOOK_HEADER", "WORKBOOK_NAME", "WORKBOOK_RELS_FOOTER", "WORKBOOK_RELS_HEADER", "WORKBOOK_RELS_NAME", "WORKSHEETS_DIR", "intellij.database.impl"})
    public static final class Companion {
        @NotNull
        public final Regex getINVALID_XML_CHARS() {
            return INVALID_XML_CHARS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

