/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.FormatBasedExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ScriptDataExtractor;
import com.intellij.database.extractors.SqlInsertValuesExtractor;
import com.intellij.database.extractors.SqlUpdateValuesExtractor;
import com.intellij.database.extractors.XlsxValuesExtractor;
import com.intellij.database.model.DasTable;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataExtractorFactories {
    public static final String JSON_EXTRACTOR_FACTORY_ID = "JSON-Groovy.json.groovy";

    private DataExtractorFactories() {
    }

    @NotNull
    public static List<DataExtractorFactory> getLegacy() {
        List<DataExtractorFactory> list = Arrays.asList(new SqlInserts(), new SqlUpdates(), new Xlsx());
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<DataExtractorFactory.Text> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getSettings().getCsvFormats();
        List list = ContainerUtil.map(formats, Format::new);
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NlsActions.ActionText
    @NotNull
    public static String getDisplayName(@NotNull DataExtractorFactory factory) {
        if (factory == null) {
            DataExtractorFactories.$$$reportNull$$$0(2);
        }
        if (!(factory instanceof Script)) {
            String string = factory.getName();
            if (string == null) {
                DataExtractorFactories.$$$reportNull$$$0(3);
            }
            return string;
        }
        String simpleName = ((Script)factory).getSimpleName();
        boolean isDuplicateName = ContainerUtil.count(DataExtractorFactories.getScripts(), f -> f.getSimpleName().equals(simpleName)) > 1;
        @NlsSafe String scriptExtension = FileUtilRt.getExtension((String)factory.getName());
        Object object = isDuplicateName && !scriptExtension.isEmpty() ? simpleName + " (" + scriptExtension + ")" : simpleName;
        if (object == null) {
            DataExtractorFactories.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    public static List<Script> getScripts() {
        List list = JBIterable.from(ExtractorScripts.getScriptFiles()).map(o -> new Script(o.getFileName().toString())).toList();
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static DataExtractorFactory.Text getDefault() {
        String csvId = ((CsvFormat)DatabaseSettings.CSV_FORMAT.getValue()).id;
        List<DataExtractorFactory.Text> formats = DataExtractorFactories.getCsvFormats();
        DataExtractorFactory.Text csvFactory = (DataExtractorFactory.Text)ObjectUtils.tryCast((Object)DataExtractorFactories.findById(csvId, formats), DataExtractorFactory.Text.class);
        DataExtractorFactory.Text text2 = csvFactory != null ? csvFactory : (formats.isEmpty() ? new Format((CsvFormat)DatabaseSettings.CSV_FORMAT.getValue()) : Objects.requireNonNull((DataExtractorFactory.Text)ContainerUtil.getFirstItem(formats)));
        if (text2 == null) {
            DataExtractorFactories.$$$reportNull$$$0(6);
        }
        return text2;
    }

    @Nullable
    public static DataExtractorFactory findById(@NotNull String id) {
        if (id == null) {
            DataExtractorFactories.$$$reportNull$$$0(7);
        }
        return DataExtractorFactories.find(id, (PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory>)((PairFunction)DataExtractorFactories::findById));
    }

    @NotNull
    public static DataExtractorFactory create(@NotNull CsvFormat format) {
        if (format == null) {
            DataExtractorFactories.$$$reportNull$$$0(8);
        }
        return new Format(format);
    }

    @Deprecated
    @Nullable
    private static DataExtractorFactory find(@NotNull String name, @NotNull List<? extends DataExtractorFactory> factories) {
        if (name == null) {
            DataExtractorFactories.$$$reportNull$$$0(9);
        }
        if (factories == null) {
            DataExtractorFactories.$$$reportNull$$$0(10);
        }
        return (DataExtractorFactory)ContainerUtil.find(factories, factory -> name.equals(factory.getName()));
    }

    @Nullable
    private static DataExtractorFactory findById(@NotNull String id, @NotNull List<? extends DataExtractorFactory> factories) {
        if (id == null) {
            DataExtractorFactories.$$$reportNull$$$0(11);
        }
        if (factories == null) {
            DataExtractorFactories.$$$reportNull$$$0(12);
        }
        return (DataExtractorFactory)ContainerUtil.find(factories, factory -> id.equals(factory.getId()));
    }

    @Nullable
    private static DataExtractorFactory find(@NotNull String key, @NotNull PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory> finder) {
        DataExtractorFactory f;
        if (key == null) {
            DataExtractorFactories.$$$reportNull$$$0(13);
        }
        if (finder == null) {
            DataExtractorFactories.$$$reportNull$$$0(14);
        }
        f = (f = (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getLegacy())) != null ? f : (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getCsvFormats());
        f = f != null ? f : (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getScripts());
        return f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScripts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 7: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Script
    implements DataExtractorFactory.Text {
        private final String myScriptFileName;
        private final String mySimpleName;

        Script(@NotNull String scriptFileName) {
            if (scriptFileName == null) {
                Script.$$$reportNull$$$0(0);
            }
            this.myScriptFileName = scriptFileName;
            int dot = this.myScriptFileName.indexOf(46);
            String simpleName = dot == -1 ? this.myScriptFileName : this.myScriptFileName.substring(0, dot);
            int dash = simpleName.lastIndexOf(45);
            String lastPart = dash == -1 || dash == simpleName.length() - 1 ? "" : simpleName.substring(dash + 1);
            this.mySimpleName = StringUtil.equalsIgnoreCase((CharSequence)lastPart, (CharSequence)"groovy") || StringUtil.equalsIgnoreCase((CharSequence)lastPart, (CharSequence)"javascript") ? simpleName.substring(0, dash) : simpleName;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getName() {
            String string = this.myScriptFileName;
            if (string == null) {
                Script.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NlsSafe
        @NotNull
        public String getSimpleName() {
            String string = this.mySimpleName;
            if (string == null) {
                Script.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            String string = ExtractorScripts.getOutputFileExtension(this.myScriptFileName);
            if (string == null) {
                Script.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public DataExtractor.Text createExtractor(@Nullable Project project, @NotNull Dbms dbms, @Nullable ObjectFormatter formatter, @Nullable DasTable table) {
            File script;
            if (dbms == null) {
                Script.$$$reportNull$$$0(4);
            }
            if ((script = ExtractorScripts.findScript(this.myScriptFileName)) == null) {
                return null;
            }
            ExtensionScriptsUtil.prepareScript(script);
            formatter = formatter != null ? formatter : new ObjectFormatter();
            return new ScriptDataExtractor(project, script, formatter, table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFileName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$Script";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$Script";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Xlsx
    implements DataExtractorFactory.Binary {
        @Override
        @NotNull
        public String getName() {
            String string = DatabaseBundle.message((String)"excel.xlsx", (Object[])new Object[0]);
            if (string == null) {
                Xlsx.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            return "xlsx";
        }

        @Override
        @NotNull
        public XlsxValuesExtractor createExtractor(@Nullable Project project, @NotNull Dbms dbms, @Nullable ObjectFormatter formatter, @Nullable DasTable table) {
            if (dbms == null) {
                Xlsx.$$$reportNull$$$0(1);
            }
            return new XlsxValuesExtractor(new ObjectFormatter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$Xlsx";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$Xlsx";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SqlInserts
    implements DataExtractorFactory.Text {
        @Override
        @NotNull
        public String getName() {
            String string = DatabaseBundle.message((String)"sql.inserts", (Object[])new Object[0]);
            if (string == null) {
                SqlInserts.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            return "sql";
        }

        @Override
        @NotNull
        public DataExtractor.Text createExtractor(@Nullable Project project, @NotNull Dbms dbms, @Nullable ObjectFormatter formatter, @Nullable DasTable table) {
            if (dbms == null) {
                SqlInserts.$$$reportNull$$$0(1);
            }
            return new SqlInsertValuesExtractor(formatter != null ? formatter : new ObjectFormatter(), table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$SqlInserts";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$SqlInserts";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SqlUpdates
    implements DataExtractorFactory.Text {
        @Override
        @NotNull
        public String getName() {
            String string = DatabaseBundle.message((String)"sql.updates", (Object[])new Object[0]);
            if (string == null) {
                SqlUpdates.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            return "sql";
        }

        @Override
        @NotNull
        public DataExtractor.Text createExtractor(@Nullable Project project, @NotNull Dbms dbms, @Nullable ObjectFormatter formatter, @Nullable DasTable table) {
            if (dbms == null) {
                SqlUpdates.$$$reportNull$$$0(1);
            }
            return new SqlUpdateValuesExtractor(formatter != null ? formatter : new ObjectFormatter(), table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$SqlUpdates";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Format
    implements DataExtractorFactory.Text {
        private final CsvFormat myFormat;

        Format(@NotNull CsvFormat format) {
            if (format == null) {
                Format.$$$reportNull$$$0(0);
            }
            this.myFormat = format;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFormat.name;
            if (string == null) {
                Format.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public DataExtractor.Text createExtractor(@Nullable Project project, @NotNull Dbms dbms, @Nullable ObjectFormatter formatter, @Nullable DasTable table) {
            if (dbms == null) {
                Format.$$$reportNull$$$0(2);
            }
            return new FormatBasedExtractor(this.myFormat, new ObjectFormatter());
        }

        @Override
        @NotNull
        public String getFileExtension() {
            String string = (String)ObjectUtils.notNull((Object)FormatBasedExtractor.getFileExtension(this.myFormat), (Object)"txt");
            if (string == null) {
                Format.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getId() {
            String string = this.myFormat.id;
            if (string == null) {
                Format.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public CsvFormat getFormat() {
            CsvFormat csvFormat = this.myFormat;
            if (csvFormat == null) {
                Format.$$$reportNull$$$0(5);
            }
            return csvFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories$Format";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories$Format";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileExtension";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

