/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DatabasePluginId;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractorScripts {
    private static final String SCRIPT_DIR = "data/extractors";
    private static final Pattern FILE_PATTERN = Pattern.compile("(.+?)(?:\\.(\\w+))?\\.\\w+");

    private ExtractorScripts() {
    }

    @Nullable
    public static File getScriptsDirectory() {
        Path result = ExtractorScripts.getScriptDirectoryImpl(true);
        return result == null ? null : result.toFile();
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<Path> getScriptFiles() {
        List<Path> list;
        Stream<Path> stream;
        block12: {
            Path directory = ExtractorScripts.getScriptDirectoryImpl(false);
            if (directory == null) {
                List<Path> list2 = Collections.emptyList();
                if (list2 == null) {
                    ExtractorScripts.$$$reportNull$$$0(0);
                }
                return list2;
            }
            stream = Files.list(directory);
            list = stream.filter(ExtensionsRootType.regularFileFilter()).filter(o -> FILE_PATTERN.matcher(o.getFileName().toString()).matches()).collect(Collectors.toList());
            if (stream == null) break block12;
            stream.close();
        }
        List<Path> list3 = list;
        if (list3 == null) {
            ExtractorScripts.$$$reportNull$$$0(1);
        }
        return list3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    List<Path> list4 = Collections.emptyList();
                    if (list4 == null) {
                        ExtractorScripts.$$$reportNull$$$0(2);
                    }
                    return list4;
                }
            }
        }
    }

    @Nullable
    public static File findScript(String name) {
        try {
            return ExtensionsRootType.getInstance().findResource(DatabasePluginId.get(), "data/extractors/" + name);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String getOutputFileExtension(@NotNull String scriptFileName) {
        if (scriptFileName == null) {
            ExtractorScripts.$$$reportNull$$$0(3);
        }
        return ExtractorScripts.getNamePart(scriptFileName, 2, "txt");
    }

    @NotNull
    private static String getNamePart(String name, int namePart, String def) {
        String string;
        Matcher matcher = FILE_PATTERN.matcher(name);
        try {
            string = matcher.matches() ? StringUtil.notNullize((String)matcher.group(namePart), (String)def) : def;
        }
        catch (Exception ignore) {
            String string2 = def;
            if (string2 == null) {
                ExtractorScripts.$$$reportNull$$$0(5);
            }
            return string2;
        }
        if (string == null) {
            ExtractorScripts.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static Path getScriptDirectoryImpl(boolean createIfMissing) {
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/ExtractorScripts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/ExtractorScripts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamePart";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutputFileExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

