/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GotoRowAction
extends AnAction
implements DumbAware {
    public static final String GO_TO_ROW_EXECUTOR_KEY = "GoToRowExecutor";

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            GotoRowAction.$$$reportNull$$$0(0);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            GotoRowAction.showGoToDialog(dataGrid);
        }
    }

    public static void showGoToDialog(DataGrid dataGrid) {
        GoToRowHelper executor2 = (GoToRowHelper)ObjectUtils.tryCast((Object)dataGrid.getResultView().getComponent().getClientProperty(GO_TO_ROW_EXECUTOR_KEY), GoToRowHelper.class);
        if (executor2 == null) {
            return;
        }
        GotoRowDialog dialog2 = new GotoRowDialog(dataGrid, executor2);
        dialog2.show();
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid resultPanel;
        if (e == null) {
            GotoRowAction.$$$reportNull$$$0(1);
        }
        JComponent component = (resultPanel = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null ? null : resultPanel.getResultView().getComponent();
        boolean enabled = component != null && ObjectUtils.tryCast((Object)component.getClientProperty(GO_TO_ROW_EXECUTOR_KEY), GoToRowHelper.class) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/database/editor/GotoRowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface GoToRowHelper {
        public void goToRow(@NotNull String var1, @NotNull String var2);
    }

    private static class GotoRowDialog
    extends DialogWrapper {
        private JTextField myField;
        private final GoToRowHelper myExecutor;

        GotoRowDialog(DataGrid dataGrid, GoToRowHelper executor2) {
            super((Component)dataGrid.getPreferredFocusedComponent(), true);
            this.myExecutor = executor2;
            this.setTitle(DatabaseBundle.message((String)"dialog.title.go.to.row", (Object[])new Object[0]));
            this.init();
        }

        protected void doOKAction() {
            String text2 = this.getText();
            int idx = GotoRowDialog.separatorIndex(text2);
            String row = idx == -1 ? text2 : text2.substring(0, idx).trim();
            String column2 = idx == -1 ? "" : text2.substring(idx + 1).trim();
            this.myExecutor.goToRow(row, column2);
            super.doOKAction();
        }

        private static int separatorIndex(String text2) {
            int colonIndex = text2.indexOf(58);
            return colonIndex >= 0 ? colonIndex : text2.indexOf(44);
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JTextField jTextField = this.myField;
            if (jTextField == null) {
                GotoRowDialog.$$$reportNull$$$0(0);
            }
            return jTextField;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        private String getText() {
            return this.myField.getText();
        }

        protected JComponent createNorthPanel() {
            JPanel panel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)8, (int)4);
            gbConstraints.fill = 3;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel label = new JLabel(DatabaseBundle.message((String)"row.column", (Object[])new Object[0]));
            panel2.add((Component)label, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            class MyTextField
            extends JTextField {
                MyTextField() {
                    super("");
                }

                @Override
                @NotNull
                public Dimension getPreferredSize() {
                    Dimension d2 = super.getPreferredSize();
                    return new Dimension(200, d2.height);
                }
            }
            this.myField = new MyTextField();
            panel2.add((Component)this.myField, gbConstraints);
            this.myField.setToolTipText(StringUtil.escapeXmlEntities((String)DatabaseBundle.message((String)"row.column.or.row.column", (Object[])new Object[0])));
            return panel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog", "getPreferredFocusedComponent"));
        }
    }
}

