/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffSupport;
import com.intellij.database.diff.TableDiffEditor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class TableDiffSupport
implements DiffSupport {
    private final TableDiffEditor myEditor;

    public TableDiffSupport(@NotNull TableDiffEditor editor) {
        if (editor == null) {
            TableDiffSupport.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
    }

    @Override
    public int getLineHeight(int row) {
        return this.myEditor.getDataGrid().getRowHeight(row);
    }

    @Override
    public Point logicalPositionToXY(LogicalPosition lp) {
        return this.myEditor.getDataGrid().getCellPosition(lp.line, lp.column);
    }

    @Override
    public LogicalPosition xyToLogicalPosition(Point pt) {
        int row = this.myEditor.getDataGrid().getRowAtPosition(pt);
        int column2 = this.myEditor.getDataGrid().getColumnAtPosition(pt);
        int rowCount = this.myEditor.getDataGrid().getVisibleRows().size();
        int colCount = this.myEditor.getDataGrid().getVisibleColumnCount();
        if (this.myEditor.getDataGrid().getResultView().isTransposed()) {
            int tmp = rowCount;
            rowCount = colCount;
            colCount = tmp;
        }
        if (row == -1) {
            int n = row = pt.y < 0 ? 0 : rowCount;
        }
        if (column2 == -1) {
            column2 = pt.x < 0 ? 0 : colCount;
        }
        return new LogicalPosition(row, column2);
    }

    @Override
    public ScrollingModel getScrollingModel() {
        return this.myEditor.getScrollingModel();
    }

    @Override
    public int getHeaderOffset() {
        return this.myEditor.getDataGrid().getHeaderOffset();
    }

    @Override
    public EditorColorsScheme getEditorColorsScheme() {
        return this.myEditor.getDataGrid().getColorsScheme();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/diff/TableDiffSupport", "<init>"));
    }
}

