/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptTextRunProfileState;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugRunner;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0016J,\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/debugger/SqlDebugRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "makeRequest", "Lcom/intellij/database/datagrid/DataRequest;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "client", "Lcom/intellij/database/console/client/VisibleDatabaseSessionClient;", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "sp", "Lcom/intellij/database/util/SearchPath;", "intellij.database.impl"})
public final class SqlDebugRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(state instanceof DatabaseScriptTextRunProfileState)) {
            return Promises.rejectedPromise();
        }
        String string = ((DatabaseScriptTextRunProfileState)state).getName();
        if (string == null) {
            string = "script";
        }
        String name = string;
        DGDepartment.RunConfigurationRunner dp = new DGDepartment.RunConfigurationRunner(name);
        SearchPath sp = ((DatabaseScriptTextRunProfileState)state).getSearchPath();
        LocalDataSource ds = ((DatabaseScriptTextRunProfileState)state).getDataSource();
        DatabaseSessionManager.Facade facade = DatabaseSessionManager.facade(((DatabaseScriptTextRunProfileState)state).getProject(), ds, null, sp, false, null, dp);
        DatabaseSession session2 = DatabaseSessionManager.getSession(((DatabaseScriptTextRunProfileState)state).getProject(), ds, name);
        VisibleDatabaseSessionClient client = facade.client(session2);
        LightVirtualFile f = new LightVirtualFile(name, (CharSequence)((DatabaseScriptTextRunProfileState)state).getScriptText());
        f.setLanguage((Language)DbSqlUtil.getSqlDialect(ds));
        ScriptingClientDataConsumer.install(((DatabaseScriptTextRunProfileState)state).getProject(), client);
        DataRequest dataRequest = this.makeRequest(session2, client, f, sp);
        if (dataRequest == null) {
            return Promises.rejectedPromise();
        }
        DataRequest request = dataRequest;
        SqlDebugSessionRunner runner = SqlDebugSessionRunner.Companion.createRunner((DataRequest.OwnerEx)client, session2, request, false, (VirtualFile)f, null, sp);
        runner.setOnFinish((Function0<Unit>)((Function0)new Function0<Unit>(client){
            final /* synthetic */ VisibleDatabaseSessionClient $client;

            public final void invoke() {
                Disposer.dispose((Disposable)this.$client);
            }
            {
                this.$client = visibleDatabaseSessionClient;
                super(0);
            }
        }));
        return runner.execute(environment);
    }

    private final DataRequest makeRequest(DatabaseSession session2, VisibleDatabaseSessionClient client, LightVirtualFile file, SearchPath sp) {
        ScriptModel scriptModel = SqlDebugSessionRunner.Companion.obtainActualScriptModel$default(SqlDebugSessionRunner.Companion, session2.getProject(), (VirtualFile)file, false, null, 8, null);
        if (scriptModel == null) {
            return null;
        }
        ScriptModel sm = scriptModel;
        List list = sm.statements().transform(ScriptModelUtil.TO_TEXT).map((Function)makeRequest.ss.1.INSTANCE).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sm.statements().transfor\u2026.Statement(it) }.toList()");
        List ss2 = list;
        return DataRequest.newCallRequest(client, ss2, sp);
    }

    @NotNull
    public String getRunnerId() {
        return "sqlDebugRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        if (!(profile instanceof DatabaseScriptRunConfiguration)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)executorId, (Object)"Debug") ^ true) {
            return false;
        }
        DatabaseScriptRunConfigurationOptions options = ((DatabaseScriptRunConfiguration)profile).getOptions();
        if (options.getMode() != DatabaseScriptRunConfigurationOptions.Mode.TEXT) {
            return false;
        }
        Object object = (DatabaseScriptRunConfigurationOptions.Target)((Object)CollectionsKt.singleOrNull(options.getTargets()));
        if (object == null || (object = object.getDataSourceId()) == null) {
            return false;
        }
        Object target = object;
        LocalDataSource localDataSource = DataSourceStorage.getProjectStorage(((DatabaseScriptRunConfiguration)profile).getProject()).getDataSourceById((String)target);
        if (localDataSource == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"DataSourceStorage.getPro\u2026d(target) ?: return false");
        LocalDataSource ds = localDataSource;
        SqlDebuggerFacade sqlDebuggerFacade = SqlDebugSessionRunner.Companion.obtainDebuggerFacadeWhenApplicable(ds);
        return sqlDebuggerFacade != null ? sqlDebuggerFacade.canDebug(ds) : false;
    }
}

