/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.dbimport.ui.csv.CharsetComponent;
import com.intellij.database.dbimport.ui.csv.CsvFormatComponent;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.view.ui.ErrorNotificationWrapperPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportPanel
extends JBLoadingPanel {
    private static final int INSET = 3;
    private final TabbedPaneWrapper myPane;
    private final List<ImportComponent<?, ?>> myComponents;
    private final ImportInfo.Builder myBuilder;
    private final ImportAction.ImportEditorContext myContext;
    private final GraphObservable<?> myObservable;
    private final ErrorNotificationWrapperPanel myErrorNotificationPanel;

    public ImportPanel(@NotNull List<ImportComponent<?, ?>> components, @NotNull ImportAction.ImportEditorContext context) {
        if (components == null) {
            ImportPanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ImportPanel.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout(), context.getDisposable());
        this.myComponents = components;
        this.myBuilder = context.getBuilder();
        this.myContext = context;
        this.myErrorNotificationPanel = new ErrorNotificationWrapperPanel();
        this.myObservable = this.createObservable(components);
        this.myObservable.addListener((Consumer<Throwable>)((Consumer)t -> {
            this.reportError((Throwable)t);
            this.revalidate();
            this.repaint();
        }));
        this.startLoading();
        this.myPane = new TabbedPaneWrapper(context.getDisposable());
    }

    @NotNull
    public CompletionStage<?> init() {
        CompletionStage<Object> completionStage = this.myObservable.init().whenComplete((o, e) -> {
            this.reportError(AsyncUtil.unwrap(e));
            this.fillPanel();
            this.stopLoading();
            this.requestFocusOnEditor();
        });
        if (completionStage == null) {
            ImportPanel.$$$reportNull$$$0(2);
        }
        return completionStage;
    }

    public void reportError(@Nullable @NlsContexts.NotificationContent String s2) {
        if (s2 != null) {
            this.myErrorNotificationPanel.reportError(s2);
        }
    }

    private void reportError(@Nullable Throwable t) {
        Optional.ofNullable(t).ifPresent(t1 -> {
            ErrorHandler handler = new ErrorHandler();
            handler.addError(null, (Throwable)t1);
            this.reportError(handler.getSummary());
        });
    }

    private void requestFocusOnEditor() {
        IdeFocusManager instance = IdeFocusManager.getInstance((Project)this.myContext.getProject());
        instance.doWhenFocusSettlesDown(() -> {
            ImportDatabaseTableEditor<?> editor = this.getTableEditorComponent().getEditor();
            if (editor != null) {
                instance.requestFocus((Component)editor.getPreferredFocusedComponent(), true);
            }
        });
    }

    @NotNull
    public ImportInfo getImportInfo() {
        for (ImportComponent<?, ?> component : this.myComponents) {
            component.build(this.myBuilder);
        }
        ImportInfo importInfo = this.myBuilder.build();
        if (importInfo == null) {
            ImportPanel.$$$reportNull$$$0(3);
        }
        return importInfo;
    }

    @Nullable
    public ValidationInfo validationInfo() {
        for (ImportComponent<?, ?> component : this.myComponents) {
            ValidationInfo info = component.validate();
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private void fillPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.fillTabbedPane();
        JComponent paneComponent = this.myPane.getComponent();
        paneComponent.setBorder((Border)JBUI.Borders.emptyTop((int)3));
        JComponent editorComponent = this.getTableEditorComponent().getComponent();
        editorComponent.setBorder((Border)JBUI.Borders.emptyBottom((int)3));
        OnePixelSplitter splitter = new OnePixelSplitter(true);
        splitter.setFirstComponent(editorComponent);
        splitter.setSecondComponent(paneComponent);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)splitter, "Center");
        right.add((Component)this.createSettingsPanel(), "South");
        mainPanel.add((Component)right, "Center");
        CsvFormatComponent component = this.getFormatComponent();
        if (component != null) {
            mainPanel.add((Component)component.getComponent(), "West");
        }
        this.add(mainPanel, "Center");
        this.add(this.myErrorNotificationPanel, "South");
    }

    private void fillTabbedPane() {
        int i2 = 0;
        DataPreviewComponent<?> previewComponent = this.getPreviewComponent();
        if (previewComponent != null) {
            String title = DatabaseBundle.message((String)"database.data.import.data.preview.tab.title", (Object[])new Object[0]);
            this.myPane.insertTab(title, null, previewComponent.getComponent(), null, i2++);
        }
        DdlPreviewComponent ddlComponent = this.getDdlComponent();
        String ddlPreviewTitle = DatabaseBundle.message((String)"database.data.import.ddl.preview.tab.title", (Object[])new Object[0]);
        this.myPane.insertTab(ddlPreviewTitle, null, ddlComponent.getComponent(), null, i2);
        this.listenText(ddlComponent, i2);
    }

    private void listenText(final @NotNull DdlPreviewComponent component, final int index2) {
        if (component == null) {
            ImportPanel.$$$reportNull$$$0(4);
        }
        if (!this.myBuilder.getImportType().isTableCreated()) {
            return;
        }
        component.getDdlPreview().getTextField().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                String text2 = component.getDdlPreview().getPreviewText();
                ImportPanel.this.myPane.setIconAt(index2, StringUtil.isEmptyOrSpaces((String)text2) ? null : AllIcons.General.Warning);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dbimport/ui/ImportPanel$1", "documentChanged"));
            }
        });
    }

    @NotNull
    public DdlPreviewComponent getDdlComponent() {
        DdlPreviewComponent ddlPreviewComponent = Objects.requireNonNull(this.getComponent(DdlPreviewComponent.class));
        if (ddlPreviewComponent == null) {
            ImportPanel.$$$reportNull$$$0(5);
        }
        return ddlPreviewComponent;
    }

    @NotNull
    public TableEditorComponent<?> getTableEditorComponent() {
        TableEditorComponent tableEditorComponent = Objects.requireNonNull(this.getComponent(TableEditorComponent.class));
        if (tableEditorComponent == null) {
            ImportPanel.$$$reportNull$$$0(6);
        }
        return tableEditorComponent;
    }

    @NotNull
    protected ImportSettingsComponent getSettingsComponent() {
        ImportSettingsComponent importSettingsComponent = Objects.requireNonNull(this.getComponent(ImportSettingsComponent.class));
        if (importSettingsComponent == null) {
            ImportPanel.$$$reportNull$$$0(7);
        }
        return importSettingsComponent;
    }

    @Nullable
    protected DataPreviewComponent<?> getPreviewComponent() {
        return this.getComponent(DataPreviewComponent.class);
    }

    @Nullable
    protected CsvFormatComponent getFormatComponent() {
        return this.getComponent(CsvFormatComponent.class);
    }

    @Nullable
    protected CharsetComponent getCharsetComponent() {
        return this.getComponent(CharsetComponent.class);
    }

    @NotNull
    private JComponent createSettingsPanel() {
        JPanel result = new JPanel((LayoutManager)new VerticalStackLayout());
        ImportSettingsComponent settingsComponent = this.getSettingsComponent();
        CharsetComponent charsetComponent = this.getCharsetComponent();
        if (charsetComponent == null) {
            JComponent jComponent = settingsComponent.getComponent();
            if (jComponent == null) {
                ImportPanel.$$$reportNull$$$0(8);
            }
            return jComponent;
        }
        ImportSettingsComponent.addStrut(result);
        result.add(charsetComponent.getComponent());
        ImportSettingsComponent.addStrut(result);
        ImportSettingsComponent.addStrut(result);
        result.add(settingsComponent.getComponent());
        JPanel jPanel = result;
        if (jPanel == null) {
            ImportPanel.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @NotNull
    private GraphObservable createObservable(@NotNull List<ImportComponent<?, ?>> components) {
        if (components == null) {
            ImportPanel.$$$reportNull$$$0(10);
        }
        CsvFormatComponent root2 = this.getFormatComponent() != null ? this.getFormatComponent() : (this.getPreviewComponent() != null ? this.getPreviewComponent() : this.getTableEditorComponent());
        GraphObservable<Object> graphObservable = new GraphObservable.Builder().add(components).root(Objects.requireNonNull(root2)).initializer(null).build();
        if (graphObservable == null) {
            ImportPanel.$$$reportNull$$$0(11);
        }
        return graphObservable;
    }

    @Nullable
    private <T extends ImportComponent<?, ?>> T getComponent(Class<T> filterBy) {
        return (T)((ImportComponent)JBIterable.from(this.myComponents).filter(filterBy).first());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/ImportPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/ImportPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableEditorComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsComponent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createObservable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listenText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createObservable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

