/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridListModel;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridDataHookUpBase;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPagingModelImpl;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DocumentDataHookUp
extends GridDataHookUpBase<DataConsumer.Row, DataConsumer.Column>
implements Disposable {
    private final Document myDocument;
    private TextRange myRange;
    private DataMarkup myCurrentMarkup;
    private final DataGridListModel myModel;
    private final GridPagingModelImpl.SinglePage<DataConsumer.Row, DataConsumer.Column> myPageModel;
    private final DocumentDataLoader myLoader;
    private final DocumentDataMutator myMutator;
    private final MyDocumentListener myDocumentListener;

    protected DocumentDataHookUp(@NotNull Project project, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            DocumentDataHookUp.$$$reportNull$$$0(0);
        }
        if (document == null) {
            DocumentDataHookUp.$$$reportNull$$$0(1);
        }
        super(project);
        this.myDocument = document;
        this.myRange = range;
        this.myModel = new DataGridListModel();
        this.myPageModel = new GridPagingModelImpl.SinglePage<DataConsumer.Row, DataConsumer.Column>(this.myModel);
        this.myLoader = new DocumentDataLoader();
        Disposer.register((Disposable)this, (Disposable)this.myLoader);
        this.myMutator = new DocumentDataMutator();
        this.myDocumentListener = new MyDocumentListener();
        this.myDocument.addDocumentListener((DocumentListener)this.myDocumentListener, (Disposable)this);
    }

    @TestOnly
    public void awaitParsingFinished() {
        this.myLoader.awaitParsingFinished();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            DocumentDataHookUp.$$$reportNull$$$0(2);
        }
        return document;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getModel() {
        DataGridListModel dataGridListModel = this.myModel;
        if (dataGridListModel == null) {
            DocumentDataHookUp.$$$reportNull$$$0(3);
        }
        return dataGridListModel;
    }

    @Override
    @NotNull
    public GridPagingModel<DataConsumer.Row, DataConsumer.Column> getPageModel() {
        GridPagingModelImpl.SinglePage<DataConsumer.Row, DataConsumer.Column> singlePage = this.myPageModel;
        if (singlePage == null) {
            DocumentDataHookUp.$$$reportNull$$$0(4);
        }
        return singlePage;
    }

    @Override
    @NotNull
    public GridLoader<DataConsumer.Row, DataConsumer.Column> getLoader() {
        DocumentDataLoader documentDataLoader = this.myLoader;
        if (documentDataLoader == null) {
            DocumentDataHookUp.$$$reportNull$$$0(5);
        }
        return documentDataLoader;
    }

    @Nullable
    public DocumentDataMutator getMutator() {
        return this.myMutator;
    }

    @Override
    public boolean isReadOnly() {
        return !this.myDocument.isWritable();
    }

    public void dispose() {
    }

    @Nullable
    public TextRange getRange() {
        return this.myRange;
    }

    @Nullable
    protected abstract DataMarkup buildMarkup(@NotNull CharSequence var1, @NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DocumentDataHookUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPageModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface UpdateAction {
        public boolean perform(@NotNull UpdateSession var1) throws Exception;
    }

    private class DocumentDataLoader
    implements GridLoader<DataConsumer.Row, DataConsumer.Column>,
    Disposable {
        private final Logger LOG = Logger.getInstance(DocumentDataLoader.class);
        private final ThreadPoolExecutor myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)this.getClass().getSimpleName());
        private Future<?> myLastExtractorTask = null;

        private DocumentDataLoader() {
        }

        @Override
        public void reloadCurrentPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(0);
            }
            this.load(source, 0);
        }

        @Override
        public void loadNextPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(1);
            }
            this.load(source, 0);
        }

        @Override
        public void loadPreviousPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(2);
            }
            this.load(source, 0);
        }

        @Override
        public void loadLastPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(3);
            }
            this.load(source, 0);
        }

        @Override
        public void loadFirstPage(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(4);
            }
            this.load(source, 0);
        }

        @Override
        public void load(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int offset) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(5);
            }
            try {
                this.doLoadData(source);
            }
            catch (Exception e) {
                DocumentDataHookUp.this.notifyRequestError(source, null, null, e);
            }
        }

        @Override
        public void updateTotalRowCount(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(6);
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, false);
        }

        @Override
        public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataLoader.$$$reportNull$$$0(7);
            }
            DocumentDataHookUp.this.notifyRequestFinished(source, false);
        }

        private void doLoadData(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            CharSequence sequence;
            CharSequence charSequence = sequence = DocumentDataHookUp.this.myRange != null ? DocumentDataHookUp.this.myRange.subSequence(DocumentDataHookUp.this.myDocument.getCharsSequence()) : DocumentDataHookUp.this.myDocument.getCharsSequence();
            if (this.myLastExtractorTask != null) {
                this.myLastExtractorTask.cancel(false);
            }
            this.myLastExtractorTask = this.myExecutor.submit(() -> {
                DataMarkup markup = DocumentDataHookUp.this.buildMarkup(sequence, source);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (markup == null) {
                        DocumentDataHookUp.this.myModel.removeRows(0, DocumentDataHookUp.this.myModel.getRowCount());
                        DocumentDataHookUp.this.myModel.setColumns(ContainerUtil.emptyList());
                        DocumentDataHookUp.this.myCurrentMarkup = null;
                        DocumentDataHookUp.this.notifyRequestFinished(source, false);
                        return;
                    }
                    List<DataConsumer.Column> columns = markup.columns;
                    List<DataConsumer.Row> rows = markup.rows;
                    if (!this.sameColumns(columns, DocumentDataHookUp.this.myModel.getColumns())) {
                        DocumentDataHookUp.this.myModel.removeRows(0, DocumentDataHookUp.this.myModel.getRowCount());
                        DocumentDataHookUp.this.myModel.setColumns(columns);
                        DocumentDataHookUp.this.myModel.addRows(rows);
                    } else {
                        int oldRowCount = DocumentDataHookUp.this.myModel.getRowCount();
                        int newRowCount = rows.size();
                        DocumentDataHookUp.this.myModel.setRows(0, rows);
                        if (oldRowCount > newRowCount) {
                            DocumentDataHookUp.this.myModel.removeRows(newRowCount, oldRowCount - newRowCount);
                        }
                    }
                    DocumentDataHookUp.this.myCurrentMarkup = markup;
                    DocumentDataHookUp.this.notifyRequestFinished(source, true);
                }, ModalityState.any());
            });
        }

        private boolean sameColumns(List<DataConsumer.Column> columns1, List<DataConsumer.Column> columns2) {
            if (columns1.size() != columns2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < columns1.size(); ++i2) {
                if (Comparing.equal((Object)columns1.get(i2), (Object)columns2.get(i2))) continue;
                return false;
            }
            return true;
        }

        public void awaitParsingFinished() {
            if (this.myLastExtractorTask == null) {
                return;
            }
            try {
                this.myLastExtractorTask.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.LOG.error("DocumentDataLoader task termination interrupted", (Throwable)e);
            }
        }

        public void dispose() {
            this.myExecutor.shutdown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "source";
            objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reloadCurrentPage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadNextPage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadPreviousPage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadLastPage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFirstPage";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateTotalRowCount";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private boolean myMuteChangeEvents;
        private boolean myChangesOccurredWhileMuted;

        private MyDocumentListener() {
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            this.adjustRange(event);
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                MyDocumentListener.$$$reportNull$$$0(1);
            }
            if (this.myMuteChangeEvents) {
                this.myChangesOccurredWhileMuted = true;
            } else {
                this.reload();
            }
        }

        public void muteChangeEvents() {
            this.myMuteChangeEvents = true;
            this.myChangesOccurredWhileMuted = false;
        }

        public void unmuteChangeEvents() {
            this.myMuteChangeEvents = false;
            if (this.myChangesOccurredWhileMuted) {
                this.reload();
            }
        }

        private void reload() {
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (!DocumentDataHookUp.this.myModel.hasListeners()) {
                    return;
                }
                DocumentDataHookUp.this.myLoader.doLoadData(new GridRequestSource<DataConsumer.Row, DataConsumer.Column>(null, null));
            });
        }

        private void adjustRange(DocumentEvent e) {
            if (DocumentDataHookUp.this.myRange == null) {
                return;
            }
            int lengthDelta = e.getNewLength() - e.getOldLength();
            if (DocumentDataHookUp.this.myRange.containsRange(e.getOffset(), e.getOffset() + e.getOldLength())) {
                DocumentDataHookUp.this.myRange = new TextRange(DocumentDataHookUp.this.myRange.getStartOffset(), DocumentDataHookUp.this.myRange.getEndOffset() + lengthDelta);
            } else if (DocumentDataHookUp.this.myRange.getStartOffset() > e.getOffset() + e.getOldLength()) {
                DocumentDataHookUp.this.myRange = DocumentDataHookUp.this.myRange.shiftRight(lengthDelta);
            } else if (DocumentDataHookUp.this.myRange.intersects(e.getOffset(), e.getOffset() + e.getOldLength())) {
                int startOffset = Math.min(e.getOffset(), DocumentDataHookUp.this.myRange.getStartOffset());
                int endOffset = Math.max(e.getOffset() + e.getNewLength(), DocumentDataHookUp.this.myRange.getEndOffset() + lengthDelta);
                DocumentDataHookUp.this.myRange = new TextRange(startOffset, endOffset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$MyDocumentListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class DocumentDataMutator
    implements GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column>,
    GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> {
        DocumentDataMutator() {
        }

        @Override
        public void deleteRows(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(0);
            }
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(1);
            }
            final List<DataConsumer.Row> rowsToDelete = this.sortedRows(DocumentDataHookUp.this.myModel.getRows(rows));
            if (DocumentDataHookUp.this.isReadOnly() || rowsToDelete.isEmpty()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.deleteRows(session2, rowsToDelete);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$1", "perform"));
                }
            });
        }

        @Override
        public void insertRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(2);
            }
            if (DocumentDataHookUp.this.isReadOnly()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.insertRow(session2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$2", "perform"));
                }
            });
        }

        @Override
        public void cloneRow(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Row> toClone) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(3);
            }
            if (toClone == null) {
                DocumentDataMutator.$$$reportNull$$$0(4);
            }
            final DataConsumer.Row row = DocumentDataHookUp.this.myModel.getRow(toClone);
            if (DocumentDataHookUp.this.isReadOnly() || row == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.cloneRow(session2, row);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$3", "perform"));
                }
            });
        }

        @Override
        public boolean isDeletedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
            if (row == null) {
                DocumentDataMutator.$$$reportNull$$$0(5);
            }
            return false;
        }

        @Override
        public boolean isDeletedRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(6);
            }
            return false;
        }

        @Override
        public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
            if (row == null) {
                DocumentDataMutator.$$$reportNull$$$0(7);
            }
            return false;
        }

        @Override
        public void deleteColumns(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Column> columns) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(8);
            }
            if (columns == null) {
                DocumentDataMutator.$$$reportNull$$$0(9);
            }
            final List<DataConsumer.Column> columnsToDelete = this.sortedColumns(DocumentDataHookUp.this.myModel.getColumns(columns));
            if (DocumentDataHookUp.this.isReadOnly() || columnsToDelete.isEmpty()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.deleteColumns(session2, columnsToDelete);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$4", "perform"));
                }
            });
        }

        @Override
        public void insertColumn(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(10);
            }
            if (DocumentDataHookUp.this.isReadOnly()) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.insertColumn(session2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$5", "perform"));
                }
            });
        }

        @Override
        public void cloneColumn(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndex<DataConsumer.Column> toClone) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(11);
            }
            if (toClone == null) {
                DocumentDataMutator.$$$reportNull$$$0(12);
            }
            final DataConsumer.Column column2 = DocumentDataHookUp.this.myModel.getColumn(toClone);
            if (DocumentDataHookUp.this.isReadOnly() || column2 == null) {
                DocumentDataHookUp.this.notifyRequestFinished(source, false);
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.cloneColumn(session2, column2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$6", "perform"));
                }
            });
        }

        @Override
        @NotNull
        public ModelIndex<DataConsumer.Row> getLastInsertedRow() {
            ModelIndex<DataConsumer.Row> modelIndex = ModelIndex.forRow(DocumentDataHookUp.this.myModel, -1);
            if (modelIndex == null) {
                DocumentDataMutator.$$$reportNull$$$0(13);
            }
            return modelIndex;
        }

        @Override
        @NotNull
        public ModelIndexSet<DataConsumer.Row> getAffectedRows() {
            ModelIndexSet<DataConsumer.Row> modelIndexSet = ModelIndexSet.forRows(DocumentDataHookUp.this.myModel, -1);
            if (modelIndexSet == null) {
                DocumentDataMutator.$$$reportNull$$$0(14);
            }
            return modelIndexSet;
        }

        @Override
        public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, Object newValue, boolean allowImmediateUpdate) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(15);
            }
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(16);
            }
            if (columns == null) {
                DocumentDataMutator.$$$reportNull$$$0(17);
            }
            this.mutate(source, DataGridUtil.createMutations(rows, columns, newValue), allowImmediateUpdate);
        }

        @Override
        public void mutate(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull List<CellMutation> mutations, boolean allowImmediateUpdate) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(18);
            }
            if (mutations == null) {
                DocumentDataMutator.$$$reportNull$$$0(19);
            }
            final List<RowMutation> rowMutations = DataGridUtil.mergeAll(mutations, DocumentDataHookUp.this.myModel);
            if (DocumentDataHookUp.this.isReadOnly() || mutations.isEmpty() || rowMutations.isEmpty() || DocumentDataHookUp.this.myModel.allValuesEqualTo(mutations)) {
                DocumentDataHookUp.this.notifyRequestFinished(source, !DocumentDataHookUp.this.isReadOnly());
                return;
            }
            this.updateDocument(source, new UpdateAction(){

                @Override
                public boolean perform(@NotNull UpdateSession session2) {
                    if (session2 == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return DocumentDataHookUp.this.myCurrentMarkup.update(session2, rowMutations);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator$7", "perform"));
                }
            });
        }

        @Override
        public boolean isUpdateSafe(@NotNull ModelIndexSet<DataConsumer.Row> rowIndices, @NotNull ModelIndexSet<DataConsumer.Column> columnIndices, @Nullable Object newValue) {
            if (rowIndices == null) {
                DocumentDataMutator.$$$reportNull$$$0(20);
            }
            if (columnIndices == null) {
                DocumentDataMutator.$$$reportNull$$$0(21);
            }
            return true;
        }

        @Override
        public boolean hasPendingChanges() {
            return false;
        }

        @Override
        public boolean isUpdateImmediately() {
            return true;
        }

        private void updateDocument(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @NotNull UpdateAction action2) {
            if (source == null) {
                DocumentDataMutator.$$$reportNull$$$0(22);
            }
            if (action2 == null) {
                DocumentDataMutator.$$$reportNull$$$0(23);
            }
            GuiUtils.invokeLaterIfNeeded(() -> {
                if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)DocumentDataHookUp.this.getProject(), (Document)DocumentDataHookUp.this.myDocument)) {
                    DocumentDataHookUp.this.notifyRequestError(source, "Cannot update document", null, null);
                    DocumentDataHookUp.this.notifyRequestFinished(source, false);
                    return;
                }
                UpdateSession session2 = new UpdateSession(DocumentDataHookUp.this.myDocument, DocumentDataHookUp.this.myRange != null ? DocumentDataHookUp.this.myRange.getStartOffset() : 0);
                ThrowableComputable wrappedAction = () -> {
                    DocumentDataHookUp.this.myDocumentListener.muteChangeEvents();
                    try {
                        Boolean bl = action2.perform(session2);
                        return bl;
                    }
                    finally {
                        DocumentDataHookUp.this.myDocumentListener.unmuteChangeEvents();
                    }
                };
                CommandProcessor.getInstance().executeCommand(DocumentDataHookUp.this.getProject(), () -> {
                    boolean success = false;
                    try {
                        success = (Boolean)ApplicationManager.getApplication().runWriteAction(wrappedAction);
                    }
                    catch (Exception e) {
                        DocumentDataHookUp.this.notifyRequestError(source, null, null, e);
                    }
                    DocumentDataHookUp.this.notifyRequestFinished(source, success);
                }, DatabaseBundle.message((String)"command.name.update.values", (Object[])new Object[0]), null);
            }, (ModalityState)ModalityState.defaultModalityState());
        }

        private List<DataConsumer.Column> sortedColumns(@NotNull List<DataConsumer.Column> columns) {
            if (columns == null) {
                DocumentDataMutator.$$$reportNull$$$0(24);
            }
            return ContainerUtil.sorted(columns, (column1, column2) -> column1.columnNum - column2.columnNum);
        }

        private List<DataConsumer.Row> sortedRows(@NotNull List<DataConsumer.Row> rows) {
            if (rows == null) {
                DocumentDataMutator.$$$reportNull$$$0(25);
            }
            return ContainerUtil.sorted(rows, (row1, row2) -> row1.rowNum - row2.rowNum);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 6: 
                case 16: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 4: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toClone";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 9: 
                case 17: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutations";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIndices";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIndices";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$DocumentDataMutator";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLastInsertedRow";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAffectedRows";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "insertRow";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneRow";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isDeletedRow";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isDeletedRows";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsertedRow";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumns";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "insertColumn";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneColumn";
                    break;
                }
                case 13: 
                case 14: {
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "mutate";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "isUpdateSafe";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "updateDocument";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "sortedColumns";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "sortedRows";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class DataMarkup {
        public final List<DataConsumer.Column> columns;
        public final List<DataConsumer.Row> rows;

        public DataMarkup(@NotNull List<DataConsumer.Column> columns, @NotNull List<DataConsumer.Row> rows) {
            if (columns == null) {
                DataMarkup.$$$reportNull$$$0(0);
            }
            if (rows == null) {
                DataMarkup.$$$reportNull$$$0(1);
            }
            this.columns = columns;
            this.rows = rows;
        }

        protected abstract boolean deleteRows(@NotNull UpdateSession var1, @NotNull List<DataConsumer.Row> var2);

        protected abstract boolean insertRow(@NotNull UpdateSession var1);

        protected abstract boolean cloneRow(@NotNull UpdateSession var1, @NotNull DataConsumer.Row var2);

        protected abstract boolean deleteColumns(@NotNull UpdateSession var1, @NotNull List<DataConsumer.Column> var2);

        protected abstract boolean insertColumn(@NotNull UpdateSession var1);

        protected abstract boolean cloneColumn(@NotNull UpdateSession var1, @NotNull DataConsumer.Column var2);

        protected abstract boolean update(@NotNull UpdateSession var1, @NotNull List<RowMutation> var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rows";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/DocumentDataHookUp$DataMarkup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static final class UpdateSession {
        private final Document myDocument;
        private int myRightShift;

        private UpdateSession(@NotNull Document document, int rightShift) {
            if (document == null) {
                UpdateSession.$$$reportNull$$$0(0);
            }
            this.myDocument = document;
            this.myRightShift = rightShift;
        }

        public void insert(@NotNull CharSequence sequence, int atOffset) {
            if (sequence == null) {
                UpdateSession.$$$reportNull$$$0(1);
            }
            this.myDocument.insertString(atOffset + this.myRightShift, sequence);
            this.myRightShift += sequence.length();
        }

        public void replace(@NotNull TextRange range, @NotNull CharSequence sequence) {
            if (range == null) {
                UpdateSession.$$$reportNull$$$0(2);
            }
            if (sequence == null) {
                UpdateSession.$$$reportNull$$$0(3);
            }
            TextRange shifted = range.shiftRight(this.myRightShift);
            this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), sequence);
            this.myRightShift += sequence.length() - shifted.getLength();
        }

        public void delete(@NotNull TextRange range) {
            if (range == null) {
                UpdateSession.$$$reportNull$$$0(4);
            }
            TextRange shifted = range.shiftRight(this.myRightShift);
            this.myDocument.deleteString(shifted.getStartOffset(), shifted.getEndOffset());
            this.myRightShift -= range.getLength();
        }

        public char charAt(int offset) {
            return this.myDocument.getCharsSequence().charAt(offset + this.myRightShift);
        }

        public boolean isValidOffset(int offset) {
            int shifted = offset + this.myRightShift;
            return shifted >= 0 && shifted < this.myDocument.getTextLength();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DocumentDataHookUp$UpdateSession";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

